#!/bin/sh
# $Id: t-mts-size-2.sh,v 1.7 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test message size
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
SCRIPTS=`cd ${SD} && pwd`

ERRS=0

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
max_message_size=1KB;
}
EOF

# ----------------------------------------
# accept mail
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -Z 'smtpc2' -c '-E -l 512' -E 1 -A 1 -X 1 $@ -S"s${TEST}@b.c" -R"r${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# reject mail due to size
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -Z 'smtpc2' -c '-E -l 2048' -E 0 -A 0 -X 0 $@ -S"s${TEST}@b.c" -R"r${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
