#!/bin/sh
# $Id: t-pmilter-8.sh,v 1.10 2005/10/19 18:34:53 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test pmilter rejections in body (not waiting for eob).
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if ../smtps/smtps -VVV | ${GREP} SM_USE_PMILTER >/dev/null
then
  :
else
  echo "$0: smtps not compiled with SM_USE_PMILTER (--enable-pmilter); test SKIPPED"
  exit 0
fi

PMPRG="-p ../libpmilter/t-pmilter-1"
PMOPT=""

if test X"`uname`" != "XOSF1"
then
while getopts O:p:s:V FLAG
do
  case "${FLAG}" in
    O) PMOPT="${PMOPT} ${OPTARG}";;
    p) PMPRG="-p ${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 12;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=unix; path="pmilter.sock";} timeout=2; }
}
EOF

# ----------------------------------------
# reject body in milter
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-r B=550" -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'DOT=error' ${CLTL} >/dev/null
then
    if ${GREP} -i 'err' ${PML} >/dev/null
    then
      ERR=true
    fi
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi



# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
