#!/bin/sh
# $Id: t-smtpf4.sh,v 1.11 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test error handling from different components
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
I=""
ERRS=0
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

TEST=1
# ----------------------------------------
# temporary failure from SMTP for all but first recipient

if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -1 -s 90 -Q '-P<bounce@y.z>' -i 4 -Y '-1' -E 10 -A 1 -X 4 -S"f4s1@b.c" -R"f4ok1@y.z -Rf4ok2@y.z -Rf4ok3@y.z -Rf4ok4@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
