#!/bin/sh
# $Id: t-tls-0.sh,v 1.22 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test TLS; check delivered mail
# creates two MTS (one in chkmts, one in qmgr) to use STARTTLS
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
THISDIR=`pwd`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OUT="t-tls-0.out"
PID2=pids2
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

if ../smtps/smtps -VVV | ${GREP} SM_USE_TLS >/dev/null
then
  :
else
  echo "$0: smtps not compiled with STARTTLS; test SKIPPED"
  exit 0
fi
if ../smtpc/smtpc -VVV | ${GREP} SM_USE_TLS >/dev/null
then
  :
else
  echo "$0: smtpc not compiled with STARTTLS; test SKIPPED"
  exit 0
fi

killit()
{
cd ${THISDIR}
if test -s ${PID2}
then
  # stop MTA components
  for i in `${CAT} ${PID2}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi
exit 1
}

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender:	local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
other.dom	[127.1.2.3]
EOF

# get certs
for i in smcert.pem smkey.pem CAcert.pem
do
  test -s ${i} || cp ${SD}/${i} .
done

# ----------------------------------------
# need two SMTP servers:
# test client [smtp1.sh] -> SMTP server 1 (SRVPORT)
# -> QMGR 1 -> SMTP client 1 (SNKPORT)
# -> SMTP server 2 [smtp1.sh] (SRVPORT2=SNKPORT)
# -> QMGR 2 [smtp1.sh] -> SMTP client 2 [smtp1.sh]
# -> lmtp sink [smtp1.sh]
# problem: test client in smtp1.sh will use SRVPORT2
# hence the port must be passed explicitly via -F

cd ${THISDIR} || exit 1
# get certs
for i in smcert.pem smkey.pem CAcert.pem
do
  test -s ${i} || cp ${SD}/${i} .
done
# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	[127.0.0.1]
other.dom	[${SM_LMTPIPV4D}]
EOF
# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender:	local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}


SM_CDQMGRDIR=false
export SM_CDQMGRDIR
. ${SD}/mta-setup.sh
SM_CDQMGRDIR=true

SNKPORT=8753
SRVPORT=1579
SM_SNKPORT=8752
SM_SRVPORT=${SNKPORT}
SNKPORT2=${SM_SNKPORT}
SRVPORT2=${SM_SRVPORT}

# ----------------------------------------
# start first MTS (chkmts)
#
CONF2=smx2.conf
${CAT} > ${CONF2} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4;
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${CONF2}";
}
smar { Log_Level = 12;
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${CONF2}";
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4;
  flags=2; # don't check "talking to myself"
	start_action = wait; user = ${USER};
	path = "../smtpc/smtpc"; arguments = "smtpc -f ${CONF2}";
}
smtps {
Log_Level = 12;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
	listen_socket { type=inet; port=${SRVPORT}; }
	start_action = wait; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -f ${CONF2} ${SM_SERVER_OPTIONS}";
}
EOF

# version of output files
V=1
# path to programs
P=..
rm -f ${PID2}
trap killit 2 15
# go for it
${P}/smar/smar -f ${CONF2} > a${V}.log 2>&1 &
echo $! >> ${PID2}
${P}/qmgr/qmgr -f ${CONF2} > q${V}.log 2>&1 &
echo $! >> ${PID2}
${P}/smtpc/smtpc -f ${CONF2} > c${V}.log 2>&1 &
echo $! >> ${PID2}
${P}/smtps/smtps -f ${CONF2} > s${V}.log 2>&1 &
echo $! >> ${PID2}

# check that the MTA is running
export P
${CHKD}/mta-running.sh ${SRVPORT} || killit

export SM_SNKPORT SM_SRVPORT

# ----------------------------------------
# test: send mail to local address, check Received: header for TLS

TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

cd ../qmgr
if ${SHELL} ${SD}/smtp1.sh -F ${SRVPORT} -3 lmtpsock -Ssender@other.dom -Ruser@local.dom -E 0 -X 0 -A 1
then
  if test -s ${B1}
  then
    if ${GREP} 'TLS' ${B1} >/dev/null
    then
      :
    else
      ERR=true
    fi
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${B1}
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi
rm -f ${MTMAP} ${ALIMAP}


# ----------------------------------------
cd ${THISDIR}
rm -f ${MTMAP} ${ALIMAP}
if test -s ${PID2}
then
  # stop MTA components
  for i in `${CAT} ${PID2}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
