/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: reccom.h,v 1.106 2005/08/15 17:05:38 ca Exp $
 */

#ifndef SM_RECCOM_H
#define SM_RECCOM_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/memops.h"

#define UINT32_LEN	10	/* printable len of UINT32_MAX */

/* convert buffer data to integer */
/* XXX maybe use htonl/ntohl? */

#define sm_buf2uint32(buf, pval)	sm_memcpy((void *) (pval), (buf), sizeof(uint32_t))
#define sm_uint32_2buf(val, buf)	sm_memcpy((buf), (void *) &(val), sizeof(uint32_t))

#define sm_buf2uint64(buf, pval)	sm_memcpy((void *) (pval), (buf), sizeof(uint64_t))
#define sm_uint64_2buf(val, buf)	sm_memcpy((buf), (void *) &(val), sizeof(uint64_t))

/*
**  RCB types (RT_*)
**
**  RCB structure:
**	length of record (total)
**	subrecords:
**	  length
**	  type
**	  value
**
**	Should we "encode" the type of the data in the record type,
**	e.g., the last bit: 1: int, 0: str (or unstructured data)?
**	This is used by the t-rcb* programs.
**	Not just one bit, but (at least) 4 bits:
**	SM_RCBV_INT, SM_RCBV_INT64, SM_RCBV_INT2, SM_RCBV_STR, SM_RCBV_CSTR,
**	SM_RCBV_BUF.
**	see sm_rcb_putv(): it doesn't need the extra type value then, the
**	record type itself encodes the data type.
**	this also allows us to write a "generic" RCB reader as it can
**	distinguish the data types.
**	note: changing the record type requires changing the protocol version
**	(and the version number of the on-disk caches EDB and IBDB).
*/

/*
**  Notice: many RCBs need an identification of the "sender" (e.g., thread),
**  so a reply can be given back to the right place.  This is similar
**  to TCP (4-tuple and sequence ID).
*/

/* Generic: RT for protocol version	*/
#define RT_PROT_VER	0x00000001

/* Current protocol version, right now we allow only 1-1 match */
#define PROT_VER_RT	((uint32_t) 1)

#define RT_NOSEND	0x00000010	/* do not send this entry */

/* SMTPS -> QMGR (SS2QM)	*/
#define RT_S2Q_NID	0x00001001	/* id of new SMTPS */
#define RT_S2Q_ID	0x00001003	/* id of SMTPS */
#define RT_S2Q_CID	0x00001005	/* close SMTPS (id) */
#define RT_S2Q_STAT	0x00001007	/* status */
#define RT_S2Q_MAXTHRDS	0x00001009	/* max # of threads */

#define RT_S2Q_NSEID	0x00001014	/* new session id */
#define RT_S2Q_SEID	0x00001016	/* session id */
#define RT_S2Q_CSEID	0x00001018	/* close session id */
#define RT_S2Q_CLTIPV4	0x00001019	/* client IPv4 address */
#define RT_S2Q_CLTIPV6	0x0000101A	/* client IPv6 address */
#define RT_S2Q_CLTPORT	0x0000101B	/* client port */

#define RT_S2Q_NTAID	0x00001020	/* new transaction id */
#define RT_S2Q_TAID	0x00001022	/* transaction id */
#define RT_S2Q_CTAID	0x00001024	/* close transaction id */
#define RT_S2Q_DTAID	0x00001026	/* discard transaction id */

#define RT_S2Q_MAIL	0x00001030	/* mail from */
#define RT_S2Q_RCPT_IDX	0x00001031	/* rcpt idx */
#define RT_S2Q_RCPT	0x00001032	/* rcpt to */

#define RT_S2Q_CDBID	0x00001040	/* cdb id */
#define RT_S2Q_SIZE_B	0x00001043	/* message size (B) */


/*
**  QMGR -> SMTPS (Q2S); common reply format
**
**  RT_PROT_VER			PROT_VER_RT
**  RT_Q2S_ID			SMTPS id
**  RT_Q2S_SEID/RT_Q2S_TAID	session/transaction id
**  RT_Q2S_STAT[D]		status (ok, reject, more detailed?)
**  [RT_Q2S_STATT		status text]
*/

#define RT_Q2S_ID	0x00002001	/* id of SMTPS */
#define RT_Q2S_IIDC	0x00002003	/* initial id counter */
#define RT_Q2S_STAT	0x00002005	/* status for session/transaction/... */
#define RT_Q2S_STATV	0x00002007	/* status value (text follows) */
#define RT_Q2S_STATT	0x00002008	/* status text */

#define RT_Q2S_SEID	0x00002010	/* session id */
#define RT_Q2S_TAID	0x00002020	/* transaction id */
#define RT_Q2S_RCPT_IDX	0x00002031	/* rcpt idx */
#define RT_Q2S_CDBID	0x00002040	/* cdb id */

#define RT_Q2S_THRDS	0x00002051	/* slow down */
#define RT_Q2S_STOP	0x00002053	/* stop reception (use slow = 0?) */
#define RT_Q2S_DOWN	0x00002057	/* shut down */

/*
**  SMTPC -> QMGR (C2Q); common reply format
**
**  RT_PROT_VER			PROT_VER_RT
**  RT_C2Q_ID			SMTPC id
**  RT_C2Q_SEID/RT_C2Q_TAID	session/transaction id
**  RT_C2Q_{C,SE,TA}STAT[D]	status (ok, error, more detailed?)
**  [RT_C2Q_{C,SE,TA}STATT	status text]
*/

#define RT_C2Q_NID	0x00003001	/* id of new SMTPC */
#define RT_C2Q_ID	0x00003003	/* id of SMTPC */
#define RT_C2Q_CID	0x00003005	/* close SMTPC (id) */
#define RT_C2Q_MAXTHR	0x00003009	/* maximum number of threads */
#define RT_C2Q_SEID	0x00003010	/* session id */
#define RT_C2Q_TAID	0x00003020	/* transaction id */
#define RT_C2Q_TAID_CS	0x00003022	/* transaction id (and close session) */
#define RT_C2Q_STAT	0x00003031	/* SMTPC status */
#define RT_C2Q_SESTAT	0x00003041	/* session status */
#define RT_C2Q_SECLSD	0x00003043	/* session is closed */
#define RT_C2Q_TASTAT	0x00003051	/* transaction status */
#define RT_C2Q_TARSTAT	0x00003053	/* transaction + recipient status */
#define RT_C2Q_RCPT_N	0x00003055	/* number of rcpts to follow */
#define RT_C2Q_RCPT_IDX	0x00003057	/* rcpt index */
#define RT_C2Q_RCPT_ST	0x00003059	/* rcpt status */
#if 0
#define RT_C2Q_DATA_ST	0x0000305B	/* data status */
#define RT_C2Q_DOT_ST	0x0000305D	/* dot status */
#endif
#define RT_C2Q_STATT	0x00003060	/* status message */
#define RT_C2Q_RCPT_STT	0x00003062	/* recipient status message */

/*
**  We may need several of these corresponding to the various stages,
**  or we need some additional value that describes the error in more
**  detail than just the error code
*/

#define RT_C2Q_INT_ST	0x00003063	/* internal status (error) */


/* QMGR -> SMTPC (Q2C)	*/
#define RT_Q2C_ID	0x00004001	/* SMTPC id */
#if 0
/* not yet implemented */
#define RT_Q2C_DCID	0x00004003	/* delivery class id */
#endif
#define RT_Q2C_NSEID	0x00004010	/* new session */
#define RT_Q2C_SEID	0x00004012	/* session id */
#define RT_Q2C_CSEID	0x00004014	/* close session id */
#define RT_Q2C_ONESEID	0x0000401A	/* session with one transaction */
#define RT_Q2C_SRVIPV4	0x00004021	/* server IPv4 address */
#define RT_Q2C_SRVIPV6	0x00004022	/* server IPv6 address */
#define RT_Q2C_SRVPORT	0x00004023	/* server port */
#define RT_Q2C_LMTP	0x00004025	/* use LMTP */
#define RT_Q2C_DA_IDX	0x00004027	/* DA index */

#define RT_Q2C_NTAID	0x00004030	/* new transaction id */
#define RT_Q2C_TAID	0x00004032	/* transaction id */
#define RT_Q2C_CTAID	0x00004034	/* close transaction id */
#define RT_Q2C_NTAIDB	0x00004036	/* new TA id for bounce DSN */
#define RT_Q2C_NTAIDDB	0x00004038	/* new TA id for double bounce DSN */
#define RT_Q2C_NTAIDD	0x0000403A	/* new TA id for delay DSN */
#define RT_Q2C_TAID_CS	0x0000403C	/* transaction id (and close session) */
#define RT_Q2C_SSTAID	0x0000403E	/* SMTPS transaction id */
#define RT_Q2C_SIZE_B	0x00004041	/* message size (B) */

#define RT_Q2C_MAIL	0x00004044	/* mail from */
#define RT_Q2C_RCPT_IDX	0x00004045	/* rcpt index */
#define RT_Q2C_RCPT	0x00004046	/* rcpt to */

#define RT_Q2C_CDBID	0x00004050	/* cdb id */
#define RT_Q2C_CDBID_NO	0x00004052	/* cdb id (but don't use: no body) */
#define RT_Q2C_CDBID_HDR 0x00004054	/* cdb id (send only headers) */

#define RT_Q2C_B_MSG	0x00004060	/* message to list in bounce */

#define RT_Q2C_B_RCPT	0x00004062	/* rcpt address to list in bounce */
#define RT_Q2C_B_R_MSG	0x00004064	/* per rcpt message */

#define RT_Q2C_FLAGS	0x00004071	/* delivery flags */

/* QMGR -> AR (Q2R)	*/
#define RT_Q2R_ID	0x00005001	/* id */
#define RT_Q2R_TAID	0x00005002	/* transaction id */
/* kind of request, e.g., RESOLVE, ANTI-RELAY, ... */
#define RT_Q2R_FLAGS	0x00005003	/* flags */
#define RT_Q2R_TIMEOUT	0x00005005	/* timeout */
#define RT_Q2R_MAIL	0x00005010	/* mail from */
#define RT_Q2R_RCPT_IDX	0x00005025	/* rcpt index */
#define RT_Q2R_RCPT_ID	0x00005026	/* rcpt id */
#define RT_Q2R_RCPT_PA	0x00005028	/* rcpt to */

/* AR -> QMGR (R2Q)	*/
#define RT_R2Q_ID	0x00005051 /* SMAR id (unused, there is only one) */
#define RT_R2Q_TAID	0x00005052	/* transaction id */
#define RT_R2Q_MAIL_ST	0x00005053	/* mail status */
#define RT_R2Q_RCPT_ST	0x00005061	/* rcpt status */
#define RT_R2Q_RCPT_IDX	0x00005063	/* rcpt index */
#define RT_R2Q_RCPT_ID	0x00005064	/* rcpt id */
#define RT_R2Q_RCPT_DA	0x00005065	/* rcpt DA */
#define RT_R2Q_RCPT_PA	0x00005066	/* rcpt to */
#define RT_R2Q_RCPT_NAR	0x00005067	/* number of rcpt addresses */
#define RT_R2Q_RCPT_IPV4 0x00005069	/* rcpt IPv4 address (XXX HACK) */
#define RT_R2Q_RCPT_IPV6 0x0000506A	/* rcpt IPv6 address (unused) */
#define RT_R2Q_RCPT_LMTP 0x0000506B	/* LMTP (unused) */
#define RT_R2Q_RCPT_PORT 0x0000506D	/* port (Hack, per rcpt, not addr) */
#define RT_R2Q_RCPT_PRE	0x00005071	/* preference (MX) */
#define RT_R2Q_RCPT_TTL	0x00005073	/* TTL */
#define RT_R2Q_RCPT_AE	0x00005081	/* alias expansion: number of entries */
#define RT_R2Q_OWN_N	0x00005083	/* alias expansion: number of owners */
#define RT_R2Q_OWN_PA	0x00005084	/* owner address */
#define RT_R2Q_OWN_REF	0x00005085	/* reference to owner index */
#define RT_R2Q_OWN_IDX	0x00005087	/* index of owner itself */

/* SMTPS -> AR (S2A)	*/
#define RT_S2A_SEID	0x00006000	/* session id */
#define RT_S2A_ID	0x00006001	/* SMTPS id */
#define RT_S2A_IPV4	0x00006003	/* IPv4 address */
#define RT_S2A_CLT_A	0x00006004	/* client address (in-addr.arpa) */
#define RT_S2A_CLT_N	0x00006006	/* client name */
#define RT_S2A_NID	0x00006009	/* new SMTPS id */
#define RT_S2A_MAXTHRDS	0x0000600B	/* max # of threads */
#define RT_S2A_TIME	0x0000600D	/* time of connection */
#define RT_S2A_TAID	0x00006010	/* transaction id */
#define RT_S2A_MAIL	0x00006012	/* mail from */
#define RT_S2A_RCPT_ID	0x00006014	/* rcpt id */
#define RT_S2A_RCPT_IDX	0x00006015	/* rcpt idx */
#define RT_S2A_RCPT	0x00006016	/* rcpt to */
#define RT_S2A_LTYPE	0x00006021	/* lookup type */
#define RT_S2A_LFLAGS	0x00006023	/* lookup flags */
#define RT_S2A_CERTISS	0x00006030	/* cert issuer */
#define RT_S2A_CERTSUB	0x00006032	/* cert subject */

/* AR -> SMTPS (A2S)	*/
#define RT_A2S_SEID	0x00006100 /* session id */
#define RT_A2S_ID	0x00006101 /* id of SMTPS */
#define RT_A2S_TAID	0x00006102 /* transaction id */
#define RT_A2S_MAP_RES	0x00006103 /* map lookup result */
#define RT_A2S_MAIL_ST	0x00006105 /* mail status (value of RHS of map lookup) */
#define RT_A2S_STATT	0x00006108 /* status message */
#define RT_A2S_RCPT_ID	0x00006110 /* rcpt id */
#define RT_A2S_RCPT_IDX	0x00006111 /* rcpt index */
#define RT_A2S_RCPT_ST	0x00006115 /* rcpt status (value of RHS of map lookup) */
/* #define RT_A2S_MAP2_RES	0x00006117 * 2nd map lookup result */
/* #define RT_A2S_SPAM	0x00006119 * 2nd map lookup status (spam) */

#define RT_A2S_CLT_A_ST	0x00006123 /* client address status (value of RHS) */
#define RT_A2S_CLT_N_ST	0x00006127 /* client hostname status (value of RHS) */

#define RT_A2S_RVRS_ST	0x00006141 /* reverse resolve status */
#define RT_A2S_N_HOSTN	0x00006143 /* number of host names */
#define RT_A2S_RVRS_NAME 0x00006144 /* host name from reverse resolution */
#define RT_A2S_CERT_ST	0x00006161 /* cert lookup status (value of RHS of map lookup) */

/* CLIENT -> AR (C2A) (XXX this overlaps with RT_S2A_: WHY???? */
#define RT_C2A_SEID	0x00006000	/* session id */
#define RT_C2A_ID	0x00006001	/* SMTPS id */
#define RT_C2A_TAID	0x00006002	/* transaction id */
#define RT_C2A_IPV4	0x00006003	/* IPv4 address */
#define RT_C2A_LTYPE	0x00006021	/* lookup type */
#define RT_C2A_LFLAGS	0x00006023	/* lookup flags */

/* SMTPS -> PMILTER (S2M)	*/
#define RT_S2M_PROT	0x00007001 /* pmilter protocol */
#define RT_S2M_NID	0x00007003 /* SMTPS id (new) */
#define RT_S2M_MAXTHRDS	0x00007005 /* max # of threads */
#define RT_S2M_CAP	0x00007007 /* SMTPS capabilities, see sm/pmilter.h */
#define RT_S2M_FCT	0x00007009 /* SMTPS functions */
#define RT_S2M_FEAT	0x0000700B /* SMTPS features */
#define RT_S2M_MISC	0x0000700D /* SMTPS features */

#define RT_S2M_ID	0x0000700F /* SMTPS id */

#define RT_S2M_NSEID	0x00007010 /* new session id */
#define RT_S2M_PORT	0x00007011 /* port */
#define RT_S2M_HOST	0x0000701A /* hostname */
#define RT_S2M_IPV4	0x0000701B /* IPv4 address */

#define RT_S2M_SEID	0x0000701A /* session id */
#define RT_S2M_HELO	0x0000701C /* helo name */
#define RT_S2M_NTAID	0x00007020 /* new transaction id */
#define RT_S2M_TAID	0x00007022 /* transaction id */
#define RT_S2M_MAIL	0x00007024 /* mail from */
#define RT_S2M_ARG	0x00007026 /* arg for mail/rcpt */
#define RT_S2M_RCPT_ID	0x00007030 /* rcpt id */
#define RT_S2M_RCPT_IDX	0x00007031 /* rcpt idx */
#define RT_S2M_RCPT	0x00007032 /* rcpt to */
#define RT_S2M_RCPT_ST	0x00007033 /* rcpt status */
#define RT_S2M_DATA	0x00007040 /* data */
#define RT_S2M_MSG	0x00007042 /* message chunk */
#define RT_S2M_DOT	0x00007044 /* last message chunk */
#define RT_S2M_ABORT_TA	0x00007046 /* abort transaction */
#define RT_S2M_MACW	0x00007051 /* macro: "Where" */
#define RT_S2M_MACN	0x00007052 /* macro name */
#define RT_S2M_MACM	0x00007053 /* macro "name" encoded as uint32 */
#define RT_S2M_MACV	0x00007054 /* macro value */
#define RT_S2M_CSEID	0x00007060 /* session id (close) */
#define RT_S2M_CID	0x00007071 /* SMTPS id (close) */


/* PMILTER -> SMTPS (M2S)	*/
#define RT_M2S_PROT	0x00007101 /* pmilter protocol */
#define RT_M2S_ID	0x00007103 /* id of SMTPS */
#define RT_M2S_CAP	0x00007105 /* requested capabilities */
#define RT_M2S_FCT	0x00007107 /* requested functions */
#define RT_M2S_FEAT	0x00007109 /* requested features */

#define RT_M2S_SEID	0x0000710A /* session id */
/* #define RT_M2S_TAID	0x00007110 * transaction id */
#define RT_M2S_RCODE	0x00007111 /* reply code */
#define RT_M2S_STATT	0x00007112 /* reply text */

#define RT_M2S_MACW	0x00007121 /* macro: "Where" */
#define RT_M2S_MACM	0x00007123 /* macro "name" encoded as uint32 */

/* DEFEDB	*/
#define RT_EDB_TAID		0x00010000	/* transaction id */
#define RT_EDB_TA_ST		0x00010001	/* transaction status */
#define RT_EDB_MAIL_PA		0x00010002	/* mail from */
#define RT_EDB_TA_R_TOT		0x00010003	/* total recipients */
#define RT_EDB_TA_R_LEFT	0x00010005	/* undelivered recipients */
#define RT_EDB_TA_R_TEMP	0x00010007	/* temp fail recipients */
#define RT_EDB_TA_R_PERM	0x00010009	/* perm fail recipients */
#define RT_EDB_TA_R_TRIED	0x0001000B	/* tried recipients */
#define RT_EDB_TA_R_NXT		0x0001000D	/* next recipient idx */
#if 0
/* should these be in DEFEDB? */
#define RT_EDB_TA_R_T_AR	0x00010011	/* recipients to SMAR */
#define RT_EDB_TA_R_F_AR	0x00010013	/* recipients from SMAR */
#endif /* 0 */
#define RT_EDB_TA_ST_TI		0x00010010	/* start time (reception) */
#define RT_EDB_TA_FL		0x00010015	/* flags */
#define RT_EDB_OWN_N		0x00010017	/* number of owners addresses */
#define RT_EDB_OWN_PA		0x00010018	/* owner address */
#define RT_EDB_CDBID		0x00010020	/* cdb id */
#define RT_EDB_SIZE_B		0x00010023	/* size of body (B) */

/* Recipient */
#define RT_EDBR_TAID	0x00010040	/* rcpt id */
#define RT_EDBR_IDX	0x00010041	/* rcpt idx */
#define RT_EDBR_ST	0x00010043	/* rcpt status code */
#define RT_EDBR_PA	0x00010044	/* rcpt to */
#define RT_EDBR_STT	0x00010045	/* rcpt status message */
#define RT_EDBR_OWN	0x00010047	/* reference to owner */
#define RT_EDBR_ST_TI	0x00010051	/* start time (reception) */
#define RT_EDBR_LA_TI	0x00010053	/* last time tried */
#define RT_EDBR_NX_TI	0x00010055	/* next time to try */
#define RT_EDBR_TRIES	0x00010061	/* # of tries */
#define RT_EDBR_FL	0x00010063	/* flags */
#define RT_EDBR_DSNFL	0x00010065	/* DSN flags */

/* Resolved address... XXX needs more details */
#define RT_EDBR_ADDRS	0x000100A1	/* number of addresses */
#define RT_EDBR_PORT	0x000100A3	/* port (Hack, per rcpt, not addr) */
#define RT_EDBR_DA	0x000100A5	/* rcpt DA */
#define RT_EDBR_IPV4	0x000100A7	/* rcpt IPv4 address (XXX HACK) */
#define RT_EDBR_EXPT	0x000100A9	/* rcpt address expiration time */
#define RT_EDBR_PREF	0x000100AB	/* rcpt address pref */

#define RT_EDBR_F_IPV4	0x000100B1	/* failure IPv4 address (XXX HACK) */
#define RT_EDBR_ERR_ST	0x000100B3	/* rcpt status code */
#define RT_EDBR_B_MSG	0x000100C0	/* bounce message (for bounce rcpt) */
#define RT_EDBR_IDX_B	0x000100C1	/* bounce rcpt idx */
#define RT_EDBR_IDX_D	0x000100C3	/* delayed DSN rcpt idx */

#define RT_EDBR_IDX_A	0x000100D1	/* alias-expanded from rcpt idx */

#define RT_EDB_VERSION	0x00010101	/* version */

/* control -> QMGR	*/
#define RT_CTL2Q_INFO	0x00100001	/* send information */
#define RT_CTL2Q_S_RCPT	0x00100002	/* "schedule" recipient */
#define RT_CTL2Q_D_RCPT	0x00100004	/* delete recipient */
#define RT_CTL2Q_D_TA	0x00100014	/* delete transaction */
#define RT_CTL2Q_R_MAP	0x00100021	/* reload maps */

#define RT_CTL2Q_DBG	0x00100031	/* set debug level */
#define RT_CTL2Q_DBG_C	0x00100033	/* debug category/level (2 values) */

/* QMGR -> control	*/
#define RT_Q2CTL_INFO	0x00101000	/* full information */

#define RT_END_OF_RCB	0x45524342	/* end of RCB marker */

#endif /* SM_RECCOM_H */
