/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sasl.h,v 1.10 2005/10/27 21:18:51 ca Exp $
 */

#ifndef SM_SASL_H
#define SM_SASL_H 1
#include "sm/generic.h"
#include "sm/io.h"
#include "sm/log.h"

#if SM_USE_SASL
#include <sasl/sasl.h>
#include <sasl/saslutil.h>

#define ENC64LEN(l)	(((l) + 2) * 4 / 3 + 1)

typedef struct sm_sasl_ctx_S sm_sasl_ctx_T, *sm_sasl_ctx_P;

struct sm_sasl_ctx_S
{
	uint32_t	 sm_sasl_sec_flags;
	uint32_t	 sm_sasl_flags;
	int		 sm_sasl_n_mechs;
	sasl_security_properties_t	 sm_sasl_ssp;
	sasl_ssf_t	*sm_sasl_sf;

	sm_log_ctx_P	 sm_sasl_lctx;
	sm_logconfig_P	 sm_sasl_lcfg;
};

sm_ret_T sm_sasl_init(bool _server, uint32_t flags, sm_log_ctx_P _lctx, sm_sasl_ctx_P *_psasl_ctx);
sm_ret_T sm_saslmechs(sm_sasl_ctx_P _sasl_ctx, sasl_conn_t *_conn, char **_mech_list);

char	*iteminlist(const char *_item, char *_list, const char *_delim);

sm_ret_T sm_saslversionprt(sm_file_T *_fp);
sm_ret_T sm_saslversionok(void);

#define SASL_NOT_AUTH	0		/* not authenticated */
#define SASL_PROC_AUTH	1		/* in process of authenticating */
#define SASL_IS_AUTH	2		/* authenticated */

#define SASL_FL_NONE	0x00
#define SASL_FL_NOMECH	0x01

#endif /* SM_USE_SASL */
#endif /* SM_SASL_H */
