/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: stsock.h,v 1.9 2005/08/25 22:06:56 ca Exp $
 */

#ifndef SM_STSOCK_H
#define SM_STSOCK_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/error.h"
#include "sm/socket.h"
#include "sm/sockcnf.h"
#include "sm/unixsock.h"
#include "statethreads/st.h"

#define INVALID_NETFD	NULL

sm_ret_T un_st_socket_close(st_netfd_t _sock);
sm_ret_T un_st_client_connect(const char *_name, st_utime_t _tmo, st_netfd_t *_fd);

sm_ret_T un_st_server_listen(const char *_name, int _backlog, st_netfd_t *_fd);
sm_ret_T un_st_server_listen_addr(sockaddr_un_T *_my_addr, socklen_T _addrlen, int _backlog, st_netfd_t *_fd);
sm_ret_T un_st_server_accept(st_netfd_t _listenfd, struct sockaddr *_addr, sockaddr_len_T *_addrlen, st_netfd_t *_fd);

sm_ret_T st_sock_connect(sockspec_P _sockspec, st_utime_t _tmo, st_netfd_t *_fd);

#endif /* SM_STSOCK_H */
