/*
 * Copyright (c) 2000-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: varargs.h,v 1.9 2005/06/16 00:09:35 ca Exp $
 */

#ifndef SM_VARARGS_H
#define SM_VARARGS_H 1

#include "sm/generic.h"

#if HAVE_STDARG_H
# include <stdarg.h>
#else
  ERROR: need stdarg.h
#endif

#if defined(va_copy)
# define SM_VA_COPY(dst, src)	va_copy((dst), (src))
#elif defined(__va_copy)
# define SM_VA_COPY(dst, src)	__va_copy((dst), (src))
#else
# define SM_VA_COPY(dst, src)	(dst) = (src)
#endif

#endif /* ! SM_VARARGS_H */
