/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sm-conf-type.c,v 1.6 2005/05/31 21:03:55 ca Exp $")

#if SM_LIBCONF_ALONE
#include "sm-conf.h"
#else
#include "sm/sm-conf.h"
#endif

#include "sm-conf-node.h"
#include "sm-conf-state.h"
#include "sm-conf-type.h"

/*
**  SM_CONF_NODE_TO_VALUE -- utility for type implementations.
**
**	Get the text of a node; complain if the node isn't
**	a single-valued text.
**
**	Parameters:
**		smc -- overall system handle
**		expected -- what the caller expects to see, used
**			to word the error message
**		node -- node whose value we're trying to access
**		text_out -- out: (shared) char pointer to node value
**		text_n_out -- out: # of bytes pointed to by *text_out.
**
**	Returns:
**		0 on success,
**		SM_CONF_ERR_TYPE on type mismatch,
**		other nonzero error codes.
*/

int
sm_conf_node_to_value(
	sm_conf_T		*smc,
	char const		*expected,
	sm_conf_node_T		*node,
	char const		**text_out,
	size_t			*text_n_out)
{
	char			nbuf[SM_CONF_ERROR_BUFFER_SIZE];

	switch (sm_conf_node_type(smc, node))
	{
	  case SM_CONF_NODE_VALUE:
		break;

	  case SM_CONF_NODE_LIST:
		sm_conf_error_add(smc, "%s: expected %s, got list",
			sm_conf_node_location(smc, node, nbuf, sizeof nbuf),
			expected);
		return SM_CONF_ERR_TYPE;

	  case SM_CONF_NODE_SECTION:
		sm_conf_error_add(smc, "%s: expected %s, got section",
			sm_conf_node_location(smc, node, nbuf, sizeof nbuf),
			expected);
		return SM_CONF_ERR_TYPE;
	}

	return sm_conf_value(smc, node, text_out, text_n_out);
}

