/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: edbcexists.c,v 1.2 2004/09/27 19:45:10 ca Exp $")
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/assert.h"
#include "sm/str.h"
#include "sm/edbc.h"
#include "edbc.h"
#include "sm/qmgrdbg.h"

/*
**  EDBC_EXISTS -- does an entry with rcpt_id exist in envelope database cache
**
**	Parameters:
**		edbc_ctx -- edbc context
**		rcpt_id -- Recipient Id
**
**	Returns:
**		true iff found
**
**	Locking: must be performed by caller.
*/

bool
edbc_exists(edbc_ctx_P edbc_ctx, rcpt_id_T rcpt_id)
{
	edbc_tnode_P edbc_tnode;
	edbc_node_P edbc_node, edbc_node_nxt;

	SM_REQUIRE(edbc_ctx != NULL);
	edbc_tnode = RB_MIN(edbc_tree_S, &(edbc_ctx->edbc_root));
	while (edbc_tnode != NULL)
	{
		for (edbc_node = ECNL_FIRST(&(edbc_tnode->ectn_hd));
		     edbc_node != ECNL_END(&(edbc_tnode->ectn_hd));
		     edbc_node = edbc_node_nxt)
		{
			edbc_node_nxt = ECNL_NEXT(edbc_node);
			if (RCPT_ID_EQ(edbc_node->ecn_rcpt_id, rcpt_id))
				return true;
		}
		edbc_tnode = RB_NEXT(edbc_tree_S, &(edbc_ctx->edbc_root),
					edbc_tnode);
	}
	return false;
}
