/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: evthrblock.c,v 1.9 2005/07/12 23:23:37 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/memops.h"
#include "sm/evthr.h"

#ifndef EVTHR_BLOCK
# define EVTHR_BLOCK	1
#endif

/*
**  EVTHR_BEFORE_BLOCK -- a thread enters a blocking section
**
**	Parameters:
**		evthr_ctx -- evthr context
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
evthr_before_block(sm_evthr_ctx_P evthr_ctx)
{
#if EVTHR_BLOCK
	int r;

	SM_IS_EVTHR_CTX(evthr_ctx);
	r = pthread_mutex_lock(&(evthr_ctx->evthr_c_runqmut));
	SM_LOCK_OK(r);
	if (r != 0)
		return sm_error_temp(SM_EM_EVTHR, r);
	SM_ASSERT(evthr_ctx->evthr_c_act > 0);
	--evthr_ctx->evthr_c_act;
	r = pthread_mutex_unlock(&(evthr_ctx->evthr_c_runqmut));
	SM_ASSERT(r == 0);
	if (r != 0)
		return sm_error_perm(SM_EM_EVTHR, r);
#endif /* EVTHR_BLOCK */
	return SM_SUCCESS;
}

/*
**  EVTHR_AFTER_BLOCK -- a thread leaves a blocking section
**
**	Parameters:
**		evthr_ctx -- evthr context
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
evthr_after_block(sm_evthr_ctx_P evthr_ctx)
{
#if EVTHR_BLOCK
	int r;

	SM_IS_EVTHR_CTX(evthr_ctx);
	r = pthread_mutex_lock(&(evthr_ctx->evthr_c_runqmut));
	SM_LOCK_OK(r);
	if (r != 0)
		return sm_error_temp(SM_EM_EVTHR, r);
	++evthr_ctx->evthr_c_act;
	r = pthread_mutex_unlock(&(evthr_ctx->evthr_c_runqmut));
	SM_ASSERT(r == 0);
	if (r != 0)
		return sm_error_perm(SM_EM_EVTHR, r);
#endif /* EVTHR_BLOCK */
	return SM_SUCCESS;
}
