/*
 * Copyright (c) 2002-2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fgetline.c,v 1.5 2004/07/26 18:16:03 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/assert.h"
#include "sm/memops.h"
#include "sm/str.h"
#include "io-int.h"

/*
**  SM_FGETLINE -- get a line (\r\n) from a file
**	Note: \r\n is preserved in str; see fgetline0.c for an alternative
**
**	Parameters:
**		fp -- file pointer to read from
**		str -- str to place read data
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_fgetline(sm_file_T *fp, sm_str_P str)
{
	int ch;
	sm_ret_T res;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);

	while ((ch = sm_getc(fp)) != SM_IO_EOF)
	{
		if (sm_is_err(ch))
			return ch;
		res = sm_str_put(str, (uchar) ch);
		if (sm_is_err(res))
			return res;
		if (ch != '\r')
			continue;
		ch = sm_getc(fp);
		if (ch == SM_IO_EOF || sm_is_err(ch))
			return ch;
		res = sm_str_put(str, (uchar) ch);
		if (sm_is_err(res))
			return res;
		if (ch == '\n')
			return SM_SUCCESS;
	}
	return ch;
}
