/*
 * Copyright (c) 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbesetcb.c,v 1.1 2003/10/16 17:40:19 ca Exp $")

#include "sm/assert.h"
#include "sm/rcb.h"
#include "sm/rcbl.h"

/*
**  SM_RCBE_SETCB -- Set callback and context in a RCB list element.
**
**	Parameters:
**		rcbe -- RCB entry
**		wr_cb -- callback to invoke after a successful rcb_snd
**		ctx -- context for callback
**
**	Returns:
**		none.
*/

void
sm_rcbe_setcb(sm_rcbe_P rcbe, rcb_wr_cb_F wr_cb, void *ctx)
{
	SM_IS_RCBE(rcbe);
	rcbe->rcbe_wr_cb = wr_cb;
	rcbe->rcbe_ctx = ctx;
}
