/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbskip.c,v 1.2 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"
#include "sm/rcb.h"

/*
**  SM_RCB_SKIP -- Skip over current record (length: n)
**
**	Parameters:
**		rcb -- sm_rcb_P object to read from.
**		n -- number of bytes to skip
**
**	Returns:
**		usual sm_error code; SM_E_OVFLW_NS
**
**	Side Effects:
**
**	Last code review:
**	Last code change: 2005-05-29 17:15:03
*/

sm_ret_T
sm_rcb_skip(sm_rcb_P rcb, uint n)
{
	uint la;

	SM_IS_RCB(rcb);
#if SM_RCB_CHECK
	SM_REQUIRE(rcb->sm_rcb_state == SM_RCB_DEC);
#endif
	SM_REQUIRE(n < INT_MAX);
	la = SM_ALIGN4(n);
	SM_ASSERT(la >= n);
	SM_ASSERT(rcb->sm_rcb_rw >= 0);
	SM_ASSERT((uint)rcb->sm_rcb_rw + la >= (uint)rcb->sm_rcb_rw);
	SM_ASSERT(rcb->sm_rcb_rw + la < INT_MAX);
	if ((uint)rcb->sm_rcb_rw + la > rcb->sm_rcb_len)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	rcb->sm_rcb_rw += la;
	return SM_SUCCESS;
}
