/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qmgrprtcnf.c,v 1.6 2004/11/01 17:51:35 ca Exp $")
#include "sm/types.h"
#include "sm/io.h"
#include "sm/qmgrcnf.h"
#include "sm/qmgrcnfdef.h"
#include "sm/sm-conf-prt.h"

/*
**  QMGR_PRT_CNF -- Print configuration data
**
**	Parameters:
**		qmgr_cnf -- QMGR configuration context
**		fp -- file for output
**		all -- print also "global" config data?
**
**	Returns:
**		none.
*/

void
qmgr_prt_cnf(qmgr_cnf_P qmgr_cnf, sm_file_T *fp, bool all)
{
	if (all)
		(void) sm_conf_prt_conf(qmgr_global_defs, qmgr_cnf, fp);
	else
		(void) sm_conf_prt_conf(qmgr_defs, qmgr_cnf, fp);
}
