/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qm_ss.c,v 1.73 2005/03/15 19:56:10 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/rcb.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "sm/rcbcomm.h"
#include "qmgr.h"
#include "log.h"

/*
**  QMGR_SMTPS -- QMGR - SMTPS interface
**	This runs as a task.
**
**	Parameters:
**		tsk -- evthr task
**
**	Returns:
**		usual sm_error code
**
**	Last code review: 2003-10-17 16:25:27, see below
**	Last changes: 2003-11-26 05:16:28
*/

sm_ret_T
qmgr_smtps(sm_evthr_task_P tsk)
{
	sm_ret_T ret;

	SM_IS_EVTHR_TSK(tsk);
	QM_LEV_DPRINTFC(QDC_Q2S, 5, (QM_DEBFP, "sev=DBG, func=qmgr_smtps, fd=%d, ev_rq=%#x, ev_occ=%#x\n", tsk->evthr_t_fd, evthr_rqevents(tsk), tsk->evthr_t_evocc));
	if (is_valid_fd(tsk->evthr_t_fd))
	{
		ret = EVTHR_WAITQ;
		if (evthr_got_slp(tsk))
		{
			sm_ret_T res;

			/* don't set ret here, it's the wrong return value */
			res = qm_ss_wakeup(tsk);
			if (sm_is_err(res))
			{
				QM_LEV_DPRINTFC(QDC_Q2S, 1, (QM_DEBFP, "sev=DBG, func=qmgr_smtps, qm_ss_wakeup=%r\n", res));
			}
		}
		if (evthr_got_wr(tsk))
		{
			ret = qm_to_ss(tsk);
			if (sm_is_err(ret))
			{
				QM_LEV_DPRINTFC(QDC_Q2S, 1, (QM_DEBFP, "sev=DBG, func=qmgr_smtps, qm_to_ss=%r\n", ret));
				/* really return here? */
				return ret;
			}
		}
		if (evthr_got_rd(tsk))
		{
			/*
			**  This routine could set EVTHR_EV_WR
			**  to cause data to be written back to the SMTPS.
			**  However, most of the routines may work
			**  asynchronously and hence they should return the
			**  correct value themselves.
			*/

			ret = qm_fr_ss(tsk);
			if (sm_is_err(ret))
			{
				QM_LEV_DPRINTFC(QDC_Q2S, 1, (QM_DEBFP, "sev=DBG, func=qmgr_smtps, qm_fr_ss=%r\n", ret));
				return ret;
			}
		}
		return ret;
	}
	return EVTHR_DEL;
}
