/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcpth.c,v 1.12 2005/10/02 18:12:12 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/net.h"
#include "sm/rcb.h"
#include "sm/mta.h"
#include "sm/rfc2821.h"
#include "smar.h"

/*
**  SMAR_RCPT_NEW -- Create a SMAR RCPT context
**
**	Parameters:
**		psmar_rcpt -- (pointer to) SMAR RCPT context (output)
**
**	Returns:
**		usual sm_error code
**
**	Last code review: 2004-03-22 04:37:24
**	Last code change: 2005-02-04 18:21:48
*/

sm_ret_T
smar_rcpt_new(smar_rcpt_P *psmar_rcpt)
{
	smar_rcpt_P smar_rcpt;

	SM_REQUIRE(psmar_rcpt != NULL);
	smar_rcpt = (smar_rcpt_P) sm_zalloc(sizeof(*smar_rcpt));
	if (smar_rcpt == NULL)
		return sm_error_temp(SM_EM_AR, ENOMEM);
	smar_rcpt->sm_magic = SM_SMAR_RCPT_MAGIC;
	*psmar_rcpt = smar_rcpt;
	return SM_SUCCESS;
}

/*
**  SMAR_RCPT_FREE -- Free a SMAR RCPT context
**
**	Parameters:
**		smar_rcpt -- SMAR RCPT context
**		smar_rcpts -- SMAR RCPT LIST context
**
**	Returns:
**		usual sm_error code
**
**	Last code review: 2004-03-22 04:37:51; see comments
**	Last code change: 2005-10-01 17:10:39
*/

sm_ret_T
smar_rcpt_free(smar_rcpt_P smar_rcpt, smar_rcpts_P smar_rcpts)
{
	if (smar_rcpt == NULL)
		return SM_SUCCESS;
	SM_IS_SMAR_RCPT(smar_rcpt);

	/* XXX free other data... */
	SM_STR_FREE(smar_rcpt->arr_domain_pa);
	SM_STR_FREE(smar_rcpt->arr_pa);
	SM_STR_FREE(smar_rcpt->arr_owner_pa);
	if (smar_rcpt->arr_res != NULL)
	{
		int i;
		smar_dns_P smar_dns;

		for (i = 0; i < smar_rcpt->arr_A_qsent; i++)
		{
			smar_dns = &(smar_rcpt->arr_res[i]);
			SM_FREE(smar_dns->ardns_A_rrs);
			SM_CSTR_FREE(smar_dns->ardns_name);
		}
		sm_free(smar_rcpt->arr_res);
	}
	if (smar_rcpts != NULL)
	{
		if (smar_rcpts->arrs_rcpt == smar_rcpt)
		{
			SM_ASSERT(SMARR_IS_FLAG(smar_rcpt, SMARR_FL_ORCPT));
			SMARR_CLR_FLAG(smar_rcpt, SMARR_FL_ORCPT);
			smar_rcpts->arrs_rcpt = NULL;
		}
		if (SMARR_IS_FLAG(smar_rcpt, SMARR_FL_INRLST))
			RCPTS_REMOVE(smar_rcpts, smar_rcpt);
		if (SMARR_IS_FLAG(smar_rcpt, SMARR_FL_INOWNLST))
			OWNER_REMOVE(smar_rcpts, smar_rcpt);
	}

	smar_rcpt->sm_magic = SM_MAGIC_NULL;
	sm_free_size(smar_rcpt, sizeof(*smar_rcpt));
	return SM_SUCCESS;
}
