#!/bin/sh
# $Id: t-cert-0.sh,v 1.14 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test cert lookups to allow relaying
# Uses smar, t-access-0, access map, t-mm, startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=cert-0.out
OUTF=cert-0.outf
OK=cert-0.ok
VERBOSE=false
TPRG=./t-access-0

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# XREF: include/sm/smreplycodes.h SMTP_R_RELAY
SMTP_R_RELAY=8
CI1='c=us/st=ca/o=example.org/cn=darth+20mail+20+28cert+29/email=darth+2bcert@example.org'
CS1='/c=us/st=ca/o=example.org/cn=cs1/email=cs1@example.org'
CI2='c=us/st=ca/o=example.org/cn=ci2/email=ci2+2bcert@example.org'
CS2='/c=us/st=ca/o=example.org/cn=cs2/email=cs2@example.org'
CI3='c=us/st=ca/o=example.org/cn=ci3/email=ci3+2bcert@example.org'
CS3='/c=us/st=ca/o=example.org/cn=cs3/email=cs3@example.org'
CI4='c=us/st=ca/o=example.org/cn=ci4/email=ci4+2bcert@example.org'
CS4='/c=us/st=ca/o=example.org/cn=cs4/email=cs4@example.org'
CI5='c=us/st=ca/o=example.org/cn=ci5/email=ci5+2bcert@example.org'
CS5='/c=us/st=ca/o=example.org/cn=cs5/email=cs5@example.org'

rm -f ${ACCMAP} ${SOCK} ${PIDS}
# create access map for tests
${MM} -t'	' -F ${ACCMAP} <<EOF
certissuer:${CI1}	relay
certsubject:${CS1}	relay
certissuer:${CI2}	cont
certsubject:${CS2}	relay
certissuer:${CI3}	cont
certsubject:${CS3}	cont
certissuer:${CI4}	cont
EOF

killit()
{
if test -s ${PIDS}
then
  # stop SMAR
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
exit 1
}
trap killit 2

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${OUTF} ${OK}

TEST=1
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -c ${CS1} ${CI1} > ${OUT} 2>&1
grep '^cert-status=' ${OUT} > ${OUTF}
cat > ${OK} <<EOF
cert-status=${SMTP_R_RELAY}
EOF
if diff ${OK} ${OUTF}
then
  ${VERBOSE} && echo "$0: test ${TEST} OK"
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

TEST=2
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -c ${CS2} ${CI2} > ${OUT} 2>&1
grep '^cert-status=' ${OUT} > ${OUTF}
cat > ${OK} <<EOF
cert-status=${SMTP_R_RELAY}
EOF
if diff ${OK} ${OUTF}
then
  ${VERBOSE} && echo "$0: test ${TEST} OK"
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

TEST=3
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -c ${CS3} ${CI3} > ${OUT} 2>&1
grep '^cert-status=' ${OUT} > ${OUTF}
cat > ${OK} <<EOF
cert-status=${SMAR_DFLT_RES}
EOF
if diff ${OK} ${OUTF}
then
  ${VERBOSE} && echo "$0: test ${TEST} OK"
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi

TEST=4
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
${VALGRIND} ${TPRG} -c ${CS4} ${CI4} > ${OUT} 2>&1
egrep '^(cert-status|react)=' ${OUT} > ${OUTF}
cat > ${OK} <<EOF
react=no_match
EOF
if diff ${OK} ${OUTF}
then
  ${VERBOSE} && echo "$0: test ${TEST} OK"
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi
else
  ${VERBOSE} && echo "$0: test ${TEST} SKIPPED"
fi


# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
sleep 3

exit ${ERRS}
