/* ====================================================================
 * Copyright (c) 2011 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.openssl.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.openssl.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* Selftest and health check data for the SP800-90 DRBG */


/* AES-128 use df PR  */
__fips_constseg
static const unsigned char aes_128_use_df_pr_entropyinput[] =
	{
	0x61,0x52,0x7c,0xe3,0x23,0x7d,0x0a,0x07,0x10,0x0c,0x50,0x33,
	0xc8,0xdb,0xff,0x12
	};

__fips_constseg
static const unsigned char aes_128_use_df_pr_nonce[] =
	{
	0x51,0x0d,0x85,0x77,0xed,0x22,0x97,0x28
	};

__fips_constseg
static const unsigned char aes_128_use_df_pr_personalizationstring[] =
	{
	0x59,0x9f,0xbb,0xcd,0xd5,0x25,0x69,0xb5,0xcb,0xb5,0x03,0xfe,
	0xd7,0xd7,0x01,0x67
	};

__fips_constseg
static const unsigned char aes_128_use_df_pr_additionalinput[] =
	{
	0xef,0x88,0x76,0x01,0xaf,0x3c,0xfe,0x8b,0xaf,0x26,0x06,0x9e,
	0x9a,0x47,0x08,0x76
	};

__fips_constseg
static const unsigned char aes_128_use_df_pr_entropyinputpr[] =
	{
	0xe2,0x76,0xf9,0xf6,0x3a,0xba,0x10,0x9f,0xbf,0x47,0x0e,0x51,
	0x09,0xfb,0xa3,0xb6
	};

__fips_constseg
static const unsigned char aes_128_use_df_pr_int_returnedbits[] =
	{
	0xd4,0x98,0x8a,0x46,0x80,0x4c,0xdb,0xa3,0x59,0x02,0x57,0x52,
	0x66,0x1c,0xea,0x5b
	};

__fips_constseg
static const unsigned char aes_128_use_df_pr_additionalinput2[] =
	{
	0x88,0x8c,0x91,0xd6,0xbe,0x56,0x6e,0x08,0x9a,0x62,0x2b,0x11,
	0x3f,0x5e,0x31,0x06
	};

__fips_constseg
static const unsigned char aes_128_use_df_pr_entropyinputpr2[] =
	{
	0xc0,0x5c,0x6b,0x98,0x01,0x0d,0x58,0x18,0x51,0x18,0x96,0xae,
	0xa7,0xe3,0xa8,0x67
	};

__fips_constseg
static const unsigned char aes_128_use_df_pr_returnedbits[] =
	{
	0xcf,0x01,0xac,0x22,0x31,0x06,0x8e,0xfc,0xce,0x56,0xea,0x24,
	0x0f,0x38,0x43,0xc6
	};


/* AES-128 use df No PR  */
__fips_constseg
static const unsigned char aes_128_use_df_entropyinput[] =
	{
	0x1f,0x8e,0x34,0x82,0x0c,0xb7,0xbe,0xc5,0x01,0x3e,0xd0,0xa3,
	0x9d,0x7d,0x1c,0x9b
	};

__fips_constseg
static const unsigned char aes_128_use_df_nonce[] =
	{
	0xd5,0x4d,0xbd,0x4a,0x93,0x7f,0xb8,0x96
	};

__fips_constseg
static const unsigned char aes_128_use_df_personalizationstring[] =
	{
	0xab,0xd6,0x3f,0x04,0xfe,0x27,0x6b,0x2d,0xd7,0xc3,0x1c,0xf3,
	0x38,0x66,0xba,0x1b
	};

__fips_constseg
static const unsigned char aes_128_use_df_additionalinput[] =
	{
	0xfe,0xf4,0x09,0xa8,0xb7,0x73,0x27,0x9c,0x5f,0xa7,0xea,0x46,
	0xb5,0xe2,0xb2,0x41
	};

__fips_constseg
static const unsigned char aes_128_use_df_int_returnedbits[] =
	{
	0x42,0xe4,0x4e,0x7b,0x27,0xdd,0xcb,0xbc,0x0a,0xcf,0xa6,0x67,
	0xe7,0x57,0x11,0xb4
	};

__fips_constseg
static const unsigned char aes_128_use_df_entropyinputreseed[] =
	{
	0x14,0x26,0x69,0xd9,0xf3,0x65,0x03,0xd6,0x6b,0xb9,0x44,0x0b,
	0xc7,0xc4,0x9e,0x39
	};

__fips_constseg
static const unsigned char aes_128_use_df_additionalinputreseed[] =
	{
	0x55,0x2e,0x60,0x9a,0x05,0x72,0x8a,0xa8,0xef,0x22,0x81,0x5a,
	0xc8,0x93,0xfa,0x84
	};

__fips_constseg
static const unsigned char aes_128_use_df_additionalinput2[] =
	{
	0x3c,0x40,0xc8,0xc4,0x16,0x0c,0x21,0xa4,0x37,0x2c,0x8f,0xa5,
	0x06,0x0c,0x15,0x2c
	};

__fips_constseg
static const unsigned char aes_128_use_df_returnedbits[] =
	{
	0xe1,0x3e,0x99,0x98,0x86,0x67,0x0b,0x63,0x7b,0xbe,0x3f,0x88,
	0x46,0x81,0xc7,0x19
	};


/* AES-192 use df PR  */
__fips_constseg
static const unsigned char aes_192_use_df_pr_entropyinput[] =
	{
	0x2b,0x4e,0x8b,0xe1,0xf1,0x34,0x80,0x56,0x81,0xf9,0x74,0xec,
	0x17,0x44,0x2a,0xf1,0x14,0xb0,0xbf,0x97,0x39,0xb7,0x04,0x7d
	};

__fips_constseg
static const unsigned char aes_192_use_df_pr_nonce[] =
	{
	0xd6,0x9d,0xeb,0x14,0x4e,0x6c,0x30,0x1e,0x39,0x55,0x73,0xd0,
	0xd1,0x80,0x78,0xfa
	};

__fips_constseg
static const unsigned char aes_192_use_df_pr_personalizationstring[] =
	{
	0xfc,0x43,0x4a,0xf8,0x9a,0x55,0xb3,0x53,0x83,0xe2,0x18,0x16,
	0x0c,0xdc,0xcd,0x5e,0x4f,0xa0,0x03,0x01,0x2b,0x9f,0xe4,0xd5,
	0x7d,0x49,0xf0,0x41,0x9e,0x3d,0x99,0x04
	};

__fips_constseg
static const unsigned char aes_192_use_df_pr_additionalinput[] =
	{
	0x5e,0x9f,0x49,0x6f,0x21,0x8b,0x1d,0x32,0xd5,0x84,0x5c,0xac,
	0xaf,0xdf,0xe4,0x79,0x9e,0xaf,0xa9,0x82,0xd0,0xf8,0x4f,0xcb,
	0x69,0x10,0x0a,0x7e,0x81,0x57,0xb5,0x36
	};

__fips_constseg
static const unsigned char aes_192_use_df_pr_entropyinputpr[] =
	{
	0xd4,0x81,0x0c,0xd7,0x66,0x39,0xec,0x42,0x53,0x87,0x41,0xa5,
	0x1e,0x7d,0x80,0x91,0x8e,0xbb,0xed,0xac,0x14,0x02,0x1a,0xd5
	};

__fips_constseg
static const unsigned char aes_192_use_df_pr_int_returnedbits[] =
	{
	0xdf,0x1d,0x39,0x45,0x7c,0x9b,0xc6,0x2b,0x7d,0x8c,0x93,0xe9,
	0x19,0x30,0x6b,0x67
	};

__fips_constseg
static const unsigned char aes_192_use_df_pr_additionalinput2[] =
	{
	0x00,0x71,0x27,0x4e,0xd3,0x14,0xf1,0x20,0x7f,0x4a,0x41,0x32,
	0x2a,0x97,0x11,0x43,0x8f,0x4a,0x15,0x7b,0x9b,0x51,0x79,0xda,
	0x49,0x3d,0xde,0xe8,0xbc,0x93,0x91,0x99
	};

__fips_constseg
static const unsigned char aes_192_use_df_pr_entropyinputpr2[] =
	{
	0x90,0xee,0x76,0xa1,0x45,0x8d,0xb7,0x40,0xb0,0x11,0xbf,0xd0,
	0x65,0xd7,0x3c,0x7c,0x4f,0x20,0x3f,0x4e,0x11,0x9d,0xb3,0x5e
	};

__fips_constseg
static const unsigned char aes_192_use_df_pr_returnedbits[] =
	{
	0x24,0x3b,0x20,0xa4,0x37,0x66,0xba,0x72,0x39,0x3f,0xcf,0x3c,
	0x7e,0x1a,0x2b,0x83
	};


/* AES-192 use df No PR  */
__fips_constseg
static const unsigned char aes_192_use_df_entropyinput[] =
	{
	0x8d,0x74,0xa4,0x50,0x1a,0x02,0x68,0x0c,0x2a,0x69,0xc4,0x82,
	0x3b,0xbb,0xda,0x0e,0x7f,0x77,0xa3,0x17,0x78,0x57,0xb2,0x7b
	};

__fips_constseg
static const unsigned char aes_192_use_df_nonce[] =
	{
	0x75,0xd5,0x1f,0xac,0xa4,0x8d,0x42,0x78,0xd7,0x69,0x86,0x9d,
	0x77,0xd7,0x41,0x0e
	};

__fips_constseg
static const unsigned char aes_192_use_df_personalizationstring[] =
	{
	0x4e,0x33,0x41,0x3c,0x9c,0xc2,0xd2,0x53,0xaf,0x90,0xea,0xcf,
	0x19,0x50,0x1e,0xe6,0x6f,0x63,0xc8,0x32,0x22,0xdc,0x07,0x65,
	0x9c,0xd3,0xf8,0x30,0x9e,0xed,0x35,0x70
	};

__fips_constseg
static const unsigned char aes_192_use_df_additionalinput[] =
	{
	0x5d,0x8b,0x8c,0xc1,0xdf,0x0e,0x02,0x78,0xfb,0x19,0xb8,0x69,
	0x78,0x4e,0x9c,0x52,0xbc,0xc7,0x20,0xc9,0xe6,0x5e,0x77,0x22,
	0x28,0x3d,0x0c,0x9e,0x68,0xa8,0x45,0xd7
	};

__fips_constseg
static const unsigned char aes_192_use_df_int_returnedbits[] =
	{
	0xd5,0xe7,0x08,0xc5,0x19,0x99,0xd5,0x31,0x03,0x0a,0x74,0xb6,
	0xb7,0xed,0xe9,0xea
	};

__fips_constseg
static const unsigned char aes_192_use_df_entropyinputreseed[] =
	{
	0x9c,0x26,0xda,0xf1,0xac,0xd9,0x5a,0xd6,0xa8,0x65,0xf5,0x02,
	0x8f,0xdc,0xa2,0x09,0x54,0xa6,0xe2,0xa4,0xde,0x32,0xe0,0x01
	};

__fips_constseg
static const unsigned char aes_192_use_df_additionalinputreseed[] =
	{
	0x9b,0x90,0xb0,0x3a,0x0e,0x3a,0x80,0x07,0x4a,0xf4,0xda,0x76,
	0x28,0x30,0x3c,0xee,0x54,0x1b,0x94,0x59,0x51,0x43,0x56,0x77,
	0xaf,0x88,0xdd,0x63,0x89,0x47,0x06,0x65
	};

__fips_constseg
static const unsigned char aes_192_use_df_additionalinput2[] =
	{
	0x3c,0x11,0x64,0x7a,0x96,0xf5,0xd8,0xb8,0xae,0xd6,0x70,0x4e,
	0x16,0x96,0xde,0xe9,0x62,0xbc,0xee,0x28,0x2f,0x26,0xa6,0xf0,
	0x56,0xef,0xa3,0xf1,0x6b,0xa1,0xb1,0x77
	};

__fips_constseg
static const unsigned char aes_192_use_df_returnedbits[] =
	{
	0x0b,0xe2,0x56,0x03,0x1e,0xdb,0x2c,0x6d,0x7f,0x1b,0x15,0x58,
	0x1a,0xf9,0x13,0x28
	};


/* AES-256 use df PR  */
__fips_constseg
static const unsigned char aes_256_use_df_pr_entropyinput[] =
	{
	0x61,0x68,0xfc,0x1a,0xf0,0xb5,0x95,0x6b,0x85,0x09,0x9b,0x74,
	0x3f,0x13,0x78,0x49,0x3b,0x85,0xec,0x93,0x13,0x3b,0xa9,0x4f,
	0x96,0xab,0x2c,0xe4,0xc8,0x8f,0xdd,0x6a
	};

__fips_constseg
static const unsigned char aes_256_use_df_pr_nonce[] =
	{
	0xad,0xd2,0xbb,0xba,0xb7,0x65,0x89,0xc3,0x21,0x6c,0x55,0x33,
	0x2b,0x36,0xff,0xa4
	};

__fips_constseg
static const unsigned char aes_256_use_df_pr_personalizationstring[] =
	{
	0x6e,0xca,0xe7,0x20,0x72,0xd3,0x84,0x5a,0x32,0xd3,0x4b,0x24,
	0x72,0xc4,0x63,0x2b,0x9d,0x12,0x24,0x0c,0x23,0x26,0x8e,0x83,
	0x16,0x37,0x0b,0xd1,0x06,0x4f,0x68,0x6d
	};

__fips_constseg
static const unsigned char aes_256_use_df_pr_additionalinput[] =
	{
	0x7e,0x08,0x4a,0xbb,0xe3,0x21,0x7c,0xc9,0x23,0xd2,0xf8,0xb0,
	0x73,0x98,0xba,0x84,0x74,0x23,0xab,0x06,0x8a,0xe2,0x22,0xd3,
	0x7b,0xce,0x9b,0xd2,0x4a,0x76,0xb8,0xde
	};

__fips_constseg
static const unsigned char aes_256_use_df_pr_entropyinputpr[] =
	{
	0x0b,0x23,0xaf,0xdf,0xf1,0x62,0xd7,0xd3,0x43,0x97,0xf8,0x77,
	0x04,0xa8,0x42,0x20,0xbd,0xf6,0x0f,0xc1,0x17,0x2f,0x9f,0x54,
	0xbb,0x56,0x17,0x86,0x68,0x0e,0xba,0xa9
	};

__fips_constseg
static const unsigned char aes_256_use_df_pr_int_returnedbits[] =
	{
	0x31,0x8e,0xad,0xaf,0x40,0xeb,0x6b,0x74,0x31,0x46,0x80,0xc7,
	0x17,0xab,0x3c,0x7a
	};

__fips_constseg
static const unsigned char aes_256_use_df_pr_additionalinput2[] =
	{
	0x94,0x6b,0xc9,0x9f,0xab,0x8d,0xc5,0xec,0x71,0x88,0x1d,0x00,
	0x8c,0x89,0x68,0xe4,0xc8,0x07,0x77,0x36,0x17,0x6d,0x79,0x78,
	0xc7,0x06,0x4e,0x99,0x04,0x28,0x29,0xc3
	};

__fips_constseg
static const unsigned char aes_256_use_df_pr_entropyinputpr2[] =
	{
	0xbf,0x6c,0x59,0x2a,0x0d,0x44,0x0f,0xae,0x9a,0x5e,0x03,0x73,
	0xd8,0xa6,0xe1,0xcf,0x25,0x61,0x38,0x24,0x86,0x9e,0x53,0xe8,
	0xa4,0xdf,0x56,0xf4,0x06,0x07,0x9c,0x0f
	};

__fips_constseg
static const unsigned char aes_256_use_df_pr_returnedbits[] =
	{
	0x22,0x4a,0xb4,0xb8,0xb6,0xee,0x7d,0xb1,0x9e,0xc9,0xf9,0xa0,
	0xd9,0xe2,0x97,0x00
	};


/* AES-256 use df No PR  */
__fips_constseg
static const unsigned char aes_256_use_df_entropyinput[] =
	{
	0xa5,0x3e,0x37,0x10,0x17,0x43,0x91,0x93,0x59,0x1e,0x47,0x50,
	0x87,0xaa,0xdd,0xd5,0xc1,0xc3,0x86,0xcd,0xca,0x0d,0xdb,0x68,
	0xe0,0x02,0xd8,0x0f,0xdc,0x40,0x1a,0x47
	};

__fips_constseg
static const unsigned char aes_256_use_df_nonce[] =
	{
	0xa9,0x4d,0xa5,0x5a,0xfd,0xc5,0x0c,0xe5,0x1c,0x9a,0x3b,0x8a,
	0x4c,0x44,0x84,0x40
	};

__fips_constseg
static const unsigned char aes_256_use_df_personalizationstring[] =
	{
	0x8b,0x52,0xa2,0x4a,0x93,0xc3,0x4e,0xa7,0x1e,0x1c,0xa7,0x05,
	0xeb,0x82,0x9b,0xa6,0x5d,0xe4,0xd4,0xe0,0x7f,0xa3,0xd8,0x6b,
	0x37,0x84,0x5f,0xf1,0xc7,0xd5,0xf6,0xd2
	};

__fips_constseg
static const unsigned char aes_256_use_df_additionalinput[] =
	{
	0x20,0xf4,0x22,0xed,0xf8,0x5c,0xa1,0x6a,0x01,0xcf,0xbe,0x5f,
	0x8d,0x6c,0x94,0x7f,0xae,0x12,0xa8,0x57,0xdb,0x2a,0xa9,0xbf,
	0xc7,0xb3,0x65,0x81,0x80,0x8d,0x0d,0x46
	};

__fips_constseg
static const unsigned char aes_256_use_df_int_returnedbits[] =
	{
	0x4e,0x44,0xfd,0xf3,0x9e,0x29,0xa2,0xb8,0x0f,0x5d,0x6c,0xe1,
	0x28,0x0c,0x3b,0xc1
	};

__fips_constseg
static const unsigned char aes_256_use_df_entropyinputreseed[] =
	{
	0xdd,0x40,0xe5,0x98,0x7b,0x27,0x16,0x73,0x15,0x68,0xd2,0x76,
	0xbf,0x0c,0x67,0x15,0x75,0x79,0x03,0xd3,0xde,0xde,0x91,0x46,
	0x42,0xdd,0xd4,0x67,0xc8,0x79,0xc8,0x1e
	};

__fips_constseg
static const unsigned char aes_256_use_df_additionalinputreseed[] =
	{
	0x7f,0xd8,0x1f,0xbd,0x2a,0xb5,0x1c,0x11,0x5d,0x83,0x4e,0x99,
	0xf6,0x5c,0xa5,0x40,0x20,0xed,0x38,0x8e,0xd5,0x9e,0xe0,0x75,
	0x93,0xfe,0x12,0x5e,0x5d,0x73,0xfb,0x75
	};

__fips_constseg
static const unsigned char aes_256_use_df_additionalinput2[] =
	{
	0xcd,0x2c,0xff,0x14,0x69,0x3e,0x4c,0x9e,0xfd,0xfe,0x26,0x0d,
	0xe9,0x86,0x00,0x49,0x30,0xba,0xb1,0xc6,0x50,0x57,0x77,0x2a,
	0x62,0x39,0x2c,0x3b,0x74,0xeb,0xc9,0x0d
	};

__fips_constseg
static const unsigned char aes_256_use_df_returnedbits[] =
	{
	0x4f,0x78,0xbe,0xb9,0x4d,0x97,0x8c,0xe9,0xd0,0x97,0xfe,0xad,
	0xfa,0xfd,0x35,0x5e
	};


/* AES-128 no df PR  */
__fips_constseg
static const unsigned char aes_128_no_df_pr_entropyinput[] =
	{
	0x9a,0x25,0x65,0x10,0x67,0xd5,0xb6,0x6b,0x70,0xa1,0xb3,0xa4,
	0x43,0x95,0x80,0xc0,0x84,0x0a,0x79,0xb0,0x88,0x74,0xf2,0xbf,
	0x31,0x6c,0x33,0x38,0x0b,0x00,0xb2,0x5a
	};

__fips_constseg
static const unsigned char aes_128_no_df_pr_nonce[] =
	{
	0x78,0x47,0x6b,0xf7,0x90,0x8e,0x87,0xf1
	};

__fips_constseg
static const unsigned char aes_128_no_df_pr_personalizationstring[] =
	{
	0xf7,0x22,0x1d,0x3a,0xbe,0x1d,0xca,0x32,0x1b,0xbd,0x87,0x0c,
	0x51,0x24,0x19,0xee,0xa3,0x23,0x09,0x63,0x33,0x3d,0xa8,0x0c,
	0x1c,0xfa,0x42,0x89,0xcc,0x6f,0xa0,0xa8
	};

__fips_constseg
static const unsigned char aes_128_no_df_pr_additionalinput[] =
	{
	0xc9,0xe0,0x80,0xbf,0x8c,0x45,0x58,0x39,0xff,0x00,0xab,0x02,
	0x4c,0x3e,0x3a,0x95,0x9b,0x80,0xa8,0x21,0x2a,0xee,0xba,0x73,
	0xb1,0xd9,0xcf,0x28,0xf6,0x8f,0x9b,0x12
	};

__fips_constseg
static const unsigned char aes_128_no_df_pr_entropyinputpr[] =
	{
	0x4c,0xa8,0xc5,0xf0,0x59,0x9e,0xa6,0x8d,0x26,0x53,0xd7,0x8a,
	0xa9,0xd8,0xf7,0xed,0xb2,0xf9,0x12,0x42,0xe1,0xe5,0xbd,0xe7,
	0xe7,0x1d,0x74,0x99,0x00,0x9d,0x31,0x3e
	};

__fips_constseg
static const unsigned char aes_128_no_df_pr_int_returnedbits[] =
	{
	0xe2,0xac,0x20,0xf0,0x80,0xe7,0xbc,0x7e,0x9c,0x7b,0x65,0x71,
	0xaf,0x19,0x32,0x16
	};

__fips_constseg
static const unsigned char aes_128_no_df_pr_additionalinput2[] =
	{
	0x32,0x7f,0x38,0x8b,0x73,0x0a,0x78,0x83,0xdc,0x30,0xbe,0x9f,
	0x10,0x1f,0xf5,0x1f,0xca,0x00,0xb5,0x0d,0xd6,0x9d,0x60,0x83,
	0x51,0x54,0x7d,0x38,0x23,0x3a,0x52,0x50
	};

__fips_constseg
static const unsigned char aes_128_no_df_pr_entropyinputpr2[] =
	{
	0x18,0x61,0x53,0x56,0xed,0xed,0xd7,0x20,0xfb,0x71,0x04,0x7a,
	0xb2,0xac,0xc1,0x28,0xcd,0xf2,0xc2,0xfc,0xaa,0xb1,0x06,0x07,
	0xe9,0x46,0x95,0x02,0x48,0x01,0x78,0xf9
	};

__fips_constseg
static const unsigned char aes_128_no_df_pr_returnedbits[] =
	{
	0x29,0xc8,0x1b,0x15,0xb1,0xd1,0xc2,0xf6,0x71,0x86,0x68,0x33,
	0x57,0x82,0x33,0xaf
	};


/* AES-128 no df No PR  */
__fips_constseg
static const unsigned char aes_128_no_df_entropyinput[] =
	{
	0xc9,0xc5,0x79,0xbc,0xe8,0xc5,0x19,0xd8,0xbc,0x66,0x73,0x67,
	0xf6,0xd3,0x72,0xaa,0xa6,0x16,0xb8,0x50,0xb7,0x47,0x3a,0x42,
	0xab,0xf4,0x16,0xb2,0x96,0xd2,0xb6,0x60
	};

__fips_constseg
static const unsigned char aes_128_no_df_nonce[] =
	{
	0x5f,0xbf,0x97,0x0c,0x4b,0xa4,0x87,0x13
	};

__fips_constseg
static const unsigned char aes_128_no_df_personalizationstring[] =
	{
	0xce,0xfb,0x7b,0x3f,0xd4,0x6b,0x29,0x0d,0x69,0x06,0xff,0xbb,
	0xf2,0xe5,0xc6,0x6c,0x0a,0x10,0xa0,0xcf,0x1a,0x48,0xc7,0x8b,
	0x3c,0x16,0x88,0xed,0x50,0x13,0x81,0xce
	};

__fips_constseg
static const unsigned char aes_128_no_df_additionalinput[] =
	{
	0x4b,0x22,0x46,0x18,0x02,0x7b,0xd2,0x1b,0x22,0x42,0x7c,0x37,
	0xd9,0xf6,0xe8,0x9b,0x12,0x30,0x5f,0xe9,0x90,0xe8,0x08,0x24,
	0x4f,0x06,0x66,0xdb,0x19,0x2b,0x13,0x95
	};

__fips_constseg
static const unsigned char aes_128_no_df_int_returnedbits[] =
	{
	0x2e,0x96,0x70,0x64,0xfa,0xdf,0xdf,0x57,0xb5,0x82,0xee,0xd6,
	0xed,0x3e,0x65,0xc2
	};

__fips_constseg
static const unsigned char aes_128_no_df_entropyinputreseed[] =
	{
	0x26,0xc0,0x72,0x16,0x3a,0x4b,0xb7,0x99,0xd4,0x07,0xaf,0x66,
	0x62,0x36,0x96,0xa4,0x51,0x17,0xfa,0x07,0x8b,0x17,0x5e,0xa1,
	0x2f,0x3c,0x10,0xe7,0x90,0xd0,0x46,0x00
	};

__fips_constseg
static const unsigned char aes_128_no_df_additionalinputreseed[] =
	{
	0x83,0x39,0x37,0x7b,0x02,0x06,0xd2,0x12,0x13,0x8d,0x8b,0xf2,
	0xf0,0xf6,0x26,0xeb,0xa4,0x22,0x7b,0xc2,0xe7,0xba,0x79,0xe4,
	0x3b,0x77,0x5d,0x4d,0x47,0xb2,0x2d,0xb4
	};

__fips_constseg
static const unsigned char aes_128_no_df_additionalinput2[] =
	{
	0x0b,0xb9,0x67,0x37,0xdb,0x83,0xdf,0xca,0x81,0x8b,0xf9,0x3f,
	0xf1,0x11,0x1b,0x2f,0xf0,0x61,0xa6,0xdf,0xba,0xa3,0xb1,0xac,
	0xd3,0xe6,0x09,0xb8,0x2c,0x6a,0x67,0xd6
	};

__fips_constseg
static const unsigned char aes_128_no_df_returnedbits[] =
	{
	0x1e,0xa7,0xa4,0xe4,0xe1,0xa6,0x7c,0x69,0x9a,0x44,0x6c,0x36,
	0x81,0x37,0x19,0xd4
	};


/* AES-192 no df PR  */
__fips_constseg
static const unsigned char aes_192_no_df_pr_entropyinput[] =
	{
	0x9d,0x2c,0xd2,0x55,0x66,0xea,0xe0,0xbe,0x18,0xb7,0x76,0xe7,
	0x73,0x35,0xd8,0x1f,0xad,0x3a,0xe3,0x81,0x0e,0x92,0xd0,0x61,
	0xc9,0x12,0x26,0xf6,0x1c,0xdf,0xfe,0x47,0xaa,0xfe,0x7d,0x5a,
	0x17,0x1f,0x8d,0x9a
	};

__fips_constseg
static const unsigned char aes_192_no_df_pr_nonce[] =
	{
	0x44,0x82,0xed,0xe8,0x4c,0x28,0x5a,0x14,0xff,0x88,0x8d,0x19,
	0x61,0x5c,0xee,0x0f
	};

__fips_constseg
static const unsigned char aes_192_no_df_pr_personalizationstring[] =
	{
	0x47,0xd7,0x9b,0x99,0xaa,0xcb,0xe7,0xd2,0x57,0x66,0x2c,0xe1,
	0x78,0xd6,0x2c,0xea,0xa3,0x23,0x5f,0x2a,0xc1,0x3a,0xf0,0xa4,
	0x20,0x3b,0xfa,0x07,0xd5,0x05,0x02,0xe4,0x57,0x01,0xb6,0x10,
	0x57,0x2e,0xe7,0x55
	};

__fips_constseg
static const unsigned char aes_192_no_df_pr_additionalinput[] =
	{
	0x4b,0x74,0x0b,0x40,0xce,0x6b,0xc2,0x6a,0x24,0xb4,0xf3,0xad,
	0x7a,0xa5,0x7a,0xa2,0x15,0xe2,0xc8,0x61,0x15,0xc6,0xb7,0x85,
	0x69,0x11,0xad,0x7b,0x14,0xd2,0xf6,0x12,0xa1,0x95,0x5d,0x3f,
	0xe2,0xd0,0x0c,0x2f
	};

__fips_constseg
static const unsigned char aes_192_no_df_pr_entropyinputpr[] =
	{
	0x0c,0x9c,0xad,0x05,0xee,0xae,0x48,0x23,0x89,0x59,0xa1,0x94,
	0xd7,0xd8,0x75,0xd5,0x54,0x93,0xc7,0x4a,0xd9,0x26,0xde,0xeb,
	0xba,0xb0,0x7e,0x30,0x1d,0x5f,0x69,0x40,0x9c,0x3b,0x17,0x58,
	0x1d,0x30,0xb3,0x78
	};

__fips_constseg
static const unsigned char aes_192_no_df_pr_int_returnedbits[] =
	{
	0xf7,0x93,0xb0,0x6d,0x77,0x83,0xd5,0x38,0x01,0xe1,0x52,0x40,
	0x7e,0x3e,0x0c,0x26
	};

__fips_constseg
static const unsigned char aes_192_no_df_pr_additionalinput2[] =
	{
	0xbc,0x4b,0x37,0x44,0x1c,0xc5,0x45,0x5f,0x8f,0x51,0x62,0x8a,
	0x85,0x30,0x1d,0x7c,0xe4,0xcf,0xf7,0x44,0xce,0x32,0x3e,0x57,
	0x95,0xa4,0x2a,0xdf,0xfd,0x9e,0x38,0x41,0xb3,0xf6,0xc5,0xee,
	0x0c,0x4b,0xee,0x6e
	};

__fips_constseg
static const unsigned char aes_192_no_df_pr_entropyinputpr2[] =
	{
	0xec,0xaf,0xf6,0x4f,0xb1,0xa0,0x54,0xb5,0x5b,0xe3,0x46,0xb0,
	0x76,0x5a,0x7c,0x3f,0x7b,0x94,0x69,0x21,0x51,0x02,0xe5,0x9f,
	0x04,0x59,0x02,0x98,0xc6,0x43,0x2c,0xcc,0x26,0x4c,0x87,0x6b,
	0x8e,0x0a,0x83,0xdf
	};

__fips_constseg
static const unsigned char aes_192_no_df_pr_returnedbits[] =
	{
	0x74,0x45,0xfb,0x53,0x84,0x96,0xbe,0xff,0x15,0xcc,0x41,0x91,
	0xb9,0xa1,0x21,0x68
	};


/* AES-192 no df No PR  */
__fips_constseg
static const unsigned char aes_192_no_df_entropyinput[] =
	{
	0x3c,0x7d,0xb5,0xe0,0x54,0xd9,0x6e,0x8c,0xa9,0x86,0xce,0x4e,
	0x6b,0xaf,0xeb,0x2f,0xe7,0x75,0xe0,0x8b,0xa4,0x3b,0x07,0xfe,
	0xbe,0x33,0x75,0x93,0x80,0x27,0xb5,0x29,0x47,0x8b,0xc7,0x28,
	0x94,0xc3,0x59,0x63
	};

__fips_constseg
static const unsigned char aes_192_no_df_nonce[] =
	{
	0x43,0xf1,0x7d,0xb8,0xc3,0xfe,0xd0,0x23,0x6b,0xb4,0x92,0xdb,
	0x29,0xfd,0x45,0x71
	};

__fips_constseg
static const unsigned char aes_192_no_df_personalizationstring[] =
	{
	0x9f,0x24,0x29,0x99,0x9e,0x01,0xab,0xe9,0x19,0xd8,0x23,0x08,
	0xb7,0xd6,0x7e,0x8c,0xc0,0x9e,0x7f,0x6e,0x5b,0x33,0x20,0x96,
	0x0b,0x23,0x2c,0xa5,0x6a,0xf8,0x1b,0x04,0x26,0xdb,0x2e,0x2b,
	0x3b,0x88,0xce,0x35
	};

__fips_constseg
static const unsigned char aes_192_no_df_additionalinput[] =
	{
	0x94,0xe9,0x7c,0x3d,0xa7,0xdb,0x60,0x83,0x1f,0x98,0x3f,0x0b,
	0x88,0x59,0x57,0x51,0x88,0x9f,0x76,0x49,0x9f,0xa6,0xda,0x71,
	0x1d,0x0d,0x47,0x16,0x63,0xc5,0x68,0xe4,0x5d,0x39,0x69,0xb3,
	0x3e,0xbe,0xd4,0x8e
	};

__fips_constseg
static const unsigned char aes_192_no_df_int_returnedbits[] =
	{
	0xf9,0xd7,0xad,0x69,0xab,0x8f,0x23,0x56,0x70,0x17,0x4f,0x2a,
	0x45,0xe7,0x4a,0xc5
	};

__fips_constseg
static const unsigned char aes_192_no_df_entropyinputreseed[] =
	{
	0xa6,0x71,0x6a,0x3d,0xba,0xd1,0xe8,0x66,0xa6,0xef,0xb2,0x0e,
	0xa8,0x9c,0xaa,0x4e,0xaf,0x17,0x89,0x50,0x00,0xda,0xa1,0xb1,
	0x0b,0xa4,0xd9,0x35,0x89,0xc8,0xe5,0xb0,0xd9,0xb7,0xc4,0x33,
	0x9b,0xcb,0x7e,0x75
	};

__fips_constseg
static const unsigned char aes_192_no_df_additionalinputreseed[] =
	{
	0x27,0x21,0xfc,0xc2,0xbd,0xf3,0x3c,0xce,0xc3,0xca,0xc1,0x01,
	0xe0,0xff,0x93,0x12,0x7d,0x54,0x42,0xe3,0x9f,0x03,0xdf,0x27,
	0x04,0x07,0x3c,0x53,0x7f,0xa8,0x66,0xc8,0x97,0x4b,0x61,0x40,
	0x5d,0x7a,0x25,0x79
	};

__fips_constseg
static const unsigned char aes_192_no_df_additionalinput2[] =
	{
	0x2d,0x8e,0x16,0x5d,0x0b,0x9f,0xeb,0xaa,0xd6,0xec,0x28,0x71,
	0x7c,0x0b,0xc1,0x1d,0xd4,0x44,0x19,0x47,0xfd,0x1d,0x7c,0xe5,
	0xf3,0x27,0xe1,0xb6,0x72,0x0a,0xe0,0xec,0x0e,0xcd,0xef,0x1a,
	0x91,0x6a,0xe3,0x5f
	};

__fips_constseg
static const unsigned char aes_192_no_df_returnedbits[] =
	{
	0xe5,0xda,0xb8,0xe0,0x63,0x59,0x5a,0xcc,0x3d,0xdc,0x9f,0xe8,
	0x66,0x67,0x2c,0x92
	};


/* AES-256 no df PR  */
__fips_constseg
static const unsigned char aes_256_no_df_pr_entropyinput[] =
	{
	0x15,0xc7,0x5d,0xcb,0x41,0x4b,0x16,0x01,0x3a,0xd1,0x44,0xe8,
	0x22,0x32,0xc6,0x9c,0x3f,0xe7,0x43,0xf5,0x9a,0xd3,0xea,0xf2,
	0xd7,0x4e,0x6e,0x6a,0x55,0x73,0x40,0xef,0x89,0xad,0x0d,0x03,
	0x96,0x7e,0x78,0x81,0x2f,0x91,0x1b,0x44,0xb0,0x02,0xba,0x1c
	};

__fips_constseg
static const unsigned char aes_256_no_df_pr_nonce[] =
	{
	0xdc,0xe4,0xd4,0x27,0x7a,0x90,0xd7,0x99,0x43,0xa1,0x3c,0x30,
	0xcc,0x4b,0xee,0x2e
	};

__fips_constseg
static const unsigned char aes_256_no_df_pr_personalizationstring[] =
	{
	0xe3,0xe6,0xb9,0x11,0xe4,0x7a,0xa4,0x40,0x6b,0xf8,0x73,0xf7,
	0x7e,0xec,0xc7,0xb9,0x97,0xbf,0xf8,0x25,0x7b,0xbe,0x11,0x9b,
	0x5b,0x6a,0x0c,0x2e,0x2b,0x01,0x51,0xcd,0x41,0x4b,0x6b,0xac,
	0x31,0xa8,0x0b,0xf7,0xe6,0x59,0x42,0xb8,0x03,0x0c,0xf8,0x06
	};

__fips_constseg
static const unsigned char aes_256_no_df_pr_additionalinput[] =
	{
	0x6a,0x9f,0x00,0x91,0xae,0xfe,0xcf,0x84,0x99,0xce,0xb1,0x40,
	0x6d,0x5d,0x33,0x28,0x84,0xf4,0x8c,0x63,0x4c,0x7e,0xbd,0x2c,
	0x80,0x76,0xee,0x5a,0xaa,0x15,0x07,0x31,0xd8,0xbb,0x8c,0x69,
	0x9d,0x9d,0xbc,0x7e,0x49,0xae,0xec,0x39,0x6b,0xd1,0x1f,0x7e
	};

__fips_constseg
static const unsigned char aes_256_no_df_pr_entropyinputpr[] =
	{
	0xf3,0xb9,0x75,0x9c,0xbd,0x88,0xea,0xa2,0x50,0xad,0xd6,0x16,
	0x1a,0x12,0x3c,0x86,0x68,0xaf,0x6f,0xbe,0x19,0xf2,0xee,0xcc,
	0xa5,0x70,0x84,0x53,0x50,0xcb,0x9f,0x14,0xa9,0xe5,0xee,0xb9,
	0x48,0x45,0x40,0xe2,0xc7,0xc9,0x9a,0x74,0xff,0x8c,0x99,0x1f
	};

__fips_constseg
static const unsigned char aes_256_no_df_pr_int_returnedbits[] =
	{
	0x2e,0xf2,0x45,0x4c,0x62,0x2e,0x0a,0xb9,0x6b,0xa2,0xfd,0x56,
	0x79,0x60,0x93,0xcf
	};

__fips_constseg
static const unsigned char aes_256_no_df_pr_additionalinput2[] =
	{
	0xaf,0x69,0x20,0xe9,0x3b,0x37,0x9d,0x3f,0xb4,0x80,0x02,0x7a,
	0x25,0x7d,0xb8,0xde,0x71,0xc5,0x06,0x0c,0xb4,0xe2,0x8f,0x35,
	0xd8,0x14,0x0d,0x7f,0x76,0x63,0x4e,0xb5,0xee,0xe9,0x6f,0x34,
	0xc7,0x5f,0x56,0x14,0x4a,0xe8,0x73,0x95,0x5b,0x1c,0xb9,0xcb
	};

__fips_constseg
static const unsigned char aes_256_no_df_pr_entropyinputpr2[] =
	{
	0xe5,0xb0,0x2e,0x7e,0x52,0x30,0xe3,0x63,0x82,0xb6,0x44,0xd3,
	0x25,0x19,0x05,0x24,0x9a,0x9f,0x5f,0x27,0x6a,0x29,0xab,0xfa,
	0x07,0xa2,0x42,0x0f,0xc5,0xa8,0x94,0x7c,0x17,0x7b,0x85,0x83,
	0x0c,0x25,0x0e,0x63,0x0b,0xe9,0x12,0x60,0xcd,0xef,0x80,0x0f
	};

__fips_constseg
static const unsigned char aes_256_no_df_pr_returnedbits[] =
	{
	0x5e,0xf2,0x26,0xef,0x9f,0x58,0x5d,0xd5,0x4a,0x10,0xfe,0xa7,
	0x2d,0x5f,0x4a,0x46
	};


/* AES-256 no df No PR  */
__fips_constseg
static const unsigned char aes_256_no_df_entropyinput[] =
	{
	0xfb,0xcf,0x1b,0x61,0x16,0x89,0x78,0x23,0xf5,0xd8,0x96,0xe3,
	0x4e,0x64,0x0b,0x29,0x9a,0x3f,0xf8,0xa5,0xed,0xf2,0xfe,0xdb,
	0x16,0xca,0x7f,0x10,0xfa,0x5e,0x18,0x76,0x2c,0x63,0x5e,0x96,
	0xcf,0xb3,0xd6,0xfc,0xaf,0x99,0x39,0x28,0x9c,0x61,0xe8,0xb3
	};

__fips_constseg
static const unsigned char aes_256_no_df_nonce[] =
	{
	0x12,0x96,0xf0,0x52,0xf3,0x8d,0x81,0xcf,0xde,0x86,0xf2,0x99,
	0x43,0x96,0xb9,0xf0
	};

__fips_constseg
static const unsigned char aes_256_no_df_personalizationstring[] =
	{
	0x63,0x0d,0x78,0xf5,0x90,0x8e,0x32,0x47,0xb0,0x4d,0x37,0x60,
	0x09,0x96,0xbc,0xbf,0x97,0x7a,0x62,0x14,0x45,0xbd,0x8d,0xcc,
	0x69,0xfb,0x03,0xe1,0x80,0x1c,0xc7,0xe2,0x2a,0xf9,0x37,0x3f,
	0x66,0x4d,0x62,0xd9,0x10,0xe0,0xad,0xc8,0x9a,0xf0,0xa8,0x6d
	};

__fips_constseg
static const unsigned char aes_256_no_df_additionalinput[] =
	{
	0x36,0xc6,0x13,0x60,0xbb,0x14,0xad,0x22,0xb0,0x38,0xac,0xa6,
	0x18,0x16,0x93,0x25,0x86,0xb7,0xdc,0xdc,0x36,0x98,0x2b,0xf9,
	0x68,0x33,0xd3,0xc6,0xff,0xce,0x8d,0x15,0x59,0x82,0x76,0xed,
	0x6f,0x8d,0x49,0x74,0x2f,0xda,0xdc,0x1f,0x17,0xd0,0xde,0x17
	};

__fips_constseg
static const unsigned char aes_256_no_df_int_returnedbits[] =
	{
	0x16,0x2f,0x8e,0x3f,0x21,0x7a,0x1c,0x20,0x56,0xd1,0x92,0xf6,
	0xd2,0x25,0x75,0x0e
	};

__fips_constseg
static const unsigned char aes_256_no_df_entropyinputreseed[] =
	{
	0x91,0x79,0x76,0xee,0xe0,0xcf,0x9e,0xc2,0xd5,0xd4,0x23,0x9b,
	0x12,0x8c,0x7e,0x0a,0xb7,0xd2,0x8b,0xd6,0x7c,0xa3,0xc6,0xe5,
	0x0e,0xaa,0xc7,0x6b,0xae,0x0d,0xfa,0x53,0x06,0x79,0xa1,0xed,
	0x4d,0x6a,0x0e,0xd8,0x9d,0xbe,0x1b,0x31,0x93,0x7b,0xec,0xfb
	};

__fips_constseg
static const unsigned char aes_256_no_df_additionalinputreseed[] =
	{
	0xd2,0x46,0x50,0x22,0x10,0x14,0x63,0xf7,0xea,0x0f,0xb9,0x7e,
	0x0d,0xe1,0x94,0x07,0xaf,0x09,0x44,0x31,0xea,0x64,0xa4,0x18,
	0x5b,0xf9,0xd8,0xc2,0xfa,0x03,0x47,0xc5,0x39,0x43,0xd5,0x3b,
	0x62,0x86,0x64,0xea,0x2c,0x73,0x8c,0xae,0x9d,0x98,0x98,0x29
	};

__fips_constseg
static const unsigned char aes_256_no_df_additionalinput2[] =
	{
	0x8c,0xab,0x18,0xf8,0xc3,0xec,0x18,0x5c,0xb3,0x1e,0x9d,0xbe,
	0x3f,0x03,0xb4,0x00,0x98,0x9d,0xae,0xeb,0xf4,0x94,0xf8,0x42,
	0x8f,0xe3,0x39,0x07,0xe1,0xc9,0xad,0x0b,0x1f,0xed,0xc0,0xba,
	0xf6,0xd1,0xec,0x27,0x86,0x7b,0xd6,0x55,0x9b,0x60,0xa5,0xc6
	};

__fips_constseg
static const unsigned char aes_256_no_df_returnedbits[] =
	{
	0xef,0xd2,0xd8,0x5c,0xdc,0x62,0x25,0x9f,0xaa,0x1e,0x2c,0x67,
	0xf6,0x02,0x32,0xe2
	};


/* SHA-1 PR  */
__fips_constseg
static const unsigned char sha1_pr_entropyinput[] =
	{
	0xd2,0x36,0xa5,0x27,0x31,0x73,0xdd,0x11,0x4f,0x93,0xbd,0xe2,
	0x31,0xa5,0x91,0x13
	};

__fips_constseg
static const unsigned char sha1_pr_nonce[] =
	{
	0xb5,0xb3,0x60,0xef,0xf7,0x63,0x31,0xf3
	};

__fips_constseg
static const unsigned char sha1_pr_personalizationstring[] =
	{
	0xd4,0xbb,0x02,0x10,0xb2,0x71,0xdb,0x81,0xd6,0xf0,0x42,0x60,
	0xda,0xea,0x77,0x52
	};

__fips_constseg
static const unsigned char sha1_pr_additionalinput[] =
	{
	0x4d,0xd2,0x6c,0x87,0xfb,0x2c,0x4f,0xa6,0x8d,0x16,0x63,0x22,
	0x6a,0x51,0xe3,0xf8
	};

__fips_constseg
static const unsigned char sha1_pr_entropyinputpr[] =
	{
	0xc9,0x83,0x9e,0x16,0xf6,0x1c,0x0f,0xb2,0xec,0x60,0x31,0xa9,
	0xcb,0xa9,0x36,0x7a
	};

__fips_constseg
static const unsigned char sha1_pr_int_returnedbits[] =
	{
	0xa8,0x13,0x4f,0xf4,0x31,0x02,0x44,0xe3,0xd3,0x3d,0x61,0x9e,
	0xe5,0xc6,0x3e,0x89,0xb5,0x9b,0x0f,0x35
	};

__fips_constseg
static const unsigned char sha1_pr_additionalinput2[] =
	{
	0xf9,0xe8,0xd2,0x72,0x13,0x34,0x95,0x6f,0x15,0x49,0x47,0x99,
	0x16,0x03,0x19,0x47
	};

__fips_constseg
static const unsigned char sha1_pr_entropyinputpr2[] =
	{
	0x4e,0x8c,0x49,0x9b,0x4a,0x5c,0x9b,0x9c,0x3a,0xee,0xfb,0xd2,
	0xae,0xcd,0x8c,0xc4
	};

__fips_constseg
static const unsigned char sha1_pr_returnedbits[] =
	{
	0x50,0xb4,0xb4,0xcd,0x68,0x57,0xfc,0x2e,0xc1,0x52,0xcc,0xf6,
	0x68,0xa4,0x81,0xed,0x7e,0xe4,0x1d,0x87
	};


/* SHA-1 No PR  */
__fips_constseg
static const unsigned char sha1_entropyinput[] =
	{
	0xa9,0x47,0x1b,0x29,0x2d,0x1c,0x05,0xdf,0x76,0xd0,0x62,0xf9,
	0xe2,0x7f,0x4c,0x7b
	};

__fips_constseg
static const unsigned char sha1_nonce[] =
	{
	0x53,0x23,0x24,0xe3,0xec,0x0c,0x54,0x14
	};

__fips_constseg
static const unsigned char sha1_personalizationstring[] =
	{
	0x7a,0x87,0xa1,0xac,0x1c,0xfd,0xab,0xae,0xf7,0xd6,0xfb,0x76,
	0x28,0xec,0x6d,0xca
	};

__fips_constseg
static const unsigned char sha1_additionalinput[] =
	{
	0xfc,0x92,0x35,0xd6,0x7e,0xb7,0x24,0x65,0xfd,0x12,0x27,0x35,
	0xc0,0x72,0xca,0x28
	};

__fips_constseg
static const unsigned char sha1_int_returnedbits[] =
	{
	0x57,0x88,0x82,0xe5,0x25,0xa5,0x2c,0x4a,0x06,0x20,0x6c,0x72,
	0x55,0x61,0xdd,0x90,0x71,0x9f,0x95,0xea
	};

__fips_constseg
static const unsigned char sha1_entropyinputreseed[] =
	{
	0x69,0xa5,0x40,0x62,0x98,0x47,0x56,0x73,0x4a,0x8f,0x60,0x96,
	0xd6,0x99,0x27,0xed
	};

__fips_constseg
static const unsigned char sha1_additionalinputreseed[] =
	{
	0xe5,0x40,0x4e,0xbd,0x50,0x00,0xf5,0x15,0xa6,0xee,0x45,0xda,
	0x84,0x3d,0xd4,0xc0
	};

__fips_constseg
static const unsigned char sha1_additionalinput2[] =
	{
	0x11,0x51,0x14,0xf0,0x09,0x1b,0x4e,0x56,0x0d,0xe9,0xf6,0x1e,
	0x52,0x65,0xcd,0x96
	};

__fips_constseg
static const unsigned char sha1_returnedbits[] =
	{
	0xa1,0x9c,0x94,0x6e,0x29,0xe1,0x33,0x0d,0x32,0xd6,0xaa,0xce,
	0x71,0x3f,0x52,0x72,0x8b,0x42,0xa8,0xd7
	};


/* SHA-224 PR  */
__fips_constseg
static const unsigned char sha224_pr_entropyinput[] =
	{
	0x12,0x69,0x32,0x4f,0x83,0xa6,0xf5,0x14,0xe3,0x49,0x3e,0x75,
	0x3e,0xde,0xad,0xa1,0x29,0xc3,0xf3,0x19,0x20,0xb5,0x4c,0xd9
	};

__fips_constseg
static const unsigned char sha224_pr_nonce[] =
	{
	0x6a,0x78,0xd0,0xeb,0xbb,0x5a,0xf0,0xee,0xe8,0xc3,0xba,0x71
	};

__fips_constseg
static const unsigned char sha224_pr_personalizationstring[] =
	{
	0xd5,0xb8,0xb6,0xbc,0xc1,0x5b,0x60,0x31,0x3c,0xf5,0xe5,0xc0,
	0x8e,0x52,0x7a,0xbd,0xea,0x47,0xa9,0x5f,0x8f,0xf9,0x8b,0xae
	};

__fips_constseg
static const unsigned char sha224_pr_additionalinput[] =
	{
	0x1f,0x55,0xec,0xae,0x16,0x12,0x84,0xba,0x84,0x16,0x19,0x88,
	0x8e,0xb8,0x33,0x25,0x54,0xff,0xca,0x79,0xaf,0x07,0x25,0x50
	};

__fips_constseg
static const unsigned char sha224_pr_entropyinputpr[] =
	{
	0x92,0xa3,0x32,0xa8,0x9a,0x0a,0x58,0x7c,0x1d,0x5a,0x7e,0xe1,
	0xb2,0x73,0xab,0x0e,0x16,0x79,0x23,0xd3,0x29,0x89,0x81,0xe1
	};

__fips_constseg
static const unsigned char sha224_pr_int_returnedbits[] =
	{
	0xf3,0x38,0x91,0x40,0x37,0x7a,0x51,0x72,0x42,0x74,0x78,0x0a,
	0x69,0xfd,0xa6,0x44,0x43,0x45,0x6c,0x0c,0x5a,0x19,0xff,0xf1,
	0x54,0x60,0xee,0x6a
	};

__fips_constseg
static const unsigned char sha224_pr_additionalinput2[] =
	{
	0x75,0xf3,0x04,0x25,0xdd,0x36,0xa8,0x37,0x46,0xae,0x0c,0x52,
	0x05,0x79,0x4c,0x26,0xdb,0xe9,0x71,0x16,0x4c,0x0a,0xf2,0x60
	};

__fips_constseg
static const unsigned char sha224_pr_entropyinputpr2[] =
	{
	0xea,0xc5,0x03,0x0a,0x4f,0xb0,0x38,0x8d,0x23,0xd4,0xc8,0x77,
	0xe2,0x6d,0x9c,0x0b,0x44,0xf7,0x2d,0x5b,0xbf,0x5d,0x2a,0x11
	};

__fips_constseg
static const unsigned char sha224_pr_returnedbits[] =
	{
	0x60,0x50,0x2b,0xe7,0x86,0xd8,0x26,0x73,0xe3,0x1d,0x95,0x20,
	0xb3,0x2c,0x32,0x1c,0xf5,0xce,0x57,0xa6,0x67,0x2b,0xdc,0x4e,
	0xdd,0x11,0x4c,0xc4
	};


/* SHA-224 No PR  */
__fips_constseg
static const unsigned char sha224_entropyinput[] =
	{
	0xb2,0x1c,0x77,0x4d,0xf6,0xd3,0xb6,0x40,0xb7,0x30,0x3e,0x29,
	0xb0,0x85,0x1c,0xbe,0x4a,0xea,0x6b,0x5a,0xb5,0x8a,0x97,0xeb
	};

__fips_constseg
static const unsigned char sha224_nonce[] =
	{
	0x42,0x02,0x0a,0x1c,0x98,0x9a,0x77,0x9e,0x9f,0x80,0xba,0xe0
	};

__fips_constseg
static const unsigned char sha224_personalizationstring[] =
	{
	0x98,0xb8,0x04,0x41,0xfc,0xc1,0x5d,0xc5,0xe9,0xb9,0x08,0xda,
	0xf9,0xfa,0x0d,0x90,0xce,0xdf,0x1d,0x10,0xa9,0x8d,0x50,0x0c
	};

__fips_constseg
static const unsigned char sha224_additionalinput[] =
	{
	0x9a,0x8d,0x39,0x49,0x42,0xd5,0x0b,0xae,0xe1,0xaf,0xb7,0x00,
	0x02,0xfa,0x96,0xb1,0xa5,0x1d,0x2d,0x25,0x78,0xee,0x83,0x3f
	};

__fips_constseg
static const unsigned char sha224_int_returnedbits[] =
	{
	0xe4,0xf5,0x53,0x79,0x5a,0x97,0x58,0x06,0x08,0xba,0x7b,0xfa,
	0xf0,0x83,0x05,0x8c,0x22,0xc0,0xc9,0xdb,0x15,0xe7,0xde,0x20,
	0x55,0x22,0x9a,0xad
	};

__fips_constseg
static const unsigned char sha224_entropyinputreseed[] =
	{
	0x67,0x09,0x48,0xaa,0x07,0x16,0x99,0x89,0x7f,0x6d,0xa0,0xe5,
	0x8f,0xdf,0xbc,0xdb,0xfe,0xe5,0x6c,0x7a,0x95,0x4a,0x66,0x17
	};

__fips_constseg
static const unsigned char sha224_additionalinputreseed[] =
	{
	0x0f,0x4b,0x1c,0x6f,0xb7,0xe3,0x47,0xe5,0x5d,0x7d,0x38,0xd6,
	0x28,0x9b,0xeb,0x55,0x63,0x09,0x3e,0x7c,0x56,0xea,0xf8,0x19
	};

__fips_constseg
static const unsigned char sha224_additionalinput2[] =
	{
	0x2d,0x26,0x7c,0x37,0xe4,0x7a,0x28,0x5e,0x5a,0x3c,0xaf,0x3d,
	0x5a,0x8e,0x55,0xa2,0x1a,0x6e,0xc0,0xe5,0xf6,0x21,0xd3,0xf6
	};

__fips_constseg
static const unsigned char sha224_returnedbits[] =
	{
	0x4d,0x83,0x35,0xdf,0x67,0xa9,0xfc,0x17,0xda,0x70,0xcc,0x8b,
	0x7f,0x77,0xae,0xa2,0x5f,0xb9,0x7e,0x74,0x4c,0x26,0xc1,0x7a,
	0x3b,0xa7,0x5c,0x93
	};


/* SHA-256 PR  */
__fips_constseg
static const unsigned char sha256_pr_entropyinput[] =
	{
	0xce,0x49,0x00,0x7a,0x56,0xe3,0x67,0x8f,0xe1,0xb6,0xa7,0xd4,
	0x4f,0x08,0x7a,0x1b,0x01,0xf4,0xfa,0x6b,0xef,0xb7,0xe5,0xeb,
	0x07,0x3d,0x11,0x0d,0xc8,0xea,0x2b,0xfe
	};

__fips_constseg
static const unsigned char sha256_pr_nonce[] =
	{
	0x73,0x41,0xc8,0x92,0x94,0xe2,0xc5,0x5f,0x93,0xfd,0x39,0x5d,
	0x2b,0x91,0x4d,0x38
	};

__fips_constseg
static const unsigned char sha256_pr_personalizationstring[] =
	{
	0x50,0x6d,0x01,0x01,0x07,0x5a,0x80,0x35,0x7a,0x56,0x1a,0x56,
	0x2f,0x9a,0x0b,0x35,0xb2,0xb1,0xc9,0xe5,0xca,0x69,0x61,0x48,
	0xff,0xfb,0x0f,0xd9,0x4b,0x79,0x1d,0xba
	};

__fips_constseg
static const unsigned char sha256_pr_additionalinput[] =
	{
	0x20,0xb8,0xdf,0x44,0x77,0x5a,0xb8,0xd3,0xbf,0xf6,0xcf,0xac,
	0x5e,0xa6,0x96,0x62,0x73,0x44,0x40,0x4a,0x30,0xfb,0x38,0xa5,
	0x7b,0x0d,0xe4,0x0d,0xc6,0xe4,0x9a,0x1f
	};

__fips_constseg
static const unsigned char sha256_pr_entropyinputpr[] =
	{
	0x04,0xc4,0x65,0xf4,0xd3,0xbf,0x83,0x4b,0xab,0xc8,0x41,0xa8,
	0xc2,0xe0,0x44,0x63,0x77,0x4c,0x6f,0x6c,0x49,0x46,0xff,0x94,
	0x17,0xea,0xe6,0x1a,0x9d,0x5e,0x66,0x78
	};

__fips_constseg
static const unsigned char sha256_pr_int_returnedbits[] =
	{
	0x07,0x4d,0xac,0x9b,0x86,0xca,0x4a,0xaa,0x6e,0x7a,0x03,0xa2,
	0x5d,0x10,0xea,0x0b,0xf9,0x83,0xcc,0xd1,0xfc,0xe2,0x07,0xc7,
	0x06,0x34,0x60,0x6f,0x83,0x94,0x99,0x76
	};

__fips_constseg
static const unsigned char sha256_pr_additionalinput2[] =
	{
	0x89,0x4e,0x45,0x8c,0x11,0xf9,0xbc,0x5b,0xac,0x74,0x8b,0x4b,
	0x5f,0xf7,0x19,0xf3,0xf5,0x24,0x54,0x14,0xd1,0x15,0xb1,0x43,
	0x12,0xa4,0x5f,0xd4,0xec,0xfc,0xcd,0x09
	};

__fips_constseg
static const unsigned char sha256_pr_entropyinputpr2[] =
	{
	0x0e,0xeb,0x1f,0xd7,0xfc,0xd1,0x9d,0xd4,0x05,0x36,0x8b,0xb2,
	0xfb,0xe4,0xf4,0x51,0x0c,0x87,0x9b,0x02,0x44,0xd5,0x92,0x4d,
	0x44,0xfe,0x1a,0x03,0x43,0x56,0xbd,0x86
	};

__fips_constseg
static const unsigned char sha256_pr_returnedbits[] =
	{
	0x02,0xaa,0xb6,0x1d,0x7e,0x2a,0x40,0x03,0x69,0x2d,0x49,0xa3,
	0x41,0xe7,0x44,0x0b,0xaf,0x7b,0x85,0xe4,0x5f,0x53,0x3b,0x64,
	0xbc,0x89,0xc8,0x82,0xd4,0x78,0x37,0xa2
	};


/* SHA-256 No PR  */
__fips_constseg
static const unsigned char sha256_entropyinput[] =
	{
	0x5b,0x1b,0xec,0x4d,0xa9,0x38,0x74,0x5a,0x34,0x0b,0x7b,0xc5,
	0xe5,0xd7,0x66,0x7c,0xbc,0x82,0xb9,0x0e,0x2d,0x1f,0x92,0xd7,
	0xc1,0xbc,0x67,0x69,0xec,0x6b,0x03,0x3c
	};

__fips_constseg
static const unsigned char sha256_nonce[] =
	{
	0xa4,0x0c,0xd8,0x9c,0x61,0xd8,0xc3,0x54,0xfe,0x53,0xc9,0xe5,
	0x5d,0x6f,0x6d,0x35
	};

__fips_constseg
static const unsigned char sha256_personalizationstring[] =
	{
	0x22,0x5e,0x62,0x93,0x42,0x83,0x78,0x24,0xd8,0x40,0x8c,0xde,
	0x6f,0xf9,0xa4,0x7a,0xc5,0xa7,0x3b,0x88,0xa3,0xee,0x42,0x20,
	0xfd,0x61,0x56,0xc6,0x4c,0x13,0x41,0x9c
	};

__fips_constseg
static const unsigned char sha256_additionalinput[] =
	{
	0xbf,0x74,0x5b,0xf6,0xc5,0x64,0x5e,0x99,0x34,0x8f,0xbc,0xa4,
	0xe2,0xbd,0xd8,0x85,0x26,0x37,0xea,0xba,0x4f,0xf2,0x9a,0x9a,
	0x66,0xfc,0xdf,0x63,0x26,0x26,0x19,0x87
	};

__fips_constseg
static const unsigned char sha256_int_returnedbits[] =
	{
	0xb3,0xc6,0x07,0x07,0xd6,0x75,0xf6,0x2b,0xd6,0x21,0x96,0xf1,
	0xae,0xdb,0x2b,0xac,0x25,0x2a,0xae,0xae,0x41,0x72,0x03,0x5e,
	0xbf,0xd3,0x64,0xbc,0x59,0xf9,0xc0,0x76
	};

__fips_constseg
static const unsigned char sha256_entropyinputreseed[] =
	{
	0xbf,0x20,0x33,0x56,0x29,0xa8,0x37,0x04,0x1f,0x78,0x34,0x3d,
	0x81,0x2a,0xc9,0x86,0xc6,0x7a,0x2f,0x88,0x5e,0xd5,0xbe,0x34,
	0x46,0x20,0xa4,0x35,0xeb,0xc7,0xe2,0x9d
	};

__fips_constseg
static const unsigned char sha256_additionalinputreseed[] =
	{
	0x9b,0xae,0x2d,0x2d,0x61,0xa4,0x89,0xeb,0x43,0x46,0xa7,0xda,
	0xef,0x40,0xca,0x4a,0x99,0x11,0x41,0xdc,0x5c,0x94,0xe9,0xac,
	0xd4,0xd0,0xe6,0xbd,0xfb,0x03,0x9c,0xa8
	};

__fips_constseg
static const unsigned char sha256_additionalinput2[] =
	{
	0x23,0xaa,0x0c,0xbd,0x28,0x33,0xe2,0x51,0xfc,0x71,0xd2,0x15,
	0x1f,0x76,0xfd,0x0d,0xe0,0xb7,0xb5,0x84,0x75,0x5b,0xbe,0xf3,
	0x5c,0xca,0xc5,0x30,0xf2,0x75,0x1f,0xda
	};

__fips_constseg
static const unsigned char sha256_returnedbits[] =
	{
	0x90,0x3c,0xc1,0x10,0x8c,0x12,0x01,0xc6,0xa6,0x3a,0x0f,0x4d,
	0xb6,0x3a,0x4f,0x41,0x9c,0x61,0x75,0x84,0xe9,0x74,0x75,0xfd,
	0xfe,0xf2,0x1f,0x43,0xd8,0x5e,0x24,0xa3
	};


/* SHA-384 PR  */
__fips_constseg
static const unsigned char sha384_pr_entropyinput[] =
	{
	0x71,0x9d,0xb2,0x5a,0x71,0x6d,0x04,0xe9,0x1e,0xc7,0x92,0x24,
	0x6e,0x12,0x33,0xa9,0x52,0x64,0x31,0xef,0x71,0xeb,0x22,0x55,
	0x28,0x97,0x06,0x6a,0xc0,0x0c,0xa0,0x7e
	};

__fips_constseg
static const unsigned char sha384_pr_nonce[] =
	{
	0xf5,0x0d,0xfa,0xb0,0xec,0x6a,0x7c,0xd6,0xbd,0x9b,0x05,0xfd,
	0x38,0x3e,0x2e,0x56
	};

__fips_constseg
static const unsigned char sha384_pr_personalizationstring[] =
	{
	0x74,0xac,0x7e,0x6d,0xb1,0xa4,0xe7,0x21,0xd1,0x1e,0x6e,0x96,
	0x6d,0x4d,0x53,0x46,0x82,0x96,0x6e,0xcf,0xaa,0x81,0x8d,0x7d,
	0x9e,0xe1,0x0f,0x15,0xea,0x41,0xbf,0xe3
	};

__fips_constseg
static const unsigned char sha384_pr_additionalinput[] =
	{
	0xda,0x95,0xd4,0xd0,0xb8,0x11,0xd3,0x49,0x27,0x5d,0xa9,0x39,
	0x68,0xf3,0xa8,0xe9,0x5d,0x19,0x8a,0x2b,0x66,0xe8,0x69,0x06,
	0x7c,0x9e,0x03,0xa1,0x8b,0x26,0x2d,0x6e
	};

__fips_constseg
static const unsigned char sha384_pr_entropyinputpr[] =
	{
	0x49,0xdf,0x44,0x00,0xe4,0x1c,0x75,0x0b,0x26,0x5a,0x59,0x64,
	0x1f,0x4e,0xb1,0xb2,0x13,0xf1,0x22,0x4e,0xb4,0x6d,0x9a,0xcc,
	0xa0,0x48,0xe6,0xcf,0x1d,0xd1,0x92,0x0d
	};

__fips_constseg
static const unsigned char sha384_pr_int_returnedbits[] =
	{
	0xc8,0x52,0xae,0xbf,0x04,0x3c,0x27,0xb7,0x78,0x18,0xaa,0x8f,
	0xff,0xcf,0xa4,0xf1,0xcc,0xe7,0x68,0xfa,0x22,0xa2,0x13,0x45,
	0xe8,0xdd,0x87,0xe6,0xf2,0x6e,0xdd,0xc7,0x52,0x90,0x9f,0x7b,
	0xfa,0x61,0x2d,0x9d,0x9e,0xcf,0x98,0xac,0x52,0x40,0xce,0xaf
	};

__fips_constseg
static const unsigned char sha384_pr_additionalinput2[] =
	{
	0x61,0x7c,0x03,0x9a,0x3e,0x50,0x57,0x60,0xc5,0x83,0xc9,0xb2,
	0xd1,0x87,0x85,0x66,0x92,0x5d,0x84,0x0e,0x53,0xfb,0x70,0x03,
	0x72,0xfd,0xba,0xae,0x9c,0x8f,0xf8,0x18
	};

__fips_constseg
static const unsigned char sha384_pr_entropyinputpr2[] =
	{
	0xf8,0xeb,0x89,0xb1,0x8d,0x78,0xbe,0x21,0xe0,0xbb,0x9d,0xb7,
	0x95,0x0e,0xd9,0x46,0x0c,0x8c,0xe2,0x63,0xb7,0x9d,0x67,0x90,
	0xbd,0xc7,0x0b,0xa5,0xce,0xb2,0x65,0x81
	};

__fips_constseg
static const unsigned char sha384_pr_returnedbits[] =
	{
	0xe6,0x9f,0xfe,0x68,0xd6,0xb5,0x79,0xf1,0x06,0x5f,0xa3,0xbb,
	0x23,0x85,0xd8,0xf0,0x29,0x5a,0x68,0x9e,0xf5,0xf4,0xa6,0x12,
	0xe0,0x9a,0xe2,0xac,0x00,0x1d,0x98,0x26,0xfc,0x53,0x95,0x53,
	0xe4,0x3e,0x17,0xd5,0x08,0x0b,0x70,0x3d,0x67,0x99,0xac,0x66
	};


/* SHA-384 No PR  */
__fips_constseg
static const unsigned char sha384_entropyinput[] =
	{
	0x07,0x15,0x27,0x2a,0xaf,0x74,0x24,0x37,0xbc,0xd5,0x14,0x69,
	0xce,0x11,0xff,0xa2,0x6b,0xb8,0x05,0x67,0x34,0xf8,0xbd,0x6d,
	0x6a,0xcc,0xcd,0x60,0xa3,0x68,0xca,0xf4
	};

__fips_constseg
static const unsigned char sha384_nonce[] =
	{
	0x70,0x17,0xc2,0x5b,0x5d,0x22,0x0b,0x06,0x15,0x54,0x78,0x77,
	0x44,0xaf,0x2f,0x09
	};

__fips_constseg
static const unsigned char sha384_personalizationstring[] =
	{
	0x89,0x39,0x28,0xb0,0x60,0xeb,0x3d,0xdc,0x55,0x75,0x86,0xeb,
	0xae,0xa2,0x8f,0xbc,0x1b,0x75,0xd4,0xe1,0x0f,0xaa,0x38,0xca,
	0x62,0x8b,0xcb,0x2c,0x26,0xf6,0xbc,0xb1
	};

__fips_constseg
static const unsigned char sha384_additionalinput[] =
	{
	0x30,0x2b,0x42,0x35,0xef,0xda,0x40,0x55,0x28,0xc6,0x95,0xfb,
	0x54,0x01,0x62,0xd7,0x87,0x14,0x48,0x6d,0x90,0x4c,0xa9,0x02,
	0x54,0x40,0x22,0xc8,0x66,0xa5,0x48,0x48
	};

__fips_constseg
static const unsigned char sha384_int_returnedbits[] =
	{
	0x82,0xc4,0xa1,0x9c,0x21,0xd2,0xe7,0xa5,0xa6,0xf6,0x5f,0x04,
	0x5c,0xc7,0x31,0x9d,0x8d,0x59,0x74,0x50,0x19,0x89,0x2f,0x63,
	0xd5,0xb7,0x7e,0xeb,0x15,0xe3,0x70,0x83,0xa1,0x24,0x59,0xfa,
	0x2c,0x56,0xf6,0x88,0x3a,0x92,0x93,0xa1,0xfb,0x79,0xc1,0x7a
	};

__fips_constseg
static const unsigned char sha384_entropyinputreseed[] =
	{
	0x39,0xa6,0xe8,0x5c,0x82,0x17,0x71,0x26,0x57,0x4f,0x9f,0xc2,
	0x55,0xff,0x5c,0x9b,0x53,0x1a,0xd1,0x5f,0xbc,0x62,0xe4,0x27,
	0x2d,0x32,0xf0,0xe4,0x52,0x8c,0xc5,0x0c
	};

__fips_constseg
static const unsigned char sha384_additionalinputreseed[] =
	{
	0x8d,0xcb,0x8d,0xce,0x08,0xea,0x80,0xe8,0x9b,0x61,0xa8,0x0f,
	0xaf,0x49,0x20,0x9e,0x74,0xcb,0x57,0x80,0x42,0xb0,0x84,0x5e,
	0x30,0x2a,0x67,0x08,0xf4,0xe3,0x40,0x22
	};

__fips_constseg
static const unsigned char sha384_additionalinput2[] =
	{
	0x7c,0x8f,0xc2,0xae,0x22,0x4a,0xd6,0xf6,0x05,0xa4,0x7a,0xea,
	0xbb,0x25,0xd0,0xb7,0x5a,0xd6,0xcf,0x9d,0xf3,0x6c,0xe2,0xb2,
	0x4e,0xb4,0xbd,0xf4,0xe5,0x40,0x80,0x94
	};

__fips_constseg
static const unsigned char sha384_returnedbits[] =
	{
	0x9e,0x7e,0xfb,0x59,0xbb,0xaa,0x3c,0xf7,0xe1,0xf8,0x76,0xdd,
	0x63,0x5f,0xaf,0x23,0xd6,0x64,0x61,0xc0,0x9a,0x09,0x47,0xc9,
	0x33,0xdf,0x6d,0x55,0x91,0x34,0x79,0x70,0xc4,0x99,0x6e,0x54,
	0x09,0x64,0x21,0x1a,0xbd,0x1e,0x80,0x40,0x34,0xad,0xfa,0xd7
	};


/* SHA-512 PR  */
__fips_constseg
static const unsigned char sha512_pr_entropyinput[] =
	{
	0x13,0xf7,0x61,0x75,0x65,0x28,0xa2,0x59,0x13,0x5a,0x4a,0x4f,
	0x56,0x60,0x8c,0x53,0x7d,0xb0,0xbd,0x06,0x4f,0xed,0xcc,0xd2,
	0xa2,0xb5,0xfd,0x5b,0x3a,0xab,0xec,0x28
	};

__fips_constseg
static const unsigned char sha512_pr_nonce[] =
	{
	0xbe,0xa3,0x91,0x93,0x1d,0xc3,0x31,0x3a,0x23,0x33,0x50,0x67,
	0x88,0xc7,0xa2,0xc4
	};

__fips_constseg
static const unsigned char sha512_pr_personalizationstring[] =
	{
	0x1f,0x59,0x4d,0x7b,0xe6,0x46,0x91,0x48,0xc1,0x25,0xfa,0xff,
	0x89,0x12,0x77,0x35,0xdf,0x3e,0xf4,0x80,0x5f,0xd9,0xb0,0x07,
	0x22,0x41,0xdd,0x48,0x78,0x6b,0x77,0x2b
	};

__fips_constseg
static const unsigned char sha512_pr_additionalinput[] =
	{
	0x30,0xff,0x63,0x6f,0xac,0xd9,0x84,0x39,0x6f,0xe4,0x99,0xce,
	0x91,0x7d,0x7e,0xc8,0x58,0xf2,0x12,0xc3,0xb6,0xad,0xda,0x22,
	0x04,0xa0,0xd2,0x21,0xfe,0xf2,0x95,0x1d
	};

__fips_constseg
static const unsigned char sha512_pr_entropyinputpr[] =
	{
	0x64,0x54,0x13,0xec,0x4f,0x77,0xda,0xb2,0x92,0x2e,0x52,0x80,
	0x11,0x10,0xc2,0xf8,0xe6,0xa7,0xcd,0x4b,0xfc,0x32,0x2e,0x9e,
	0xeb,0xbb,0xb1,0xbf,0x15,0x5c,0x73,0x08
	};

__fips_constseg
static const unsigned char sha512_pr_int_returnedbits[] =
	{
	0xef,0x1e,0xdc,0x0a,0xa4,0x36,0x91,0x9c,0x3d,0x27,0x97,0x50,
	0x8d,0x36,0x29,0x8d,0xce,0x6a,0x0c,0xf7,0x21,0xc0,0x91,0xae,
	0x0c,0x96,0x72,0xbd,0x52,0x81,0x58,0xfc,0x6d,0xe5,0xf7,0xa5,
	0xfd,0x5d,0xa7,0x58,0x68,0xc8,0x99,0x58,0x8e,0xc8,0xce,0x95,
	0x01,0x7d,0xff,0xa4,0xc8,0xf7,0x63,0xfe,0x5f,0x69,0x83,0x53,
	0xe2,0xc6,0x8b,0xc3
	};

__fips_constseg
static const unsigned char sha512_pr_additionalinput2[] =
	{
	0xe6,0x9b,0xc4,0x88,0x34,0xca,0xea,0x29,0x2f,0x98,0x05,0xa4,
	0xd3,0xc0,0x7b,0x11,0xe8,0xbb,0x75,0xf2,0xbd,0x29,0xb7,0x40,
	0x25,0x7f,0xc1,0xb7,0xb1,0xf1,0x25,0x61
	};

__fips_constseg
static const unsigned char sha512_pr_entropyinputpr2[] =
	{
	0x23,0x6d,0xff,0xde,0xfb,0xd1,0xba,0x33,0x18,0xe6,0xbe,0xb5,
	0x48,0x77,0x6d,0x7f,0xa7,0xe1,0x4d,0x48,0x1e,0x3c,0xa7,0x34,
	0x1a,0xc8,0x60,0xdb,0x8f,0x99,0x15,0x99
	};

__fips_constseg
static const unsigned char sha512_pr_returnedbits[] =
	{
	0x70,0x27,0x31,0xdb,0x92,0x70,0x21,0xfe,0x16,0xb6,0xc8,0x51,
	0x34,0x87,0x65,0xd0,0x4e,0xfd,0xfe,0x68,0xec,0xac,0xdc,0x93,
	0x41,0x38,0x92,0x90,0xb4,0x94,0xf9,0x0d,0xa4,0xf7,0x4e,0x80,
	0x92,0x67,0x48,0x40,0xa7,0x08,0xc7,0xbc,0x66,0x00,0xfd,0xf7,
	0x4c,0x8b,0x17,0x6e,0xd1,0x8f,0x9b,0xf3,0x6f,0xf6,0x34,0xdd,
	0x67,0xf7,0x68,0xdd
	};


/* SHA-512 No PR  */
__fips_constseg
static const unsigned char sha512_entropyinput[] =
	{
	0xb6,0x0b,0xb7,0xbc,0x84,0x56,0xf6,0x12,0xaf,0x45,0x67,0x17,
	0x7c,0xd1,0xb2,0x78,0x2b,0xa0,0xf2,0xbe,0xb6,0x6d,0x8b,0x56,
	0xc6,0xbc,0x4d,0xe1,0xf7,0xbe,0xce,0xbd
	};

__fips_constseg
static const unsigned char sha512_nonce[] =
	{
	0x9d,0xed,0xc0,0xe5,0x5a,0x98,0x6a,0xcb,0x51,0x7d,0x76,0x31,
	0x5a,0x64,0xf0,0xf7
	};

__fips_constseg
static const unsigned char sha512_personalizationstring[] =
	{
	0xc2,0x6d,0xa3,0xc3,0x06,0x74,0xe5,0x01,0x5c,0x10,0x17,0xc7,
	0xaf,0x83,0x9d,0x59,0x8d,0x2d,0x29,0x38,0xc5,0x59,0x70,0x8b,
	0x46,0x48,0x2d,0xcf,0x36,0x7d,0x59,0xc0
	};

__fips_constseg
static const unsigned char sha512_additionalinput[] =
	{
	0xec,0x8c,0xd4,0xf7,0x61,0x6e,0x0d,0x95,0x79,0xb7,0x28,0xad,
	0x5f,0x69,0x74,0x5f,0x2d,0x36,0x06,0x8a,0x6b,0xac,0x54,0x97,
	0xc4,0xa1,0x12,0x85,0x0a,0xdf,0x4b,0x34
	};

__fips_constseg
static const unsigned char sha512_int_returnedbits[] =
	{
	0x84,0x2f,0x1f,0x68,0x6a,0xa3,0xad,0x1e,0xfb,0xf4,0x15,0xbd,
	0xde,0x38,0xd4,0x30,0x80,0x51,0xe9,0xd3,0xc7,0x20,0x88,0xe9,
	0xf5,0xcc,0xdf,0x57,0x5c,0x47,0x2f,0x57,0x3c,0x5f,0x13,0x56,
	0xcc,0xc5,0x4f,0x84,0xf8,0x10,0x41,0xd5,0x7e,0x58,0x6e,0x19,
	0x19,0x9e,0xaf,0xc2,0x22,0x58,0x41,0x50,0x79,0xc2,0xd8,0x04,
	0x28,0xd4,0x39,0x9a
	};

__fips_constseg
static const unsigned char sha512_entropyinputreseed[] =
	{
	0xfa,0x7f,0x46,0x51,0x83,0x62,0x98,0x16,0x9a,0x19,0xa2,0x49,
	0xa9,0xe6,0x4a,0xd8,0x85,0xe7,0xd4,0x3b,0x2c,0x82,0xc5,0x82,
	0xbf,0x11,0xf9,0x9e,0xbc,0xd0,0x01,0xee
	};

__fips_constseg
static const unsigned char sha512_additionalinputreseed[] =
	{
	0xb9,0x12,0xe0,0x4f,0xf7,0xa7,0xc4,0xd8,0xd0,0x8e,0x99,0x29,
	0x7c,0x9a,0xe9,0xcf,0xc4,0x6c,0xf8,0xc3,0xa7,0x41,0x83,0xd6,
	0x2e,0xfa,0xb8,0x5e,0x8e,0x6b,0x78,0x20
	};

__fips_constseg
static const unsigned char sha512_additionalinput2[] =
	{
	0xd7,0x07,0x52,0xb9,0x83,0x2c,0x03,0x71,0xee,0xc9,0xc0,0x85,
	0xe1,0x57,0xb2,0xcd,0x3a,0xf0,0xc9,0x34,0x24,0x41,0x1c,0x42,
	0x99,0xb2,0x84,0xe9,0x17,0xd2,0x76,0x92
	};

__fips_constseg
static const unsigned char sha512_returnedbits[] =
	{
	0x36,0x17,0x5d,0x98,0x2b,0x65,0x25,0x8e,0xc8,0x29,0xdf,0x27,
	0x05,0x36,0x26,0x12,0x8a,0x68,0x74,0x27,0x37,0xd4,0x7f,0x32,
	0xb1,0x12,0xd6,0x85,0x83,0xeb,0x2e,0xa0,0xed,0x4b,0xb5,0x7b,
	0x6f,0x39,0x3c,0x71,0x77,0x02,0x12,0xcc,0x2c,0x3a,0x8e,0x63,
	0xdf,0x4a,0xbd,0x6f,0x6e,0x2e,0xed,0x0a,0x85,0xa5,0x2f,0xa2,
	0x68,0xde,0x42,0xb5
	};


/* HMAC SHA-1 PR  */
__fips_constseg
static const unsigned char hmac_sha1_pr_entropyinput[] =
	{
	0x26,0x5f,0x36,0x14,0xff,0x3d,0x83,0xfa,0x73,0x5e,0x75,0xdc,
	0x2c,0x18,0x17,0x1b
	};

__fips_constseg
static const unsigned char hmac_sha1_pr_nonce[] =
	{
	0xc8,0xe3,0x57,0xa5,0x7b,0x74,0x86,0x6e
	};

__fips_constseg
static const unsigned char hmac_sha1_pr_personalizationstring[] =
	{
	0x6e,0xdb,0x0d,0xfe,0x7d,0xac,0x79,0xd0,0xa5,0x3a,0x48,0x85,
	0x80,0xe2,0x7f,0x2a
	};

__fips_constseg
static const unsigned char hmac_sha1_pr_additionalinput[] =
	{
	0x31,0xcd,0x5e,0x43,0xdc,0xfb,0x7a,0x79,0xca,0x88,0xde,0x1f,
	0xd7,0xbb,0x42,0x09
	};

__fips_constseg
static const unsigned char hmac_sha1_pr_entropyinputpr[] =
	{
	0x7c,0x23,0x95,0x38,0x00,0x95,0xc1,0x78,0x1f,0x8f,0xd7,0x63,
	0x23,0x87,0x2a,0xed
	};

__fips_constseg
static const unsigned char hmac_sha1_pr_int_returnedbits[] =
	{
	0xbb,0x34,0xe7,0x93,0xa3,0x02,0x2c,0x4a,0xd0,0x89,0xda,0x7f,
	0xed,0xf4,0x4c,0xde,0x17,0xec,0xe5,0x6c
	};

__fips_constseg
static const unsigned char hmac_sha1_pr_additionalinput2[] =
	{
	0x49,0xbc,0x2d,0x2c,0xb7,0x32,0xcb,0x20,0xdf,0xf5,0x77,0x58,
	0xa0,0x4b,0x93,0x6e
	};

__fips_constseg
static const unsigned char hmac_sha1_pr_entropyinputpr2[] =
	{
	0x3c,0xaa,0xb0,0x21,0x42,0xb0,0xdd,0x34,0xf0,0x16,0x7f,0x0c,
	0x0f,0xff,0x2e,0xaf
	};

__fips_constseg
static const unsigned char hmac_sha1_pr_returnedbits[] =
	{
	0x8e,0xcb,0xa3,0x64,0xb2,0xb8,0x33,0x6c,0x64,0x3b,0x78,0x16,
	0x99,0x35,0xc8,0x30,0xcb,0x3e,0xa0,0xd8
	};


/* HMAC SHA-1 No PR  */
__fips_constseg
static const unsigned char hmac_sha1_entropyinput[] =
	{
	0x32,0x9a,0x2a,0x87,0x7b,0x89,0x7c,0xf6,0xcb,0x95,0xd5,0x40,
	0x17,0xfe,0x47,0x70
	};

__fips_constseg
static const unsigned char hmac_sha1_nonce[] =
	{
	0x16,0xd8,0xe0,0xc7,0x52,0xcf,0x4a,0x25
	};

__fips_constseg
static const unsigned char hmac_sha1_personalizationstring[] =
	{
	0x35,0x35,0xa9,0xa5,0x40,0xbe,0x9b,0xd1,0x56,0xdd,0x44,0x00,
	0x72,0xf7,0xd3,0x5e
	};

__fips_constseg
static const unsigned char hmac_sha1_additionalinput[] =
	{
	0x1b,0x2c,0x84,0x2d,0x4a,0x89,0x8f,0x69,0x19,0xf1,0xf3,0xdb,
	0xbb,0xe3,0xaa,0xea
	};

__fips_constseg
static const unsigned char hmac_sha1_int_returnedbits[] =
	{
	0xcf,0xfa,0x7d,0x72,0x0f,0xe6,0xc7,0x96,0xa0,0x69,0x31,0x11,
	0x9b,0x0b,0x1a,0x20,0x1f,0x3f,0xaa,0xd1
	};

__fips_constseg
static const unsigned char hmac_sha1_entropyinputreseed[] =
	{
	0x90,0x75,0x15,0x04,0x95,0xf1,0xba,0x81,0x0c,0x37,0x94,0x6f,
	0x86,0x52,0x6d,0x9c
	};

__fips_constseg
static const unsigned char hmac_sha1_additionalinputreseed[] =
	{
	0x5b,0x40,0xba,0x5f,0x17,0x70,0xf0,0x4b,0xdf,0xc9,0x97,0x92,
	0x79,0xc5,0x82,0x28
	};

__fips_constseg
static const unsigned char hmac_sha1_additionalinput2[] =
	{
	0x97,0xc8,0x80,0x90,0xb3,0xaa,0x6e,0x60,0xea,0x83,0x7a,0xe3,
	0x8a,0xca,0xa4,0x7f
	};

__fips_constseg
static const unsigned char hmac_sha1_returnedbits[] =
	{
	0x90,0xbd,0x05,0x56,0x6d,0xb5,0x22,0xd5,0xb9,0x5a,0x29,0x2d,
	0xe9,0x0b,0xe1,0xac,0xde,0x27,0x0b,0xb0
	};


/* HMAC SHA-224 PR  */
__fips_constseg
static const unsigned char hmac_sha224_pr_entropyinput[] =
	{
	0x17,0x32,0x2b,0x2e,0x6f,0x1b,0x9c,0x6d,0x31,0xe0,0x34,0x07,
	0xcf,0xed,0xf6,0xb6,0x5a,0x76,0x4c,0xbc,0x62,0x85,0x01,0x90
	};

__fips_constseg
static const unsigned char hmac_sha224_pr_nonce[] =
	{
	0x38,0xbf,0x5f,0x20,0xb3,0x68,0x2f,0x43,0x61,0x05,0x8f,0x23
	};

__fips_constseg
static const unsigned char hmac_sha224_pr_personalizationstring[] =
	{
	0xc0,0xc9,0x45,0xac,0x8d,0x27,0x77,0x08,0x0b,0x17,0x6d,0xed,
	0xc1,0x7d,0xd5,0x07,0x9d,0x6e,0xf8,0x23,0x2a,0x22,0x13,0xbd
	};

__fips_constseg
static const unsigned char hmac_sha224_pr_additionalinput[] =
	{
	0xa4,0x3c,0xe7,0x3b,0xea,0x19,0x45,0x32,0xc2,0x83,0x6d,0x21,
	0x8a,0xc0,0xee,0x67,0x45,0xde,0x13,0x7d,0x9d,0x61,0x00,0x3b
	};

__fips_constseg
static const unsigned char hmac_sha224_pr_entropyinputpr[] =
	{
	0x15,0x05,0x74,0x4a,0x7f,0x8d,0x5c,0x60,0x16,0xe5,0x7b,0xad,
	0xf5,0x41,0x8f,0x55,0x60,0xc4,0x09,0xee,0x1e,0x11,0x81,0xab
	};

__fips_constseg
static const unsigned char hmac_sha224_pr_int_returnedbits[] =
	{
	0x6f,0xf5,0x9a,0xe2,0x54,0x53,0x30,0x3d,0x5a,0x27,0x29,0x38,
	0x27,0xf2,0x0d,0x05,0xe9,0x26,0xcb,0x16,0xc3,0x51,0x5f,0x13,
	0x41,0xfe,0x99,0xf2
	};

__fips_constseg
static const unsigned char hmac_sha224_pr_additionalinput2[] =
	{
	0x73,0x81,0x88,0x84,0x8f,0xed,0x6f,0x10,0x9f,0x93,0xbf,0x17,
	0x35,0x7c,0xef,0xd5,0x8d,0x26,0xa6,0x7a,0xe8,0x09,0x36,0x4f
	};

__fips_constseg
static const unsigned char hmac_sha224_pr_entropyinputpr2[] =
	{
	0xe6,0xcf,0xcf,0x7e,0x12,0xe5,0x43,0xd2,0x38,0xd8,0x24,0x6f,
	0x5a,0x37,0x68,0xbf,0x4f,0xa0,0xff,0xd5,0x61,0x8a,0x93,0xe0
	};

__fips_constseg
static const unsigned char hmac_sha224_pr_returnedbits[] =
	{
	0xaf,0xf9,0xd8,0x19,0x91,0x30,0x82,0x6f,0xa9,0x1e,0x9d,0xd7,
	0xf3,0x50,0xe0,0xc7,0xd5,0x64,0x96,0x7d,0x4c,0x4d,0x78,0x03,
	0x6d,0xd8,0x9e,0x72
	};


/* HMAC SHA-224 No PR  */
__fips_constseg
static const unsigned char hmac_sha224_entropyinput[] =
	{
	0x11,0x82,0xfd,0xd9,0x42,0xf4,0xfa,0xc8,0xf2,0x41,0xe6,0x54,
	0x01,0xae,0x22,0x6e,0xc6,0xaf,0xaf,0xd0,0xa6,0xb2,0xe2,0x6d
	};

__fips_constseg
static const unsigned char hmac_sha224_nonce[] =
	{
	0xa9,0x48,0xd7,0x92,0x39,0x7e,0x2a,0xdc,0x30,0x1f,0x0e,0x2b
	};

__fips_constseg
static const unsigned char hmac_sha224_personalizationstring[] =
	{
	0x11,0xd5,0xf4,0xbd,0x67,0x8c,0x31,0xcf,0xa3,0x3f,0x1e,0x6b,
	0xa8,0x07,0x02,0x0b,0xc8,0x2e,0x6c,0x64,0x41,0x5b,0xc8,0x37
	};

__fips_constseg
static const unsigned char hmac_sha224_additionalinput[] =
	{
	0x68,0x18,0xc2,0x06,0xeb,0x3e,0x04,0x95,0x44,0x5e,0xfb,0xe6,
	0x41,0xc1,0x5c,0xcc,0x40,0x2f,0xb7,0xd2,0x0f,0xf3,0x6b,0xe7
	};

__fips_constseg
static const unsigned char hmac_sha224_int_returnedbits[] =
	{
	0x7f,0x45,0xc7,0x5d,0x32,0xe6,0x17,0x60,0xba,0xdc,0xb8,0x42,
	0x1b,0x9c,0xf1,0xfa,0x3b,0x4d,0x29,0x54,0xc6,0x90,0xff,0x5c,
	0xcd,0xd6,0xa9,0xcc
	};

__fips_constseg
static const unsigned char hmac_sha224_entropyinputreseed[] =
	{
	0xc4,0x8e,0x37,0x95,0x69,0x53,0x28,0xd7,0x37,0xbb,0x70,0x95,
	0x1c,0x07,0x1d,0xd9,0xb7,0xe6,0x1b,0xbb,0xfe,0x41,0xeb,0xc9
	};

__fips_constseg
static const unsigned char hmac_sha224_additionalinputreseed[] =
	{
	0x53,0x17,0xa1,0x6a,0xfa,0x77,0x47,0xb0,0x95,0x56,0x9a,0x20,
	0x57,0xde,0x5c,0x89,0x9f,0x7f,0xe2,0xde,0x17,0x3a,0x50,0x23
	};

__fips_constseg
static const unsigned char hmac_sha224_additionalinput2[] =
	{
	0x3a,0x32,0xf9,0x85,0x0c,0xc1,0xed,0x76,0x2d,0xdf,0x40,0xc3,
	0x06,0x22,0x66,0xd4,0x9a,0x9a,0xff,0x5a,0x7e,0x7a,0xf3,0x96
	};

__fips_constseg
static const unsigned char hmac_sha224_returnedbits[] =
	{
	0x43,0xb4,0x57,0x5c,0x38,0x25,0x9d,0xae,0xec,0x96,0xd1,0x85,
	0x3a,0x84,0x8d,0xfe,0x68,0xd5,0x0e,0x5c,0x8f,0x65,0xa5,0x4e,
	0x45,0x84,0xa8,0x94
	};


/* HMAC SHA-256 PR  */
__fips_constseg
static const unsigned char hmac_sha256_pr_entropyinput[] =
	{
	0x4d,0xb0,0x43,0xd8,0x34,0x4b,0x10,0x70,0xb1,0x8b,0xed,0xea,
	0x07,0x92,0x9f,0x6c,0x79,0x31,0xaf,0x81,0x29,0xeb,0x6e,0xca,
	0x32,0x48,0x28,0xe7,0x02,0x5d,0xa6,0xa6
	};

__fips_constseg
static const unsigned char hmac_sha256_pr_nonce[] =
	{
	0x3a,0xae,0x15,0xa9,0x99,0xdc,0xe4,0x67,0x34,0x3b,0x70,0x15,
	0xaa,0xd3,0x30,0x9a
	};

__fips_constseg
static const unsigned char hmac_sha256_pr_personalizationstring[] =
	{
	0x13,0x1d,0x24,0x04,0xb0,0x18,0x81,0x15,0x21,0x51,0x2a,0x24,
	0x52,0x61,0xbe,0x64,0x82,0x6b,0x55,0x2f,0xe2,0xf1,0x40,0x7d,
	0x71,0xd8,0x01,0x86,0x15,0xb7,0x8b,0xb5
	};

__fips_constseg
static const unsigned char hmac_sha256_pr_additionalinput[] =
	{
	0x8f,0xa6,0x54,0x5f,0xb1,0xd0,0xd8,0xc3,0xe7,0x0c,0x15,0xa9,
	0x23,0x6e,0xfe,0xfb,0x93,0xf7,0x3a,0xbd,0x59,0x01,0xfa,0x18,
	0x8e,0xe9,0x1a,0xa9,0x78,0xfc,0x79,0x0b
	};

__fips_constseg
static const unsigned char hmac_sha256_pr_entropyinputpr[] =
	{
	0xcf,0x24,0xb9,0xeb,0xb3,0xd4,0xcd,0x17,0x37,0x38,0x75,0x79,
	0x15,0xcb,0x2d,0x75,0x51,0xf1,0xcc,0xaa,0x32,0xa4,0xa7,0x36,
	0x7c,0x5c,0xe4,0x47,0xf1,0x3e,0x1d,0xe5
	};

__fips_constseg
static const unsigned char hmac_sha256_pr_int_returnedbits[] =
	{
	0x52,0x42,0xfa,0xeb,0x85,0xe0,0x30,0x22,0x79,0x00,0x16,0xb2,
	0x88,0x2f,0x14,0x6a,0xb7,0xfc,0xb7,0x53,0xdc,0x4a,0x12,0xef,
	0x54,0xd6,0x33,0xe9,0x20,0xd6,0xfd,0x56
	};

__fips_constseg
static const unsigned char hmac_sha256_pr_additionalinput2[] =
	{
	0xf4,0xf6,0x49,0xa1,0x2d,0x64,0x2b,0x30,0x58,0xf8,0xbd,0xb8,
	0x75,0xeb,0xbb,0x5e,0x1c,0x9b,0x81,0x6a,0xda,0x14,0x86,0x6e,
	0xd0,0xda,0x18,0xb7,0x88,0xfb,0x59,0xf3
	};

__fips_constseg
static const unsigned char hmac_sha256_pr_entropyinputpr2[] =
	{
	0x21,0xcd,0x6e,0x46,0xad,0x99,0x07,0x17,0xb4,0x3d,0x76,0x0a,
	0xff,0x5b,0x52,0x50,0x78,0xdf,0x1f,0x24,0x06,0x0d,0x3f,0x74,
	0xa9,0xc9,0x37,0xcf,0xd8,0x26,0x25,0x91
	};

__fips_constseg
static const unsigned char hmac_sha256_pr_returnedbits[] =
	{
	0xa7,0xaf,0x2f,0x29,0xe0,0x3a,0x72,0x95,0x96,0x1c,0xa9,0xf0,
	0x4a,0x17,0x4d,0x66,0x06,0x10,0xbf,0x39,0x89,0x88,0xb8,0x91,
	0x37,0x18,0x99,0xcf,0x8c,0x53,0x3b,0x7e
	};


/* HMAC SHA-256 No PR  */
__fips_constseg
static const unsigned char hmac_sha256_entropyinput[] =
	{
	0x96,0xb7,0x53,0x22,0x1e,0x52,0x2a,0x96,0xb1,0x15,0x3c,0x35,
	0x5a,0x8b,0xd3,0x4a,0xa6,0x6c,0x83,0x0a,0x7d,0xa3,0x23,0x3d,
	0x43,0xa1,0x07,0x2c,0x2d,0xe3,0x81,0xcc
	};

__fips_constseg
static const unsigned char hmac_sha256_nonce[] =
	{
	0xf1,0xac,0x97,0xcb,0x5e,0x06,0x48,0xd2,0x94,0xbe,0x15,0x2e,
	0xc7,0xfc,0xc2,0x01
	};

__fips_constseg
static const unsigned char hmac_sha256_personalizationstring[] =
	{
	0x98,0xc5,0x1e,0x35,0x5e,0x89,0x0d,0xce,0x64,0x6d,0x18,0xa7,
	0x5a,0xc6,0xf3,0xe7,0xd6,0x9e,0xc0,0xea,0xb7,0x3a,0x8d,0x65,
	0xb8,0xeb,0x10,0xd7,0x57,0x18,0xa0,0x32
	};

__fips_constseg
static const unsigned char hmac_sha256_additionalinput[] =
	{
	0x1b,0x10,0xaf,0xac,0xd0,0x65,0x95,0xad,0x04,0xad,0x03,0x1c,
	0xe0,0x40,0xd6,0x3e,0x1c,0x46,0x53,0x39,0x7c,0xe2,0xbc,0xda,
	0x8c,0xa2,0x33,0xa7,0x9a,0x26,0xd3,0x27
	};

__fips_constseg
static const unsigned char hmac_sha256_int_returnedbits[] =
	{
	0xba,0x61,0x0e,0x55,0xfe,0x11,0x8a,0x9e,0x0f,0x80,0xdf,0x1d,
	0x03,0x0a,0xfe,0x15,0x94,0x28,0x4b,0xba,0xf4,0x9f,0x51,0x25,
	0x88,0xe5,0x4e,0xfb,0xaf,0xce,0x69,0x90
	};

__fips_constseg
static const unsigned char hmac_sha256_entropyinputreseed[] =
	{
	0x62,0x7f,0x1e,0x6b,0xe8,0x8e,0xe1,0x35,0x7d,0x9b,0x4f,0xc7,
	0xec,0xc8,0xac,0xef,0x6b,0x13,0x9e,0x05,0x56,0xc1,0x08,0xf9,
	0x2f,0x0f,0x27,0x9c,0xd4,0x15,0xed,0x2d
	};

__fips_constseg
static const unsigned char hmac_sha256_additionalinputreseed[] =
	{
	0xc7,0x76,0x6e,0xa9,0xd2,0xb2,0x76,0x40,0x82,0x25,0x2c,0xb3,
	0x6f,0xac,0xe9,0x74,0xef,0x8f,0x3c,0x8e,0xcd,0xf1,0xbf,0xb3,
	0x49,0x77,0x34,0x88,0x52,0x36,0xe6,0x2e
	};

__fips_constseg
static const unsigned char hmac_sha256_additionalinput2[] =
	{
	0x8d,0xb8,0x0c,0xd1,0xbf,0x70,0xf6,0x19,0xc3,0x41,0x80,0x9f,
	0xe1,0xa5,0xa4,0x1f,0x2c,0x26,0xb1,0xe5,0xd8,0xeb,0xbe,0xf8,
	0xdf,0x88,0x6a,0x89,0xd6,0x05,0xd8,0x9d
	};

__fips_constseg
static const unsigned char hmac_sha256_returnedbits[] =
	{
	0x43,0x12,0x2a,0x2c,0x40,0x53,0x2e,0x7c,0x66,0x34,0xac,0xc3,
	0x43,0xe3,0xe0,0x6a,0xfc,0xfa,0xea,0x87,0x21,0x1f,0xe2,0x26,
	0xc4,0xf9,0x09,0x9a,0x0d,0x6e,0x7f,0xe0
	};


/* HMAC SHA-384 PR  */
__fips_constseg
static const unsigned char hmac_sha384_pr_entropyinput[] =
	{
	0x69,0x81,0x98,0x88,0x44,0xf5,0xd6,0x2e,0x00,0x08,0x3b,0xc5,
	0xfb,0xd7,0x8e,0x6f,0x23,0xf8,0x6d,0x09,0xd6,0x85,0x49,0xd1,
	0xf8,0x6d,0xa4,0x58,0x54,0xfd,0x88,0xa9
	};

__fips_constseg
static const unsigned char hmac_sha384_pr_nonce[] =
	{
	0x6e,0x38,0x81,0xca,0xb7,0xe8,0x6e,0x66,0x49,0x8a,0xb2,0x59,
	0xee,0x16,0xc9,0xde
	};

__fips_constseg
static const unsigned char hmac_sha384_pr_personalizationstring[] =
	{
	0xfe,0x4c,0xd9,0xf4,0x78,0x3b,0x08,0x41,0x8d,0x8f,0x55,0xc4,
	0x43,0x56,0xb6,0x12,0x36,0x6b,0x30,0xb7,0x5e,0xe1,0xb9,0x47,
	0x04,0xb1,0x4e,0xa9,0x00,0xa1,0x52,0xa1
	};

__fips_constseg
static const unsigned char hmac_sha384_pr_additionalinput[] =
	{
	0x89,0xe9,0xcc,0x8f,0x27,0x3c,0x26,0xd1,0x95,0xc8,0x7d,0x0f,
	0x5b,0x1a,0xf0,0x78,0x39,0x56,0x6f,0xa4,0x23,0xe7,0xd1,0xda,
	0x7c,0x66,0x33,0xa0,0x90,0xc9,0x92,0x88
	};

__fips_constseg
static const unsigned char hmac_sha384_pr_entropyinputpr[] =
	{
	0xbe,0x3d,0x7c,0x0d,0xca,0xda,0x7c,0x49,0xb8,0x12,0x36,0xc0,
	0xdb,0xad,0x35,0xa8,0xc7,0x0b,0x2a,0x2c,0x69,0x6d,0x25,0x56,
	0x63,0x82,0x11,0x3e,0xa7,0x33,0x70,0x72
	};

__fips_constseg
static const unsigned char hmac_sha384_pr_int_returnedbits[] =
	{
	0x82,0x3d,0xe6,0x54,0x80,0x42,0xf8,0xba,0x90,0x4f,0x06,0xa6,
	0xd2,0x7f,0xbf,0x79,0x7c,0x12,0x7d,0xa6,0xa2,0x66,0xe8,0xa6,
	0xc0,0xd6,0x4a,0x55,0xbf,0xd8,0x0a,0xc5,0xf8,0x03,0x88,0xdd,
	0x8e,0x87,0xd1,0x5a,0x48,0x26,0x72,0x2a,0x8e,0xcf,0xee,0xba
	};

__fips_constseg
static const unsigned char hmac_sha384_pr_additionalinput2[] =
	{
	0x8f,0xff,0xd9,0x84,0xbb,0x85,0x3a,0x66,0xa1,0x21,0xce,0xb2,
	0x3a,0x3a,0x17,0x22,0x19,0xae,0xc7,0xb6,0x63,0x81,0xd5,0xff,
	0x0d,0xc8,0xe1,0xaf,0x57,0xd2,0xcb,0x60
	};

__fips_constseg
static const unsigned char hmac_sha384_pr_entropyinputpr2[] =
	{
	0xd7,0xfb,0xc9,0xe8,0xe2,0xf2,0xaa,0x4c,0xb8,0x51,0x2f,0xe1,
	0x22,0xba,0xf3,0xda,0x0a,0x19,0x76,0x71,0x57,0xb2,0x1d,0x94,
	0x09,0x69,0x6c,0xd3,0x97,0x51,0x81,0x87
	};

__fips_constseg
static const unsigned char hmac_sha384_pr_returnedbits[] =
	{
	0xe6,0x19,0x28,0xa8,0x21,0xce,0x5e,0xdb,0x24,0x79,0x8c,0x76,
	0x5d,0x73,0xb2,0xdf,0xac,0xef,0x85,0xa7,0x3b,0x19,0x09,0x8b,
	0x7f,0x98,0x28,0xa9,0x93,0xd8,0x7a,0xad,0x55,0x8b,0x24,0x9d,
	0xe6,0x98,0xfe,0x47,0xd5,0x48,0xc1,0x23,0xd8,0x1d,0x62,0x75
	};


/* HMAC SHA-384 No PR  */
__fips_constseg
static const unsigned char hmac_sha384_entropyinput[] =
	{
	0xc3,0x56,0x2b,0x1d,0xc2,0xbb,0xa8,0xf0,0xae,0x1b,0x0d,0xd3,
	0x5a,0x6c,0xda,0x57,0x8e,0xa5,0x8a,0x0d,0x6c,0x4b,0x18,0xb1,
	0x04,0x3e,0xb4,0x99,0x35,0xc4,0xc0,0x5f
	};

__fips_constseg
static const unsigned char hmac_sha384_nonce[] =
	{
	0xc5,0x49,0x1e,0x66,0x27,0x92,0xbe,0xec,0xb5,0x1e,0x4b,0xb1,
	0x38,0xe3,0xeb,0x62
	};

__fips_constseg
static const unsigned char hmac_sha384_personalizationstring[] =
	{
	0xbe,0xe7,0x6b,0x57,0xde,0x88,0x11,0x96,0x9b,0x6e,0xea,0xe5,
	0x63,0x83,0x4c,0xb6,0x8d,0x66,0xaa,0x1f,0x8b,0x54,0xe7,0x62,
	0x6d,0x5a,0xfc,0xbf,0x97,0xba,0xcd,0x77
	};

__fips_constseg
static const unsigned char hmac_sha384_additionalinput[] =
	{
	0xe5,0x28,0x5f,0x43,0xf5,0x83,0x6e,0x0a,0x83,0x5c,0xe3,0x81,
	0x03,0xf2,0xf8,0x78,0x00,0x7c,0x95,0x87,0x16,0xd6,0x6c,0x58,
	0x33,0x6c,0x53,0x35,0x0d,0x66,0xe3,0xce
	};

__fips_constseg
static const unsigned char hmac_sha384_int_returnedbits[] =
	{
	0xe2,0x1f,0xf3,0xda,0x0d,0x19,0x99,0x87,0xc4,0x90,0xa2,0x31,
	0xca,0x2a,0x89,0x58,0x43,0x44,0xb8,0xde,0xcf,0xa4,0xbe,0x3b,
	0x53,0x26,0x22,0x31,0x76,0x41,0x22,0xb5,0xa8,0x70,0x2f,0x4b,
	0x64,0x95,0x4d,0x48,0x96,0x35,0xe6,0xbd,0x3c,0x34,0xdb,0x1b
	};

__fips_constseg
static const unsigned char hmac_sha384_entropyinputreseed[] =
	{
	0x77,0x61,0xba,0xbc,0xf2,0xc1,0xf3,0x4b,0x86,0x65,0xfd,0x48,
	0x0e,0x3c,0x02,0x5e,0xa2,0x7a,0x6b,0x7c,0xed,0x21,0x5e,0xf9,
	0xcd,0xcd,0x77,0x07,0x2b,0xbe,0xc5,0x5c
	};

__fips_constseg
static const unsigned char hmac_sha384_additionalinputreseed[] =
	{
	0x18,0x24,0x5f,0xc6,0x84,0xd1,0x67,0xc3,0x9a,0x11,0xa5,0x8c,
	0x07,0x39,0x21,0x83,0x4d,0x04,0xc4,0x6a,0x28,0x19,0xcf,0x92,
	0x21,0xd9,0x9e,0x41,0x72,0x6c,0x9e,0x63
	};

__fips_constseg
static const unsigned char hmac_sha384_additionalinput2[] =
	{
	0x96,0x67,0x41,0x28,0x9b,0xb7,0x92,0x8d,0x64,0x3b,0xe4,0xcf,
	0x7e,0xaa,0x1e,0xb1,0x4b,0x1d,0x09,0x56,0x67,0x9c,0xc6,0x6d,
	0x3b,0xe8,0x91,0x9d,0xe1,0x8a,0xb7,0x32
	};

__fips_constseg
static const unsigned char hmac_sha384_returnedbits[] =
	{
	0xe3,0x59,0x61,0x38,0x92,0xec,0xe2,0x3c,0xff,0xb7,0xdb,0x19,
	0x0f,0x5b,0x93,0x68,0x0d,0xa4,0x94,0x40,0x72,0x0b,0xe0,0xed,
	0x4d,0xcd,0x68,0xa0,0x1e,0xfe,0x67,0xb2,0xfa,0x21,0x56,0x74,
	0xa4,0xad,0xcf,0xb7,0x60,0x66,0x2e,0x40,0xde,0x82,0xca,0xfb
	};


/* HMAC SHA-512 PR  */
__fips_constseg
static const unsigned char hmac_sha512_pr_entropyinput[] =
	{
	0xaa,0x9e,0x45,0x67,0x0e,0x00,0x2a,0x67,0x98,0xd6,0xda,0x0b,
	0x0f,0x17,0x7e,0xac,0xfd,0x27,0xc4,0xca,0x84,0xdf,0xde,0xba,
	0x85,0xd9,0xbe,0x8f,0xf3,0xff,0x91,0x4d
	};

__fips_constseg
static const unsigned char hmac_sha512_pr_nonce[] =
	{
	0x8c,0x49,0x2f,0x58,0x1e,0x7a,0xda,0x4b,0x7e,0x8a,0x30,0x7b,
	0x86,0xea,0xaf,0xa2
	};

__fips_constseg
static const unsigned char hmac_sha512_pr_personalizationstring[] =
	{
	0x71,0xe1,0xbb,0xad,0xa7,0x4b,0x2e,0x31,0x3b,0x0b,0xec,0x24,
	0x99,0x38,0xbc,0xaa,0x05,0x4c,0x46,0x44,0xfa,0xad,0x8e,0x02,
	0xc1,0x7e,0xad,0xec,0x54,0xa6,0xd0,0xad
	};

__fips_constseg
static const unsigned char hmac_sha512_pr_additionalinput[] =
	{
	0x3d,0x6e,0xa6,0xa8,0x29,0x2a,0xb2,0xf5,0x98,0x42,0xe4,0x92,
	0x78,0x22,0x67,0xfd,0x1b,0x15,0x1e,0x29,0xaa,0x71,0x3c,0x3c,
	0xe7,0x05,0x20,0xa9,0x29,0xc6,0x75,0x71
	};

__fips_constseg
static const unsigned char hmac_sha512_pr_entropyinputpr[] =
	{
	0xab,0xb9,0x16,0xd8,0x55,0x35,0x54,0xb7,0x97,0x3f,0x94,0xbc,
	0x2f,0x7c,0x70,0xc7,0xd0,0xed,0xb7,0x4b,0xf7,0xf6,0x6c,0x03,
	0x0c,0xb0,0x03,0xd8,0xbb,0x71,0xd9,0x10
	};

__fips_constseg
static const unsigned char hmac_sha512_pr_int_returnedbits[] =
	{
	0x8e,0xd3,0xfd,0x52,0x9e,0x83,0x08,0x49,0x18,0x6e,0x23,0x56,
	0x5c,0x45,0x93,0x34,0x05,0xe2,0x98,0x8f,0x0c,0xd4,0x32,0x0c,
	0xfd,0xda,0x5f,0x92,0x3a,0x8c,0x81,0xbd,0xf6,0x6c,0x55,0xfd,
	0xb8,0x20,0xce,0x8d,0x97,0x27,0xe8,0xe8,0xe0,0xb3,0x85,0x50,
	0xa2,0xc2,0xb2,0x95,0x1d,0x48,0xd3,0x7b,0x4b,0x78,0x13,0x35,
	0x05,0x17,0xbe,0x0d
	};

__fips_constseg
static const unsigned char hmac_sha512_pr_additionalinput2[] =
	{
	0xc3,0xfc,0x95,0xaa,0x69,0x06,0xae,0x59,0x41,0xce,0x26,0x08,
	0x29,0x6d,0x45,0xda,0xe8,0xb3,0x6c,0x95,0x60,0x0f,0x70,0x2c,
	0x10,0xba,0x38,0x8c,0xcf,0x29,0x99,0xaa
	};

__fips_constseg
static const unsigned char hmac_sha512_pr_entropyinputpr2[] =
	{
	0x3b,0x9a,0x25,0xce,0xd7,0xf9,0x5c,0xd1,0x3a,0x3e,0xaa,0x71,
	0x14,0x3e,0x19,0xe8,0xce,0xe6,0xfe,0x51,0x84,0xe9,0x1b,0xfe,
	0x3f,0xa7,0xf2,0xfd,0x76,0x5f,0x6a,0xe7
	};

__fips_constseg
static const unsigned char hmac_sha512_pr_returnedbits[] =
	{
	0xb7,0x82,0xa9,0x57,0x81,0x67,0x53,0xb5,0xa1,0xe9,0x3d,0x35,
	0xf9,0xe4,0x97,0xbe,0xa6,0xca,0xf1,0x01,0x13,0x09,0xe7,0x21,
	0xc0,0xed,0x93,0x5d,0x4b,0xf4,0xeb,0x8d,0x53,0x25,0x8a,0xc4,
	0xb1,0x6f,0x6e,0x37,0xcd,0x2e,0xac,0x39,0xb2,0xb6,0x99,0xa3,
	0x82,0x00,0xb0,0x21,0xf0,0xc7,0x2f,0x4c,0x73,0x92,0xfd,0x00,
	0xb6,0xaf,0xbc,0xd3
	};


/* HMAC SHA-512 No PR  */
__fips_constseg
static const unsigned char hmac_sha512_entropyinput[] =
	{
	0x6e,0x85,0xe6,0x25,0x96,0x29,0xa7,0x52,0x5b,0x60,0xba,0xaa,
	0xde,0xdb,0x36,0x0a,0x51,0x9a,0x15,0xae,0x6e,0x18,0xd3,0xfe,
	0x39,0xb9,0x4a,0x96,0xf8,0x77,0xcb,0x95
	};

__fips_constseg
static const unsigned char hmac_sha512_nonce[] =
	{
	0xe0,0xa6,0x5d,0x08,0xc3,0x7c,0xae,0x25,0x2e,0x80,0xd1,0x3e,
	0xd9,0xaf,0x43,0x3c
	};

__fips_constseg
static const unsigned char hmac_sha512_personalizationstring[] =
	{
	0x53,0x99,0x52,0x5f,0x11,0xa9,0x64,0x66,0x20,0x5e,0x1b,0x5f,
	0x42,0xb3,0xf4,0xda,0xed,0xbb,0x63,0xc1,0x23,0xaf,0xd0,0x01,
	0x90,0x3b,0xd0,0x78,0xe4,0x0b,0xa7,0x20
	};

__fips_constseg
static const unsigned char hmac_sha512_additionalinput[] =
	{
	0x85,0x90,0x80,0xd3,0x98,0xf1,0x53,0x6d,0x68,0x15,0x8f,0xe5,
	0x60,0x3f,0x17,0x29,0x55,0x8d,0x33,0xb1,0x45,0x64,0x64,0x8d,
	0x50,0x21,0x89,0xae,0xf6,0xfd,0x32,0x73
	};

__fips_constseg
static const unsigned char hmac_sha512_int_returnedbits[] =
	{
	0x28,0x56,0x30,0x6f,0xf4,0xa1,0x48,0xe0,0xc9,0xf5,0x75,0x90,
	0xcc,0xfb,0xdf,0xdf,0x71,0x3d,0x0a,0x9a,0x03,0x65,0x3b,0x18,
	0x61,0xe3,0xd1,0xda,0xcc,0x4a,0xfe,0x55,0x38,0xf8,0x21,0x6b,
	0xfa,0x18,0x01,0x42,0x39,0x2f,0x99,0x53,0x38,0x15,0x82,0x34,
	0xc5,0x93,0x92,0xbc,0x4d,0x75,0x1a,0x5f,0x21,0x27,0xcc,0xa1,
	0xb1,0x57,0x69,0xe8
	};

__fips_constseg
static const unsigned char hmac_sha512_entropyinputreseed[] =
	{
	0x8c,0x52,0x7e,0x77,0x72,0x3f,0xa3,0x04,0x97,0x10,0x9b,0x41,
	0xbd,0xe8,0xff,0x89,0xed,0x80,0xe3,0xbd,0xaa,0x12,0x2d,0xca,
	0x75,0x82,0x36,0x77,0x88,0xcd,0xa6,0x73
	};

__fips_constseg
static const unsigned char hmac_sha512_additionalinputreseed[] =
	{
	0x7e,0x32,0xe3,0x69,0x69,0x07,0x34,0xa2,0x16,0xa2,0x5d,0x1a,
	0x10,0x91,0xd3,0xe2,0x21,0xa2,0xa3,0xdd,0xcd,0x0c,0x09,0x86,
	0x11,0xe1,0x50,0xff,0x5c,0xb7,0xeb,0x5c
	};

__fips_constseg
static const unsigned char hmac_sha512_additionalinput2[] =
	{
	0x7f,0x78,0x66,0xd8,0xfb,0x67,0xcf,0x8d,0x8c,0x08,0x30,0xa5,
	0xf8,0x7d,0xcf,0x44,0x59,0xce,0xf8,0xdf,0x58,0xd3,0x60,0xcb,
	0xa8,0x60,0xb9,0x07,0xc4,0xb1,0x95,0x48
	};

__fips_constseg
static const unsigned char hmac_sha512_returnedbits[] =
	{
	0xdf,0xa7,0x36,0xd4,0xdc,0x5d,0x4d,0x31,0xad,0x69,0x46,0x9f,
	0xf1,0x7c,0xd7,0x3b,0x4f,0x55,0xf2,0xd7,0xb9,0x9d,0xad,0x7a,
	0x79,0x08,0x59,0xa5,0xdc,0x74,0xf5,0x9b,0x73,0xd2,0x13,0x25,
	0x0b,0x81,0x08,0x08,0x25,0xfb,0x39,0xf2,0xf0,0xa3,0xa4,0x8d,
	0xef,0x05,0x9e,0xb8,0xc7,0x52,0xe4,0x0e,0x42,0xaa,0x7c,0x79,
	0xc2,0xd6,0xfd,0xa5
	};


/* P-256 SHA-1 PR  */
__fips_constseg
static const unsigned char p_256_sha1_pr_entropyinput[] =
	{
	0xb7,0xd4,0x38,0x90,0x9a,0xa8,0xfc,0xb6,0xd6,0x3c,0xc5,0x35,
	0x2b,0x0b,0x0e,0x1f
	};

__fips_constseg
static const unsigned char p_256_sha1_pr_nonce[] =
	{
	0xd9,0xae,0xf5,0xe8,0xd5,0x10,0x1f,0x82
	};

__fips_constseg
static const unsigned char p_256_sha1_pr_personalizationstring[] =
	{
	0x88,0xe8,0x77,0xab,0x01,0x19,0x5e,0xaf,0x50,0x6c,0x89,0x2d,
	0x0c,0x12,0xe2,0x11
	};

__fips_constseg
static const unsigned char p_256_sha1_pr_additionalinput[] =
	{
	0xd1,0x46,0xa6,0xb0,0x6e,0xc5,0xaa,0x7b,0x6d,0x1a,0xf9,0x36,
	0x8c,0x95,0x9c,0xed
	};

__fips_constseg
static const unsigned char p_256_sha1_pr_entropyinputpr[] =
	{
	0xb0,0x97,0xa8,0x3e,0xd3,0x28,0x3d,0x36,0xdd,0xfe,0x89,0x00,
	0x63,0x4f,0x21,0xfc
	};

__fips_constseg
static const unsigned char p_256_sha1_pr_int_returnedbits[] =
	{
	0x9f,0x66,0x6a,0x38,0x57,0x49,0x15,0xcd,0x5a,0x85,0x03,0x97,
	0x67,0xc3,0x62,0x46,0xb7,0x3a,0xd2,0x08,0x86,0x40,0x4e,0x6d,
	0x67,0xf4,0x19,0x68,0x92,0x63
	};

__fips_constseg
static const unsigned char p_256_sha1_pr_additionalinput2[] =
	{
	0x0c,0xb6,0x1c,0xc7,0x52,0x47,0xe4,0xf1,0xa7,0x75,0x60,0x3d,
	0x60,0x07,0x72,0x6f
	};

__fips_constseg
static const unsigned char p_256_sha1_pr_entropyinputpr2[] =
	{
	0x39,0x37,0xb6,0x55,0x82,0x71,0x0e,0xd4,0x8f,0x8c,0x10,0xe5,
	0x7c,0x8f,0x5e,0x37
	};

__fips_constseg
static const unsigned char p_256_sha1_pr_returnedbits[] =
	{
	0x37,0x6c,0x94,0x02,0xbe,0x28,0x42,0xd5,0xe7,0x4d,0x1a,0x6e,
	0xa8,0x5a,0x90,0x9a,0x31,0xa8,0x84,0x16,0xbc,0xe9,0x18,0xa4,
	0xe1,0xa1,0x05,0xf0,0x2a,0xe3
	};


/* P-256 SHA-1 No PR  */
__fips_constseg
static const unsigned char p_256_sha1_entropyinput[] =
	{
	0xac,0x08,0x45,0x86,0x79,0xfc,0x4b,0xb4,0x8b,0xe4,0xfd,0x1d,
	0x0e,0xeb,0x1b,0x8f
	};

__fips_constseg
static const unsigned char p_256_sha1_nonce[] =
	{
	0x5e,0xf4,0xe9,0xc5,0x04,0xee,0xb7,0x8a
	};

__fips_constseg
static const unsigned char p_256_sha1_personalizationstring[] =
	{
	0x55,0x0f,0xca,0x3b,0x1c,0xa6,0xf3,0xce,0xcb,0x6f,0xa7,0xc7,
	0x26,0x65,0x0f,0x7c
	};

__fips_constseg
static const unsigned char p_256_sha1_additionalinput[] =
	{
	0x74,0x51,0x73,0xa9,0xee,0x2e,0x21,0xf9,0xba,0x07,0xe4,0xad,
	0x97,0xae,0x1c,0x8b
	};

__fips_constseg
static const unsigned char p_256_sha1_int_returnedbits[] =
	{
	0x8d,0x45,0x11,0xa9,0x74,0x14,0x05,0x94,0x97,0x66,0x71,0xe2,
	0x9b,0x61,0x22,0x85,0xa5,0xaa,0x09,0x01,0x75,0xb5,0xab,0x3a,
	0x3a,0x6e,0x69,0xd3,0xc8,0xc4
	};

__fips_constseg
static const unsigned char p_256_sha1_entropyinputreseed[] =
	{
	0x34,0xd9,0x8b,0x67,0x82,0xaf,0x97,0x95,0xe9,0x25,0xa7,0x93,
	0x37,0x06,0x73,0x5c
	};

__fips_constseg
static const unsigned char p_256_sha1_additionalinputreseed[] =
	{
	0x39,0x21,0x24,0x27,0x67,0xa1,0xc3,0xc4,0x90,0xc2,0x68,0x68,
	0x26,0x9b,0x32,0xc2
	};

__fips_constseg
static const unsigned char p_256_sha1_additionalinput2[] =
	{
	0x84,0xa8,0x10,0xe5,0x71,0x0c,0x1e,0x74,0x42,0x6a,0xa5,0x09,
	0x90,0x74,0x39,0xd7
	};

__fips_constseg
static const unsigned char p_256_sha1_returnedbits[] =
	{
	0x1e,0x0b,0x5c,0x41,0xcd,0xab,0x07,0xbd,0xdc,0x53,0xa7,0x62,
	0xd1,0xd0,0xca,0x19,0xe6,0xbb,0x8e,0xcf,0x1e,0x0a,0x4c,0xc0,
	0x2d,0x8c,0xe2,0xa4,0x89,0x2c
	};


/* P-256 SHA-224 PR  */
__fips_constseg
static const unsigned char p_256_sha224_pr_entropyinput[] =
	{
	0x92,0x05,0xf0,0x1e,0xc4,0xc4,0x9e,0xab,0x85,0x10,0x16,0xda,
	0xa6,0xb4,0xba,0x6f
	};

__fips_constseg
static const unsigned char p_256_sha224_pr_nonce[] =
	{
	0xa3,0x5e,0xde,0x12,0xdc,0xa7,0x67,0xfd
	};

__fips_constseg
static const unsigned char p_256_sha224_pr_personalizationstring[] =
	{
	0x76,0xa0,0x8d,0x6c,0x0d,0x19,0x5d,0x94,0x9b,0x92,0x67,0x78,
	0x6c,0x02,0xfe,0xe4
	};

__fips_constseg
static const unsigned char p_256_sha224_pr_additionalinput[] =
	{
	0xe2,0x05,0xcf,0x63,0x0f,0xf1,0xd0,0x41,0xc9,0xe3,0xf6,0xb0,
	0x57,0xaa,0xcd,0x92
	};

__fips_constseg
static const unsigned char p_256_sha224_pr_entropyinputpr[] =
	{
	0x1a,0xd5,0xa9,0x25,0x52,0xa8,0xba,0x51,0x81,0x99,0x62,0x4d,
	0xbf,0x30,0x44,0xf3
	};

__fips_constseg
static const unsigned char p_256_sha224_pr_int_returnedbits[] =
	{
	0xbf,0x9e,0x45,0x73,0x67,0x4b,0x25,0xa5,0x58,0x23,0x31,0xd8,
	0x0f,0xf3,0xe5,0x5d,0x0e,0x2d,0x9b,0x4a,0x5f,0x93,0x9c,0xad,
	0x6a,0xc5,0x70,0x4e,0x5e,0x58
	};

__fips_constseg
static const unsigned char p_256_sha224_pr_additionalinput2[] =
	{
	0x4a,0x85,0x19,0xb2,0x61,0x5d,0xd5,0xc0,0x1f,0x47,0x72,0x8b,
	0x62,0x35,0x19,0xc1
	};

__fips_constseg
static const unsigned char p_256_sha224_pr_entropyinputpr2[] =
	{
	0xda,0xa7,0x84,0x3f,0xfa,0xf9,0xd1,0x51,0x17,0xf8,0xe3,0x77,
	0xf5,0x20,0x37,0x17
	};

__fips_constseg
static const unsigned char p_256_sha224_pr_returnedbits[] =
	{
	0x15,0xa4,0xa1,0x53,0x4f,0x63,0x06,0xfe,0x28,0xfd,0x58,0xa9,
	0xac,0x9c,0x83,0xb7,0x3a,0x86,0x82,0x92,0x96,0x89,0xea,0x3d,
	0xbd,0x83,0x3a,0x06,0x2a,0x7d
	};


/* P-256 SHA-224 No PR  */
__fips_constseg
static const unsigned char p_256_sha224_entropyinput[] =
	{
	0xec,0x5b,0x46,0x4a,0xe1,0xe1,0xcb,0x31,0x86,0xa7,0x11,0x3a,
	0xff,0x87,0x4a,0x66
	};

__fips_constseg
static const unsigned char p_256_sha224_nonce[] =
	{
	0xd1,0x6c,0x33,0x3c,0x37,0xc9,0xc6,0xac
	};

__fips_constseg
static const unsigned char p_256_sha224_personalizationstring[] =
	{
	0x8b,0xfe,0x68,0x96,0x2d,0xc5,0x91,0xb3,0xf2,0xaa,0x15,0xad,
	0x1a,0x50,0x0c,0x0a
	};

__fips_constseg
static const unsigned char p_256_sha224_additionalinput[] =
	{
	0xd4,0x48,0xfd,0x16,0x41,0xea,0xef,0x06,0x7f,0x4a,0xa2,0x60,
	0x60,0x31,0x20,0x5d
	};

__fips_constseg
static const unsigned char p_256_sha224_int_returnedbits[] =
	{
	0x68,0x64,0x67,0x0c,0x73,0x08,0x00,0x60,0x5a,0xa6,0x9a,0x27,
	0x01,0x81,0xae,0x2e,0x1d,0xa6,0x0a,0x86,0x77,0xef,0x05,0x3f,
	0x42,0xbe,0x46,0x73,0x40,0x1c
	};

__fips_constseg
static const unsigned char p_256_sha224_entropyinputreseed[] =
	{
	0x9c,0xde,0x86,0x11,0x55,0x9a,0xb4,0x2b,0x70,0xf0,0xc6,0x9d,
	0x8d,0x3a,0xc3,0x1e
	};

__fips_constseg
static const unsigned char p_256_sha224_additionalinputreseed[] =
	{
	0x5d,0x5b,0xeb,0x38,0xc5,0x8b,0x2b,0xc8,0x73,0xe3,0x0e,0xca,
	0x35,0xb0,0x4d,0x11
	};

__fips_constseg
static const unsigned char p_256_sha224_additionalinput2[] =
	{
	0xf7,0xa3,0x79,0x4b,0xb0,0x2c,0x1e,0xc6,0x61,0x69,0x14,0x6a,
	0xed,0xf1,0xa2,0xd8
	};

__fips_constseg
static const unsigned char p_256_sha224_returnedbits[] =
	{
	0x89,0x75,0x1b,0x89,0x20,0xcc,0xe2,0xaf,0xae,0x5e,0xc1,0xa9,
	0xde,0xc0,0x35,0x0b,0xf6,0x4e,0x04,0xfc,0xa7,0xe6,0x35,0xf9,
	0x16,0x8a,0xc6,0x0c,0x63,0x6b
	};


/* P-256 SHA-256 PR  */
__fips_constseg
static const unsigned char p_256_sha256_pr_entropyinput[] =
	{
	0x22,0xe4,0x4c,0x01,0x94,0x59,0xce,0x08,0xb3,0x92,0x48,0xe2,
	0x0d,0x1a,0x32,0x4d
	};

__fips_constseg
static const unsigned char p_256_sha256_pr_nonce[] =
	{
	0x8d,0xf9,0x20,0x8a,0x65,0xf4,0x93,0x37
	};

__fips_constseg
static const unsigned char p_256_sha256_pr_personalizationstring[] =
	{
	0x06,0x7e,0xe8,0x4f,0xdd,0xae,0x8d,0xf1,0xc9,0x13,0x9a,0x81,
	0xd3,0x68,0x76,0xc1
	};

__fips_constseg
static const unsigned char p_256_sha256_pr_additionalinput[] =
	{
	0xfa,0x8e,0xea,0xf3,0xcf,0xda,0x7c,0x11,0x88,0xaa,0xb9,0x02,
	0x84,0xc4,0x30,0x54
	};

__fips_constseg
static const unsigned char p_256_sha256_pr_entropyinputpr[] =
	{
	0xbb,0x21,0x72,0x4f,0x83,0x03,0x14,0x18,0x8e,0x88,0xec,0x73,
	0xde,0xed,0x60,0xf7
	};

__fips_constseg
static const unsigned char p_256_sha256_pr_int_returnedbits[] =
	{
	0xdc,0x40,0x73,0x5e,0x1d,0x21,0x35,0x8c,0xcf,0xa4,0x50,0x05,
	0x5e,0x73,0xbd,0xde,0x5e,0x58,0xcc,0xc0,0x6f,0xd9,0xca,0x8d,
	0x48,0x9d,0x84,0x77,0xc2,0x8e
	};

__fips_constseg
static const unsigned char p_256_sha256_pr_additionalinput2[] =
	{
	0x0e,0xa7,0x4d,0x4f,0x19,0x94,0x34,0x05,0x46,0x3e,0x0c,0x05,
	0x27,0x85,0xd9,0xdf
	};

__fips_constseg
static const unsigned char p_256_sha256_pr_entropyinputpr2[] =
	{
	0x4f,0xae,0x44,0x10,0x2b,0xa1,0xbc,0xd7,0xcb,0xa7,0x49,0x55,
	0x27,0x54,0x36,0x2b
	};

__fips_constseg
static const unsigned char p_256_sha256_pr_returnedbits[] =
	{
	0x1c,0x16,0xf7,0x2b,0xd0,0xb7,0x54,0x5a,0xa5,0x85,0x14,0x63,
	0xd4,0x96,0x81,0x5a,0x6b,0xa4,0xde,0x57,0xbf,0xf3,0x81,0xc7,
	0xf5,0xbc,0xeb,0x4e,0x49,0xdf
	};


/* P-256 SHA-256 No PR  */
__fips_constseg
static const unsigned char p_256_sha256_entropyinput[] =
	{
	0xa7,0x0b,0x6b,0xf7,0xfb,0x40,0x1a,0xca,0xa9,0x1f,0x16,0xc9,
	0x6a,0xd0,0x4a,0x8c
	};

__fips_constseg
static const unsigned char p_256_sha256_nonce[] =
	{
	0x97,0x8e,0xb1,0x72,0xe8,0x30,0xfc,0x43
	};

__fips_constseg
static const unsigned char p_256_sha256_personalizationstring[] =
	{
	0x6c,0x90,0x00,0x41,0x84,0x7c,0x58,0x56,0x48,0xf0,0x60,0x04,
	0xe9,0xc0,0xa0,0xd8
	};

__fips_constseg
static const unsigned char p_256_sha256_additionalinput[] =
	{
	0x69,0xad,0xd7,0x7c,0xbd,0x90,0xa1,0x63,0xcd,0x64,0x7c,0xb3,
	0xce,0xff,0xf2,0xf7
	};

__fips_constseg
static const unsigned char p_256_sha256_int_returnedbits[] =
	{
	0xe8,0x5a,0x4f,0x5d,0xab,0xc7,0xd2,0x94,0x4d,0xbf,0x02,0x57,
	0xa1,0x89,0x73,0xa1,0xc2,0xca,0xfb,0x46,0x11,0x41,0x47,0x8e,
	0x32,0x45,0xd7,0x8a,0x8a,0x38
	};

__fips_constseg
static const unsigned char p_256_sha256_entropyinputreseed[] =
	{
	0x5c,0xb4,0x82,0x38,0xa2,0x2d,0x78,0x63,0x2a,0x38,0x77,0x5b,
	0x9a,0x59,0x4d,0x17
	};

__fips_constseg
static const unsigned char p_256_sha256_additionalinputreseed[] =
	{
	0x43,0x28,0x7f,0x91,0x92,0xad,0x88,0x75,0x64,0xe5,0xef,0x95,
	0x59,0xa9,0x11,0x61
	};

__fips_constseg
static const unsigned char p_256_sha256_additionalinput2[] =
	{
	0x77,0xee,0xfc,0x84,0x5b,0x69,0xdf,0x9f,0x7e,0xf2,0xb1,0x35,
	0x34,0x28,0x8f,0xcd
	};

__fips_constseg
static const unsigned char p_256_sha256_returnedbits[] =
	{
	0x2d,0x45,0x00,0x60,0x87,0x6c,0xfa,0x69,0x06,0x9e,0x99,0xf9,
	0xf6,0xb6,0x1e,0xf6,0xfb,0x6b,0x54,0x68,0x1a,0xd3,0xda,0x31,
	0x3e,0x60,0x4a,0x31,0x7d,0x41
	};


/* P-256 SHA-384 PR  */
__fips_constseg
static const unsigned char p_256_sha384_pr_entropyinput[] =
	{
	0xb3,0x6a,0x1b,0x68,0xe3,0x8a,0xa4,0xad,0x2d,0xa0,0x6a,0xae,
	0x10,0xe5,0x55,0x58
	};

__fips_constseg
static const unsigned char p_256_sha384_pr_nonce[] =
	{
	0xe2,0xe8,0xd4,0x8d,0xc8,0x47,0xad,0x79
	};

__fips_constseg
static const unsigned char p_256_sha384_pr_personalizationstring[] =
	{
	0xf9,0xbb,0xac,0xe9,0xd9,0x8a,0x58,0xae,0x58,0xa6,0x68,0xd2,
	0xff,0x49,0x71,0x08
	};

__fips_constseg
static const unsigned char p_256_sha384_pr_additionalinput[] =
	{
	0xa7,0xa3,0xcc,0xc1,0xbf,0xa7,0x32,0xe8,0xcb,0x21,0xf4,0x35,
	0x42,0xa6,0xdd,0x4b
	};

__fips_constseg
static const unsigned char p_256_sha384_pr_entropyinputpr[] =
	{
	0x37,0xdb,0x5a,0x83,0x9c,0x7a,0x50,0xe3,0xc7,0xbd,0x50,0x63,
	0x88,0x44,0xa1,0x50
	};

__fips_constseg
static const unsigned char p_256_sha384_pr_int_returnedbits[] =
	{
	0x65,0x3a,0xdd,0x95,0x3a,0x52,0xd7,0x7f,0x8d,0x81,0x1b,0x53,
	0x4e,0xa9,0x5b,0x80,0xa2,0x08,0x1e,0xf5,0x7f,0xac,0x62,0x28,
	0xbc,0x1c,0x02,0xd2,0xe9,0x1e
	};

__fips_constseg
static const unsigned char p_256_sha384_pr_additionalinput2[] =
	{
	0xb3,0xff,0xbc,0x54,0x38,0x49,0x1f,0xad,0x3f,0x33,0x5f,0x45,
	0x21,0x2f,0xcf,0xba
	};

__fips_constseg
static const unsigned char p_256_sha384_pr_entropyinputpr2[] =
	{
	0x43,0x37,0x4a,0x16,0x15,0x1d,0x3d,0xa9,0x3b,0xcf,0xbb,0x73,
	0x67,0xce,0x93,0xbf
	};

__fips_constseg
static const unsigned char p_256_sha384_pr_returnedbits[] =
	{
	0x1e,0x1b,0x69,0x67,0xb8,0xd7,0xb4,0x18,0xb8,0xa0,0x11,0xc7,
	0x5f,0xd7,0x14,0xb7,0x24,0xae,0xa5,0x35,0x06,0xa0,0xd0,0x7f,
	0xcd,0x9b,0x20,0x03,0x66,0xc0
	};


/* P-256 SHA-384 No PR  */
__fips_constseg
static const unsigned char p_256_sha384_entropyinput[] =
	{
	0x1c,0x0d,0xa7,0x27,0x1f,0xb4,0xa2,0x4a,0xe5,0x25,0x00,0xbe,
	0xbe,0x80,0x88,0xa8
	};

__fips_constseg
static const unsigned char p_256_sha384_nonce[] =
	{
	0x2c,0x7e,0x21,0x02,0x46,0x9e,0xe5,0xae
	};

__fips_constseg
static const unsigned char p_256_sha384_personalizationstring[] =
	{
	0x0a,0xf6,0x83,0xa9,0x7b,0x97,0x20,0x60,0xcc,0x46,0x0e,0x52,
	0xd0,0xcb,0x57,0xb5
	};

__fips_constseg
static const unsigned char p_256_sha384_additionalinput[] =
	{
	0xac,0xd8,0x25,0xef,0x85,0xa8,0x5e,0x55,0x89,0x5b,0x6e,0xf6,
	0x4d,0x4d,0x05,0x53
	};

__fips_constseg
static const unsigned char p_256_sha384_int_returnedbits[] =
	{
	0x5c,0x71,0x32,0x2f,0x34,0x09,0x99,0x6a,0x4e,0x55,0xaf,0x4b,
	0x73,0x32,0xb5,0xad,0x52,0x4c,0x54,0xa0,0x25,0x3b,0xd9,0x70,
	0xe5,0xe4,0x6f,0x61,0xab,0x8c
	};

__fips_constseg
static const unsigned char p_256_sha384_entropyinputreseed[] =
	{
	0x4b,0x0d,0xa9,0x66,0xc3,0x64,0xe9,0xd5,0x87,0xb1,0x98,0xc2,
	0xeb,0x14,0xd2,0x8a
	};

__fips_constseg
static const unsigned char p_256_sha384_additionalinputreseed[] =
	{
	0x1f,0x11,0x6b,0xc0,0x15,0x38,0xbd,0x62,0x27,0xf7,0x6d,0x97,
	0x77,0xd1,0xcc,0x00
	};

__fips_constseg
static const unsigned char p_256_sha384_additionalinput2[] =
	{
	0x1d,0x9a,0xe5,0xfc,0xed,0x93,0x3d,0xbb,0x08,0xf3,0xba,0x01,
	0x6f,0x9f,0xdf,0xb1
	};

__fips_constseg
static const unsigned char p_256_sha384_returnedbits[] =
	{
	0x4a,0xd5,0xd3,0x62,0xbb,0x6e,0x6c,0xb2,0x1c,0x0e,0xf6,0x97,
	0xd3,0x15,0x18,0xb5,0x42,0x59,0xc4,0xf6,0xa9,0x8f,0x1b,0xff,
	0xaa,0xf8,0xf9,0x9c,0xba,0x47
	};


/* P-256 SHA-512 PR  */
__fips_constseg
static const unsigned char p_256_sha512_pr_entropyinput[] =
	{
	0x73,0x83,0x07,0x93,0x85,0x39,0x2f,0x96,0xcd,0x74,0x32,0x4d,
	0x68,0x0e,0x97,0x9d
	};

__fips_constseg
static const unsigned char p_256_sha512_pr_nonce[] =
	{
	0xab,0xc6,0xf4,0x38,0x72,0x9b,0x9f,0x36
	};

__fips_constseg
static const unsigned char p_256_sha512_pr_personalizationstring[] =
	{
	0x88,0x8e,0xc1,0xaf,0xe9,0x1b,0x8a,0xf5,0xf2,0x23,0x44,0x71,
	0xf5,0x9a,0xed,0x5e
	};

__fips_constseg
static const unsigned char p_256_sha512_pr_additionalinput[] =
	{
	0x38,0xf7,0x2b,0x11,0x7b,0xd6,0xfa,0xbd,0x07,0x42,0x46,0x77,
	0xed,0x1b,0x3f,0x95
	};

__fips_constseg
static const unsigned char p_256_sha512_pr_entropyinputpr[] =
	{
	0x52,0xf2,0x68,0x6d,0xc9,0x1b,0xc7,0xb0,0x52,0x07,0x69,0x79,
	0x25,0x5d,0xbb,0xdb
	};

__fips_constseg
static const unsigned char p_256_sha512_pr_int_returnedbits[] =
	{
	0x23,0xa6,0x84,0x48,0x4f,0xd3,0x1f,0x56,0x57,0xae,0x50,0xea,
	0x9f,0x2b,0x47,0x80,0x6a,0x46,0x10,0x54,0x1d,0x77,0x67,0x79,
	0x45,0xbb,0x1d,0x90,0x2c,0xce
	};

__fips_constseg
static const unsigned char p_256_sha512_pr_additionalinput2[] =
	{
	0x9c,0x46,0x61,0x85,0x2c,0x9e,0x2c,0xd0,0x4d,0xcd,0x73,0x78,
	0x08,0x8d,0x49,0x5b
	};

__fips_constseg
static const unsigned char p_256_sha512_pr_entropyinputpr2[] =
	{
	0x71,0x60,0x46,0x14,0xc1,0xaa,0x21,0xc8,0xf1,0xfe,0x32,0x90,
	0x46,0xfd,0xe9,0x80
	};

__fips_constseg
static const unsigned char p_256_sha512_pr_returnedbits[] =
	{
	0x7a,0x30,0x7d,0x6e,0xb1,0x22,0xb9,0x68,0x7d,0x00,0x14,0x63,
	0xca,0xe2,0x06,0x03,0xe0,0x94,0xbb,0x45,0x14,0x2d,0xd2,0xd1,
	0xfb,0x35,0xfd,0xe6,0xf1,0x81
	};


/* P-256 SHA-512 No PR  */
__fips_constseg
static const unsigned char p_256_sha512_entropyinput[] =
	{
	0x55,0xd0,0x7f,0xb7,0x23,0x81,0x95,0x38,0xa7,0xbf,0x01,0x8d,
	0x06,0x8b,0xbc,0x47
	};

__fips_constseg
static const unsigned char p_256_sha512_nonce[] =
	{
	0x96,0xab,0x85,0xba,0x88,0x7b,0xf5,0x6e
	};

__fips_constseg
static const unsigned char p_256_sha512_personalizationstring[] =
	{
	0xea,0x25,0x60,0xd0,0x5d,0xd8,0x9c,0x8d,0x43,0x23,0x49,0x0a,
	0xd5,0x57,0xf3,0x54
	};

__fips_constseg
static const unsigned char p_256_sha512_additionalinput[] =
	{
	0x8e,0xe8,0xfd,0x2e,0xcd,0x27,0xc6,0x7e,0x7a,0xf8,0xe7,0x11,
	0xb8,0x0d,0x20,0x36
	};

__fips_constseg
static const unsigned char p_256_sha512_int_returnedbits[] =
	{
	0x57,0x18,0x20,0x51,0xd7,0x57,0x13,0xb0,0xa0,0x8f,0x92,0xd2,
	0xf5,0xa0,0x85,0xf3,0xac,0x64,0xb7,0x6b,0x94,0xde,0x9f,0xda,
	0x0a,0x04,0x11,0xdf,0x52,0x27
	};

__fips_constseg
static const unsigned char p_256_sha512_entropyinputreseed[] =
	{
	0x89,0x1d,0x17,0x0c,0xe4,0x82,0x34,0xe7,0x81,0x6c,0x47,0x47,
	0xc6,0x49,0x50,0x3e
	};

__fips_constseg
static const unsigned char p_256_sha512_additionalinputreseed[] =
	{
	0xe7,0xe4,0x88,0x00,0xa7,0xc9,0xb7,0x6b,0x70,0xda,0xe3,0xf0,
	0x44,0xa9,0x02,0xf6
	};

__fips_constseg
static const unsigned char p_256_sha512_additionalinput2[] =
	{
	0x09,0x9f,0xd2,0xe8,0xb2,0x0e,0x6e,0x89,0xf5,0x73,0x1c,0x1f,
	0x93,0xf2,0x76,0xb2
	};

__fips_constseg
static const unsigned char p_256_sha512_returnedbits[] =
	{
	0xdd,0x42,0x2a,0x7b,0x4f,0x84,0x07,0xfa,0x4d,0x17,0x9a,0x2e,
	0x48,0xba,0xbf,0xc5,0x1c,0x42,0xc7,0xc3,0x63,0x4f,0x79,0xb0,
	0xc1,0x54,0x1d,0xa6,0x0a,0x1c
	};


/* P-384 SHA-224 PR  */
__fips_constseg
static const unsigned char p_384_sha224_pr_entropyinput[] =
	{
	0x34,0xf0,0x89,0xac,0x46,0x33,0xe2,0x7f,0x8c,0x02,0x65,0x09,
	0xe1,0xcf,0x93,0x5b,0x10,0xbc,0xb0,0x43,0x4f,0xc7,0x62,0x19
	};

__fips_constseg
static const unsigned char p_384_sha224_pr_nonce[] =
	{
	0x55,0x30,0xdf,0xa9,0xfb,0xbe,0x4a,0x2e,0x1d,0x03,0xf5,0x91
	};

__fips_constseg
static const unsigned char p_384_sha224_pr_personalizationstring[] =
	{
	0x35,0xc7,0x3a,0x7b,0x5a,0x4e,0xd4,0x1a,0x82,0xe2,0xf5,0xed,
	0x40,0x61,0x4b,0xf4,0xb9,0xcf,0xd0,0xc1,0xe2,0x41,0x23,0x04
	};

__fips_constseg
static const unsigned char p_384_sha224_pr_additionalinput[] =
	{
	0xec,0xef,0x64,0xfb,0x92,0xbb,0xdf,0x8b,0xc8,0xf2,0xad,0xd8,
	0x93,0x21,0x6f,0x11,0xde,0x37,0x52,0xe3,0x16,0x49,0xc7,0xe1
	};

__fips_constseg
static const unsigned char p_384_sha224_pr_entropyinputpr[] =
	{
	0x59,0xb0,0x7e,0x34,0x49,0x29,0x7e,0x91,0x92,0x91,0x0c,0xca,
	0x8e,0x31,0x62,0x06,0xab,0xf4,0x81,0x80,0xa4,0x55,0x8f,0x0f
	};

__fips_constseg
static const unsigned char p_384_sha224_pr_int_returnedbits[] =
	{
	0x29,0xd9,0x3a,0x95,0xb1,0x34,0xff,0x73,0x06,0x1e,0x08,0x43,
	0xd7,0x1d,0x53,0xd1,0xcf,0x09,0xd2,0x83,0x04,0x44,0x29,0x9d,
	0x0d,0x18,0x76,0x94,0xa8,0x98,0xb4,0xc1,0xb0,0x31,0xbc,0xe6,
	0xf0,0xc7,0x57,0x35,0x5d,0x32,0x78,0x9e,0x1d,0x2a
	};

__fips_constseg
static const unsigned char p_384_sha224_pr_additionalinput2[] =
	{
	0x56,0x8c,0x6f,0x29,0xd6,0x25,0x9f,0xb8,0x6a,0x1d,0x70,0x5f,
	0x6a,0xe7,0xe2,0x2e,0xcc,0x6b,0x78,0x0a,0x3f,0x54,0x73,0x97
	};

__fips_constseg
static const unsigned char p_384_sha224_pr_entropyinputpr2[] =
	{
	0xe3,0x91,0x20,0x13,0x78,0xc6,0x01,0xfd,0x82,0xd7,0x43,0x1e,
	0xed,0x85,0x4a,0xe2,0x0c,0x6f,0xdc,0x43,0x5f,0x7c,0xfd,0xd0
	};

__fips_constseg
static const unsigned char p_384_sha224_pr_returnedbits[] =
	{
	0x89,0xa9,0x17,0xd8,0xcb,0x73,0x17,0x69,0x78,0x69,0x50,0x58,
	0x74,0xe4,0x8c,0x6f,0x5c,0xfa,0x6e,0x01,0xb3,0xf0,0xce,0xa9,
	0xd0,0xc0,0x40,0xb3,0x20,0x78,0xe2,0xdb,0xec,0x1f,0x73,0xea,
	0x2e,0xa6,0xf1,0xc8,0xfe,0x7c,0xe7,0x68,0xf7,0x86
	};


/* P-384 SHA-224 No PR  */
__fips_constseg
static const unsigned char p_384_sha224_entropyinput[] =
	{
	0x44,0x2c,0xc3,0xc6,0x20,0xe6,0x61,0xec,0xd1,0x2b,0xdf,0x18,
	0x2e,0xc5,0x4a,0xd4,0x80,0x55,0xbd,0x54,0x89,0x01,0x7b,0xbb
	};

__fips_constseg
static const unsigned char p_384_sha224_nonce[] =
	{
	0x16,0x27,0x4b,0xb3,0x0f,0x01,0xd0,0xe6,0x9f,0x5c,0x44,0xa4
	};

__fips_constseg
static const unsigned char p_384_sha224_personalizationstring[] =
	{
	0x55,0x26,0x3e,0xee,0xaa,0x1b,0x35,0x27,0xef,0x18,0x28,0x62,
	0x51,0x1e,0xbc,0x4c,0x64,0x0d,0xf8,0x20,0xe6,0x0a,0x1d,0xaa
	};

__fips_constseg
static const unsigned char p_384_sha224_additionalinput[] =
	{
	0x27,0x08,0x22,0x32,0x4a,0xd6,0xc6,0x51,0xff,0xc5,0xb7,0x8f,
	0xb4,0x3e,0xa0,0x6e,0xe2,0x55,0xa1,0xf1,0x2e,0x0d,0x89,0x91
	};

__fips_constseg
static const unsigned char p_384_sha224_int_returnedbits[] =
	{
	0x85,0x0e,0xe3,0xde,0xed,0x40,0xdc,0xec,0x9a,0x2d,0x65,0x24,
	0x2b,0x56,0xd6,0xce,0x7c,0x40,0x07,0xe5,0x61,0x64,0xe5,0xac,
	0x6e,0x48,0xa3,0xda,0x7d,0x4c,0xd6,0x7d,0xd0,0x69,0xa8,0x93,
	0xa7,0xb1,0x91,0xba,0x0d,0x81,0x8f,0x04,0xaf,0x91
	};

__fips_constseg
static const unsigned char p_384_sha224_entropyinputreseed[] =
	{
	0x27,0x57,0xc2,0x22,0xa6,0x70,0xb9,0x74,0x86,0x59,0x8c,0xff,
	0x7d,0x10,0x0c,0xe3,0x24,0xf1,0x95,0xbd,0x99,0x84,0xca,0x11
	};

__fips_constseg
static const unsigned char p_384_sha224_additionalinputreseed[] =
	{
	0x5a,0xc3,0x47,0x2c,0x9c,0x1d,0xe0,0x43,0x3b,0x1b,0x01,0xed,
	0x86,0x5d,0x1b,0x3f,0x45,0xb1,0x8e,0xa9,0x79,0x7b,0x88,0x01
	};

__fips_constseg
static const unsigned char p_384_sha224_additionalinput2[] =
	{
	0x7d,0x48,0x91,0xda,0x00,0x60,0x33,0x2c,0x22,0xe4,0x42,0x61,
	0xbc,0x70,0x05,0x73,0x22,0x23,0x42,0xda,0x7a,0x2b,0xba,0xbb
	};

__fips_constseg
static const unsigned char p_384_sha224_returnedbits[] =
	{
	0xfa,0x7d,0x7b,0x35,0x32,0xbe,0x44,0x91,0x90,0xd2,0x69,0x9a,
	0x06,0xb8,0x52,0x3e,0x3b,0xcf,0x1e,0x81,0xd3,0x20,0x5f,0x5b,
	0x55,0xb6,0xb3,0xc9,0x6b,0xc7,0x0c,0xf1,0xa7,0xbd,0x4a,0x83,
	0x25,0x50,0xc3,0x78,0x3f,0x4e,0xe9,0xed,0x6c,0x4c
	};


/* P-384 SHA-256 PR  */
__fips_constseg
static const unsigned char p_384_sha256_pr_entropyinput[] =
	{
	0xc6,0xd0,0xc7,0xa3,0x7e,0x2b,0x8c,0xd6,0x23,0xe9,0x9e,0x1f,
	0x77,0x30,0xed,0x6a,0xfc,0xe4,0x7b,0xf0,0x6f,0xd6,0xfe,0x05
	};

__fips_constseg
static const unsigned char p_384_sha256_pr_nonce[] =
	{
	0x67,0x91,0xca,0x93,0xc8,0x1e,0x93,0x13,0x00,0x72,0x4e,0xa2
	};

__fips_constseg
static const unsigned char p_384_sha256_pr_personalizationstring[] =
	{
	0xa5,0x5b,0x6e,0xeb,0xc9,0x0d,0x42,0x0b,0x41,0xec,0x0b,0x9e,
	0xde,0xc1,0x80,0x4d,0xe3,0x86,0xa0,0xfe,0x7e,0x92,0x47,0xa3
	};

__fips_constseg
static const unsigned char p_384_sha256_pr_additionalinput[] =
	{
	0x9a,0x04,0xa9,0x78,0x48,0xa8,0x77,0x0f,0x38,0x2a,0x54,0x66,
	0x34,0xaa,0x31,0xbd,0xf6,0xfb,0xc1,0x14,0xa5,0xcb,0x1c,0xf2
	};

__fips_constseg
static const unsigned char p_384_sha256_pr_entropyinputpr[] =
	{
	0x19,0x6c,0x48,0xf5,0x64,0xb3,0xb4,0x49,0x6e,0xb8,0xc4,0x8b,
	0xab,0xba,0xb5,0x8e,0xa3,0xf1,0x6e,0xe9,0xf6,0x37,0xa1,0x46
	};

__fips_constseg
static const unsigned char p_384_sha256_pr_int_returnedbits[] =
	{
	0xfd,0x04,0x26,0x4f,0xbd,0x84,0xe3,0x54,0xb2,0x9b,0xb1,0x84,
	0x66,0x5f,0x02,0xc0,0xcc,0x69,0x7e,0x4d,0x4f,0xc4,0x00,0x8e,
	0x13,0x5d,0xe9,0x0f,0x98,0x71,0xe8,0x7f,0x50,0xd1,0x49,0xc8,
	0xae,0x71,0xe9,0x60,0x94,0x90,0xce,0x6d,0xba,0xab
	};

__fips_constseg
static const unsigned char p_384_sha256_pr_additionalinput2[] =
	{
	0x4d,0x27,0x90,0x17,0x81,0x74,0x4f,0xa4,0x40,0xdf,0x42,0x29,
	0xc5,0x37,0xf1,0x31,0x89,0x90,0x27,0x8a,0x96,0xcc,0x68,0x6e
	};

__fips_constseg
static const unsigned char p_384_sha256_pr_entropyinputpr2[] =
	{
	0x1d,0xbe,0xdf,0x39,0xd8,0x82,0xb2,0x8f,0x7f,0x90,0xac,0x19,
	0xc8,0x65,0xf2,0x5a,0xff,0x4e,0xbb,0xcf,0xcd,0xce,0x2c,0xfd
	};

__fips_constseg
static const unsigned char p_384_sha256_pr_returnedbits[] =
	{
	0x45,0x63,0xac,0xb5,0x1e,0x49,0x99,0x67,0x89,0xd4,0x9c,0xa9,
	0xf8,0x5a,0x05,0x0d,0xeb,0xe6,0xc7,0x78,0x8e,0xf1,0xec,0xe3,
	0xc8,0x52,0xf1,0xfa,0x0f,0xd0,0xd7,0xbe,0x8a,0x34,0x0a,0x1f,
	0x38,0x42,0xc6,0xac,0x61,0xd4,0x32,0xc5,0xd2,0x15
	};


/* P-384 SHA-256 No PR  */
__fips_constseg
static const unsigned char p_384_sha256_entropyinput[] =
	{
	0x52,0x92,0xc4,0xac,0xce,0xf5,0x35,0xa4,0x15,0xdb,0xa9,0xe1,
	0xbc,0x7b,0x08,0xa5,0x27,0x16,0xe3,0x50,0x08,0x2d,0x09,0x2d
	};

__fips_constseg
static const unsigned char p_384_sha256_nonce[] =
	{
	0xe8,0x14,0x2b,0xee,0xba,0xac,0xe0,0x25,0xd0,0x3b,0x78,0xc5
	};

__fips_constseg
static const unsigned char p_384_sha256_personalizationstring[] =
	{
	0x28,0x0c,0x86,0x48,0x5e,0xca,0xfa,0x89,0x1f,0x58,0xb8,0x2c,
	0x41,0x28,0x3f,0x98,0x71,0x66,0x7b,0xb7,0x32,0xa2,0xe1,0x49
	};

__fips_constseg
static const unsigned char p_384_sha256_additionalinput[] =
	{
	0xdc,0x59,0xb1,0x23,0x39,0x75,0x1b,0x27,0x24,0x5f,0x7a,0x55,
	0x82,0xdc,0xdc,0xe2,0x12,0x65,0xbf,0x8a,0x65,0xdb,0x27,0xdb
	};

__fips_constseg
static const unsigned char p_384_sha256_int_returnedbits[] =
	{
	0xc0,0x86,0xd8,0x67,0xdd,0xe4,0xce,0x15,0x60,0xad,0x45,0x60,
	0x80,0x8b,0x5a,0xb6,0x85,0x6d,0x4a,0xdf,0x8e,0xc0,0x2d,0xbf,
	0xa9,0x8c,0x9b,0x8d,0x03,0xca,0xbf,0x3b,0x1f,0xdc,0xc1,0xac,
	0xa8,0x0f,0x45,0xd6,0x2e,0xd1,0xe6,0x29,0xb5,0x1c
	};

__fips_constseg
static const unsigned char p_384_sha256_entropyinputreseed[] =
	{
	0x9f,0x19,0x9f,0xc8,0x18,0x43,0xfc,0x9a,0x97,0xed,0x20,0x13,
	0xad,0xc9,0xa0,0x65,0xef,0x38,0xd6,0x2e,0xce,0x4d,0xe1,0x1d
	};

__fips_constseg
static const unsigned char p_384_sha256_additionalinputreseed[] =
	{
	0xa6,0x27,0x35,0x9f,0x8a,0xaa,0xf5,0xb3,0x60,0x4b,0x16,0x68,
	0xdd,0x32,0x2e,0x1b,0xb1,0x34,0x47,0x03,0x45,0x3f,0xb6,0x3e
	};

__fips_constseg
static const unsigned char p_384_sha256_additionalinput2[] =
	{
	0x76,0x4e,0x5c,0x75,0x33,0xa5,0x94,0x95,0xf4,0x36,0xa5,0x39,
	0x28,0xc1,0x74,0xd1,0xfa,0x1d,0x8a,0x40,0x6e,0x84,0x4e,0xc7
	};

__fips_constseg
static const unsigned char p_384_sha256_returnedbits[] =
	{
	0x50,0x15,0xc9,0x98,0x73,0x71,0x55,0xb7,0x7a,0xf4,0xa5,0xe7,
	0xb3,0xe2,0x24,0x2e,0x96,0x5b,0xd1,0xab,0xe8,0x51,0x1f,0xbe,
	0x3b,0x1e,0x1f,0xd4,0x18,0x2d,0x99,0xda,0xb8,0xa5,0x98,0x65,
	0x1d,0xaa,0x1e,0x46,0x8f,0x6b,0x4f,0xa2,0xd5,0xdf
	};


/* P-384 SHA-384 PR  */
__fips_constseg
static const unsigned char p_384_sha384_pr_entropyinput[] =
	{
	0x3b,0x40,0x57,0x65,0x46,0x14,0xa5,0xf6,0x63,0x21,0xe7,0x33,
	0xd7,0x38,0xa7,0x54,0x33,0x62,0x08,0x08,0x37,0xef,0xbf,0x22
	};

__fips_constseg
static const unsigned char p_384_sha384_pr_nonce[] =
	{
	0xf4,0xd4,0x11,0x0a,0x4a,0xdb,0xfc,0xbb,0x08,0x7a,0x20,0x51
	};

__fips_constseg
static const unsigned char p_384_sha384_pr_personalizationstring[] =
	{
	0x5d,0x5b,0x9d,0xe5,0x45,0x62,0x5b,0xd0,0xa8,0x1b,0xea,0xe3,
	0xbd,0x59,0xd4,0xab,0x50,0xbe,0x5d,0x21,0x5d,0x85,0x42,0x16
	};

__fips_constseg
static const unsigned char p_384_sha384_pr_additionalinput[] =
	{
	0xd9,0xac,0x4b,0x76,0x18,0x46,0xba,0x30,0x88,0xdf,0x41,0xdb,
	0x72,0x9b,0x4d,0xb7,0xbb,0x12,0xd2,0xd8,0x00,0xa0,0x81,0x14
	};

__fips_constseg
static const unsigned char p_384_sha384_pr_entropyinputpr[] =
	{
	0x46,0x6d,0x66,0xaf,0xcf,0xb3,0x59,0x37,0x52,0x7e,0xa0,0xce,
	0x6d,0xaa,0x40,0xac,0x87,0xce,0x01,0x76,0x8f,0xac,0x49,0x42
	};

__fips_constseg
static const unsigned char p_384_sha384_pr_int_returnedbits[] =
	{
	0xe1,0xea,0x43,0x73,0x35,0xf8,0x1f,0x2d,0xab,0x82,0x82,0x7f,
	0x82,0xca,0x78,0xb4,0x9b,0xfd,0x89,0xbc,0x83,0xcb,0x8d,0x09,
	0x44,0xb6,0xd6,0x0c,0xd9,0x43,0x97,0x5c,0xf8,0x51,0x5d,0xe3,
	0x0c,0x36,0xe1,0xaf,0xd3,0xbd,0x43,0x08,0xb8,0x65
	};

__fips_constseg
static const unsigned char p_384_sha384_pr_additionalinput2[] =
	{
	0x6f,0xe5,0x27,0xa8,0x0c,0x4b,0xad,0x03,0xba,0xaa,0x70,0xc5,
	0xc6,0x4c,0xa6,0x6b,0xd9,0xb4,0x74,0x7a,0xea,0x4b,0x07,0xc8
	};

__fips_constseg
static const unsigned char p_384_sha384_pr_entropyinputpr2[] =
	{
	0xec,0xc8,0x0c,0x3a,0x39,0xd3,0x2e,0xa9,0xab,0x57,0x89,0x1d,
	0x85,0x23,0x54,0x40,0xdf,0x15,0xbd,0x65,0x41,0xe5,0xaf,0xfb
	};

__fips_constseg
static const unsigned char p_384_sha384_pr_returnedbits[] =
	{
	0x3f,0xe0,0xa9,0x90,0x8e,0x27,0x2c,0xbe,0xfe,0xdd,0x35,0x67,
	0x4e,0x9b,0x9b,0x54,0xf3,0xb9,0x53,0xf4,0x62,0x8a,0xad,0x67,
	0x3e,0x68,0x92,0xd5,0xdb,0xd7,0x8f,0xb1,0xf7,0x10,0x5e,0xc6,
	0xc3,0xe8,0x45,0x60,0xde,0x05,0x4e,0x94,0xbc,0x43
	};


/* P-384 SHA-384 No PR  */
__fips_constseg
static const unsigned char p_384_sha384_entropyinput[] =
	{
	0x52,0x51,0xd7,0x2a,0x26,0xda,0xeb,0x5c,0xfb,0x23,0x47,0x49,
	0xf7,0x04,0xc6,0x62,0xed,0x72,0x3e,0x70,0x41,0x87,0x75,0x42
	};

__fips_constseg
static const unsigned char p_384_sha384_nonce[] =
	{
	0x63,0x66,0x35,0x65,0x9b,0xe5,0xd3,0xcb,0x94,0x82,0x81,0x05
	};

__fips_constseg
static const unsigned char p_384_sha384_personalizationstring[] =
	{
	0x52,0xa4,0xce,0x0e,0x4b,0x72,0x21,0x63,0xad,0x21,0x7f,0x60,
	0x9e,0x5d,0xa7,0xff,0xef,0xf1,0xfb,0x04,0xdb,0x30,0x5a,0x0c
	};

__fips_constseg
static const unsigned char p_384_sha384_additionalinput[] =
	{
	0xd7,0xde,0x8e,0xc4,0xeb,0x69,0xd2,0x2b,0xed,0x00,0x4a,0x6e,
	0x3a,0x13,0xf5,0x48,0xe4,0x83,0xad,0x81,0x4d,0x68,0xe5,0x57
	};

__fips_constseg
static const unsigned char p_384_sha384_int_returnedbits[] =
	{
	0xbc,0x2d,0x9b,0x3b,0xbb,0x75,0xf4,0xdf,0xda,0x0f,0x10,0x88,
	0xb4,0x95,0x4c,0xf3,0xfa,0xff,0x3d,0x30,0x53,0x0b,0xa7,0xb9,
	0x95,0x27,0xc3,0x11,0xc9,0xef,0xd4,0xfe,0x84,0x9d,0xe0,0x76,
	0xcc,0x39,0x83,0xab,0x3f,0x31,0xe7,0x6d,0x44,0x0f
	};

__fips_constseg
static const unsigned char p_384_sha384_entropyinputreseed[] =
	{
	0xef,0x0f,0xa7,0x4e,0x90,0xe1,0x57,0x9e,0xce,0x52,0xe1,0xa0,
	0xd3,0x0f,0x06,0xa4,0xfe,0x5d,0x55,0x60,0xe2,0xc5,0x45,0x3b
	};

__fips_constseg
static const unsigned char p_384_sha384_additionalinputreseed[] =
	{
	0xec,0x87,0x9e,0x8e,0x58,0xb8,0xa3,0xd3,0x3e,0x49,0x22,0xf5,
	0x68,0x5b,0x60,0x6e,0x7b,0x73,0xd5,0xa4,0x7c,0x9e,0xcd,0xba
	};

__fips_constseg
static const unsigned char p_384_sha384_additionalinput2[] =
	{
	0x1c,0xd2,0xce,0x30,0x31,0x8b,0xbb,0xaf,0xbb,0xa8,0xae,0x20,
	0xa3,0x6b,0xb5,0x37,0xfe,0x09,0x91,0x1a,0x63,0x33,0x29,0x8c
	};

__fips_constseg
static const unsigned char p_384_sha384_returnedbits[] =
	{
	0xd7,0x36,0x7b,0x33,0x50,0x6a,0x59,0xb0,0x7c,0xb3,0xc4,0xe9,
	0xc2,0x16,0x41,0x7b,0xe4,0x4c,0xd8,0x7c,0x6b,0x74,0x00,0x31,
	0xd1,0x97,0x2d,0x7a,0x97,0x22,0x45,0xe6,0xf0,0xcd,0x8e,0xa5,
	0xeb,0xab,0x37,0xd6,0xb7,0xb1,0x9c,0x42,0xfb,0xcf
	};


/* P-384 SHA-512 PR  */
__fips_constseg
static const unsigned char p_384_sha512_pr_entropyinput[] =
	{
	0x14,0xdf,0x91,0xdb,0xad,0xe2,0x22,0xe5,0x56,0xa1,0x88,0xbd,
	0x42,0x73,0xf7,0x8d,0xdc,0x99,0x54,0x99,0x8a,0xab,0x11,0x4b
	};

__fips_constseg
static const unsigned char p_384_sha512_pr_nonce[] =
	{
	0x10,0x49,0x5d,0xf6,0x5d,0x17,0xa7,0xa6,0xd8,0xc7,0xc8,0xe7
	};

__fips_constseg
static const unsigned char p_384_sha512_pr_personalizationstring[] =
	{
	0x61,0x59,0xc5,0x8e,0x30,0x77,0x05,0x75,0x87,0xff,0x0b,0x06,
	0x03,0x79,0xa5,0x8b,0x59,0xb8,0x32,0xc9,0x19,0x47,0x7d,0x0e
	};

__fips_constseg
static const unsigned char p_384_sha512_pr_additionalinput[] =
	{
	0x41,0xd5,0x73,0x17,0x13,0x4c,0xe8,0x7c,0x83,0x45,0x84,0xf1,
	0x72,0xae,0x1d,0xea,0x08,0x0a,0x56,0xec,0x16,0xf9,0x1f,0xb6
	};

__fips_constseg
static const unsigned char p_384_sha512_pr_entropyinputpr[] =
	{
	0xa6,0x85,0xa8,0xa4,0x0f,0xad,0x96,0x32,0x39,0x5e,0x86,0xb0,
	0x8b,0xda,0xb2,0xf0,0x38,0x75,0xf8,0xe2,0xc0,0xbf,0x77,0x62
	};

__fips_constseg
static const unsigned char p_384_sha512_pr_int_returnedbits[] =
	{
	0xc8,0xf2,0x0c,0x8a,0xe7,0x72,0xe2,0xa3,0x5e,0x0a,0xaa,0x21,
	0x3a,0x92,0x08,0x70,0xaf,0xc2,0x1e,0xed,0xd1,0x2c,0xa0,0xbc,
	0xcb,0x0e,0x46,0xb9,0x34,0x97,0x62,0x03,0x4a,0x93,0xe3,0x6f,
	0x92,0x08,0x71,0x16,0xce,0x3e,0x5b,0x6b,0x9a,0x52
	};

__fips_constseg
static const unsigned char p_384_sha512_pr_additionalinput2[] =
	{
	0x72,0x72,0xb3,0x26,0x05,0x49,0xf0,0x34,0xb6,0x04,0x75,0x6a,
	0x0a,0x86,0x9c,0x8f,0xe5,0x3d,0x90,0x26,0x42,0x92,0x2a,0x77
	};

__fips_constseg
static const unsigned char p_384_sha512_pr_entropyinputpr2[] =
	{
	0xf1,0xda,0x51,0xa2,0x21,0x54,0x2d,0x6d,0xec,0x92,0xe5,0x8f,
	0x81,0x96,0x21,0x60,0x93,0x33,0x3d,0xfb,0x92,0xfe,0xae,0xcb
	};

__fips_constseg
static const unsigned char p_384_sha512_pr_returnedbits[] =
	{
	0x12,0x87,0x30,0xc4,0x87,0x61,0x58,0xab,0x79,0x05,0xb4,0xfd,
	0x47,0x95,0x86,0x4c,0x24,0x45,0xb0,0x4b,0x23,0x9a,0xe6,0x72,
	0x03,0xd8,0xc1,0x8a,0xbc,0xd0,0x3b,0xb5,0x8e,0x84,0x9f,0x2d,
	0xa4,0xf6,0x9b,0x89,0xd6,0x92,0x72,0x70,0x63,0xb9
	};


/* P-384 SHA-512 No PR  */
__fips_constseg
static const unsigned char p_384_sha512_entropyinput[] =
	{
	0xc7,0x7b,0x0e,0xe1,0x06,0x66,0x63,0x87,0x15,0x09,0x0a,0xe2,
	0xbe,0xdc,0xd5,0x3c,0x65,0xce,0xc5,0x25,0xfd,0xf2,0x23,0xbe
	};

__fips_constseg
static const unsigned char p_384_sha512_nonce[] =
	{
	0x5c,0xe8,0xa7,0x7d,0x45,0x8d,0x89,0xcd,0xb7,0xa3,0x4a,0x98
	};

__fips_constseg
static const unsigned char p_384_sha512_personalizationstring[] =
	{
	0xa9,0x0e,0x29,0xff,0x2f,0x4e,0x92,0xe3,0xbd,0xcf,0x25,0xfa,
	0x96,0xdf,0x18,0x16,0x9a,0x99,0xb0,0x07,0xfe,0x51,0x24,0x9e
	};

__fips_constseg
static const unsigned char p_384_sha512_additionalinput[] =
	{
	0x1a,0x19,0xdf,0x08,0x35,0x94,0x83,0x30,0xab,0x01,0x98,0x2b,
	0xa5,0xe2,0x6d,0x99,0xe7,0x30,0xd5,0xef,0xf1,0xa7,0x61,0x61
	};

__fips_constseg
static const unsigned char p_384_sha512_int_returnedbits[] =
	{
	0xa2,0x80,0xdb,0xa3,0x6c,0x7b,0x74,0x57,0x65,0x9d,0x32,0x53,
	0xaf,0xcc,0x91,0x21,0x59,0x3c,0xf2,0xf7,0xf7,0x06,0x29,0xee,
	0xce,0x1f,0x3d,0xdb,0x2c,0x9c,0xb9,0xfb,0xf1,0xe1,0xf1,0xac,
	0x90,0xcd,0x6e,0xc5,0x97,0x1e,0xa2,0x90,0x2b,0x7e
	};

__fips_constseg
static const unsigned char p_384_sha512_entropyinputreseed[] =
	{
	0xf4,0x57,0x3d,0xc5,0x13,0x99,0xb2,0x4d,0xdd,0xdf,0xf3,0xa0,
	0x7b,0x82,0x8a,0x22,0x9a,0x02,0x9c,0xac,0x6f,0xb4,0x07,0xd8
	};

__fips_constseg
static const unsigned char p_384_sha512_additionalinputreseed[] =
	{
	0x12,0x98,0x84,0xa1,0xb5,0x26,0x7e,0x55,0xe1,0xd1,0x00,0x8f,
	0x50,0x96,0x30,0xa7,0x33,0xf5,0xb4,0x76,0x93,0x7a,0x2d,0x82
	};

__fips_constseg
static const unsigned char p_384_sha512_additionalinput2[] =
	{
	0xfd,0x4c,0x76,0x61,0x48,0x40,0xa7,0x1e,0xa1,0xe9,0x25,0xcc,
	0xa6,0x21,0x4e,0x87,0xc9,0x27,0x06,0x3e,0x89,0x8b,0x18,0x3c
	};

__fips_constseg
static const unsigned char p_384_sha512_returnedbits[] =
	{
	0x90,0xa9,0xd4,0x1a,0x7f,0xb5,0xdd,0x66,0x5f,0xa7,0xc9,0x53,
	0x57,0xfc,0xc1,0x42,0x93,0x09,0xb4,0xf6,0x6c,0x7a,0xce,0x16,
	0x5e,0xed,0xad,0xea,0x0e,0x34,0x06,0xbb,0x80,0x89,0xba,0xd3,
	0xfe,0x49,0x21,0x4e,0x28,0xa7,0xfe,0xdb,0x27,0xfe
	};


/* P-521 SHA-256 PR  */
__fips_constseg
static const unsigned char p_521_sha256_pr_entropyinput[] =
	{
	0x1a,0xb3,0x78,0x1e,0x14,0x19,0x83,0x05,0xac,0xb0,0x95,0xe1,
	0x10,0xa3,0xc4,0xbc,0x8e,0x13,0x2c,0xf2,0xad,0x63,0x25,0x1f,
	0x88,0xc4,0xc4,0x4e,0x6d,0x03,0x96,0x5e
	};

__fips_constseg
static const unsigned char p_521_sha256_pr_nonce[] =
	{
	0xd8,0x3d,0x1c,0x7e,0x4a,0x8e,0x28,0x4a,0xd6,0xf7,0xe8,0x0c,
	0x54,0x69,0x31,0xe4
	};

__fips_constseg
static const unsigned char p_521_sha256_pr_personalizationstring[] =
	{
	0xc7,0xa6,0xb8,0xc0,0x25,0xaa,0x88,0xf5,0xc7,0x6a,0xd2,0xfc,
	0x7a,0x07,0xdd,0xf9,0x02,0xfb,0x79,0x36,0x17,0xc3,0x23,0x6e,
	0x9e,0xcd,0x5c,0x5d,0x2b,0xa3,0x45,0x86
	};

__fips_constseg
static const unsigned char p_521_sha256_pr_additionalinput[] =
	{
	0xde,0xc5,0x1d,0x59,0x4d,0x25,0x3c,0x4f,0xbb,0x81,0xb3,0x61,
	0xd4,0x84,0x6e,0x4e,0x52,0x80,0xcd,0x5d,0x1a,0xb9,0xdf,0x44,
	0x94,0xf2,0xde,0x54,0x49,0x37,0xea,0xe8
	};

__fips_constseg
static const unsigned char p_521_sha256_pr_entropyinputpr[] =
	{
	0x4e,0xe6,0x23,0xa4,0x97,0xaf,0x70,0x36,0xed,0xed,0x37,0x6b,
	0xc9,0x31,0x95,0x1e,0x07,0x42,0x42,0x4b,0x24,0x06,0xee,0xa0,
	0xb5,0xb1,0xd7,0x40,0x29,0x2e,0xa8,0xd8
	};

__fips_constseg
static const unsigned char p_521_sha256_pr_int_returnedbits[] =
	{
	0x7d,0x64,0x63,0x00,0xa5,0x98,0x9b,0xf3,0xf4,0x09,0x44,0x64,
	0xcc,0xa8,0x99,0xbc,0x6e,0xac,0x67,0xb9,0xb1,0xb5,0x3b,0xe8,
	0x99,0xde,0x91,0xe8,0x8b,0x95,0x09,0xcc,0x35,0xde,0xd7,0x78,
	0x97,0x47,0x7d,0xa0,0x5f,0xe4,0x48,0x1e,0x5f,0x14,0xa0,0xda,
	0xd6,0xac,0x59,0xf0,0x31,0xc6,0xb4,0x78,0x70,0x32,0x87,0xd8,
	0xbb,0xe1,0x8e
	};

__fips_constseg
static const unsigned char p_521_sha256_pr_additionalinput2[] =
	{
	0xda,0x8a,0xbb,0x5e,0x1f,0xc7,0x4b,0x7e,0x2b,0x09,0xdd,0x64,
	0x42,0x4b,0x19,0x66,0x16,0xb6,0xec,0x1c,0x46,0xd1,0x23,0x26,
	0x16,0xe9,0x4a,0x3b,0x6e,0xc1,0xc6,0x74
	};

__fips_constseg
static const unsigned char p_521_sha256_pr_entropyinputpr2[] =
	{
	0x7b,0x4d,0x60,0x68,0xb1,0xd7,0xbe,0xf7,0x40,0xb5,0x84,0xa8,
	0x3b,0x49,0x38,0x8a,0xc2,0x40,0x44,0x0b,0x80,0xc8,0x94,0xbf,
	0x6a,0xf5,0x72,0x74,0xb5,0x6f,0x9f,0x7a
	};

__fips_constseg
static const unsigned char p_521_sha256_pr_returnedbits[] =
	{
	0xb2,0x4e,0x40,0x75,0xaf,0xcf,0x93,0x13,0xaf,0x97,0x49,0x49,
	0x5f,0xdf,0x5d,0x21,0x2f,0x99,0x7d,0xe9,0xb8,0x98,0x3e,0x1f,
	0x06,0xcc,0xca,0xb6,0xcf,0x6d,0xd2,0xd9,0x85,0x45,0x1a,0xd5,
	0x39,0x6a,0x26,0x6c,0x7b,0x7b,0x72,0x18,0xa2,0xf1,0x99,0x7e,
	0xe1,0xa0,0xa6,0x54,0xe4,0x0f,0x73,0x48,0xc2,0x54,0xc2,0xc3,
	0x4f,0x53,0xb3
	};


/* P-521 SHA-256 No PR  */
__fips_constseg
static const unsigned char p_521_sha256_entropyinput[] =
	{
	0x69,0x5d,0x57,0x6d,0xe8,0xb1,0x0a,0x01,0xf8,0x1d,0xb9,0x5d,
	0xbd,0xfb,0xec,0x38,0xc9,0xd3,0x70,0x88,0x9a,0x8d,0xf2,0x4e,
	0x55,0xd6,0xde,0xa2,0xc4,0xd2,0x78,0xfb
	};

__fips_constseg
static const unsigned char p_521_sha256_nonce[] =
	{
	0x12,0xd2,0x1a,0xac,0xaf,0x49,0xb2,0xa4,0x9c,0x33,0x2e,0xdb,
	0x46,0xd1,0xc7,0x23
	};

__fips_constseg
static const unsigned char p_521_sha256_personalizationstring[] =
	{
	0xb7,0xe2,0xeb,0xa9,0x88,0xb5,0x24,0xf3,0x82,0xc6,0x83,0xe3,
	0x5e,0x12,0x32,0xd1,0x50,0x16,0xd4,0x96,0x5e,0x62,0x0b,0xb8,
	0x02,0x5b,0x2e,0xd2,0x01,0x52,0x4a,0x48
	};

__fips_constseg
static const unsigned char p_521_sha256_additionalinput[] =
	{
	0xf4,0xa2,0xfa,0xae,0x18,0x94,0xdb,0x12,0x0b,0xa8,0x1e,0x4e,
	0x7f,0xdb,0x3d,0x9e,0x06,0xe2,0x77,0x53,0x2b,0x76,0x0a,0xbd,
	0xcc,0xdb,0xae,0x5a,0xbc,0xb0,0x53,0x3f
	};

__fips_constseg
static const unsigned char p_521_sha256_int_returnedbits[] =
	{
	0xbd,0x16,0xe4,0x4d,0x62,0xa1,0xb4,0x4f,0x3f,0xba,0x27,0x58,
	0xa3,0xa1,0x6f,0x92,0xe9,0xe9,0x48,0xd0,0x64,0xba,0xb2,0x17,
	0x54,0x9a,0xcc,0x8d,0xae,0x2e,0x68,0x62,0x42,0xab,0x55,0x24,
	0x47,0x0f,0x71,0xd2,0xa8,0x78,0xf0,0x5b,0x76,0xd0,0x01,0xd7,
	0x86,0xca,0xe5,0xa4,0x41,0x82,0x73,0x51,0x5e,0xa4,0x12,0xa4,
	0xe1,0xea,0xbd
	};

__fips_constseg
static const unsigned char p_521_sha256_entropyinputreseed[] =
	{
	0xda,0x4e,0x7f,0xf0,0x7d,0x4d,0xd8,0x74,0xa2,0x74,0x08,0x82,
	0x1b,0xe2,0xab,0xc9,0xd2,0xae,0x07,0xc3,0xc5,0x94,0x2f,0xfa,
	0x40,0xe0,0x5a,0x95,0x5b,0x99,0x7f,0x28
	};

__fips_constseg
static const unsigned char p_521_sha256_additionalinputreseed[] =
	{
	0xf3,0x7d,0x64,0xae,0x7a,0xb3,0x9c,0xee,0x0a,0xd3,0x1a,0x56,
	0x3d,0x65,0xac,0x33,0xcc,0x3c,0xb0,0x4a,0x43,0xe3,0xf4,0xe7,
	0x05,0x49,0xcc,0x28,0x81,0xaf,0x73,0x8a
	};

__fips_constseg
static const unsigned char p_521_sha256_additionalinput2[] =
	{
	0x80,0xf2,0xdc,0xd2,0x0e,0x77,0x89,0xd7,0x46,0x67,0x31,0x28,
	0xf6,0xe1,0x1a,0x3f,0x70,0xdb,0x42,0x57,0xc7,0x0a,0xbd,0xf9,
	0x46,0x0e,0x50,0xc8,0x32,0xe0,0x4d,0x8f
	};

__fips_constseg
static const unsigned char p_521_sha256_returnedbits[] =
	{
	0x04,0xce,0x3f,0x47,0x4b,0x90,0x0e,0x0b,0x5d,0x61,0xd2,0xe4,
	0xca,0x19,0x98,0x3e,0xda,0xbb,0xe0,0x68,0x42,0x16,0x3c,0x25,
	0x69,0xb2,0x62,0x3f,0x57,0x84,0x22,0xc5,0x27,0x94,0xcb,0x2a,
	0x6c,0xe4,0xe5,0x3a,0x4d,0xfe,0x23,0xeb,0x81,0x09,0x8a,0xa4,
	0x57,0x8d,0x38,0x26,0x36,0x83,0xc7,0xfa,0xbd,0x1e,0xab,0x50,
	0xfe,0xae,0x42
	};


/* P-521 SHA-384 PR  */
__fips_constseg
static const unsigned char p_521_sha384_pr_entropyinput[] =
	{
	0xd7,0xc3,0x75,0xc9,0xdc,0xd6,0x28,0x49,0x6c,0x0c,0x26,0xe8,
	0x50,0x5a,0x98,0x53,0xa0,0xa1,0x59,0xfc,0xd9,0xef,0x34,0x05,
	0x42,0x12,0x5f,0x6c,0x80,0x65,0x37,0x77
	};

__fips_constseg
static const unsigned char p_521_sha384_pr_nonce[] =
	{
	0x07,0x8a,0xc4,0xbb,0x27,0x54,0x33,0xe2,0xfa,0x4a,0xe2,0x84,
	0xe5,0x5b,0x27,0x69
	};

__fips_constseg
static const unsigned char p_521_sha384_pr_personalizationstring[] =
	{
	0x69,0x90,0xea,0xac,0x46,0x2f,0x9a,0x3a,0xcc,0xdb,0xbc,0x26,
	0x5d,0xae,0x6d,0xca,0x80,0x62,0x95,0x3f,0x7c,0x17,0xa3,0xc5,
	0x36,0x69,0x8a,0x70,0x4e,0xb0,0xfb,0x16
	};

__fips_constseg
static const unsigned char p_521_sha384_pr_additionalinput[] =
	{
	0xc7,0x82,0x8d,0xac,0x49,0xed,0x4d,0xe0,0x5f,0x26,0xe4,0xdf,
	0xd6,0x26,0xd0,0x90,0x5b,0xeb,0x36,0xa1,0x5a,0x8d,0xe0,0x33,
	0x18,0x86,0x73,0xcb,0x0d,0x3c,0xf4,0x76
	};

__fips_constseg
static const unsigned char p_521_sha384_pr_entropyinputpr[] =
	{
	0x88,0xeb,0xbc,0xc4,0xdb,0xb0,0x0c,0xc7,0xc9,0x0a,0xae,0x9f,
	0xe7,0x2c,0x8d,0x8e,0x9a,0x5b,0x37,0xf4,0x91,0x15,0x7c,0x1c,
	0x84,0x84,0x48,0x47,0x2d,0x24,0xc4,0xf8
	};

__fips_constseg
static const unsigned char p_521_sha384_pr_int_returnedbits[] =
	{
	0xf1,0x8a,0x43,0xec,0x2b,0x3f,0x74,0x05,0xae,0x4f,0x96,0xbb,
	0x90,0xba,0x55,0x23,0xb5,0x07,0xc9,0xfc,0x53,0x36,0x02,0x1d,
	0xb5,0xf4,0x8a,0x8c,0x71,0xb0,0xb2,0x35,0x2e,0xc1,0x91,0xbb,
	0x78,0xf1,0x5f,0x1d,0x1b,0xa3,0xa3,0x4d,0x93,0x76,0x36,0xbe,
	0xb2,0x83,0x6e,0xe1,0x00,0xe3,0x58,0x98,0x84,0x1a,0x4d,0x77,
	0x1c,0x3a,0x5f
	};

__fips_constseg
static const unsigned char p_521_sha384_pr_additionalinput2[] =
	{
	0x1e,0xbd,0x75,0x87,0x28,0x2e,0x05,0xbe,0xb3,0xa8,0x81,0x57,
	0x00,0x24,0xe5,0xe2,0xad,0x7d,0xe5,0x60,0x36,0x9b,0x82,0x09,
	0xac,0xdd,0xec,0x5e,0xb6,0xc6,0x9e,0x72
	};

__fips_constseg
static const unsigned char p_521_sha384_pr_entropyinputpr2[] =
	{
	0xa4,0x30,0xe4,0xec,0x31,0x84,0x79,0x5c,0x40,0xd8,0x54,0x9d,
	0xd9,0x64,0xdf,0x46,0xc4,0xca,0x08,0x19,0x65,0x24,0x41,0xa8,
	0xdb,0x4c,0xbd,0x4a,0x5a,0x6c,0xe7,0x40
	};

__fips_constseg
static const unsigned char p_521_sha384_pr_returnedbits[] =
	{
	0x15,0x44,0x90,0x6e,0x56,0xc1,0x51,0x2a,0x0d,0x3a,0x2f,0x1a,
	0x2d,0x0e,0xf8,0x32,0x05,0xe0,0xd7,0x77,0xd4,0x82,0x31,0x11,
	0x4e,0x70,0x50,0x76,0x5a,0x42,0x56,0x0a,0xeb,0x27,0x63,0x74,
	0xe5,0xc4,0x83,0x31,0x25,0x14,0xc4,0x5e,0x6e,0xc7,0xec,0x57,
	0x4b,0xaf,0x17,0xd9,0x43,0x61,0xfb,0xf6,0xc1,0x18,0xc3,0x41,
	0x3a,0xae,0x81
	};


/* P-521 SHA-384 No PR  */
__fips_constseg
static const unsigned char p_521_sha384_entropyinput[] =
	{
	0xd2,0x5e,0x8a,0xdf,0x9d,0x50,0x3e,0xb8,0x0e,0x01,0x7b,0x02,
	0x95,0xb4,0x26,0x59,0x25,0x7c,0xdf,0x15,0x6f,0x2f,0x59,0xe2,
	0x60,0x8d,0xf8,0x83,0xdc,0xaf,0xb0,0xe1
	};

__fips_constseg
static const unsigned char p_521_sha384_nonce[] =
	{
	0x03,0xb8,0xbe,0x6f,0x90,0x5a,0xca,0x32,0xcd,0x86,0x9f,0x0a,
	0x01,0xb6,0x8f,0x41
	};

__fips_constseg
static const unsigned char p_521_sha384_personalizationstring[] =
	{
	0x39,0x5d,0xc0,0xa6,0xa7,0x8f,0xc4,0x5e,0xec,0xb7,0x45,0xa7,
	0x18,0x35,0x73,0xac,0x41,0x12,0x9c,0x8e,0x83,0xaa,0x45,0xb0,
	0x35,0x9a,0x8a,0x44,0x6f,0xea,0xb8,0x15
	};

__fips_constseg
static const unsigned char p_521_sha384_additionalinput[] =
	{
	0xac,0x37,0xb4,0x53,0x39,0xd7,0xdd,0xad,0x63,0x8d,0xe6,0x1a,
	0x4c,0xdf,0x1d,0x3a,0x0c,0x54,0xcf,0xb0,0x15,0x01,0xc5,0x46,
	0xc7,0x56,0xff,0x64,0x50,0x29,0xb2,0xb2
	};

__fips_constseg
static const unsigned char p_521_sha384_int_returnedbits[] =
	{
	0x16,0xf7,0x2a,0xa2,0x12,0x41,0xb9,0x58,0xac,0x9c,0x99,0xaa,
	0x9b,0xbd,0xcd,0x2c,0x18,0x0d,0xf6,0x5a,0x52,0xd8,0x26,0x4e,
	0xd0,0x7a,0xc1,0xe5,0x67,0x54,0x7f,0x65,0x63,0x2a,0xd1,0xef,
	0xf0,0x8f,0xb9,0x2e,0xb0,0xdb,0xc7,0x03,0xc8,0xe1,0x58,0xaa,
	0xdb,0x7c,0x67,0xf6,0xf4,0x4d,0x33,0x0d,0xf0,0x6c,0xd9,0xdd,
	0xd4,0x2c,0xa1
	};

__fips_constseg
static const unsigned char p_521_sha384_entropyinputreseed[] =
	{
	0x38,0xae,0xd1,0xbd,0xde,0xcc,0x88,0xc7,0x2d,0x39,0x68,0x1e,
	0xef,0x19,0xb6,0x3c,0xcc,0xed,0xec,0x87,0xc5,0xc5,0x56,0x22,
	0xf6,0xa9,0xea,0xf4,0x8b,0x43,0x6b,0xf7
	};

__fips_constseg
static const unsigned char p_521_sha384_additionalinputreseed[] =
	{
	0x6f,0xd8,0x16,0x55,0x9f,0xe8,0x71,0x65,0x83,0xf2,0xf5,0xaf,
	0xad,0xff,0x19,0x72,0x59,0x8c,0x84,0xdb,0xc7,0x14,0x88,0x34,
	0xda,0xda,0xde,0x4f,0xf0,0xfa,0xa3,0x33
	};

__fips_constseg
static const unsigned char p_521_sha384_additionalinput2[] =
	{
	0xd9,0xe2,0x19,0x2e,0x78,0x71,0x2f,0xec,0x45,0xcc,0x63,0x0e,
	0x5b,0x7a,0x02,0x34,0x29,0x90,0xd5,0x2c,0x10,0x7e,0xdd,0x5a,
	0x3e,0x1a,0x4c,0x69,0xcb,0xec,0xc6,0x33
	};

__fips_constseg
static const unsigned char p_521_sha384_returnedbits[] =
	{
	0x88,0x53,0x0c,0xa7,0x5c,0x3f,0x56,0x6a,0x0a,0x10,0xa5,0xac,
	0x41,0x60,0x2a,0xa2,0x29,0x35,0x4c,0xc8,0x24,0xd1,0x75,0xc9,
	0xcc,0xb8,0x87,0x46,0xcc,0xf2,0x72,0x05,0x7f,0x39,0xf0,0x0f,
	0x4d,0x26,0xac,0x8c,0xa4,0x9a,0x87,0xe1,0x16,0xb3,0xc1,0x95,
	0xba,0x0e,0x7b,0x96,0xa9,0x91,0x15,0x9c,0x54,0x16,0x73,0x3b,
	0xce,0x2a,0xfd
	};


/* P-521 SHA-512 PR  */
__fips_constseg
static const unsigned char p_521_sha512_pr_entropyinput[] =
	{
	0xb7,0x8e,0x4a,0x70,0x59,0xf4,0xb4,0xfa,0x94,0xef,0xc7,0xe7,
	0x7b,0xde,0x06,0x46,0x2e,0x71,0xde,0x82,0x59,0xd5,0x3a,0x32,
	0xee,0x1e,0x64,0x24,0x25,0xf4,0x1d,0xa6
	};

__fips_constseg
static const unsigned char p_521_sha512_pr_nonce[] =
	{
	0x46,0x15,0x8e,0x0c,0x97,0x3c,0x81,0x7b,0x2b,0x38,0xde,0x1a,
	0x93,0x68,0x00,0x30
	};

__fips_constseg
static const unsigned char p_521_sha512_pr_personalizationstring[] =
	{
	0x05,0x12,0xdf,0xac,0xf9,0xf8,0xce,0xec,0x1e,0x98,0x91,0x6d,
	0x1d,0xf5,0x4c,0xdf,0xb5,0xb4,0x43,0x90,0x1d,0xaa,0x53,0x9c,
	0x9a,0xa3,0xb5,0x54,0x63,0x74,0xf0,0xf2
	};

__fips_constseg
static const unsigned char p_521_sha512_pr_additionalinput[] =
	{
	0x04,0x8d,0xfc,0x7a,0xa2,0x25,0x99,0x6a,0xb0,0x17,0x7e,0xe8,
	0x3b,0xc1,0x2f,0x59,0x48,0xde,0xbe,0x44,0xcc,0x2c,0xe6,0xa8,
	0xf0,0x57,0x69,0x7e,0x85,0x2a,0xa8,0x8b
	};

__fips_constseg
static const unsigned char p_521_sha512_pr_entropyinputpr[] =
	{
	0xbb,0xa2,0x0b,0x9f,0xf2,0x01,0x4c,0x9a,0x20,0x87,0x75,0x69,
	0x18,0x51,0x21,0x12,0x55,0xf3,0xc4,0xfe,0x2c,0x5e,0x08,0x85,
	0x52,0x12,0x68,0xb8,0x90,0x87,0x0c,0x6f
	};

__fips_constseg
static const unsigned char p_521_sha512_pr_int_returnedbits[] =
	{
	0x81,0x79,0xde,0xe3,0xe0,0x72,0xd8,0x86,0x39,0x42,0x4b,0x86,
	0xf0,0x4b,0xf2,0xa2,0x56,0xc1,0x67,0x41,0x12,0x2e,0x33,0x2d,
	0x48,0x80,0x91,0x40,0xef,0x3d,0x47,0xf1,0x9b,0xea,0x55,0x2e,
	0x78,0xa1,0x22,0x24,0x5b,0x0c,0xea,0x35,0xba,0xb5,0x0c,0x74,
	0x17,0x1a,0x07,0xe6,0x0b,0x51,0xb5,0x9b,0xbf,0xdb,0xa8,0x05,
	0xe4,0x7a,0x01
	};

__fips_constseg
static const unsigned char p_521_sha512_pr_additionalinput2[] =
	{
	0x9d,0x9c,0xbd,0x7e,0x2d,0x33,0x41,0x63,0xb7,0x44,0x91,0xd0,
	0xd1,0xaf,0x07,0x8a,0xb2,0xc4,0xd9,0xbc,0x72,0x37,0x70,0x7d,
	0x85,0x47,0x06,0x9e,0x73,0x2b,0x85,0xb7
	};

__fips_constseg
static const unsigned char p_521_sha512_pr_entropyinputpr2[] =
	{
	0xcd,0x1e,0x0c,0x58,0xe9,0x65,0x44,0x95,0x7a,0x68,0xf1,0xe1,
	0xd7,0xc5,0xdb,0x89,0x0d,0xdc,0x30,0x0e,0x16,0xc1,0xe5,0xad,
	0x57,0x60,0x50,0x31,0x5f,0xf0,0x05,0xf7
	};

__fips_constseg
static const unsigned char p_521_sha512_pr_returnedbits[] =
	{
	0x5b,0x24,0x8e,0xab,0x1b,0x1b,0x86,0xe0,0x65,0x11,0x84,0x75,
	0xbf,0x5b,0x00,0x0b,0xd8,0x08,0x7d,0x3f,0xfa,0x70,0xe7,0x65,
	0xe3,0x68,0xe8,0x1f,0x78,0x68,0x49,0x5d,0x06,0x3f,0x7b,0x9b,
	0xc2,0xc9,0x06,0x48,0xbd,0x3d,0x27,0x6c,0x36,0xc3,0xfb,0x57,
	0x89,0x8a,0x90,0x92,0x1c,0xc0,0xda,0x58,0xd8,0x0e,0x81,0x70,
	0x6d,0xd4,0x34
	};


/* P-521 SHA-512 No PR  */
__fips_constseg
static const unsigned char p_521_sha512_entropyinput[] =
	{
	0x3d,0x1f,0x10,0x75,0x3c,0x9f,0x09,0xf2,0xe2,0x38,0x50,0x8e,
	0x88,0xb1,0x1f,0x45,0xd3,0xb9,0x60,0xd9,0xd4,0x2f,0xed,0xbb,
	0x5f,0xb2,0x0e,0x3b,0xaa,0x6b,0x2e,0xee
	};

__fips_constseg
static const unsigned char p_521_sha512_nonce[] =
	{
	0x9d,0x59,0xbf,0xcb,0xcf,0x3f,0xe0,0xb1,0x2b,0x6f,0x3d,0xd8,
	0x38,0x77,0xf6,0x1c
	};

__fips_constseg
static const unsigned char p_521_sha512_personalizationstring[] =
	{
	0xf2,0x91,0xdb,0xef,0x70,0x9a,0x87,0x74,0xc4,0xf6,0x8e,0x09,
	0xe8,0x39,0xe5,0xc0,0x79,0x12,0xcb,0xeb,0x58,0x1c,0x88,0x81,
	0x83,0xe8,0x66,0xd0,0x2f,0x49,0xef,0x63
	};

__fips_constseg
static const unsigned char p_521_sha512_additionalinput[] =
	{
	0x38,0x7c,0xdd,0x33,0xcd,0x09,0x12,0xc0,0xb8,0x73,0x72,0xdf,
	0xad,0xe1,0xe9,0xd2,0x69,0xd0,0xa0,0x1a,0xe5,0xfc,0x51,0x0a,
	0xd5,0x90,0xe9,0x8c,0x66,0x8c,0x63,0x35
	};

__fips_constseg
static const unsigned char p_521_sha512_int_returnedbits[] =
	{
	0x7c,0xd6,0xd8,0xbb,0x12,0x5d,0xaf,0x65,0x65,0xd2,0x20,0x58,
	0x82,0x17,0xbb,0xd6,0x37,0x24,0x23,0xe2,0x49,0xe3,0x13,0x74,
	0x66,0x7a,0xaf,0x35,0x8f,0x18,0x88,0xa8,0xb8,0xc3,0x84,0xb1,
	0xb5,0xfa,0xf2,0x46,0x49,0x91,0x95,0x06,0x1a,0x8c,0xb3,0x94,
	0x78,0x11,0x73,0x9d,0xeb,0x07,0xc6,0x20,0x52,0x89,0xf1,0xaf,
	0xb2,0x66,0xba
	};

__fips_constseg
static const unsigned char p_521_sha512_entropyinputreseed[] =
	{
	0xd5,0x51,0xf0,0x88,0xb6,0xa5,0x26,0x8c,0x34,0x82,0xd3,0xa4,
	0xee,0x6e,0xc4,0x70,0x27,0xb8,0x85,0xa7,0xca,0x22,0x7b,0x62,
	0x9c,0xcf,0x3e,0xa9,0xc2,0x6e,0x3a,0x3e
	};

__fips_constseg
static const unsigned char p_521_sha512_additionalinputreseed[] =
	{
	0x22,0xce,0x9f,0x3b,0x36,0x8d,0x4e,0xe2,0xe5,0xff,0xaf,0x72,
	0x90,0xe8,0xfa,0x3b,0x16,0xe2,0xcb,0xc6,0xf1,0xac,0x5e,0xb8,
	0x8e,0xb0,0x0a,0x05,0xeb,0xd4,0xfd,0x58
	};

__fips_constseg
static const unsigned char p_521_sha512_additionalinput2[] =
	{
	0x2f,0x55,0x03,0xe2,0x5f,0x58,0xf4,0xc8,0xf9,0x98,0x79,0x9a,
	0x1e,0x44,0xa5,0x0d,0x38,0x20,0x5e,0xe4,0x54,0x0a,0xd4,0x1f,
	0xc3,0xcf,0x3e,0x66,0xf2,0x2f,0xd5,0xb6
	};

__fips_constseg
static const unsigned char p_521_sha512_returnedbits[] =
	{
	0x2e,0xbf,0x98,0xf9,0x85,0x27,0x8b,0xff,0x36,0xb9,0x40,0x0b,
	0xc0,0xa1,0xa0,0x13,0x20,0x06,0xcc,0xe6,0x2a,0x03,0x77,0x7d,
	0xee,0xde,0xcc,0x34,0xe3,0xcd,0x77,0xea,0xd0,0x3e,0xbe,0xdd,
	0xf6,0x15,0xfb,0xa7,0xd7,0x8e,0xd0,0x2e,0x2f,0x82,0x4c,0xc7,
	0x87,0xb1,0x6f,0xc5,0xf8,0x5c,0x78,0xde,0x77,0x9b,0x15,0x9a,
	0xb9,0x3c,0x38
	};

