/* 
   Unix SMB/Netbios implementation.
   Version 3.0
   NBT netbios routines and daemon - version 3
   Copyright (C) Andrew Tridgell 1994-1996 Luke Leighton 1996
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   Module name: namereg.c

   Revision History:

   14 jan 96: lkcl@pires.co.uk
   added multiple workgroup domain master support

   09 oct 96: lkcl@pires.co.uk
   created module namereg containing NetBIOS registration reply

*/

#include "includes.h"

extern int DEBUGLEVEL;


/****************************************************************************
  reply to a reg request
  **************************************************************************/
void reply_name_reg(struct packet_struct *p)
{
  struct nmb_packet *nmb = &p->packet.nmb;
  struct nmb_name *question = &nmb->question.question_name;
  
  struct nmb_name *reply_name = question;

  BOOL bcast = nmb->header.nm_flags.bcast;
  BOOL wins  = nmb->header.nm_flags.recursion_desired;
  
  int ttl = GET_TTL(nmb->additional->ttl);

  int nb_flags = nmb->additional->rdata[0];
  BOOL group = NAME_GROUP(nb_flags);

  struct subnet_record *d = NULL;
  struct name_record *n = NULL;

  BOOL success = True;
  int rcode;

  struct in_addr ip;
  struct in_addr from_ip;
  int idx;
  
  putip(&from_ip,&nmb->additional->rdata[2]);
  putip(&ip,&from_ip);
  
  DEBUG(3,("Name registration for name %s at %s\n",
	           namestr(question),inet_ntoa(from_ip)));
  
  if (wins && !bcast)
  {
    DEBUG(2,("nmbd received packet intended for winsd!\n"));
    return;
  }

  if (!(d = find_req_subnet(p->ip, False)))
  {
    DEBUG(3,("Name registration packet: %s not known\n", inet_ntoa(p->ip)));
    return;
  }

  /* see if the name already exists */
  n = find_name_search(&d, question, FIND_WINS|FIND_LOCAL|FIND_SELF, ip, &idx);
  
  /* really don't care about anything other than our own names */
  if (!n || n->ip_flgs[idx].source != SELF) return;

  /* ignore registration for names by ourselves */
  if (ismyip(p->ip)) return;

  /* can only allow registration if the name is a group name. */
  success = group && NAME_GROUP(n->ip_flgs[idx].nb_flags);

  /* if samba owns a unique name on a subnet, then it must respond and
     disallow the attempted registration. if the registration is
     successful by broadcast, there is no need to respond (implicit
     positive registration: see rfc1001.txt 15.2.1).
   */
  if (bcast && success) return;
  
  /* see rfc1002.txt 4.2.6 for RCODEs */
  rcode = success ? RCODE_REG_OK : RCODE_REG_ACT_ERR;

  /* Send a NAME REGISTRATION RESPONSE (pos/neg) see rfc1002.txt 4.2.13-14 */
  send_name_response(p, nmb->header.name_trn_id, NMB_REG,
						rcode, False, True,
						reply_name, nb_flags, ttl, ip);
}

