/* cache.h - Caching functionality header file

   Copyright (c) Dave Airlie 2000
   airlied@samba.org
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _CACHE_H_
#define _CACHE_H_

typedef enum { UNK, SMB, PDC } sertype;

typedef struct {
  char sername[MAX_SERV_LEN];
  sertype type;
} serv;

typedef struct {
  int numservers;
  serv servers[MAX_SERVERS];
  char domain[MAX_NTDOM_LEN];
} domain_ctls;

typedef struct {
	int numdomains;
	int last_check_time;
	domain_ctls controllers[MAX_DOMAINS];
} domain_list;

typedef struct 
{
  /* NOTE: all char* are +1.  The extra char should be set to '\0'
   * before use to prevent buffer overflows in other parts of the code */
  char nt_user[MAX_NT_LEN+1];
  char ux_user[MAX_UU_LEN+1]; /* This is the UNIX equivalent */
  char password[MAX_PASS_LEN+1]; /* This is the password for the NT domain */
  char mx_domain[MAX_NTDOM_LEN+1]; /* This is the NT domain or default */
  char nt_domain[MAX_NTDOM_LEN+1]; /* this is the NT domain (no default) */
  char pdc_nbname[MAX_SERV_LEN+1]; /* This is the Netbios name of the NT PDC*/
  char bdc_nbname[MAX_SERV_LEN+1]; /* This is the Netbios name of the NT BDC */
  char pdc_hostname[MAX_HOST_LEN+1]; /* This is the IP address of the NT PDC */
  char bdc_hostname[MAX_HOST_LEN+1]; /* This is the IP Address of the NT BDC */
  long usertimeout; /* This is the cache timeout value */
} usercache_data;

#ifdef PAM_SMB_DAEMON
int Valid_MapUser(usercache_data *user);

#define CACHE_OK 0
#define CACHE_ENOENT 1
#define CACHE_ETIME 2
#define CACHE_OK_FAILOVER 3

/* Check cache every CACHE_CHECK minutes -- default every 5 mins */
#ifndef CACHE_CHECK
#define CACHE_CHECK 300
#endif

/* How long should the system cache the password for ?? -- default every 10 mins */
#ifndef CACHE_TIMEOUT
#define CACHE_TIMEOUT 600
#endif

/* Cache management function prototypes */
int serv_initcachedb(void);
int serv_closecachedb(void);
int add_entry_to_cache(usercache_data *entry);
int check_entry_in_cache(usercache_data *entry,int,int);
void sigusr1_handler(int);
#endif

/* Server.c protptypes (sould be in server.h) */
void sigterm_handler(int signum);
int setup_queue(void);
int do_queue(int mid);

/* map_user protptypes (should be in map_user.h) */
int map_user_add_entry(char *unix_user, char *nt_user, char *nt_domain);
int map_user_read_map_file(char *map_file);
int map_user_initdb();
int map_user(usercache_data *user);
int map_user_closedb();

/* pam_read_conf */
int smb_readpamconf(domain_list *);

#endif
