/* UNIX SMBlib NetBIOS implementation

   Version 1.0
   SMBlib Utility Routines

   Copyright (C) Richard Sharpe 1996

*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "smblib-priv.h"

#include "rfcnb/rfcnb.h"

/* Negotiate the protocol we will use from the list passed in Prots       */
/* we return the index of the accepted protocol in NegProt, -1 indicates  */
/* none acceptible, and our return value is 0 if ok, <0 if problems       */

int SMB_Negotiate(SMB_Handle_Type Con_Handle, char *Prots[], int *NegProt)

{ struct SMB_Neg_Prot_Def *prot_pkt;
  struct SMB_Neg_Prot_Resp_Def *resp_pkt;
  struct RFCNB_Pkt *pkt;
  int prots_len, i, pkt_len;
  char *p;

  /* Figure out how long the prot list will be and allocate space for it */

  prots_len = 0;

  for (i = 0; Prots[i] != NULL; i++) {

    prots_len = prots_len + strlen(Prots[i]) + 2; /* Account for null etc */

  }

  /* The -1 accounts for the one byte smb_buf we have because some systems */
  /* don't like char msg_buf[]                                             */

  pkt_len = sizeof(struct SMB_Neg_Prot_Def) - 1 + prots_len;

  pkt = (struct RFCNB_Pkt *)RFCNB_Alloc_Pkt(pkt_len);

  if (pkt == NULL) {

  }

  prot_pkt = (struct SMB_Neg_Prot_Def *)(pkt -> data);

  /* Now plug in the bits we need */

  bzero(prot_pkt, sizeof(struct SMB_Neg_Prot_Def));
  prot_pkt -> smb_hdr.smb_idf = SMB_DEF_IDF;
  prot_pkt -> smb_hdr.smb_com = SMBnegprot;

  prot_pkt -> smb_hdr.smb_pid = Con_Handle -> pid;

  prot_pkt -> smb_hdr.smb_wct = 0;
  prot_pkt -> smb_bcc = prots_len;

  /* Now copy the prot strings in with the right stuff */

  p = (char *)(prot_pkt -> smb_buf);

  for (i = 0; Prots[i] != NULL; i++) {

    *p = SMBdialectID;
    strcpy(p + 1, Prots[i]);
    p = p + strlen(Prots[i]) + 2; /* Adjust len of p for null plus dialectID */

  }

  /* Now send the packet and sit back ... */

  if (RFCNB_Send(Con_Handle -> Trans_Connect, pkt, pkt_len) < 0){

    fprintf(stderr, "Error sending negotiate protocol\n");
    
    return(-1);

  }

  /* Now get the response ... */

  if (RFCNB_Recv(Con_Handle -> Trans_Connect, pkt, pkt_len) < 0) {

    fprintf(stderr, "Error receiving response to negotiate\n");
    return(-1);

  }

  resp_pkt = (struct SMB_Neg_Prot_Resp_Def *)(pkt -> data);

  if (resp_pkt -> smb_index < 0) {

    fprintf(stderr, "None of our protocols was accepted ... ");
    return(-1);

  }

#ifdef DEBUG
  fprintf(stderr, "Protocol selected is: %i:%s\n", resp_pkt -> smb_index,
	  Prots[resp_pkt -> smb_index]);
#endif
 
  Con_Handle -> protocol = resp_pkt -> smb_index;

  return(0);

}

/* Get our hostname */

void SMB_Get_My_Name(char *name, int len)

{ int loc;

  if (gethostname(name, len) < 0) { /* Error getting name */

    strncpy(name, "unknown", len);

    /* Should check the error */

#ifdef DEBUG
    fprintf(stderr, "gethostname in SMB_Get_My_Name returned error:");
    perror("");
#endif

  }

  /* only keep the portion up to the first "." */


}

/* Send a TCON to the remote server ...               */

int SMB_TreeConnect(SMB_Handle_Type Con_Handle, 
                    char *path, 
		    char *password,
		    char *device)

{

  return(-1); 

}
