/* UNIX RFCNB (RFC1001/RFC1002) NetBIOS implementation

   Version 1.0
   RFCNB Defines

   Copyright (C) Richard Sharpe 1996

*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Defines we need */

#include "rfcnb-error.h"
#include "rfcnb-common.h"

#ifdef RFCNB_PORT
#define RFCNB_Default_Port RFCNB_PORT
#else
#define RFCNB_Default_Port 139
#endif

/* Protocol defines we need */

#define RFCNB_SESSION_MESSAGE 0
#define RFCNB_SESSION_REQUEST 0x81
#define RFCNB_SESSION_ACK 0x82
#define RFCNB_SESSION_REJ 0x83
#define RFCNB_SESSION_RETARGET 0x84
#define RFCNB_SESSION_KEEP_ALIVE 0x85

/* Structures      */

typedef struct redirect_addr * redirect_ptr;

struct redirect_addr {

  struct in_addr ip_addr;
  int port;
  redirect_ptr next;

};

typedef struct RFCNB_Con {

  int fd;                     /* File descripter for TCP/IP connection */
  int errno;                  /* last error                            */
  int timeout;		      /* How many milli-secs before IO times out */
  int redirects;	      /* How many times we were redirected     */
  struct redirect_addr *redirect_list;  /* First is first address */
  struct redirect_addr *last_addr;

} RFCNB_Con;

typedef struct RFCNB_Hdr {

  unsigned char type;
  unsigned char flags;
  int16 len;

  } RFCNB_Hdr;

typedef struct RFCNB_Sess_Pkt {  /* The structure of a session packet */
    unsigned char type;
    unsigned char flags;
    int16 length;
    unsigned char n1_len;
    char called_name[33];
    unsigned char n2_len;
    char calling_name[33];
  } RFCNB_Sess_Pkt;


typedef struct RFCNB_Nack_Pkt {

  struct RFCNB_Hdr hdr;
  unsigned char error;
 
  } RFCNB_Nack_Pkt;

typedef struct RFCNB_Retarget_Pkt {

  struct RFCNB_Hdr hdr;
  int dest_ip;
  unsigned char port;

  } RFCNB_Redir_Pkt;

/* Static variables */

/* Only declare this if not defined */

extern int RFCNB_errno;

