/* Test out the RFCNB routines ...

   Version 1.0

*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "rfcnb.h"
#include <stdio.h>

/* Input name is 1234567890123456                              */
char *name1 =   "A name          ";
/* Output name   12345678901234567890123456789012              */
char *name2 =   "                                ";

void usage() 

{

  fprintf(stderr, "Usage: test_rfcnb <called-name> [<calling_name>]\n");
  fprintf(stderr, "\tIf <calling_name> is not specified, then current");
  fprintf(stderr, " hostname is used.\n");

}


int main(int argc, char *argv[])

{ void *con;
  char err_string[200];
  char called[80], calling[80];

  if (argc == 1) {

    usage();

    exit(1);

  }

  strncpy(called, argv[1], sizeof(called));

  if (argc == 2) {  /* Set calling name to called name */

    if (gethostname(calling, sizeof(calling)) < 0) { /* no name? */

      strncpy(calling, "unknown", sizeof(calling));
    }

  }
  else {

    strncpy(calling, argv[2], sizeof(calling));

  }

  RFCNB_AName_To_NBName(name1, name2);

  fprintf(stderr, "Calling %s from %s\n", called, calling);

  if ((con = RFCNB_Call(called,calling, 0)) == NULL) {

    RFCNB_Get_Error(err_string, sizeof(err_string));
    printf("Error in calling: %s ...\n", err_string);
    exit(1);

  }

  printf("The end ...\n");
}
