/* UNIX SMBlib NetBIOS implementation

   Version 1.0
   SMBlib private Defines

   Copyright (C) Richard Sharpe 1996

*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "std-defines.h"

#define SMB_DEF_IDF 0x424D53FF        /* "\377SMB" */
 
/* Core protocol commands */

#define SMBmkdir      0x00   /* create directory */
#define SMBrmdir      0x01   /* delete directory */
#define SMBopen       0x02   /* open file */
#define SMBcreate     0x03   /* create file */
#define SMBclose      0x04   /* close file */
#define SMBflush      0x05   /* flush file */
#define SMBunlink     0x06   /* delete file */
#define SMBmv         0x07   /* rename file */
#define SMBgetatr     0x08   /* get file attributes */
#define SMBsetatr     0x09   /* set file attributes */
#define SMBread       0x0A   /* read from file */
#define SMBwrite      0x0B   /* write to file */
#define SMBlock       0x0C   /* lock byte range */
#define SMBunlock     0x0D   /* unlock byte range */
#define SMBctemp      0x0E   /* create temporary file */
#define SMBmknew      0x0F   /* make new file */
#define SMBchkpth     0x10   /* check directory path */
#define SMBexit       0x11   /* process exit */
#define SMBlseek      0x12   /* seek */
#define SMBtcon       0x70   /* tree connect */
#define SMBtdis       0x71   /* tree disconnect */
#define SMBnegprot    0x72   /* negotiate protocol */
#define SMBdskattr    0x80   /* get disk attributes */
#define SMBsearch     0x81   /* search directory */
#define SMBsplopen    0xC0   /* open print spool file */
#define SMBsplwr      0xC1   /* write to print spool file */
#define SMBsplclose   0xC2   /* close print spool file */
#define SMBsplretq    0xC3   /* return print queue */
#define SMBsends      0xD0   /* send single block message */
#define SMBsendb      0xD1   /* send broadcast message */
#define SMBfwdname    0xD2   /* forward user name */
#define SMBcancelf    0xD3   /* cancel forward */
#define SMBgetmac     0xD4   /* get machine name */
#define SMBsendstrt   0xD5   /* send start of multi-block message */
#define SMBsendend    0xD6   /* send end of multi-block message */
#define SMBsendtxt    0xD7   /* send text of multi-block message */

#define SMBdatablockID     0x01  /* A data block identifier */
#define SMBdialectID       0x02  /* A dialect id            */
#define SMBpathnameID      0x03  /* A pathname ID           */
#define SMBasciiID         0x04  /* An ascii string ID      */
#define SMBvariableblockID 0x05  /* A variable block ID     */

/* Error CLASS codes and etc ... */

#define SMBC_SUCCESS        0
#define SMBC_ERRDOS         0x01
#define SMBC_ERRSRV         0x02
#define SMBC_ERRHRD         0x03
#define SMBC_ERRCMD         0xFF

/* Success error codes    */

#define SMBS_BUFFERED       0x54
#define SMBS_LOGGED         0x55
#define SMBS_DISPLAYED      0x56

/* ERRDOS Error codes     */

#define SMBD_badfunc        0x01
#define SMBD_badfile        0x02
#define SMBD_badpath        0x03
#define SMBD_nofids         0x04
#define SMBD_noaccess       0x05
#define SMBD_badfid         0x06
#define SMBD_badmcb         0x07
#define SMBD_nomem          0x08
#define SMBD_badmem         0x09
#define SMBD_badenv         0x0A
#define SMBD_badformat      0x0B
#define SMBD_badaccess      0x0C
#define SMBD_baddata        0x0D
#define SMBD_reserved       0x0E
#define SMBD_baddrive       0x0F
#define SMBD_remcd          0x10
#define SMBD_diffdevice     0x11
#define SMBD_nofiles        0x12
#define SMBD_badshare       0x20
#define SMBD_errlock        0x21
#define SMBD_filexists      0x50

/* Server errors ... */

#define SMBV_error          0x01         /* Generic error */
#define SMBV_badpw          0x02
#define SMBV_badtype        0x03
#define SMBV_access         0x04
#define SMBV_invnid         0x05
#define SMBV_invnetname     0x06
#define SMBV_invdevice      0x07
#define SMBV_qfull          0x31
#define SMBV_qtoobig        0x32
#define SMBV_qeof           0x33
#define SMBV_invpfid        0x34
#define SMBV_paused         0x51
#define SMBV_msgoff         0x52
#define SMBV_noroom         0x53
#define SMBV_rmuns          0x57
#define SMBV_nosupport      0xFFFF

/* Hardware error codes ... */

#define SMBH_nowrite        0x13
#define SMBH_badunit        0x14
#define SMBH_notready       0x15
#define SMBH_badcmd         0x16
#define SMBH_data           0x17
#define SMBH_badreq         0x18
#define SMBH_seek           0x19
#define SMBH_badmedia       0x1A
#define SMBH_badsector      0x1B
#define SMBH_nopaper        0x1C
#define SMBH_write          0x1D
#define SMBH_read           0x1E
#define SMBH_general        0x1F
#define SMBH_badshare       0x20

/* Access mode defines ... */

#define SMB_AMODE_WTRU      0x4000
#define SMB_AMODE_NOCACHE   0x1000
#define SMB_AMODE_COMPAT    0x0000
#define SMB_AMODE_DENYRWX   0x0010
#define SMB_AMODE_DENYW     0x0020
#define SMB_AMODE_DENYRX    0x0030
#define SMB_AMODE_DENYNONE  0x0040
#define SMB_AMODE_OPENR     0x0000
#define SMB_AMODE_OPENW     0x0001
#define SMB_AMODE_OPENRW    0x0002
#define SMB_AMODE_OPENX     0x0003
#define SMB_AMODE_FCBOPEN   0x00FF
#define SMB_AMODE_LOCUNKN   0x0000
#define SMB_AMODE_LOCMSEQ   0x0100
#define SMB_AMODE_LOCMRAN   0x0200
#define SMB_AMODE_LOCRAL    0x0300

/* some other defines we need */

typedef unsigned short WORD;
typedef unsigned short UWORD;
typedef unsigned int ULONG;
typedef unsigned char BYTE;
typedef unsigned char UCHAR;

/* SMB Hdr def for File Sharing Protocol? From MS and Intel,    */
/* Intel PN 138446 Doc Version 2.0, Nov 7, 1988. This def also  */
/* applies to LANMAN1.0 as well as the Core Protocol            */
/* The spec states that wct and bcc must be present, even if 0  */

struct SMB_Hdr_Def_CP {

  int        smb_idf;              /* Contains 0xFF,'SMB'   */
  BYTE       smb_com;              /* Command               */
  BYTE       smb_rcls;             /* Error Class           */
  BYTE       smb_reh;              /* reserved for future   */
  WORD       smb_err;              /* error code            */
  BYTE       smb_reb;              /* reserved              */
  WORD       smb_res[7];           /* reserved              */
  WORD       smb_tid;              /* tree id #             */
  WORD       smb_pid;              /* caller's process id # */
  WORD       smb_uid;              /* user id #             */
  WORD       smb_mid;              /* multiplex id #        */
  BYTE       smb_wct;              /* count of param words  */

/* remainder is smb_vwv[] of WORDs, smb_bcc[] of WORD that counts the bytes,
 then smb_data[] */

} SMB_Hdr_Def_CP;

/* SMB Hdr definitions V3.0 Doc V1.09 from Nov 29, 1989        */
/* This version says that it is LM1.2, but the structure seems */
/* apply to LM2.0 as well.                                     */
/* The spec states that wct and bcc must be present, even if 0 */

struct SMB_Hdr_Def_LM12 {

  int        smb_idf;              /* Contains 0xFF,'SMB'   */
  BYTE       smb_com;              /* Command               */
  BYTE       smb_rcls;             /* Error Class           */
  BYTE       smb_reh;              /* reserved for future   */
  WORD       smb_err;              /* error code            */
  BYTE       smb_flg;              /* flags                 */
  WORD       smb_flg2;             /* flags                 */
  WORD       smb_res[6];           /* reserved              */
  WORD       smb_tid;              /* tree id #             */
  WORD       smb_pid;              /* caller's process id # */
  WORD       smb_uid;              /* user id #             */
  WORD       smb_mid;              /* multiplex id #        */
  BYTE       smb_wct;              /* count of param words  */

/* remainder is smb_vwv[] of WORDs, smb_bcc[] of WORD that counts the bytes,
 then smb_data[] */

} SMB_Hdr_Def_LM12;

/* Negotiate protocol packet */

struct SMB_Neg_Prot_Def {

  struct SMB_Hdr_Def_LM12 smb_hdr;
  WORD       smb_bcc;              /* Count of bytes in prot list */
  BYTE       smb_buf[1];           /* List of dialects            */
                                   /* format is a list of strings,*
                                   /* each with SMBasciiID on     */
				   /* front ... Some compilers    */
                                   /* seem to require some space  */
				   /* in smb_buf                  */
};

/* Negotiate protocol response packet */

struct SMB_Neg_Prot_Resp_Def {

  struct SMB_Hdr_Def_LM12 smb_hdr;
  WORD       smb_index;             /* Index of the accepted prot */
                                    /* also called smb_wvw[0]     */
  WORD       smb_bcc;               /* = 0                        */

};

struct SMB_TCon_Prot_Def {

  struct SMB_Hdr_Def_LM12 smb_hdr;
  WORD       smb_bcc;              /* Count of bytes in prot list */
  BYTE       smb_buf[1];           /* Path, user, dev sep by 0x04 */

};

struct SMB_TCon_Resp_Def {

  struct SMB_Hdr_Def_LM12 smb_hdr;
  WORD       smb_max_xmit;         /* vwv[0] is max xmit size    */
  WORD       smb_TID;              /* vwv[1] is returned tree id */
  WORD       smb_bcc               /* Will be zero               */

};

struct SMB_Open_Prot_Def {

  struct SMB_Hdr_Def_LM12 smb_hdr;
  WORD       smb_mode;             /* vwv[0] with r/w/share mode */
  WORD       smb_attr;             /* vwv[1] with attributes     */
  WORD       smb_bcc;              /* Size of file name etc      */
  BYTE       smb_buf[1];           /* start of file path name etc*/

};

struct SMB_Open_Resp_Def {

  struct SMB_Hdr_Def_LM12 smb_hdr;
  WORD       smb_fhndl;           /* returned FID                */
  WORD       smb_attr;            /* attributes                  */
  ULONG      smb_time;
  ULONG      smb_size;
  WORD       smb_access;          /* Access allowed              */
  WORD       smb_bcc;             /* will be zero                */

};

struct SMB_Close_Prot_Def {
  struct SMB_Hdr_Def_LM12 smb_hdr;
  UWORD      smb_fhndl;           /* FID of file to close        */
  ULONG      smb_time;            /* time of last modification   */
  UWORD      smb_bcc;             /* Will be zero                */

};

/* Structures and defines we use in the client interface */

/* The protocols we might support. Perhaps a bit ambitious, as only RFCNB */
/* has any support so far 0(sometimes called NBT)                         */

typedef enum {SMB_RFCNB, SMB_NETBEUI, SMB_X25} SMB_Transport_Types;

typedef enum {SMB_Con_FShare, SMB_Con_PShare, SMB_Con_IPC} SMB_Con_Types;

typedef enum {SMB_State_NoState, SMB_State_Stopped, SMB_State_Started} SMB_State_Types;

typedef enum {SMB_Core, SMB_CorePlus, SMB_LanMan1, SMB_LanMan2, SMB_NT1} SMB_Protocol_Types;

static char *SMB_Prots[] = {"PC NETWORK PROGRAM 1.0", 
/*			    "MICROSOFT NETWORKS 1.03",
			    "MICROSOFT NETWORKS 3.0",
			    "LANMAN1.0",
			    "LM1.2X002",
			    "Samba",
			    "NT LM 0.12",
			    "NT LANMAN 1.0", */
			    NULL};

typedef struct SMB_Connect_Def * SMB_Handle_Type;

struct SMB_Connect_Def {

  SMB_Handle_Type Next_Con, Prev_Con;          /* Next and previous conn */
  int SMB_Errno;                               /* Error                  */
  int protocol;                                /* What is the protocol   */
  void *Trans_Connect;                         /* The connection         */

  /* All these strings should be malloc'd */

  char service[80], username[80], password[80], desthost[80], sock_options[80];
  char myname[80];

  int gid;         /* Group ID, do we need it?                      */
  int mid;         /* Multiplex ID? We might need one per con       */
  int pid;         /* Process ID                                    */
  int tid;         /* authenticated resource id. Need one per tcon? */
  int uid;         /* Authenticated user id.                        */

                   /* It is pretty clear that we need to bust some of */
                   /* these out into a per TCon record, as there may  */
                   /* be multiple TCon's per server, etc ... later    */

  int port;        /* port to use in case not default, this is a TCPism! */

  int max_xmit;    /* Max xmit permitted by server                  */

};

typedef struct SMB_File_Def SMB_File;

struct SMB_File_Def {

  SMB_Handle_Type con;
  char filename[256];          /* We should malloc this ... */
  UWORD fid;
  unsigned int lastmod, size;
  UWORD access;

};

/* global Variables for the library */

static SMB_State_Types SMBlib_State = SMB_State_NoState;

