/* A test for smblib ... */

#include <sys/types.h>
#include <unistd.h>

#include "smblib.h"

int verbose = FALSE;

char data[65536] = "Now is the time for all birds to roost.";

void usage()

{

  fprintf(stderr, "test_smblib [-s <file-service>] [-w <write-size] server\n");

}

char *SMB_Prots[] = {"PC NETWORK PROGRAM 1.0", 
			    "MICROSOFT NETWORKS 1.03",
			    "MICROSOFT NETWORKS 3.0",
			    "DOS LANMAN1.0",
			    "LANMAN1.0",
			    "DOS LM1.2X002",
			    "LM1.2X002",
			    "DOS LANMAN2.1",
			    "LANMAN2.1",
			    "Samba",
			    "NT LM 0.12",
			    "NT LANMAN 1.0",
			    NULL};

main(int argc, char *argv[])

{ void *con, *file, *tree;
  extern char *optarg;
  extern int optind;
  int opt, actual_size, i, written, error, SMB_Error, err_class, err_code;
  char server[80], service[80], service_name[160], password[80], username[80];
  char file_name[80], error_message[1024], slosh = '\\', err_string[1024];
  int lotc = FALSE, prot;

  actual_size = 8192;
  strcpy(service, "msfax");
  strcpy(username, "fred");

  while ((opt = getopt(argc, argv, "b:s:w:u:lv")) != EOF) {

    switch (opt) {
    case 's':

      strcpy(service, optarg);
      break;

    case 'w':

      actual_size = atoi(optarg) * 1024;
      break;

    case 'b':     /* set the slosh character */
      slosh = *optarg;
      break;

    case 'u':     /* Pick up the user name */

      strncpy(username, optarg, sizeof(username) - 1);
      break;

    case 'l':     /* do a logon and tree connect ... */
      lotc = TRUE;
      break;

    case 'v':     /* Set verbose flag */
      verbose = TRUE;
      break;

    default:

      usage();
      exit(1);
      break;
    }

  }

  if (actual_size < 1024)
    actual_size = 1024;

  if (actual_size > sizeof(data))
    actual_size = sizeof(data);

  if (optind < argc) { /* Some more parameters, assume is the server */
    strncpy(server, argv[optind], sizeof(server) - 1);
    optind++;

    if (optind < argc) { /* Pick up password ... */
      strncpy(password, argv[optind], sizeof(password) -1);
    }
    else {
      strcpy(password, "nurk");
    }
  }
  else {
    strcpy(server, "nemesis");
  }

  SMB_Init();          /* Initialize things ... */

  sprintf(service_name, "%c%c%s%c%s", slosh, slosh, server, slosh, service);

  strcpy(file_name, "netfax.q");

  fprintf(stderr, "Connecting to %s ...\n", service_name);

  if (lotc == TRUE) { /* Then do the combined crap, else ... */

    /* We must do a connect server and a negotiate first */

    con = SMB_Connect_Server(NULL, server);

    if (con == NULL) {  /* Error processing */

      fprintf(stderr, "Unable to connect to server %s ...\n", server);

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }

      printf("  %s\n", err_string);
      exit(1);

    }

    /* We need to negotiate a protocol better than PC NetWork Program */

    if (SMB_Negotiate(con, SMB_Prots) < 0) {

      fprintf(stderr, "Unable to negotiate a protocol with server %s ...\n",
	      server);

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }

      printf("  %s\n", err_string);
      exit(1);

    }

    if (verbose == TRUE) {

      prot = SMB_Get_Protocol_IDX(con);
      fprintf(stderr, "The protocol negotiated was %i: %s\n", prot,
	      SMB_Prots[prot]);
      
    }

    /* Should check the protocol level ... */

    if (SMB_Logon_TCon_Open(con, username, password, service, "A:",
			    file_name, SMB_AMODE_OPENRW, SMB_FA_ORD, &file) < 0) {

      fprintf(stderr, "Unable to logon and tree connect to server %s ...\n",
	      server);

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }

      printf("  %s\n", err_string);

      exit(1);       /* Too bad ... */
    }

    fprintf(stderr, "  The Max Buffer Size is %i\n", SMB_Get_Max_Buf_Siz(con));

  }
  else {

    con = SMB_Connect(NULL, &tree, service_name, "Guest", password);

    if (con == NULL) { /* Error ... */

      fprintf(stderr, "Unable to connect ... \n");

      error = SMB_Get_Last_Error();                  /* Find out the problem */

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);
	
      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }
	
      fprintf(stderr, "  %s\n", err_string);

      exit(1);  /* Can't proceed ... */

    }

    fprintf(stderr, "  The Max Buffer Size is %i\n", SMB_Get_Max_Buf_Siz(con));

    fprintf(stderr, "Attempting to open \'%s\' ...\n", file_name);

    file = SMB_Open(con, NULL, file_name, SMB_AMODE_OPENRW, SMB_FA_ORD);

  }

  fprintf(stderr, "  The Max Buffer Size is %i\n", SMB_Get_Max_Buf_Siz(con));

  if (file != NULL) { /* Now close the file ... */

    /* Now write and close the file ... */

    for (i=0; i< actual_size; i++)
      data[i] = (char)(i & 0xFF);

    strncpy(data + actual_size - 20, "abcdefghijklmnopqrs", 19);

    fprintf(stderr, "Attempting to write %i bytes to the file ... \n",
	    actual_size);

    written = SMB_Write(file, data, actual_size);

    if (written < 0) { /* An error, what is it ... */

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);

      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }

      fprintf(stderr, "Write error: %s\n", error_message);

      exit(1);  /* Can't proceed ... */

    }

    fprintf(stderr, "Bytes written = %i\n", written);

    fprintf(stderr, "Now setting file pos to 512 and writing again ...\n");

    SMB_Lseek(file, 512, SEEK_SET);

    written = SMB_Write(file, data, actual_size);

    if (written < 0) {  /* What is the error? */

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);
	
      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }
	
      fprintf(stderr, "  %s\n", err_string);

      exit(1);  /* Can't proceed ... */

    }

    fprintf(stderr, "Bytes written = %i\n", written);

    fprintf(stderr, "Now read from start for 1024 bytes ...\n");

    SMB_Lseek(file, 0, SEEK_SET);

    for (i = 0; i < sizeof(data); i++)
      data[i] = 0xff;

    SMB_Read(file, data, 1024); 

    fprintf(stderr, "Attempting to close the file just opened ...\n");
    SMB_Close(file);

  }
  else { /* Error opening the file */
    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);
	
    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }
	
    fprintf(stderr, "Error opening file: %s\n", err_string);

    exit(1);  /* Can't proceed ... */

  }

  fprintf(stderr, "Attempting to create file 'xyzwertyaaa.dfgty' ...\n");

  file = SMB_Create(con, NULL, "xyzwertyaaa.dfgty", SMB_FA_ORD);

  if (file != NULL) { /* Do something with the file ... */

    /* Now attempt to write the file ... */

    fprintf(stderr, "The file was opened OK. So now write it ...\n");

    written = SMB_Write(file, data, actual_size);

    if (written < 0) {   /* What is the error */

      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);
	
      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }
	
      fprintf(stderr, "Error writing: %s\n", err_string);

      exit(1);  /* Can't proceed ... */

    }

    fprintf(stderr, "Bytes written: %i\n", written);

    fprintf(stderr, "Now close the file just created ...\n");

    SMB_Close(file);

  }

  fprintf(stderr, "Attempting to delete the file 'delete.txt' ...\n");

  if (SMB_Delete(con, "delete.txt", SMB_FA_ORD) < 0) {

    fprintf(stderr, "The file could not be deleted ... \n");

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);
	
    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }
	
    fprintf(stderr, "  %s\n", err_string);

    fprintf(stderr, "Perhaps we are talking to PW4Ultrix ..., try again ...\n");
    fprintf(stderr, "Trying to delete \\DELETE.TXT ... \n");

    if (SMB_Delete(con, "\\DELETE.TXT", SMB_FA_ORD) < 0) {
      fprintf(stderr, "Still could not be deleted ...\n");
  
      if (SMB_Get_Last_Error() == SMBlibE_Remote) {

	SMB_Error = SMB_Get_Last_SMB_Err();
	SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			      SMBlib_Error_Code(SMB_Error),
			      err_string,
			      sizeof(err_string) - 1);
	
      }
      else {
	SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
      }
      
      fprintf(stderr, "  %s\n", err_string);

    }
    else {
      fprintf(stderr, "Deleted now ...\n");
    }
  }
  else {

    fprintf(stderr, "The file was deleted ... \n");

  }

  strcpy(file_name, "alongnamehurts.txt");

  fprintf(stderr, "Attempting to open '%s' ...\n", file_name);

  file = SMB_Create(con, NULL, file_name, 0);

  if (file == NULL) { /* It failed ... why? */

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);
	
    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }
      
    fprintf(stderr, "File \'%s\' could not be created!\n  %s\n", 
	    file_name, err_string);

  }

  strncpy(file_name, "another-dir-name", sizeof(file_name) - 1);

  fprintf(stderr, "Attempting to create directory \'%s\' ...\n", file_name);

  if (SMB_Create_Dir(con, file_name) < 0) {

    fprintf(stderr, "Creating directory \'%s\' failed ...\n", file_name);

  }

  fprintf(stderr, "Attempting to check the directory \'%s\' ...\n", file_name);

  if (SMB_Check_Dir(con, file_name) < 0) {

    if (SMB_Get_Last_Error() == SMBlibE_Remote) {

      SMB_Error = SMB_Get_Last_SMB_Err();
      SMB_Get_SMB_Error_Msg(SMBlib_Error_Class(SMB_Error),
			    SMBlib_Error_Code(SMB_Error),
			    err_string,
			    sizeof(err_string) - 1);
	
    }
    else {
      SMB_Get_Error_Msg(SMB_Get_Last_Error(), err_string, sizeof(err_string) - 1);
    }
      
    fprintf(stderr, "Directory \'%s\' could not be checked!\n  %s\n", 
	    file_name, err_string);

  }

  fprintf(stderr, "Attempting to delete directory \'%s\' ... \n", file_name);

  if (SMB_Delete_Dir(con, file_name) < 0) {

    fprintf(stderr, "Deleting directory \'%s\' failed ...\n", file_name);

  }
  

  fprintf(stderr,"Done\n");

}
