/**
 * Copyright 2009 Opera Software ASA. All rights reserved.
 
 *This file contains Original Code and/or Contributions to the Original 
 *Code as defined in the Opera Web Applications License (the License). 
 *You may not use this file except in compliance with the License. Please 
 *obtain a copy of the License at http://www.opera.com/license/owal/
 *and read it before using this file. 

 *The Original Code and all Contributions to the Original Code distributed 
 *under the License are distributed on an AS IS basis, WITHOUT WARRANTY 
 *OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 *SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 *MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 

 *Please see the License for the specific language governing rights and 
 *limitations under the License.
 */



//For generating drop down menu dynamically from google server.
function googleInitCallback()
{
    clearTimeout(g_googleTimeout);
	$('loader').style.display = 'none';
    $('errorMessageContainer').style.display = 'none';
    $('content').style.display = 'block';
	languageList();
	google.language.getBranding(branding);
}

/***
 * Putting Detect Language on top of drop down
 * Removing one of chinese language type
 * No Detect Language in target language drop down
*/

function languageList()
{
	var srcLanguage = $('sourceLanguage');
    var tgtLanguage = $('targetLanguage');
	var l = 1;
    for (l in google.language.Languages)
    {
        var lng = l.toLowerCase();
        var lngCode = google.language.Languages[l];
        if (google.language.isTranslatable(lngCode) && lng != "chinese") 
        {
		    if (lng == g_sourceDefaultLanguage )
            {
				if(lng == 'unknown')
				{
					var unknownSubstitute = 'detect Language';
					srcLanguage.options.add(new Option(purifyString(unknownSubstitute), lngCode,'selected'),0);
				}
				else
				{
					srcLanguage.options.add(new Option(purifyString(lng), lngCode,'selected'));
				}
            }
            else
            {
				if(lng == 'unknown')
				{
					var unknownSubstitute = 'detect Language';
					srcLanguage.options.add(new Option(purifyString(unknownSubstitute), lngCode),0);
				}
				else
				{
					srcLanguage.options.add(new Option(purifyString(lng), lngCode));
				}
            }
            if(lng != 'unknown')
            {
                if (lng == g_targetDefaultLanguage)
                {
                    tgtLanguage.options.add(new Option(purifyString(lng), lngCode,'selected'));
                }
                else
                {
                    tgtLanguage.options.add(new Option(purifyString(lng), lngCode));
                }
            }
            
        }
    }
	//translateText();
	textAlignState();
}

function purifyString(string)
{
    var temp = string.substring(0, 1).toUpperCase()+ string.substring(1);
    temp=temp.replace('_', ' ');
    return temp;
}

function languageDetect(text)
{
    var srcLanguage = $('sourceLanguage');
    google.language.detect(text, function(result) {
    if (!result.error) 
    {
        for (l in google.language.Languages) 
        {
            if (google.language.Languages[l] == result.language) 
            {
                var lng = l.toLowerCase();
                var i = 0;
                for(i in srcLanguage.options)
                {   
                    if(srcLanguage.options[i].value == result.language )
                    {
                        srcLanguage.options[i].selected = 'true';
                    }
				}            
            }
        }

    }
    });
}

function xhrTranslationRequest(text)
{
    var srcLanguageCode = $('sourceLanguage').value;
	var tgtLanguageCode = $('targetLanguage').value;
	var url = 'http://ajax.googleapis.com/ajax/services/language/translate';
	xhr = new XMLHttpRequest();
	xhr.open('POST', url ,true);
	xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xhr.onreadystatechange = function()
	{    
		clearTimeout(g_translateTimeout);
		if (this.readyState == 4)
		{
			if( this.status == 200)
			{
				clearTimeout(g_translateTimeout);
				var data = eval('(' + xhr.responseText + ')');
				var googleResponse = data.responseData.translatedText;
				var translated = $('translatedText');
				$('swap').onclick = function(){swapLanguage();};
				$('swap').dropClass('swapDisabled');
				$('swap').addClass('swapButton');
				$('translate').onclick = function() { translateText();};
				if(tgtLanguageCode == 'ar' || tgtLanguageCode == 'iw')
				{
					$('translatedText').dropClass('translatedBox');
					$('translatedText').addClass('translatedBoxRtl');
				}
				else
				{
					$('translatedText').dropClass('translatedBoxRtl');
					$('translatedText').addClass('translatedBox');
				}
				$('translatingView').style.display = 'none';
				$('translatedText').style.display = 'block';
				$('translateText').textContent = 'Translate';
				translated.innerHTML = googleResponse;
				enableElements();
			}
			else if(this.readyState == 4 && this.status != 200)
			{
				resetOnError();
			}
		}
		else
		{
			g_translateTimeout = setTimeout('resetOnError()', 1000 * 30);
		}
	}
	xhr.send('v=1.0&q='+encodeURIComponent(text)+'&langpair='+(srcLanguageCode)+'%7C'+(tgtLanguageCode));
}