/**
 * Copyright 2009 Opera Software ASA. All rights reserved.
 
 *This file contains Original Code and/or Contributions to the Original 
 *Code as defined in the Opera Web Applications License (the License). 
 *You may not use this file except in compliance with the License. Please 
 *obtain a copy of the License at http://www.opera.com/license/owal/
 *and read it before using this file. 

 *The Original Code and all Contributions to the Original Code distributed 
 *under the License are distributed on an AS IS basis, WITHOUT WARRANTY 
 *OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 *SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 *MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 

 *Please see the License for the specific language governing rights and 
 *limitations under the License.
 */


//when widget is loaded
var google = null;
var g_googleTimeout;
var g_flag = false;
var g_sourceDefaultLanguage;
var g_targetDefaultLanguage;
var g_translateTimeout;
var xhr;
var g_xhrAbort;


/**
 * When widget is loaded
 * We can set language of widget
 * @param loaded(bool) Checking for google server and timeout  
*/

window.addEventListener('load',onLoad,false);
function onLoad()
{    
	window.setLanguage( 'en', function(){ document.toLocale(); } );
    var loaded = false;
    googleServerCheck(loaded);   
    $('swap').onclick = function (){swapLanguage();} ;
    $('translate').onclick = function () {translateText();};
    $('textToTranslate').addEventListener('focus', clearTextField,false);   
    $('textToTranslate').value = 'Enter text ';
	$('textToTranslate').style = 'color:#7c7c7c;';
    $('errorMsg').textContent = 'Error:Cannot access Google Translate. Please check your Internet connection.';
    $('retryText').textContent = 'Retry';
    $('retry').addEventListener('click', loadAfterRetry ,false);
    $('translateText').textContent = 'Translate';
	defaultLanguage();
	$('sourceLanguage').onchange  = function (){textAlignState();};
}


/***
 * Setting text alignment
 * @param temp(object) corresponding to input text area
*/

function textAlignState()
{
	var temp = $('textToTranslate');
	//opera.postError('onchange1 '+$('sourceLanguage').value);
	if($('sourceLanguage').value == 'ar' || $('sourceLanguage').value == 'iw')
	{
		temp.setAttribute('dir','rtl');
	}
	else
	{
		temp.setAttribute('dir','ltr');
	}
}
function googleServerCheck(loaded)
{
    $("jsLoader").onload = function()
    {
		if(google != null)
        {
			loaded = true;
        }
    }  
    $("jsLoader").src = "google.html";
    g_googleTimeout = setTimeout(function()
    {
        if(!loaded)
		{
            networkTimeout();
		}
    }, 1000 * 30);
}

/***
 * Setting the Default Select Options
 * @param sdl(string) A key corresponding to SOURCE DEFAULT LANGUAGE
 * @param tdl(string) A key corresponding to TARGET DEFAULT LANGUAGE
*/

function defaultLanguage()
{
	if(widget.preferenceForKey('sdl') !='' && widget.preferenceForKey('tdl') !='')
	{
		g_sourceDefaultLanguage = widget.preferenceForKey('sdl').toLowerCase();
		g_targetDefaultLanguage = widget.preferenceForKey('tdl').toLowerCase();
	}
	else
	{	
		g_sourceDefaultLanguage = 'unknown';
		g_targetDefaultLanguage = 'english';
	}
}



function loadAfterRetry()
{
    $('errorMessageContainer').style.display = 'none';
    $('loader').style.display = 'block';
    googleServerCheck();
    $('translatedText').innerHTML = '';
    $('textToTranslate').value = 'Enter text ';
}

function networkTimeout()
{
   clearTimeout(g_googleTimeout);
   $('loader').style.display = 'none';
   $('errorMessageContainer').style.display = 'block';
   $('retry').focus();
}
function resetOnError()
{
	clearTimeout(g_translateTimeout);
	$('translatedText').innerHTML = '';
	$('translatedText').style.display = 'none';
	$('translatingView').style.display = 'none';
	$('swap').onclick = function() {swapLanguage();};
	$('translate').onclick = function() { translateText();};
	$('translateText').textContent = 'Translate';
	$('swap').dropClass("swapDisabled");
	$('swap').addClass("swapButton");
	enableElements();
	if(!g_xhrAbort)
	{
		$('translateError').style.display = 'block';//error message is displayed only when network timeout but not on abort 
	}
}

/***
 * @param sdl(string) A key corresponding to SOURCE DEFAULT LANGUAGE
 * @param tdl(string) A key corresponding to TARGET DEFAULT LANGUAGE
 * @param temp1(string) String to be set preference for source language
 * @param temp2(string) String to be set preference for target language
*/

//final translation
function translateText()
{    
	g_xhrAbort = false;
	clearTimeout(g_translateTimeout);
    text = $("textToTranslate").value;
    $('swap').onclick = null;
	$('swap').dropClass("swapButton");
	$('swap').className +="swapDisabled";
	var temp1 = $('sourceLanguage').children[$('sourceLanguage').selectedIndex].firstChild.nodeValue;
	var temp2 = $('targetLanguage').children[$('targetLanguage').selectedIndex].firstChild.nodeValue;
	widget.setPreferenceForKey(temp1,'sdl');
	widget.setPreferenceForKey(temp2,'tdl');
	//Use of regular expression for embedding a html tag at newline, HTML tag are not converted by Google translate
	text = text.replace(/\r\n/g, '<br/>');
    if(text && g_flag == true)
    {
		//$('translatedText').style.display = 'block';
		$('translateError').style.display = 'none';
		$('translatedText').innerHTML = '';
		$('translatedText').style.display = 'none';
		$('translatingView').style.display = 'block';
		$('translateText').textContent = 'Cancel';
		disableElements();
		$('translate').onclick = function() {xhr.abort();g_xhrAbort = true;resetOnError();};
        if ( $('sourceLanguage').options.value == '' )
		{
            languageDetect(text);
		}
		xhrTranslationRequest(text);
    }
    else
    {
		opera.postError('empty...');
        $('translatedText').innerHTML = '';
		$('textToTranslate').value = 'Enter text ';
		$('textToTranslate').style = 'color:#7c7c7c;';
		g_flag = false;
		$('translatedText').style.display = 'none';
		$('swap').dropClass('swapDisabled');
		$('swap').addClass('swapButton');
	}
}

function swapLanguage()
{
    var srcLanguage = $('sourceLanguage');
    var tgtLanguage = $('targetLanguage');
	if(srcLanguage.value != '')
	{
		var newSrcLanguage = tgtLanguage.options.value;
		var newtgtLanguage = srcLanguage.options.value;    
		var i = 0;    
		for( i in srcLanguage.options)
		{
			if(srcLanguage.options[i].value == newSrcLanguage)
			{
				srcLanguage.options[i].selected = 'true';
			}      
		}   
		var j = 0;
		for( j in tgtLanguage.options)
		{
			if(tgtLanguage.options[j].value == newtgtLanguage)
			{
				tgtLanguage.options[j].selected = 'true';
			}           
		}
		textAlignState();
		swapText();
	}
}

function swapText()
{
    var t1 = $('textToTranslate').value;
    var t2 = $('translatedText').innerHTML;
	if(t2 != '')
	{
		$('textToTranslate').value= '';
		$('translatedText').innerHTML = '';
		//opera.postError('start ' +t2);
		t2 = t2.replace(/\s*\<BR\>\s*/g,'\r\n');
		//opera.postError('end ' +t2);
		$('textToTranslate').value = t2;
		translateText();
	}
    else  if(t2 == '' || (t1!= 'Enter text'))
    {
        //no swapping
    }
	else
	{
		$('textToTranslate').value = 'Enter text ';
		g_flag = false;
	}
}

function disableElements()
{
	$('textToTranslate').setAttribute('readonly','readonly');
	$('sourceLanguage').setAttribute('disabled','true');
	$('targetLanguage').setAttribute('disabled','true');
}

function enableElements()
{
	$('textToTranslate').removeAttribute('readonly');
	$('sourceLanguage').removeAttribute('disabled');
	$('targetLanguage').removeAttribute('disabled');
}

