/**
* Copyright (c) 2007-2009, Opera Software ASA
* All rights reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of Opera Software ASA nor the
*       names of its contributors may be used to endorse or promote products
*       derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY OPERA SOFTWARE ASA AND CONTRIBUTORS ``AS IS'' AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL OPERA SOFTWARE ASA AND CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/*
 *  list of language strings
 */
window.languages =
{
    'en' : 'lang/en.js',
    'es' : 'lang/es.js',
    'de' : 'lang/de.js',
    'it' : 'lang/it.js'
};

/*
 *  failsafe for the pauselayout & continuelayout methods
 */
opera.pauselayout       = opera.pauselayout||function(){};
opera.continuelayout    = opera.continuelayout||function(){};

/*
 *  HTMLDocument.prototype.getElementsByIdOrName
 */

function getElementsByIdOrName(doc, val) {
    return doc.selectNodes("//*[@id='"+val+"' or @name='"+val+"']");
}

HTMLDocument.prototype.getElementsByIdOrName = function( val )
{
    return getElementsByIdOrName(this, val);
};

/**
 *  the Wikipedia
 */
Wikipedia = new (function()
{
    var _baseUri            = 'http://en.wikipedia.org/wiki/';

    var _h                  = {};

    var _article_title      = '';
    var _article_document   = null;
    var _article_hasToc     = false;
    var _article_tocHash    = [];
    var _article_tocLength  = 0;
    var _isSearchPage       = false;

    var _keyword_random     = 'Special:Random';
    var _keyword_search     = 'Special:Search?go=Go&search=';

    var _history            = (widget.preferenceForKey('history')!=''?widget.preferenceForKey('history').split('\03'):[]);
    var _lastSearch         = '';
    
    var _gpsPages           = (widget.preferenceForKey('gpspages')!=''?widget.preferenceForKey('gpspages').split('\03'):[]);
    var _currentlyViewing   = 0;     // would be either gpsNoOfPages2 or gpsNoOfPages3
    var _isGpsUpdated       = false;
    
    var _prevSection        = '';
    var _nextSection        = '';
    var _preferences        =
    {
        historyMax  : 10,
        language    : widget.preferenceForKey('language')||navigator.language||'en',
        gpsNoOfPages1      : 3,
        gpsNoOfPages2      : 9,
        gpsNoOfPages3      : 25
    }

    // Random GPS data (for testing/demo)
    var _gpsData = 
    [
        {place: 'Paris, France', lat: 48.8565, lng: 2.351},
        {place: 'Sydney, Australia', lat: -33.866, lng: 151.207},
        {place: 'Panjab, Afghanistan', lat: 34.379, lng: 67.033},
        {place: 'RishiKesh, Uttarakhand', lat: 30.265, lng: 77.987},
        {place: 'Bogotá, Colombia', lat: 4.655, lng: -74.096},
        {place: 'Santiago, Chile', lat: -33.45, lng: -70.667},
        {place: 'London, UK', lat: 51.5, lng: 0},
        {place: 'Hobart, Australia (Tasmania)', lat: -42.882, lng: 147.330},
        {place: 'Rapa Nui', lat: -27.151, lng: -109.382},
        {place: 'Praia (Cape Verde)', lat: 16.002, lng: -24.013}
    ]
    
    /*
     *  onload -> initialize
     */
    window.addEventListener
    (
        'load',
        function(/* initialize the Wikipedia singleton */)
        {
            //  max width of the widget
            widgetModes.setMaxSize( '40ex' );

            //  get various handles
            _h.tocUl            = $('wdgt-toc');
            _h.articleContent   = $('article-content');
            _h.views            = $('views');
            _h.historyUl        = $('wdgt-history');
            _h.language         = $('wdgt-language');
            _h.activity         = $('wdgt-activity');
            _h.closeBy          = $('wdgt-closeby');

            //  set default language
            this.setLanguage( _preferences.language, function()
            {
                // add popup to the dialog
                _h.txtLatitude  = document.getElementById('wdgt-latitude');
                _h.txtLongitude = document.getElementById('wdgt-longitude')
                _h.popup = document.createElement('div');
                _h.popup.appendChild( $('div_popup') );
                _h.popup.firstChild.style.display = 'block';

                

                //  create the _article_document
                _article_document = document.implementation.createDocument( 'http://www.w3.org/1999/xhtml', 'html', null );
                _article_document.documentElement.appendChild( _article_document.createElement( 'body' ) );
                _article_document.body = _article_document.documentElement.lastChild;


                //  attach the _linkHandler to the content
                //_h.tocUl.onclick             =
                _h.views.addEventListener
                (
                    'click',
                    _linkHandler.bind( this ),
                    true
                );

                //  _h.language -> cycle through  _preferences.languages
                _h.language.addEventListener
                (
                    'click',
                    function()
                    {
                        var options     = {}
                        options.title   = 'Select a language'.toLocale();
                        options.buttons =
                        [
                            {
                                label   :'English'.toLocale(),
                                callback:function(){ Wikipedia.setLanguage('en'); }
                            },
                            {
                                label   :'Spanish'.toLocale(),
                                callback:function(){ Wikipedia.setLanguage('es'); }
                            },
                            {
                                label   :'German'.toLocale(),
                                callback:function(){ Wikipedia.setLanguage('de'); }
                            },
                            {
                                label   :'Italian'.toLocale(),
                                callback:function(){ Wikipedia.setLanguage('it'); }
                            }
                        ];


                        Dialog.showMessage( '', options );

                    }.bind( this ),
                    false
                );

                //  bypass the wdgt-search submit to search
                $('wdgt-search').onsubmit = function(event)
                {
                    event.preventDefault();
                    var keyword = document.getElementById('wdgt-query').value.trim();
                    if( keyword!=='' )
                    {
                        this.search( keyword );
                    }
                }.bind( this );

                //  handle missingViews --> event
                window.addEventListener
                (
                    'missingView',
                    _missingViewHandler.bind( this ),
                    true
                );

                // update gpsPages
                _updateGpsHistory();
                
                //  update history
                _updateHistory();

                //  switch view
                Views.show( 'view_home' );
                $('wdgt-query').focus();
            
            }.bind(this) );
        }.bind( this ),
        false
    );

    /*
     *  _missingViewHandler
     */
    function _missingViewHandler( event )
    {
        var data = event.data;
        if( data=='wikipedia_randomArticle' )
        {
            this.search();
        }
        else if( data=='wikipedia_nextSection' )
        {
            _renderSection( _nextSection );
        }
        else if( data=='wikipedia_prevSection' )
        {
            _renderSection( _prevSection );
        }
        else if( ~data.indexOf('wikipedia_history ') || ~data.indexOf('wikipedia_closeby ') )
        {
            var keyword     = data.slice( 'wikipedia_history '.length ).split( ' ' ),
                language    = keyword.shift();

            this.setLanguage( language );
            this.search( keyword.join(' ') );
        }
        else if( ~data.indexOf('topPage9') )
        {
            if( ! widget.preferenceForKey( 'gpspages'  ) )
            {
                _showGeoPopup();
            }
            else
            {
                Views.show('view_topPages');
            }
        }
        else if( ~data.indexOf('topPage25') )
        {
            //Views.show('view_topPages');
            _fetchData(_preferences.gpsNoOfPages3);
        }
        else if( ~data.indexOf('refreshData') )
        {
            //  TODO: 1. Update GPS location, 2. Fetch data
             
            _showGeoPopup();
            //_fetchData( _currentlyViewing );
        }
        else if( ~data.indexOf('randomGpsData') )
        {
            var index = rand(0, 9);
            _h.txtLatitude.value  = _gpsData[index].lat;
            _h.txtLongitude.value = _gpsData[index].lng;
        }
     }
    
    function _fetchData( noOfPages )
    {
        var lat = _h.txtLatitude.value.trim();
        var lng = _h.txtLongitude.value.trim();
        if( lat != '' && lng != '')
        {
            widget.setPreferenceForKey( lat, 'latitude'  );
            widget.setPreferenceForKey( lng, 'longitude' );
            
            // Gps location has been updated
            if( !noOfPages )
            {
                _isGpsUpdated = true;
            }
            
            _loadPagesCloseBy( lat, lng, noOfPages || _preferences.gpsNoOfPages2 );
        }
    }

    /*
     *  setLanguage
     *  set baseUri for the requests
     */
    this.setLanguage = function( language, callback )
    {
        if( !(language in window.languages) )
        {
            var language = language.split('-')[0];
        }
        if( !(language in window.languages) )
        {
            var language = 'en';
        }

        if( language in window.languages )
        {
            _preferences.language   = language;
            _baseUri                = 'http://' + language + '.wikipedia.org/wiki/';
            _h.language.textContent = language.toUpperCase();
            widget.setPreferenceForKey( _preferences.language, 'language' );
            
            window.setLanguage( language, function()
            { 
                document.toLocale(); 
                if ( callback ) callback();
            } );

            //  try to fecth the article in the new language
            if( _lastSearch )
            {
                this.search( _lastSearch );
            };
        }
    }



    /*
     *  _search_normalizeKeyword
     */
    function _search_normalizeKeyword( str )
    {
        var kanaMap =
        [
            // normal cases (incomplete)
            { 0x8A:0x30CF, 0x8B:0x30D2, 0x8C:0x30D5, 0x8D:0x30D8, 0x8E:0x30DB },
            // tenten (ﾞ) cases (incomplete)
            { 0x8A:0x30D0, 0x8B:0x30D3, 0x8C:0x30D6, 0x8D:0x30D9, 0x8E:0x30DC },
            // maru (ﾟ) cases (complete)
            { 0x8A:0x30D1, 0x8B:0x30D4, 0x8C:0x30D7, 0x8D:0x30DA, 0x8E:0x30DD }
        ];

        var str = str
        .replace
        (
            /[\u3000\uFF01-\uFF5E]/g,
            function(/* ...romaji */ m0 )
            {
                var code    = m0.charCodeAt(0);
                return code==0x3000?' ':String.fromCharCode( code-0xFEE0 );
            }
        )
        .replace
        (
            /([\uFF66-\uFF9D])(\uFF9E?)(\uFF9F?)/g,
            function(/* ...kana */ m0, kana, tenten, maru )
            {
                var type    = (tenten?1:0)+(maru?2:0);
                var code    = m0.charCodeAt(0);
                return String.fromCharCode( kanaMap[ type ][ code-0xFF00 ] );
            }
        );

        return str;
    }


    /*
     * Displays an error message on the screen.
     */
    function _showError(message)
    {
        // or not??? -- Yoanb
    }



    /*
     *  _linkHandler
     */
    function _linkHandler( event )
    {
        var link = event.target;
        while( link && link.nodeName!='A' ) link=link.parentNode;
        if( link )
        {
            event.preventDefault();
            event.stopPropagation();

            var href        = link.getAttribute('href'),
                typeOfLink  = href[0];

            //  a link -> what type ?
            if( typeOfLink=='/' )
            {
                // ? Wiki link
                this.search( href.replace( '/wiki/', '' ) );
            }
            else if( typeOfLink=='#' )
            {
                // ? Fragment identifier
                _renderSection( href );
            }
            else
            {
                // ? a "normal" link
                widget.openURL( href );
            }
        }
    }

    /*
     *  _updateHistory
     */
    function _updateHistory( newEntry )
    {
        var newEntry = newEntry||_article_title||'';
            markup      = '';

        if( newEntry!='' ) //&& newEntry!=_keyword_random )
        {
            var entry = _article_title +'\01'+ _preferences.language;

            //  remove duplicates
            var tmp = [ entry ];
            for( i=0; i<_history.length; i++ )
            {
                if( _history[i]!=entry )
                {
                    tmp.push( _history[i] );
                }
            }
            _history = tmp.concat();

            //  cap the history
            if( _history.length>_preferences.historyMax )
            {
                _history.pop();
            }

            widget.setPreferenceForKey( _history.join('\03'), 'history' );
        }

        //  generate markup
        if( _history.length )
        {
            for( var i=0, h; h=_history[i++]; )
            {
                var h = h.split('\01');
                markup += '<li data-view-target="wikipedia_history '+ h[1] +' '+h[0] +'">'+ h[0].replace( /</g, '&lt;' )+' ('+ h[1].toUpperCase() +')</li>\n';
            }
        }
        else
        {
            markup = '<li data-locale="first start">'+ 'first start'.toLocale() +'</li>';
        }

        //  update markup
        if( _h.historyUl.innerHTML!= markup )
        {
            _h.historyUl.innerHTML  = markup;
        }
    }

    /*
     *  search (public)
     */
    this.search = function( keyword )
    {
        var keyword     = _search_normalizeKeyword( keyword||'' ).capitalize();
        var searchXhr   = new XMLHttpRequest();
        var uri         = _baseUri+ (keyword==''?_keyword_random+'?nocache='+new Date().getTime():_keyword_search+encodeURI(keyword) );

        searchXhr.open( 'GET', uri, true );
        searchXhr.onreadystatechange = function( request )
        {
            if( request.readyState==4 )
            {
                if( request.status!==0 )
                {
                    _prepareArticle( request.responseText );
                    _renderSection();
                    $('navigation').firstChild.setAttribute( 'data-view-alternate-target', 'view_article' );
                    if( !_isSearchPage )
                    {
                        _lastSearch = _article_title;
                        _updateHistory( _article_title );
                    }
                }
                else
                {
                    _showError( 'errorMessage'.toLocale() );
                }
            }
        }.bind( this );
        searchXhr.send( null );
    }


    /**
     * This function uses the current element to start the
     * rendering. It parses backwards to search if there is any
     * content before the currentElement. Also parses
     * to search for any content after the present content.
     *
     * @param {DOMString} anchorName
     */
    function _renderSection( anchorName )
    {
        //  _article_document view
        Views.show( '!view_article' );

        //  get element #anchorName
        var anchorName      = (anchorName||_article_tocHash[0].name).slice(1);
        var targetElement   = getElementsByIdOrName( _article_document, anchorName )[0].parentNode;

        //  locate anchor, _prevSection & _nextSection
        _prevSection    = '';
        _nextSection    = '';
        var current     = '',
            index       = targetElement.sourceIndexFix,
            page        = 0,
            next        = Infinity;

        for( var j in _article_tocHash )
        {
            if( (j|0)<=index )
            {
                page++;
                _prevSection    = current;
                current         = _article_tocHash[j].name;
            }
            else if( !_nextSection )
            {
                next            = j;
                _nextSection    = _article_tocHash[j].name;
                break;
            }
        }

        //  set paging label
        $('paging').children[1].firstChild.nodeValue = page +' / '+ _article_tocLength;

        // pauselayout
        opera.pauselayout();

        //  wipe _h.articleContent
        _h.articleContent.innerHTML = '';

        //  push elements into _h.articleContent
        current         = current.slice(1);
        var isOver      = false,
            sectionNode = (getElementsByIdOrName( _article_document, current )[0]||_article_document.firstChild).parentNode;
        while( sectionNode && !isOver )
        {
            if( sectionNode.nodeType==1 )
            {
                _h.articleContent.appendChild( sectionNode.cloneNode( true ) );
                isOver = sectionNode.sourceIndexFix>=next;
            }
            sectionNode = sectionNode.nextSibling;
        }

        //  _prevSection & _nextSection links needed ?
        var className = ((_prevSection?'prev':'')+'_'+(_nextSection?'next':'') ).replace( /^_|_$/g, '' )+' hasContent';
        document.documentElement.className = className;

        //  continuelayout
        opera.continuelayout();

        //  set scrollTop
        _h.views.scrollTop = 0;
        if( 'function'==typeof(_h.articleContent.scrollIntoView) )
        {
            var targetElement   = (document.getElementsByIdOrName( anchorName )[0]||_h.articleContent.firstChild).parentNode;
//            var targetElement = (document.getElementById(anchorName)||document.getElementsByName(anchorName)[0]||_h.articleContent.firstChild).parentNode;
            //targetElement.scrollIntoView();
        }
    }


    /*
     *  _prepareArticle
     */
    function _prepareArticle( text )
    {
        var textLowerCase   = text.toLowerCase();
            markup          = text.substring( textLowerCase.indexOf('<body'), textLowerCase.lastIndexOf('</body>')+7 );
        _article_document.body.innerHTML = markup;
        
        //  is this is a search result page ?
        var specialSearch = markup.indexOf('page-Special_Search');
        _isSearchPage   = ~specialSearch && specialSearch<markup.indexOf('>');

        // get _article_title
        _article_title = (_article_document.getElementsByTagName('h1')[0]||{textContent:'@@ NO TITLE @@'}).textContent;

        // remove scripts
        var scripts = _article_document.getElementsByTagName( 'script' );
        for( var i=scripts.length; i--; scripts[i].parentNode.removeChild( scripts[i] ) );

        /*
         *  /!\ work around the lack of support of .sourceIndex
         */
        var nodes = _article_document.getElementsByTagName('*');
        for( var i=0; i<nodes.length; i++ )
        {
            nodes[i].sourceIndexFix = i;
        }


        //  inject topAnchor
        var tmp = _article_document.getElementById('bodyContent').firstChild;
        while( tmp.nodeType!=1 )    tmp = tmp.nextSibling;
        var topAnchor = document.createElement( 'a' );
        topAnchor.name  = '_article_first_anchor_'+ new Date().getTime();
        tmp.insertBefore( topAnchor, tmp.firstChild );

        //  initial _article_tocHash
        _article_tocHash    = {'0':{name:'#'+ topAnchor.name,text:_article_title||'top'.toLocale()}}

        //  does the article have a TOC ?
        _article_tocLength  = 1;
        var toc     = _article_document.getElementById('toc'),
            tocUl;
        _article_hasToc = false;
        if( toc && (tocUl=toc.getElementsByTagName('ul')[0]) )
        {
            //  grabs the links of the toc
            var links = tocUl.getElementsByTagName( 'a' );

            //  remove the TOC from the _article_document
            toc.parentNode.removeChild( toc );

            //  generate _article_tocHash
            for( var i=0,link; link=links[i++]; )
            {
                opera.postError(_article_document, name);
                var name    = link.getAttribute( 'href' ).slice(1),
                    anchor  = getElementsByIdOrName( _article_document, name )[0]||null;

                if( anchor )
                {
                    _article_tocHash[ anchor.parentNode.sourceIndexFix ] = {'name':'#'+name,'text':link.textContent};
                    _article_hasToc = true;
                    _article_tocLength++;

                }
            }
        }

        //  update _h.tocUl
        var tmp = [];
        for( var j in _article_tocHash )
        {
            tmp.push( '<li><a href="'+ _article_tocHash[j].name +'">'+ _article_tocHash[j].text +'</a></li>' );
        }
        _h.tocUl.innerHTML = tmp.join('\n');
        
        // fixing tables
        for ( var i=0; i < _article_document.getElementsByTagName('table').length; i++)
        {
            var div = document.createElement('div');
            var tbl = _article_document.getElementsByTagName('table')[i];
            tbl.parentNode.insertBefore( div, tbl );
            div.appendChild(tbl);
            div.style.overflow = 'auto';
        }
        
    }

    /*
     * Loads the pages close by
     */
    function _loadPagesCloseBy(lat, lng, noOfPages)
    {   
        _currentlyViewing = noOfPages || _preferences.gpsNoOfPages2;
        Geonames.findWikiPagesNearBy( lat, lng, noOfPages, _preferences.language, 'json', function( data )
        {
            if ( data ) 
            {
                // NOTE: comment the line below in case of xml data. (will be fixed/removed later)
                data = JSON.parse( data );
                if( data )
                {
                    _updateGpsHistory(data.geonames)
                    
                }
            }
            
        });
    }
    
    /*
     * Updates GPS location history and pages close by.
     */
    function _updateGpsHistory( data )
    {
        // save to pref
        if ( data )
        {
            var pageCount = Math.min( _preferences.gpsNoOfPages2, data.length );
            
            // remove old data.
            _gpsPages = [];
            for ( var i = 0; i < pageCount; i++ )
            {
                _gpsPages[i] = data[i].title +'\01'+ _preferences.language + '\01' + data[i].distance;
            }
            
            widget.setPreferenceForKey( _gpsPages.join('\03'), 'gpspages' );
        }
        
        if( widget.preferenceForKey( 'latitude' ) )
        {
            if( _isGpsUpdated )
            {
                $('wdgt-old').style.display = 'none';
                $('wdgt-location-locale').style.display = 'inline-block';
                
                 $('wdgt-old-location').style.display = 'none';
            }
            else
            {
                $('wdgt-location-locale').style.display = 'none';
                $('wdgt-old').style.display = 'inline-block';
                
                $('wdgt-old-location').style.display = 'inline-block';
            }

            $( 'wdgt-location' ).innerHTML = widget.preferenceForKey( 'latitude' ) + '&deg;, ' 
                + widget.preferenceForKey( 'longitude' ) + '&deg;';
        }
        
        var markup1 = '';
        var markup2 = '';
        var newData = data || _gpsPages;
        if ( newData.length )
        {
            for ( var i = 0; i < newData.length; i++)
            {
                if ( data )
                {
                    tmp = [ data[i].title, _preferences.language, data[i].distance ];
                }
                else
                {
                    tmp = newData[i].split('\01');
                }
                
                // prepare the 3 pages view
                if( i < _preferences.gpsNoOfPages1 )
                {
                    markup1 += '<li data-view-target="wikipedia_closeby ' + tmp[1] + ' ' + tmp[0] + '">' + tmp[0] + ' (' + _fixDistance( tmp[2] ) + ')</li>';
                }
                
                // 9 pages view
                if( newData.length <= _preferences.gpsNoOfPages2 )
                {
                    markup2 += '<li data-view-target="wikipedia_closeby ' + tmp[1] + ' ' + tmp[0] + '">' + (i+1) + '. ' + tmp[0] + ' (' + _fixDistance( tmp[2] ) + ')</li>';
                }
                else    // 25 pages view
                {
                    markup2 += '<li data-view-target="wikipedia_closeby ' + tmp[1] + ' ' + tmp[0] + '">' + tmp[0] + ' (' + _fixDistance( tmp[2] ) + ')</li>';
                }
            }
            
            _h.closeBy.innerHTML            = markup1;
            $( 'wdgt-topPages' ).innerHTML  = markup2;
            
            // add distance
            var distance = data != null ? newData[ newData.length - 1 ].distance : newData[_gpsPages.length-1].split('\01')[2];
            $('wdgt-topWithin').innerHTML = ' (' + _fixDistance( distance ) + ')';
            $('wdgt-numberOfPages').innerHTML = (newData.length > 9 ? ' 25 ' : '' );
            
            // hide the more button in case of 25 pages view
            if( _currentlyViewing == _preferences.gpsNoOfPages3 )
            {
                $('btnMore').style.display = 'none';
            }
            else
            {
                $('btnMore').style.display = '';
            }
            
            Views.show('view_topPages');
        }
        else    // no data for the current location
        {   
             _h.closeBy.innerHTML           = '';
            $( 'wdgt-topPages' ).innerHTML  = '';
            
            Views.show('view_home');
        }
    }

    /*
     * Shows popup to set geo-coordinates. 
     */
    function _showGeoPopup()
    {
        if ( widget.preferenceForKey( 'latitude'  ) )
        {
            _h.txtLatitude.value  = widget.preferenceForKey( 'latitude'  );
            _h.txtLongitude.value = widget.preferenceForKey( 'longitude' );
        }
        
        Dialog.showMessageOkCancel( _h.popup, { title: "GPS Data", ok: _fetchData } );
    }                        
    
    function _fixDistance( num )
    {
        num = num + '';
        if( ~num.indexOf('.') )
        {
            num = num > 1 ?  num.substr(0, num.indexOf('.')+2)  + ' km' : 
                num.substring( num.indexOf('.') + 1, num.indexOf('.') + 3) + ' m';
        }
            
        return num;
    }
    
    function rand(l,u) // lower bound and upper bound
    {
        return Math.floor((Math.random() * (u-l+1))+l);
    }
        
})();

