/**
 *  Copyright 2009 Opera Software ASA. All rights reserved.
 *
 * This file contains Original Code and/or Contributions to the Original 
 * Code as defined in the Opera Web Applications License (the License). 
 * You may not use this file except in compliance with the License. Please 
 * obtain a copy of the License at http://www.opera.com/license/owal/
 * and read it before using this file. 
 *
 * The Original Code and all Contributions to the Original Code distributed 
 * under the License are distributed on an AS IS basis, WITHOUT WARRANTY 
 * OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 * SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 
 *
 * Please see the License for the specific language governing rights and 
 * limitations under the License.
 */
 
opera           = opera||function(){};
opera.postError = opera.postError||function(){};

/*
 *  widgetModes
 */
var widgetModes = new (function()
{
    var _dockId     = 'dock';
    var _maxSize    = '40em';

//    if(navigator.userAgent.search("Opera Mobi") === -1) {
        this.setMaxSize = function( maxWidth )
        {
            if(maxWidth.toString().match( /^[1-9][0-9]*(\.[0-9]+)?e[mx]$/gi ))
            {
                _maxSize   = maxWidth;
                _adjustDocumentFontsize();
            }
        }

        function _adjustDocumentFontsize()
        {
            if( document.body )
            {
                var fontSize        = 6,
                    tmp             = document.createElement('span'),
                    defaultStyle    ='background:transparent;position:fixed;z-index:70;top:0;left:0;padding:0;margin:0;display:inline-block;width:'+ _maxSize +';height:'+ _maxSize +';font-size:';
                document.body.appendChild( tmp );
                do
                {
                    tmp.style.cssText = defaultStyle+ fontSize++ +'px';
                }
                while( tmp.offsetWidth<window.outerWidth && tmp.offsetHeight<window.outerHeight );
                document.body.removeChild( tmp );
                document.body.style.cssText = 'font-size:'+ --fontSize +'px !important';
            }
            else
            {
                window.addEventListener
                (
                    'load',
                    arguments.callee,
                    false
                );
            }
        }
        //  and on resize
        window.addEventListener
        (
            'resize',
            function(){ return _adjustDocumentFontsize }(),
            false
        );
/*    } else {
        this.setMaxSize = function() {
            // pass
        };
    }*/

    this.defineDockElement = function( id )
    {
        if( document.getElementById( id ) )
        {
            _dockId = id;
        }
    }

    function _widgetModeChangeHandler( event )
    {
        var mode = event.widgetMode||widget.widgetMode;
        
        if( mode=='widget' && navigator.userAgent.search("Opera Mobi") === -1 )
        {
            var closeButton = document.createElement('button');
            closeButton.id = 'close';
            var style = 'background: transparent url(common/img/button_close.png) 0 0 no-repeat; width: 26px; height: 26px;';
            closeButton.addEventListener( 'click', function() {
                widget.hide();
            }, false);
            
            var header = document.getElementById('header');
            if ( header )
            {
                closeButton.style = style + 'float: right; margin-top: 2px; margin-right: 0px';
                header.insertBefore( closeButton, header.firstChild );
            }
            else
            {
                document.body.appendChild( closeButton );
            }
        }


        var wrapperElement = document.getElementById( 'widgetWrapper' )||document.getElementsByClassName( 'widgetWrapper' )[0]||{style:'dummy'};
        wrapperElement.style.display = mode=='docked'?'none':'block';

        var dockElement = document.getElementById( _dockId );
        if( dockElement )
        {
            if( mode=='docked' )
            {
                dockElement.style.display = 'block';
            }
            else
            {
                dockElement.style.display = 'none';
            }
        }
    }
    //  listen to the widgetmodechange events
    if( widget.addEventListener )
    {
        widget.addEventListener
        (
            'widgetmodechange',
            function(){ return _widgetModeChangeHandler }(),
            false
        );
    }
    //  check the widgetMode onload
    window.addEventListener
    (
        'load',
        function(){ return _widgetModeChangeHandler }(),
        false
    );


    /**
     * if we're on a small screen, use all of it
     */
    if( screen.availHeight + screen.availWidth <= 600 || navigator.userAgent.search("Opera Mobi") !== -1 )
    {
        function setFullscreen() {
            window.moveTo(0, 0);
            window.scrollTo(0, 0);
            window.setTimeout(function(){
                // take a deep breath
                window.resizeTo(screen.availWidth, screen.availHeight);
            }, 10);
        }

        /**
         * if we're on a small screen, use all of it
         */
        window.addEventListener
        (
            'resize',
            function()
            {
                setFullscreen();
            },
            false
        );

        setFullscreen();
    }



})();
