/* Generated by re2c 0.15.3 on Tue Oct 24 13:44:48 2017 */
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015 Derick Rethans
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/* $Id$ */

#include "timelib.h"
#include "timelib_private.h"

#include <ctype.h>
#include <math.h>
#include <assert.h>

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, TIMELIB_ERR_DOUBLE_DATE, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, TIMELIB_ERR_DOUBLE_TZ, "Double timezone specification") : add_warning(s, TIMELIB_WARN_DOUBLE_TZ, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

typedef struct _timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct _Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	timelib_error_container *errors;

	timelib_time        *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
static const timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, int error_code, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, int error_code, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, int error_code, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, int error_code, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static timelib_sll timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin);
	memcpy(str, begin + 1, end - begin - 1);
	tmp_nr = strtod(str, NULL) * pow(10, 7 - (end - begin));
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
           **ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: s->time->relative.us += amount * relunit->multiplier; break;
		case TIMELIB_SECOND:   s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE:   s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:     s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:      s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:    s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:     s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

static const timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if (fmp->gmtoffset == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = tp->gmtoffset;
		*dst = tp->type;
		value -= tp->type * 3600;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

#define sHOUR(a) (int)(a * 3600)
#define sMIN(a) (int)(a * 60)

static timelib_long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	timelib_long  tmp;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1: /* H */
		case 2: /* HH */
			return sHOUR(strtol(begin, NULL, 10));
			break;
		case 3: /* H:M */
		case 4: /* H:MM, HH:M, HHMM */
			if (begin[1] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 2, NULL, 10));
				return tmp;
			} else if (begin[2] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return sHOUR(tmp / 100) + sMIN(tmp % 100);
			}
		case 5: /* HH:MM */
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
			return tmp;
	}
	return 0;
}

timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			int dummy_error_code;

			if ((res = tz_wrapper(tz_abbr, tzdb, &dummy_error_code)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   0,   0,   0,   0,   0,   0, 
		  0,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   0,   0,   0,   0,   0, 
		  0,  24,  24,  24,  88,  24,  24,  24, 
		 88,  24,  24,  24,  24,  24,  88,  24, 
		 24,  24,  88,  88,  88,  24,  24,  24, 
		 24,  24,  24,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 33) YYFILL(33);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy51;
	case '\t':
	case ' ':	goto yy48;
	case '(':	goto yy45;
	case '+':
	case '-':	goto yy30;
	case ',':
	case '.':	goto yy50;
	case '0':	goto yy25;
	case '1':	goto yy26;
	case '2':	goto yy27;
	case '3':	goto yy28;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy29;
	case '@':	goto yy11;
	case 'A':	goto yy36;
	case 'B':	goto yy17;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy46;
	case 'D':	goto yy40;
	case 'E':	goto yy21;
	case 'F':	goto yy13;
	case 'G':	goto yy44;
	case 'I':	goto yy31;
	case 'J':	goto yy34;
	case 'L':	goto yy15;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy38;
	case 'P':	goto yy23;
	case 'S':	goto yy19;
	case 'T':	goto yy9;
	case 'V':	goto yy32;
	case 'W':	goto yy42;
	case 'X':	goto yy33;
	case 'Y':	goto yy2;
	case 'a':	goto yy37;
	case 'b':	goto yy18;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy47;
	case 'd':	goto yy41;
	case 'e':	goto yy22;
	case 'f':	goto yy14;
	case 'j':	goto yy35;
	case 'l':	goto yy16;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy39;
	case 'p':	goto yy24;
	case 's':	goto yy20;
	case 't':	goto yy10;
	case 'w':	goto yy43;
	case 'y':	goto yy4;
	default:	goto yy53;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy1523;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych >= 'a') goto yy170;
		} else {
			if (yych <= 'e') goto yy1532;
			if (yych <= 'z') goto yy170;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy1523;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'e') goto yy1523;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1494;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1495;
				if (yych <= 'N') goto yy165;
				goto yy1493;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1510;
				goto yy170;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1511;
				goto yy170;
			} else {
				if (yych <= 'o') goto yy1509;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1494;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1495;
				if (yych <= 'N') goto yy165;
				goto yy1493;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1494;
				goto yy165;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1495;
				goto yy165;
			} else {
				if (yych <= 'o') goto yy1493;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy1463;
		} else {
			if (yych == 'I') goto yy1464;
			if (yych <= 'N') goto yy165;
			goto yy1465;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1478;
			goto yy170;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1479;
				goto yy170;
			} else {
				if (yych <= 'o') goto yy1480;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy1463;
		} else {
			if (yych == 'I') goto yy1464;
			if (yych <= 'N') goto yy165;
			goto yy1465;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1463;
			goto yy165;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1464;
				goto yy165;
			} else {
				if (yych <= 'o') goto yy1465;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy164;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy165;
	case 'E':	goto yy1388;
	case 'H':	goto yy1389;
	case 'O':	goto yy1390;
	case 'U':	goto yy1391;
	case 'W':	goto yy1392;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy170;
	case 'e':	goto yy1431;
	case 'h':	goto yy1432;
	case 'o':	goto yy1433;
	case 'u':	goto yy1434;
	case 'w':	goto yy1435;
	default:	goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy164;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy165;
	case 'E':
	case 'e':	goto yy1388;
	case 'H':
	case 'h':	goto yy1389;
	case 'O':
	case 'o':	goto yy1390;
	case 'U':
	case 'u':	goto yy1391;
	case 'W':
	case 'w':	goto yy1392;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1376;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1377;
yy12:
	YYDEBUG(12, *YYCURSOR);
	{
		add_error(s, TIMELIB_ERR_UNEXPECTED_CHARACTER, "Unexpected character");
		goto std;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy165;
				goto yy1311;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1312;
				goto yy165;
			} else {
				if (yych <= 'O') goto yy1313;
				if (yych <= 'Q') goto yy165;
				goto yy1314;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy165;
				if (yych <= '`') goto yy3;
				goto yy170;
			} else {
				if (yych <= 'e') goto yy1353;
				if (yych <= 'h') goto yy170;
				goto yy1354;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1355;
				goto yy170;
			} else {
				if (yych <= 'r') goto yy1356;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy165;
				goto yy1311;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1312;
				goto yy165;
			} else {
				if (yych <= 'O') goto yy1313;
				if (yych <= 'Q') goto yy165;
				goto yy1314;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy165;
				if (yych <= '`') goto yy3;
				goto yy165;
			} else {
				if (yych <= 'e') goto yy1311;
				if (yych <= 'h') goto yy165;
				goto yy1312;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1313;
				goto yy165;
			} else {
				if (yych <= 'r') goto yy1314;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1297;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1308;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1297;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1297;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1276;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1294;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1276;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy165;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1276;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1219;
				goto yy165;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1218;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1220;
				if (yych <= 'T') goto yy165;
				goto yy1221;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1248;
				if (yych <= 'd') goto yy170;
				goto yy1247;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1249;
				goto yy170;
			} else {
				if (yych <= 'u') goto yy1250;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1219;
				goto yy165;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1218;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy1220;
				if (yych <= 'T') goto yy165;
				goto yy1221;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1219;
				if (yych <= 'd') goto yy165;
				goto yy1218;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1220;
				goto yy165;
			} else {
				if (yych <= 'u') goto yy1221;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1188;
			if (yych <= 'K') goto yy165;
			goto yy1189;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy170;
			goto yy1206;
		} else {
			if (yych == 'l') goto yy1207;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1188;
			if (yych <= 'K') goto yy165;
			goto yy1189;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy165;
			goto yy1188;
		} else {
			if (yych == 'l') goto yy1189;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy165;
			goto yy1062;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'r') goto yy1181;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy165;
			goto yy1062;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'r') goto yy1062;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1016;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy1018;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy1028;
					if (yych <= '/') goto yy436;
					goto yy1061;
				} else {
					if (yych <= '9') goto yy1060;
					if (yych <= ':') goto yy1029;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy1018;
					if (yych <= 'C') goto yy12;
					goto yy1018;
				} else {
					if (yych == 'F') goto yy1018;
					goto yy12;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy1018;
					if (yych <= 'L') goto yy12;
					goto yy1018;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy1018;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy1018;
					if (yych <= 'c') goto yy12;
					goto yy1018;
				} else {
					if (yych == 'f') goto yy1018;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy1018;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy1018;
					goto yy434;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'o') goto yy1018;
					if (yych <= 'q') goto yy12;
					goto yy435;
				} else {
					if (yych <= 's') goto yy429;
					if (yych <= 't') goto yy432;
					goto yy1018;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy1018;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy1018;
					if (yych == 0xC2) goto yy1018;
					goto yy12;
				}
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy424;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy426;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy438;
					if (yych <= '/') goto yy436;
					goto yy1060;
				} else {
					if (yych <= '9') goto yy1027;
					if (yych <= ':') goto yy447;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy426;
					if (yych <= 'C') goto yy12;
					goto yy426;
				} else {
					if (yych == 'F') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy426;
					if (yych <= 'L') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy426;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy426;
					if (yych <= 'c') goto yy12;
					goto yy426;
				} else {
					if (yych == 'f') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy426;
					goto yy434;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy426;
					if (yych <= 'q') goto yy12;
					goto yy435;
				} else {
					if (yych <= 's') goto yy429;
					if (yych <= 't') goto yy432;
					goto yy426;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy426;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy426;
					if (yych == 0xC2) goto yy426;
					goto yy12;
				}
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy424;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy426;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy438;
					if (yych <= '/') goto yy436;
					goto yy1027;
				} else {
					if (yych <= '9') goto yy1014;
					if (yych <= ':') goto yy447;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy426;
					if (yych <= 'C') goto yy12;
					goto yy426;
				} else {
					if (yych == 'F') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy426;
					if (yych <= 'L') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy426;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy426;
					if (yych <= 'c') goto yy12;
					goto yy426;
				} else {
					if (yych == 'f') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy426;
					goto yy434;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy426;
					if (yych <= 'q') goto yy12;
					goto yy435;
				} else {
					if (yych <= 's') goto yy429;
					if (yych <= 't') goto yy432;
					goto yy426;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy426;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy426;
					if (yych == 0xC2) goto yy426;
					goto yy12;
				}
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy424;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy426;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy438;
					if (yych <= '/') goto yy436;
					goto yy1014;
				} else {
					if (yych <= '9') goto yy433;
					if (yych <= ':') goto yy447;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy426;
					if (yych <= 'C') goto yy12;
					goto yy426;
				} else {
					if (yych == 'F') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy426;
					if (yych <= 'L') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy426;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy426;
					if (yych <= 'c') goto yy12;
					goto yy426;
				} else {
					if (yych == 'f') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy426;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy426;
					goto yy434;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy426;
					if (yych <= 'q') goto yy12;
					goto yy435;
				} else {
					if (yych <= 's') goto yy429;
					if (yych <= 't') goto yy432;
					goto yy426;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy426;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy426;
					if (yych == 0xC2) goto yy426;
					goto yy12;
				}
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy424;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy426;
					if (yych <= ',') goto yy12;
					goto yy437;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy438;
					if (yych <= '/') goto yy436;
					goto yy433;
				} else {
					if (yych <= ':') goto yy447;
					if (yych <= '@') goto yy12;
					goto yy426;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy426;
					goto yy12;
				} else {
					if (yych == 'G') goto yy12;
					goto yy426;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy12;
					if (yych <= 'P') goto yy426;
					goto yy12;
				} else {
					if (yych <= 'Y') goto yy426;
					if (yych <= '`') goto yy12;
					goto yy426;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy426;
					goto yy12;
				} else {
					if (yych == 'g') goto yy12;
					goto yy426;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy426;
					goto yy12;
				} else {
					if (yych == 'n') goto yy434;
					goto yy426;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'q') goto yy12;
					if (yych <= 'r') goto yy435;
					goto yy429;
				} else {
					if (yych <= 't') goto yy432;
					if (yych <= 'u') goto yy426;
					goto yy12;
				}
			} else {
				if (yych <= 'y') {
					if (yych == 'x') goto yy12;
					goto yy426;
				} else {
					if (yych == 0xC2) goto yy426;
					goto yy12;
				}
			}
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy404;
	case '0':
	case '1':	goto yy401;
	case '2':	goto yy402;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy403;
	default:	goto yy12;
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy165;
			} else {
				if (yych <= 'I') goto yy400;
				if (yych <= 'U') goto yy165;
				goto yy399;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy399;
				goto yy165;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy396;
				goto yy165;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy394;
				goto yy165;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy377;
			if (yych <= 'T') goto yy165;
			goto yy376;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy386;
		} else {
			if (yych == 'u') goto yy385;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy377;
			if (yych <= 'T') goto yy165;
			goto yy376;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy377;
		} else {
			if (yych == 'u') goto yy376;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy355;
				goto yy165;
			} else {
				if (yych <= 'P') goto yy354;
				if (yych <= 'T') goto yy165;
				goto yy353;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'g') goto yy367;
				goto yy170;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy366;
				goto yy170;
			} else {
				if (yych <= 'u') goto yy365;
				if (yych <= 'z') goto yy170;
				goto yy3;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy355;
				goto yy165;
			} else {
				if (yych <= 'P') goto yy354;
				if (yych <= 'T') goto yy165;
				goto yy353;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy165;
				goto yy3;
			} else {
				if (yych == 'g') goto yy355;
				goto yy165;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy354;
				goto yy165;
			} else {
				if (yych <= 'u') goto yy353;
				if (yych <= 'z') goto yy165;
				goto yy3;
			}
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy165;
			goto yy343;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'c') goto yy348;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy165;
			goto yy343;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'c') goto yy343;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy216;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'e') goto yy334;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy216;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'e') goto yy216;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy189;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy170;
		} else {
			if (yych <= 'e') goto yy203;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy165;
			goto yy189;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy165;
			if (yych <= '`') goto yy3;
			goto yy165;
		} else {
			if (yych <= 'e') goto yy189;
			if (yych <= 'z') goto yy165;
			goto yy3;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy165;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy181;
			goto yy165;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy170;
			goto yy3;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy180;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy180;
	goto yy12;
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy165;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy170;
		goto yy3;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy165;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy165;
		goto yy3;
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy49;
	if (yych <= '9') goto yy54;
yy49:
	YYDEBUG(49, *YYCURSOR);
	{
		goto std;
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy49;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(52, *YYCURSOR);
	{
		s->pos = cursor; s->line++;
		goto std;
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	YYDEBUG(55, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= 'D') {
					if (yych >= 'D') goto yy66;
				} else {
					if (yych == 'F') goto yy67;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy65;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych >= 'S') goto yy64;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy70;
					goto yy63;
				} else {
					if (yych == 'W') goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy68;
				} else {
					if (yych <= 'd') goto yy66;
					if (yych >= 'f') goto yy67;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy65;
				} else {
					if (yych == 'm') goto yy61;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy64;
					goto yy70;
				} else {
					if (yych <= 'u') goto yy63;
					if (yych >= 'w') goto yy69;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy68;
				} else {
					if (yych == 0xC2) goto yy62;
				}
			}
		}
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy3;
						} else {
							goto yy12;
						}
					} else {
						goto yy49;
					}
				} else {
					if (yyaccept == 3) {
						goto yy74;
					} else {
						goto yy191;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy218;
					} else {
						goto yy232;
					}
				} else {
					if (yyaccept == 7) {
						goto yy246;
					} else {
						goto yy357;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy440;
					} else {
						goto yy455;
					}
				} else {
					if (yyaccept == 11) {
						goto yy576;
					} else {
						goto yy621;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy631;
					} else {
						goto yy728;
					}
				} else {
					if (yyaccept == 15) {
						goto yy748;
					} else {
						goto yy779;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept == 17) {
							goto yy786;
						} else {
							goto yy813;
						}
					} else {
						goto yy758;
					}
				} else {
					if (yyaccept == 20) {
						goto yy419;
					} else {
						goto yy938;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept == 22) {
						goto yy807;
					} else {
						goto yy1032;
					}
				} else {
					if (yyaccept == 24) {
						goto yy1040;
					} else {
						goto yy1084;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept == 26) {
						goto yy1108;
					} else {
						goto yy1284;
					}
				} else {
					if (yyaccept == 28) {
						goto yy1379;
					} else {
						goto yy1417;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept == 30) {
						goto yy1420;
					} else {
						goto yy1500;
					}
				} else {
					if (yyaccept == 32) {
						goto yy1508;
					} else {
						goto yy1531;
					}
				}
			}
		}
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(58, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy54;
	goto yy56;
yy59:
	YYDEBUG(59, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy60:
	YYDEBUG(60, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy56;
				goto yy59;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy66;
				} else {
					if (yych == 'F') goto yy67;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy65;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych <= 'R') goto yy56;
					goto yy64;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy70;
					goto yy63;
				} else {
					if (yych == 'W') goto yy69;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy66;
					if (yych <= 'e') goto yy56;
					goto yy67;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy65;
				} else {
					if (yych != 'm') goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy64;
					goto yy70;
				} else {
					if (yych <= 'u') goto yy63;
					if (yych <= 'v') goto yy56;
					goto yy69;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy68;
				} else {
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy138;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy137;
			if (yych <= 'R') goto yy56;
			goto yy139;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy138;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy137;
			if (yych == 's') goto yy139;
			goto yy56;
		}
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy134;
	goto yy56;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy132;
	if (yych == 's') goto yy132;
	goto yy56;
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy120;
			if (yych <= 'T') goto yy56;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy120;
			if (yych == 'u') goto yy118;
			goto yy56;
		}
	}
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy116;
	if (yych == 'o') goto yy116;
	goto yy56;
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy115;
	if (yych == 'a') goto yy115;
	goto yy56;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy100;
		if (yych <= 'Q') goto yy56;
		goto yy99;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy100;
		} else {
			if (yych == 'r') goto yy99;
			goto yy56;
		}
	}
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy96;
	if (yych == 'e') goto yy96;
	goto yy56;
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy84;
	if (yych == 'e') goto yy84;
	goto yy56;
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy71;
		if (yych <= 'T') goto yy56;
		goto yy72;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy79;
	if (yych == 'u') goto yy79;
	goto yy56;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy73;
	if (yych != 'e') goto yy56;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy75;
	if (yych == 's') goto yy75;
yy74:
	YYDEBUG(74, *YYCURSOR);
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy76;
	if (yych != 'd') goto yy56;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy77;
	if (yych != 'a') goto yy56;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych != 'y') goto yy56;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy74;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy80;
	if (yych != 'r') goto yy74;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy81;
	if (yych != 's') goto yy56;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy82;
	if (yych != 'd') goto yy56;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy83;
	if (yych != 'a') goto yy56;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy86;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy86;
		if (yych >= 'f') goto yy56;
	}
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy92;
	if (yych == 'k') goto yy92;
	goto yy56;
yy86:
	YYDEBUG(86, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy87;
	if (yych != 'n') goto yy74;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy88;
	if (yych != 'e') goto yy56;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych != 's') goto yy56;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy90;
	if (yych != 'd') goto yy56;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy91;
	if (yych != 'a') goto yy56;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy93;
		if (yych <= 'R') goto yy74;
		goto yy78;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy74;
		} else {
			if (yych == 's') goto yy78;
			goto yy74;
		}
	}
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy94;
	if (yych != 'a') goto yy56;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy95;
	if (yych != 'y') goto yy56;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy78;
	if (yych == 's') goto yy78;
	goto yy74;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy97;
	if (yych != 'a') goto yy56;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy98;
	if (yych != 'r') goto yy56;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy78;
	if (yych == 's') goto yy78;
	goto yy74;
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy112;
	if (yych == 'i') goto yy112;
	goto yy56;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy101;
	if (yych != 'r') goto yy56;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy102;
	if (yych != 't') goto yy56;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy104;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy104;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy109;
	if (yych == 'i') goto yy109;
	goto yy56;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy105;
	if (yych != 'n') goto yy56;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy106;
	if (yych != 'i') goto yy56;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy107;
	if (yych != 'g') goto yy56;
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy108;
	if (yych != 'h') goto yy56;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy98;
	if (yych == 't') goto yy98;
	goto yy56;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy110;
	if (yych != 'g') goto yy56;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy111;
	if (yych != 'h') goto yy56;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy98;
	if (yych == 't') goto yy98;
	goto yy56;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy113;
	if (yych != 'd') goto yy74;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy114;
	if (yych != 'a') goto yy56;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy98;
	if (yych == 'y') goto yy98;
	goto yy56;
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy117;
	if (yych != 'u') goto yy56;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy98;
	if (yych == 'r') goto yy98;
	goto yy56;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy129;
	if (yych == 'n') goto yy129;
	goto yy56;
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy124;
	if (yych == 't') goto yy124;
	goto yy56;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy121;
	if (yych != 'c') goto yy56;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy122;
		if (yych <= 'R') goto yy74;
		goto yy78;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy74;
		} else {
			if (yych == 's') goto yy78;
			goto yy74;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy123;
	if (yych != 'n') goto yy56;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy98;
	if (yych == 'd') goto yy98;
	goto yy56;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy125;
	if (yych != 'u') goto yy74;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy126;
	if (yych != 'r') goto yy56;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy127;
	if (yych != 'd') goto yy56;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy128;
	if (yych != 'a') goto yy56;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy130;
	if (yych != 'd') goto yy74;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy131;
	if (yych != 'a') goto yy56;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy133;
	if (yych != 'e') goto yy56;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy98;
	if (yych == 'c') goto yy98;
	goto yy56;
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy135;
	if (yych != 's') goto yy56;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy136;
	if (yych != 'e') goto yy74;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy98;
	if (yych == 'c') goto yy98;
	goto yy56;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy160;
	if (yych == 'n') goto yy160;
	goto yy56;
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy142;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy141;
			if (yych <= 'M') goto yy56;
			goto yy143;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy142;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy141;
			if (yych == 'n') goto yy143;
			goto yy56;
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy140;
	if (yych != 'e') goto yy74;
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy98;
	if (yych == 'c') goto yy98;
	goto yy56;
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy153;
	if (yych == 'l') goto yy153;
	goto yy56;
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy146;
	if (yych == 'r') goto yy146;
	goto yy56;
yy143:
	YYDEBUG(143, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy78;
		if (yych <= 'T') goto yy74;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy74;
			goto yy78;
		} else {
			if (yych != 'u') goto yy74;
		}
	}
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy145;
	if (yych != 't') goto yy56;
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy98;
	if (yych == 'e') goto yy98;
	goto yy56;
yy146:
	YYDEBUG(146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy147;
	if (yych != 'o') goto yy56;
yy147:
	YYDEBUG(147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy148;
	if (yych != 's') goto yy56;
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy149;
	if (yych != 'e') goto yy56;
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy150;
	if (yych != 'c') goto yy56;
yy150:
	YYDEBUG(150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy151;
	if (yych != 'o') goto yy56;
yy151:
	YYDEBUG(151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy152;
	if (yych != 'n') goto yy56;
yy152:
	YYDEBUG(152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy98;
	if (yych == 'd') goto yy98;
	goto yy56;
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy154;
	if (yych != 'i') goto yy56;
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy155;
	if (yych != 's') goto yy56;
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy156;
	if (yych != 'e') goto yy56;
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy157;
	if (yych != 'c') goto yy56;
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy158;
	if (yych != 'o') goto yy56;
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy159;
	if (yych != 'n') goto yy56;
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy98;
	if (yych == 'd') goto yy98;
	goto yy56;
yy160:
	YYDEBUG(160, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy161;
		if (yych <= 'S') goto yy74;
		goto yy162;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy74;
		} else {
			if (yych == 't') goto yy162;
			goto yy74;
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy163;
	if (yych == 'a') goto yy163;
	goto yy56;
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy98;
	if (yych == 'h') goto yy98;
	goto yy56;
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy78;
	if (yych == 'y') goto yy78;
	goto yy56;
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy166;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy167;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy168;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy169;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy164;
	goto yy3;
yy170:
	YYDEBUG(170, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy166;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy167;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	goto yy56;
yy173:
	YYDEBUG(173, *YYCURSOR);
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(174, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy3;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy3;
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy164;
		if (yych <= ',') goto yy3;
		goto yy172;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy3;
		}
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy179:
	YYDEBUG(179, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy56;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy56;
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy165;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy165;
		goto yy3;
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy166;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy166;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
	YYDEBUG(182, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych != '+') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy183;
			if (yych <= '@') goto yy3;
			goto yy167;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy184;
	if (yych <= '2') goto yy185;
	if (yych <= '9') goto yy186;
	goto yy56;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy186;
	if (yych <= ':') goto yy187;
	goto yy3;
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy3;
		if (yych >= '5') goto yy188;
	} else {
		if (yych <= '9') goto yy164;
		if (yych <= ':') goto yy187;
		goto yy3;
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy188;
	if (yych <= '9') goto yy164;
	if (yych >= ';') goto yy3;
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy188;
	if (yych <= '9') goto yy164;
	goto yy3;
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy164;
	goto yy3;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy166;
			if (yych >= 'E') goto yy192;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'd') goto yy190;
			if (yych <= 'e') goto yy192;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy190:
	YYDEBUG(190, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'M') goto yy167;
			goto yy198;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych >= 'a') goto yy167;
		} else {
			if (yych <= 'n') goto yy198;
			if (yych <= 'z') goto yy167;
		}
	}
yy191:
	YYDEBUG(191, *YYCURSOR);
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy167;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'k') goto yy193;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy168;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'd') goto yy194;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy195;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy196;
		if (yych != 'y') goto yy3;
	}
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy197;
	if (yych != 's') goto yy191;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy191;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'e') goto yy199;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy169;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 's') goto yy200;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy201;
		if (yych != 'd') goto yy3;
	}
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy202;
	if (yych != 'a') goto yy56;
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy197;
	goto yy56;
yy203:
	YYDEBUG(203, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy172;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy166;
				goto yy190;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy192;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy171;
			} else {
				if (yych <= 'e') goto yy205;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
	YYDEBUG(204, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy198;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy211;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy205:
	YYDEBUG(205, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy193;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'k') goto yy206;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy194;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'd') goto yy207;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy207:
	YYDEBUG(207, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy195;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy208;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy208:
	YYDEBUG(208, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy196;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'y') goto yy209;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy209:
	YYDEBUG(209, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy172;
			goto yy191;
		} else {
			if (yych <= '/') goto yy172;
			if (yych <= 'R') goto yy191;
			goto yy197;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy172;
			goto yy191;
		} else {
			if (yych == 's') goto yy210;
			if (yych <= 'z') goto yy178;
			goto yy191;
		}
	}
yy210:
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy191;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy191;
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy199;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy212;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy212:
	YYDEBUG(212, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy200;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 's') goto yy213;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy213:
	YYDEBUG(213, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy201;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'd') goto yy214;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy202;
	if (yych != 'a') goto yy179;
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy210;
	goto yy179;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy166;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'c') goto yy217;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy217:
	YYDEBUG(217, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy220;
			} else {
				if (yych == ' ') goto yy220;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
			} else {
				if (yych == 'E') goto yy225;
				goto yy167;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy167;
			} else {
				if (yych <= 'e') goto yy225;
				if (yych <= 'z') goto yy167;
			}
		}
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy219:
	YYDEBUG(219, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 23) YYFILL(23);
	yych = *YYCURSOR;
yy220:
	YYDEBUG(220, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy219;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy222;
	if (yych <= '3') goto yy223;
	if (yych <= '9') goto yy224;
	goto yy56;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy220;
	if (yych <= '0') goto yy324;
	if (yych <= '2') goto yy325;
	if (yych <= '3') goto yy326;
	goto yy220;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy323;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy323;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy230;
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy230;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy168;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'm') goto yy226;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy169;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'b') goto yy227;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy227:
	YYDEBUG(227, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy228;
		if (yych != 'e') goto yy3;
	}
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych != 'r') goto yy56;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy220;
		if (yych <= 0x1F) goto yy218;
		goto yy220;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy218;
			goto yy220;
		} else {
			if (yych <= '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		}
	}
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy320;
	goto yy56;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy319;
	goto yy237;
yy232:
	YYDEBUG(232, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy233:
	YYDEBUG(233, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy319;
	goto yy237;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy319;
	goto yy237;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy319;
	goto yy237;
yy236:
	YYDEBUG(236, *YYCURSOR);
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy237:
	YYDEBUG(237, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy236;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy232;
		if (yych <= '0') goto yy310;
		if (yych <= '1') goto yy311;
		goto yy312;
	} else {
		if (yych <= '9') goto yy313;
		if (yych == 'T') goto yy239;
		goto yy232;
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych <= '/') goto yy232;
			goto yy240;
		} else {
			if (yych <= '1') goto yy241;
			if (yych <= '2') goto yy242;
			goto yy243;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= 'S') goto yy232;
		} else {
			if (yych != 't') goto yy232;
		}
	}
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy308;
	if (yych <= '2') goto yy309;
	if (yych <= '9') goto yy298;
	goto yy56;
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy56;
	} else {
		if (yych <= '0') goto yy298;
		if (yych <= '9') goto yy243;
		if (yych <= ':') goto yy299;
		goto yy56;
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy56;
	} else {
		if (yych <= '2') goto yy243;
		if (yych <= '9') goto yy298;
		if (yych <= ':') goto yy244;
		goto yy56;
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy56;
	} else {
		if (yych <= '4') goto yy298;
		if (yych == ':') goto yy244;
		goto yy56;
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy244;
	if (yych != ':') goto yy56;
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy245;
	if (yych <= '9') goto yy247;
	goto yy56;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy248;
	} else {
		if (yych <= '9') goto yy291;
		if (yych <= ':') goto yy248;
	}
yy246:
	YYDEBUG(246, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy248;
	if (yych != ':') goto yy246;
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy249;
	if (yych <= '6') goto yy250;
	if (yych <= '9') goto yy251;
	goto yy56;
yy249:
	YYDEBUG(249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '9') goto yy252;
	goto yy246;
yy250:
	YYDEBUG(250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy252;
	goto yy246;
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy246;
yy252:
	YYDEBUG(252, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy254;
			goto yy246;
		} else {
			if (yych <= ' ') goto yy254;
			if (yych == '(') goto yy254;
			goto yy246;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy246;
			if (yych <= '-') goto yy254;
			goto yy246;
		} else {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy254;
			goto yy246;
		}
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy254:
	YYDEBUG(254, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy253;
			} else {
				if (yych == ' ') goto yy253;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy257;
				if (yych <= '*') goto yy56;
				goto yy256;
			} else {
				if (yych == '-') goto yy256;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy258;
				if (yych <= 'F') goto yy259;
			} else {
				if (yych == 'P') goto yy258;
				goto yy259;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy260;
				goto yy261;
			} else {
				if (yych <= 'p') goto yy260;
				if (yych <= 'z') goto yy261;
				goto yy56;
			}
		}
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy251;
		if (yych <= '@') goto yy246;
		goto yy262;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy289;
			goto yy262;
		} else {
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy273;
			goto yy246;
		}
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy284;
	if (yych <= '2') goto yy285;
	if (yych <= '9') goto yy286;
	goto yy56;
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy261;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy261;
	goto yy56;
yy258:
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych <= '.') goto yy267;
			if (yych <= '@') goto yy246;
			goto yy262;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy268;
			if (yych <= 'Z') goto yy262;
			goto yy246;
		} else {
			if (yych == 'm') goto yy283;
			if (yych <= 'z') goto yy273;
			goto yy246;
		}
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy262;
		if (yych <= '`') goto yy246;
		if (yych <= 'z') goto yy273;
		goto yy246;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych <= '.') goto yy267;
			if (yych <= '@') goto yy246;
			goto yy262;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy268;
			if (yych <= 'Z') goto yy262;
			goto yy246;
		} else {
			if (yych == 'm') goto yy268;
			if (yych <= 'z') goto yy262;
			goto yy246;
		}
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy262;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy263;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy264;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy264:
	YYDEBUG(264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy265;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy251;
		goto yy246;
	} else {
		if (yych <= 'Z') goto yy266;
		if (yych <= '`') goto yy246;
		if (yych >= '{') goto yy246;
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy251;
	goto yy246;
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy272;
	if (yych == 'm') goto yy272;
	goto yy56;
yy268:
	YYDEBUG(268, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy270;
			if (yych <= 0x08) goto yy246;
			goto yy270;
		} else {
			if (yych == ' ') goto yy270;
			if (yych <= '(') goto yy246;
			goto yy251;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy246;
		} else {
			if (yych <= 'Z') goto yy263;
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy263;
			goto yy246;
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy270;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(271, *YYCURSOR);
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy270;
		if (yych == '\t') goto yy270;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy270;
		if (yych == '.') goto yy269;
		goto yy56;
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych == '.') goto yy246;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy246;
			if (yych <= 'Z') goto yy263;
			goto yy246;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy246;
			if (yych >= '{') goto yy246;
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych == '.') goto yy246;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy246;
			if (yych <= 'Z') goto yy264;
			goto yy246;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy278;
			goto yy246;
		}
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy276;
	if (yych <= '`') goto yy56;
	if (yych >= '{') goto yy56;
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(277, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy246;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			goto yy246;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy276;
			if (yych <= '^') goto yy246;
			goto yy275;
		} else {
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy276;
			goto yy246;
		}
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych == '.') goto yy246;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy246;
			if (yych <= 'Z') goto yy265;
			goto yy246;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy246;
			if (yych >= '{') goto yy246;
		}
	}
	YYDEBUG(279, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy251;
			goto yy246;
		} else {
			if (yych == '.') goto yy246;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy246;
			if (yych <= 'Z') goto yy266;
			goto yy246;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy246;
			if (yych >= '{') goto yy246;
		}
	}
	YYDEBUG(280, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy246;
			goto yy251;
		} else {
			if (yych == '-') goto yy275;
			goto yy246;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy275;
			if (yych <= '^') goto yy246;
			goto yy275;
		} else {
			if (yych <= '`') goto yy246;
			if (yych >= '{') goto yy246;
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(282, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy275;
		if (yych <= '.') goto yy56;
		goto yy275;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy56;
			goto yy275;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy281;
			goto yy56;
		}
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy270;
			if (yych == '\t') goto yy270;
			goto yy246;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy270;
				goto yy246;
			} else {
				if (yych <= ')') goto yy251;
				if (yych <= ',') goto yy246;
				goto yy275;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy269;
			if (yych <= '/') goto yy275;
			if (yych <= '@') goto yy246;
			goto yy263;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy246;
				goto yy275;
			} else {
				if (yych <= '`') goto yy246;
				if (yych <= 'z') goto yy274;
				goto yy246;
			}
		}
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '9') goto yy286;
	if (yych <= ':') goto yy287;
	goto yy246;
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy246;
		if (yych >= '5') goto yy288;
	} else {
		if (yych <= '9') goto yy251;
		if (yych <= ':') goto yy287;
		goto yy246;
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '5') goto yy288;
	if (yych <= '9') goto yy251;
	if (yych >= ';') goto yy246;
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '5') goto yy288;
	if (yych <= '9') goto yy251;
	goto yy246;
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '9') goto yy251;
	goto yy246;
yy289:
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy251;
		if (yych <= '@') goto yy246;
		goto yy263;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy263;
		} else {
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy263;
			goto yy246;
		}
	}
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy246;
			goto yy251;
		} else {
			if (yych == '+') goto yy256;
			goto yy246;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy256;
			if (yych <= '@') goto yy246;
			goto yy264;
		} else {
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy264;
			goto yy246;
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy292;
			if (yych <= 0x1F) goto yy246;
		} else {
			if (yych == '.') goto yy248;
			if (yych <= '9') goto yy246;
			goto yy248;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy294;
			if (yych <= 'O') goto yy246;
			goto yy294;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy246;
				goto yy294;
			} else {
				if (yych == 'p') goto yy294;
				goto yy246;
			}
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(293, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy292;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy292;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy294;
			if (yych != 'p') goto yy56;
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy296;
		if (yych == 'm') goto yy296;
		goto yy56;
	}
	YYDEBUG(295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy296;
	if (yych != 'm') goto yy56;
yy296:
	YYDEBUG(296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy270;
		if (yych == '\t') goto yy270;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy270;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy270;
		if (yych <= 0x08) goto yy56;
		goto yy270;
	} else {
		if (yych == ' ') goto yy270;
		goto yy56;
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy299;
	if (yych != ':') goto yy56;
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy300;
	if (yych <= '9') goto yy301;
	goto yy56;
yy300:
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy302;
		goto yy246;
	} else {
		if (yych <= '9') goto yy301;
		if (yych <= ':') goto yy302;
		goto yy246;
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy302;
	if (yych != ':') goto yy246;
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy303;
	if (yych <= '6') goto yy304;
	if (yych <= '9') goto yy251;
	goto yy56;
yy303:
	YYDEBUG(303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy246;
	if (yych <= '9') goto yy305;
	goto yy246;
yy304:
	YYDEBUG(304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy246;
yy305:
	YYDEBUG(305, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy307;
			goto yy246;
		} else {
			if (yych <= ' ') goto yy307;
			if (yych == '(') goto yy307;
			goto yy246;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy246;
			if (yych <= '-') goto yy307;
			goto yy246;
		} else {
			if (yych <= 'Z') goto yy307;
			if (yych <= '`') goto yy246;
			if (yych <= 'z') goto yy307;
			goto yy246;
		}
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy307:
	YYDEBUG(307, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy306;
			if (yych <= 0x1F) goto yy56;
			goto yy306;
		} else {
			if (yych == '(') goto yy257;
			if (yych <= '*') goto yy56;
			goto yy256;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy256;
			if (yych <= '@') goto yy56;
			goto yy259;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy255;
				goto yy259;
			} else {
				if (yych <= '`') goto yy56;
				if (yych <= 'z') goto yy261;
				goto yy56;
			}
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy56;
	} else {
		if (yych <= '9') goto yy298;
		if (yych <= ':') goto yy299;
		goto yy56;
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy56;
	} else {
		if (yych <= '4') goto yy298;
		if (yych == ':') goto yy299;
		goto yy56;
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy232;
	} else {
		if (yych <= '0') goto yy317;
		if (yych <= '9') goto yy318;
		if (yych <= ':') goto yy299;
		goto yy232;
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy232;
	} else {
		if (yych <= '2') goto yy318;
		if (yych <= '9') goto yy317;
		if (yych <= ':') goto yy244;
		goto yy232;
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy232;
	} else {
		if (yych <= '4') goto yy317;
		if (yych <= '9') goto yy314;
		if (yych <= ':') goto yy244;
		goto yy232;
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy232;
	} else {
		if (yych <= '9') goto yy314;
		if (yych <= ':') goto yy244;
		goto yy232;
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy232;
	if (yych >= ':') goto yy232;
yy315:
	YYDEBUG(315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy232;
	if (yych >= ':') goto yy232;
	YYDEBUG(316, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy232;
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy299;
		goto yy232;
	} else {
		if (yych <= '9') goto yy315;
		if (yych <= ':') goto yy299;
		goto yy232;
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy244;
		goto yy232;
	} else {
		if (yych <= '9') goto yy315;
		if (yych <= ':') goto yy244;
		goto yy232;
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy238;
	goto yy237;
yy320:
	YYDEBUG(320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(321, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(322, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy320;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy327;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy327;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy236;
				goto yy56;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy230;
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy238;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy236;
				if (yych <= 0x1F) goto yy56;
				goto yy236;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy56;
				if (yych <= ',') goto yy236;
			} else {
				if (yych <= '.') goto yy236;
				if (yych <= '/') goto yy56;
				goto yy320;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy236;
			} else {
				if (yych == 'h') goto yy236;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy233;
				if (yych <= 'q') goto yy56;
				goto yy234;
			} else {
				if (yych <= 's') goto yy231;
				if (yych <= 't') goto yy235;
				goto yy56;
			}
		}
	}
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(329, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy330;
	if (yych <= '9') goto yy331;
yy330:
	YYDEBUG(330, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy330;
	if (yych >= ':') goto yy330;
	YYDEBUG(332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy330;
	if (yych >= ':') goto yy330;
	YYDEBUG(333, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy330;
yy334:
	YYDEBUG(334, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy217;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'c') goto yy335;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'E') goto yy225;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy337;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	if (yych <= '/') goto yy220;
	if (yych <= '0') goto yy324;
	if (yych <= '2') goto yy325;
	if (yych <= '3') goto yy326;
	goto yy220;
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy226;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'm') goto yy338;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy227;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'b') goto yy339;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy228;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'e') goto yy340;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych != 'r') goto yy179;
yy341:
	YYDEBUG(341, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych <= ',') goto yy218;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy172;
			goto yy220;
		} else {
			if (yych == '_') goto yy172;
			goto yy218;
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy173;
	}
	goto yy220;
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy166;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 't') goto yy344;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'O') goto yy167;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'o') goto yy345;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy168;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'b') goto yy346;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy169;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'e') goto yy347;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy229;
		if (yych == 'r') goto yy229;
		goto yy3;
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy344;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 't') goto yy349;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'O') goto yy345;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy350;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy346;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'b') goto yy351;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy347;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'e') goto yy352;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy229;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'r') goto yy341;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy166;
			goto yy361;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'g') goto yy361;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy166;
			goto yy358;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'r') goto yy358;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy166;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'o') goto yy356;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy167;
		if (yych <= '`') goto yy357;
		if (yych <= 'z') goto yy167;
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'I') goto yy167;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'i') goto yy359;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy168;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'l') goto yy360;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy218;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		} else {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy218;
			if (yych <= 'z') goto yy169;
			goto yy218;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'U') goto yy167;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'u') goto yy362;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy168;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 's') goto yy363;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy169;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 't') goto yy364;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy218;
			goto yy220;
		} else {
			if (yych == ' ') goto yy220;
			goto yy218;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy164;
			if (yych <= ',') goto yy218;
			goto yy220;
		} else {
			if (yych <= '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy361;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'g') goto yy372;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy358;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'r') goto yy369;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy356;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'o') goto yy368;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy357;
		} else {
			if (yych == '.') goto yy357;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy357;
			if (yych <= 'Z') goto yy167;
			goto yy357;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy357;
			if (yych <= 'z') goto yy175;
			goto yy357;
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'I') goto yy359;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'i') goto yy370;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy360;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'l') goto yy371;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy218;
				goto yy164;
			} else {
				if (yych <= ',') goto yy218;
				if (yych <= '-') goto yy342;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy172;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy218;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy218;
				goto yy172;
			} else {
				if (yych <= '`') goto yy218;
				if (yych <= 'z') goto yy177;
				goto yy218;
			}
		}
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'U') goto yy362;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy373;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy363;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 's') goto yy374;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy364;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 't') goto yy375;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy218;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy342;
			if (yych <= '.') goto yy220;
			goto yy172;
		} else {
			if (yych <= '9') goto yy220;
			if (yych == '_') goto yy172;
			goto yy218;
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'L') goto yy383;
			if (yych <= 'M') goto yy166;
			goto yy382;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy166;
			goto yy383;
		} else {
			if (yych == 'n') goto yy382;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy378;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'U') goto yy167;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'u') goto yy379;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy380;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy169;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'r') goto yy381;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy229;
		if (yych == 'y') goto yy229;
		goto yy3;
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych == 'E') goto yy384;
				goto yy167;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'e') goto yy384;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'Y') goto yy167;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'y') goto yy384;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy218;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy218;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		} else {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy218;
			if (yych <= 'z') goto yy168;
			goto yy218;
		}
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'L') goto yy383;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy382;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy392;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy391;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy378;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy387;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'U') goto yy379;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy388;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy380;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy389;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy381;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy390;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy229;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'y') goto yy341;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'E') goto yy384;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy393;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'Y') goto yy384;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'y') goto yy393;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy218;
				goto yy164;
			} else {
				if (yych <= ',') goto yy218;
				if (yych <= '-') goto yy342;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy172;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy218;
			goto yy168;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy218;
				goto yy172;
			} else {
				if (yych <= '`') goto yy218;
				if (yych <= 'z') goto yy176;
				goto yy218;
			}
		}
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy166;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy220;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy166;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
	YYDEBUG(397, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy167;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy167;
				goto yy3;
			}
		}
	}
	YYDEBUG(398, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy220;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy220;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy220;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy220;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy3;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy220;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy395;
				goto yy166;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy421;
				} else {
					if (yych <= ':') goto yy187;
					if (yych <= 'C') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy3;
					goto yy60;
				} else {
					if (yych == 'H') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy3;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy421;
					goto yy406;
				} else {
					if (yych <= '9') goto yy407;
					if (yych <= ':') goto yy187;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy406;
				} else {
					if (yych <= '9') goto yy407;
					if (yych <= ':') goto yy187;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(405, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy404;
		goto yy56;
	} else {
		if (yych <= '-') goto yy404;
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy54;
		goto yy56;
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy420;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
yy409:
	YYDEBUG(409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych != '-') goto yy60;
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy411;
	if (yych <= '1') goto yy412;
	goto yy56;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy413;
	goto yy56;
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy413:
	YYDEBUG(413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	YYDEBUG(414, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy415;
	if (yych <= '2') goto yy416;
	if (yych <= '3') goto yy417;
	goto yy56;
yy415:
	YYDEBUG(415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy418;
	goto yy56;
yy416:
	YYDEBUG(416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy418;
	goto yy56;
yy417:
	YYDEBUG(417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy418:
	YYDEBUG(418, *YYCURSOR);
	++YYCURSOR;
yy419:
	YYDEBUG(419, *YYCURSOR);
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy409;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy420;
					if (yych <= ':') goto yy187;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(422, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '-') {
					if (yych <= ',') goto yy3;
					goto yy410;
				} else {
					if (yych == 'D') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy3;
				}
			}
		}
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy426;
	if (yych <= '0') goto yy700;
	if (yych <= '1') goto yy701;
	if (yych <= '9') goto yy702;
	goto yy426;
yy425:
	YYDEBUG(425, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy426:
	YYDEBUG(426, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy425;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy425;
					if (yych <= ',') goto yy56;
					goto yy541;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy444;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy430;
					if (yych == 'F') goto yy431;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy65;
					if (yych <= 'I') goto yy439;
					goto yy443;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy427;
					if (yych <= 'N') goto yy446;
					goto yy445;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy448;
					if (yych <= 'R') goto yy56;
					goto yy428;
				} else {
					if (yych <= 'T') goto yy70;
					if (yych <= 'U') goto yy63;
					if (yych <= 'V') goto yy441;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy442;
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy444;
					if (yych == 'd') goto yy430;
					goto yy56;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy431;
					if (yych <= 'g') goto yy56;
					goto yy65;
				} else {
					if (yych == 'j') goto yy443;
					if (yych <= 'l') goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy446;
					if (yych <= 'o') goto yy445;
					goto yy448;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy428;
					if (yych <= 't') goto yy70;
					goto yy63;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy69;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy68;
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy556;
			if (yych <= 'H') goto yy56;
			goto yy138;
		} else {
			if (yych == 'O') goto yy137;
			if (yych <= 'R') goto yy56;
			goto yy139;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy556;
			if (yych <= 'h') goto yy56;
			goto yy138;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy137;
			} else {
				if (yych == 's') goto yy139;
				goto yy56;
			}
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1013;
			if (yych <= 'T') goto yy56;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1013;
			if (yych == 'u') goto yy118;
			goto yy56;
		}
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1013;
			if (yych == 'U') goto yy118;
			goto yy56;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy119;
			if (yych <= 'd') goto yy56;
			goto yy1013;
		} else {
			if (yych <= 's') goto yy56;
			if (yych <= 't') goto yy693;
			if (yych <= 'u') goto yy118;
			goto yy56;
		}
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy115;
		if (yych <= 'D') goto yy56;
		goto yy543;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy115;
		} else {
			if (yych == 'e') goto yy543;
			goto yy56;
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy559;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy100;
			if (yych <= 'Q') goto yy56;
			goto yy99;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy559;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy100;
			if (yych == 'r') goto yy99;
			goto yy56;
		}
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy71;
		if (yych <= 'T') goto yy56;
		goto yy72;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1012;
		} else {
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy706;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy705;
	goto yy60;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy494;
		goto yy56;
	} else {
		if (yych <= 'd') goto yy693;
		if (yych == 'o') goto yy494;
		goto yy56;
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy693;
	goto yy56;
yy436:
	YYDEBUG(436, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy630;
	case '3':	goto yy632;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy633;
	case 'A':
	case 'a':	goto yy637;
	case 'D':
	case 'd':	goto yy641;
	case 'F':
	case 'f':	goto yy635;
	case 'J':
	case 'j':	goto yy634;
	case 'M':
	case 'm':	goto yy636;
	case 'N':
	case 'n':	goto yy640;
	case 'O':
	case 'o':	goto yy639;
	case 'S':
	case 's':	goto yy638;
	default:	goto yy56;
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy580;
	case '1':	goto yy581;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy582;
	case 'A':
	case 'a':	goto yy586;
	case 'D':
	case 'd':	goto yy590;
	case 'F':
	case 'f':	goto yy584;
	case 'J':
	case 'j':	goto yy583;
	case 'M':
	case 'm':	goto yy585;
	case 'N':
	case 'n':	goto yy589;
	case 'O':
	case 'o':	goto yy588;
	case 'S':
	case 's':	goto yy587;
	default:	goto yy542;
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy542;
		if (yych <= '0') goto yy532;
		goto yy533;
	} else {
		if (yych <= '5') goto yy534;
		if (yych <= '9') goto yy535;
		goto yy542;
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '.') goto yy496;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy498;
			if (yych == 'I') goto yy531;
		} else {
			if (yych == 'W') goto yy440;
			if (yych <= 'X') goto yy504;
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy529;
			goto yy440;
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy528;
			goto yy440;
		}
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy521;
		if (yych <= 'T') goto yy56;
		goto yy520;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy521;
		} else {
			if (yych == 'u') goto yy520;
			goto yy56;
		}
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy449;
			goto yy56;
		} else {
			if (yych <= 'M') goto yy450;
			if (yych == 'P') goto yy514;
			goto yy56;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy513;
			if (yych == 'm') goto yy450;
			goto yy56;
		} else {
			if (yych <= 'p') goto yy514;
			if (yych == 'u') goto yy513;
			goto yy56;
		}
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy508;
	if (yych == 'c') goto yy508;
	goto yy56;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy494;
	if (yych == 'o') goto yy494;
	goto yy56;
yy447:
	YYDEBUG(447, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy454;
	if (yych <= '9') goto yy456;
	goto yy56;
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy450;
		if (yych == 'm') goto yy450;
		goto yy56;
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy450;
	if (yych != 'm') goto yy56;
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy452;
		if (yych == '\t') goto yy452;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy452;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy452;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(453, *YYCURSOR);
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy457;
	} else {
		if (yych <= '9') goto yy471;
		if (yych <= ':') goto yy457;
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy457;
	if (yych != ':') goto yy455;
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy458;
	if (yych <= '6') goto yy459;
	if (yych <= '9') goto yy460;
	goto yy56;
yy458:
	YYDEBUG(458, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy464;
	goto yy455;
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych == '0') goto yy464;
	goto yy455;
yy460:
	YYDEBUG(460, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy455;
yy461:
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy462:
	YYDEBUG(462, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(463, *YYCURSOR);
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy462;
	goto yy455;
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy455;
		} else {
			if (yych <= ' ') goto yy465;
			if (yych == '.') goto yy461;
			goto yy455;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy467;
			if (yych == 'P') goto yy467;
			goto yy455;
		} else {
			if (yych <= 'a') goto yy467;
			if (yych == 'p') goto yy467;
			goto yy455;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(466, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy465;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy465;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy467;
			if (yych != 'p') goto yy56;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy469;
		if (yych == 'm') goto yy469;
		goto yy56;
	}
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy469;
	if (yych != 'm') goto yy56;
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy452;
		if (yych == '\t') goto yy452;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy452;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy452;
		if (yych <= 0x08) goto yy56;
		goto yy452;
	} else {
		if (yych == ' ') goto yy452;
		goto yy56;
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy472;
			if (yych <= 0x1F) goto yy455;
		} else {
			if (yych == '.') goto yy457;
			if (yych <= '9') goto yy455;
			goto yy475;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy474;
			if (yych <= 'O') goto yy455;
			goto yy474;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy474;
			} else {
				if (yych == 'p') goto yy474;
				goto yy455;
			}
		}
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(473, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy472;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy472;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy474;
			if (yych != 'p') goto yy56;
		}
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy491;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy492;
		if (yych == 'm') goto yy492;
		goto yy56;
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy476;
	if (yych <= '6') goto yy477;
	if (yych <= '9') goto yy460;
	goto yy56;
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy478;
	goto yy455;
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych != '0') goto yy455;
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy465;
			if (yych <= 0x1F) goto yy455;
			goto yy465;
		} else {
			if (yych == '.') goto yy479;
			if (yych <= '9') goto yy455;
			goto yy480;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy467;
			if (yych <= 'O') goto yy455;
			goto yy467;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy467;
			} else {
				if (yych == 'p') goto yy467;
				goto yy455;
			}
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy489;
	goto yy56;
yy480:
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy481:
	YYDEBUG(481, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(482, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy56;
			goto yy481;
		} else {
			if (yych != 'A') goto yy56;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy483;
			if (yych <= '`') goto yy56;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy485;
		if (yych == 'm') goto yy485;
		goto yy56;
	}
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy485;
	if (yych != 'm') goto yy56;
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy487;
		if (yych == '\t') goto yy487;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy487;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy487;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(488, *YYCURSOR);
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(490, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy455;
			goto yy489;
		} else {
			if (yych == 'A') goto yy483;
			goto yy455;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy483;
			if (yych <= '`') goto yy455;
			goto yy483;
		} else {
			if (yych == 'p') goto yy483;
			goto yy455;
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy492;
	if (yych != 'm') goto yy56;
yy492:
	YYDEBUG(492, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy452;
		if (yych == '\t') goto yy452;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy452;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy452;
		if (yych <= 0x08) goto yy56;
		goto yy452;
	} else {
		if (yych == ' ') goto yy452;
		goto yy56;
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy495;
	if (yych != 'v') goto yy56;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy500;
			if (yych == 'e') goto yy500;
			goto yy440;
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy497:
	YYDEBUG(497, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy496;
		if (yych <= 0x1F) goto yy56;
		goto yy496;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			goto yy496;
		} else {
			if (yych <= '/') goto yy56;
			if (yych >= ':') goto yy56;
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy499;
	if (yych <= '9') goto yy505;
yy499:
	YYDEBUG(499, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy501;
	if (yych != 'm') goto yy56;
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy502;
	if (yych != 'b') goto yy56;
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy503;
	if (yych != 'e') goto yy56;
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy504;
	if (yych != 'r') goto yy56;
yy504:
	YYDEBUG(504, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy496;
		if (yych <= 0x1F) goto yy440;
		goto yy496;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy440;
			goto yy496;
		} else {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		}
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych >= ':') goto yy499;
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych >= ':') goto yy499;
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy499;
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy509;
	if (yych != 't') goto yy56;
yy509:
	YYDEBUG(509, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'O') goto yy510;
			if (yych != 'o') goto yy440;
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy511;
	if (yych != 'b') goto yy56;
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy512;
	if (yych != 'e') goto yy56;
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy504;
	if (yych == 'r') goto yy504;
	goto yy56;
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy517;
	if (yych == 'g') goto yy517;
	goto yy56;
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy515;
	if (yych != 'r') goto yy56;
yy515:
	YYDEBUG(515, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'I') goto yy516;
			if (yych != 'i') goto yy440;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy504;
	if (yych == 'l') goto yy504;
	goto yy56;
yy517:
	YYDEBUG(517, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'U') goto yy518;
			if (yych != 'u') goto yy440;
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy519;
	if (yych != 's') goto yy56;
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy504;
	if (yych == 't') goto yy504;
	goto yy56;
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy527;
		if (yych <= 'M') goto yy56;
		goto yy526;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy527;
		} else {
			if (yych == 'n') goto yy526;
			goto yy56;
		}
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy522;
	if (yych != 'n') goto yy56;
yy522:
	YYDEBUG(522, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'U') goto yy523;
			if (yych != 'u') goto yy440;
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy524;
	if (yych != 'a') goto yy56;
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy525;
	if (yych != 'r') goto yy56;
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy504;
	if (yych == 'y') goto yy504;
	goto yy56;
yy526:
	YYDEBUG(526, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy504;
			if (yych == 'e') goto yy504;
			goto yy440;
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'Y') goto yy504;
			if (yych == 'y') goto yy504;
			goto yy440;
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy504;
			goto yy440;
		}
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych != 'I') goto yy440;
		}
	}
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy504;
			goto yy440;
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy496;
			if (yych <= '/') goto yy440;
			goto yy498;
		} else {
			if (yych == 'I') goto yy504;
			goto yy440;
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy565;
	} else {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy579;
		if (yych <= ':') goto yy457;
		goto yy455;
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		if (yych <= '.') goto yy565;
		goto yy455;
	} else {
		if (yych <= '2') goto yy579;
		if (yych <= '9') goto yy578;
		if (yych <= ':') goto yy457;
		goto yy455;
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy565;
	} else {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy578;
		if (yych <= ':') goto yy457;
		goto yy455;
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy565;
	} else {
		if (yych == ':') goto yy457;
		goto yy455;
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy559;
	if (yych == 'e') goto yy559;
	goto yy56;
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy556;
	if (yych == 'a') goto yy556;
	goto yy56;
yy538:
	YYDEBUG(538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy514;
		if (yych <= 'T') goto yy56;
		goto yy513;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy514;
		} else {
			if (yych == 'u') goto yy513;
			goto yy56;
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy549;
	if (yych == 'e') goto yy549;
	goto yy56;
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy543;
	if (yych == 'e') goto yy543;
	goto yy56;
yy541:
	YYDEBUG(541, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy542:
	YYDEBUG(542, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy541;
	case 'A':
	case 'a':	goto yy538;
	case 'D':
	case 'd':	goto yy540;
	case 'F':
	case 'f':	goto yy536;
	case 'I':	goto yy439;
	case 'J':
	case 'j':	goto yy443;
	case 'M':
	case 'm':	goto yy537;
	case 'N':
	case 'n':	goto yy446;
	case 'O':
	case 'o':	goto yy445;
	case 'S':
	case 's':	goto yy539;
	case 'V':	goto yy441;
	case 'X':	goto yy442;
	default:	goto yy56;
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy544;
	if (yych != 'c') goto yy56;
yy544:
	YYDEBUG(544, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy545;
			if (yych != 'e') goto yy440;
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy546;
	if (yych != 'm') goto yy56;
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy547;
	if (yych != 'b') goto yy56;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy548;
	if (yych != 'e') goto yy56;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy504;
	if (yych == 'r') goto yy504;
	goto yy56;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy550;
	if (yych != 'p') goto yy56;
yy550:
	YYDEBUG(550, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'T') goto yy551;
			if (yych != 't') goto yy440;
		}
	}
yy551:
	YYDEBUG(551, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy552;
			if (yych != 'e') goto yy440;
		}
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy553;
	if (yych != 'm') goto yy56;
yy553:
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy554;
	if (yych != 'b') goto yy56;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy555;
	if (yych != 'e') goto yy56;
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy504;
	if (yych == 'r') goto yy504;
	goto yy56;
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy557;
		if (yych <= 'X') goto yy56;
		goto yy504;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy504;
			goto yy56;
		}
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'C') goto yy558;
			if (yych != 'c') goto yy440;
		}
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy504;
	if (yych == 'h') goto yy504;
	goto yy56;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy560;
	if (yych != 'b') goto yy56;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			goto yy496;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'R') goto yy561;
			if (yych != 'r') goto yy440;
		}
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy562;
	if (yych != 'u') goto yy56;
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy563;
	if (yych != 'a') goto yy56;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy564;
	if (yych != 'r') goto yy56;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy504;
	if (yych == 'y') goto yy504;
	goto yy56;
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy572;
	if (yych <= '6') goto yy573;
	if (yych <= '9') goto yy574;
	goto yy56;
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(567, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy568:
	YYDEBUG(568, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(570, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(571, *YYCURSOR);
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy577;
	goto yy455;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy461;
		goto yy455;
	} else {
		if (yych <= '0') goto yy577;
		if (yych <= '9') goto yy575;
		goto yy455;
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych >= ':') goto yy455;
yy575:
	YYDEBUG(575, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy576;
	if (yych <= '9') goto yy569;
yy576:
	YYDEBUG(576, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy465;
			if (yych <= 0x1F) goto yy455;
			goto yy465;
		} else {
			if (yych == '.') goto yy461;
			if (yych <= '/') goto yy455;
			goto yy569;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy467;
			if (yych <= 'O') goto yy455;
			goto yy467;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy467;
			} else {
				if (yych == 'p') goto yy467;
				goto yy455;
			}
		}
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy472;
			if (yych <= 0x1F) goto yy455;
			goto yy472;
		} else {
			if (yych == '.') goto yy457;
			if (yych <= '9') goto yy455;
			goto yy457;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy474;
			if (yych <= 'O') goto yy455;
			goto yy474;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy474;
			} else {
				if (yych == 'p') goto yy474;
				goto yy455;
			}
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy472;
			if (yych <= 0x1F) goto yy455;
			goto yy472;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy455;
				goto yy566;
			} else {
				if (yych <= '.') goto yy565;
				if (yych <= '9') goto yy455;
				goto yy457;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy474;
			if (yych <= 'O') goto yy455;
			goto yy474;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy455;
				goto yy474;
			} else {
				if (yych == 'p') goto yy474;
				goto yy455;
			}
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy619;
		goto yy566;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy582;
		goto yy56;
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy619;
		goto yy566;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy619;
	if (yych <= '.') goto yy566;
	goto yy56;
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy615;
		if (yych <= 'T') goto yy56;
		goto yy614;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy615;
		} else {
			if (yych == 'u') goto yy614;
			goto yy56;
		}
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy612;
	if (yych == 'e') goto yy612;
	goto yy56;
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy609;
	if (yych == 'a') goto yy609;
	goto yy56;
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy606;
		if (yych <= 'T') goto yy56;
		goto yy605;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy606;
		} else {
			if (yych == 'u') goto yy605;
			goto yy56;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy602;
	if (yych == 'e') goto yy602;
	goto yy56;
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy600;
	if (yych == 'c') goto yy600;
	goto yy56;
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy598;
	if (yych == 'o') goto yy598;
	goto yy56;
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy591;
	if (yych != 'e') goto yy56;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy592;
	if (yych != 'c') goto yy56;
yy592:
	YYDEBUG(592, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych >= '.') goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy545;
			if (yych == 'e') goto yy545;
			goto yy440;
		}
	}
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy497;
	if (yych <= '0') goto yy594;
	if (yych <= '2') goto yy595;
	if (yych <= '3') goto yy596;
	goto yy497;
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych <= '9') goto yy597;
	goto yy499;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych <= '9') goto yy597;
	goto yy499;
yy596:
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych <= '1') goto yy597;
	if (yych <= '9') goto yy505;
	goto yy499;
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy499;
	if (yych <= '9') goto yy506;
	goto yy499;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy599;
	if (yych != 'v') goto yy56;
yy599:
	YYDEBUG(599, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy500;
			if (yych == 'e') goto yy500;
			goto yy440;
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy601;
	if (yych != 't') goto yy56;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'O') goto yy510;
			if (yych == 'o') goto yy510;
			goto yy440;
		}
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy603;
	if (yych != 'p') goto yy56;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'T') goto yy604;
			if (yych != 't') goto yy440;
		}
	}
yy604:
	YYDEBUG(604, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy552;
			if (yych == 'e') goto yy552;
			goto yy440;
		}
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy608;
	if (yych == 'g') goto yy608;
	goto yy56;
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy607;
	if (yych != 'r') goto yy56;
yy607:
	YYDEBUG(607, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'I') goto yy516;
			if (yych == 'i') goto yy516;
			goto yy440;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'U') goto yy518;
			if (yych == 'u') goto yy518;
			goto yy440;
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy610;
		if (yych <= 'X') goto yy56;
		goto yy611;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy611;
			goto yy56;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'C') goto yy558;
			if (yych == 'c') goto yy558;
			goto yy440;
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy440;
			goto yy496;
		} else {
			if (yych == ' ') goto yy496;
			goto yy440;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy593;
			goto yy496;
		} else {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		}
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy613;
	if (yych != 'b') goto yy56;
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'R') goto yy561;
			if (yych == 'r') goto yy561;
			goto yy440;
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy618;
		if (yych <= 'M') goto yy56;
		goto yy617;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy618;
		} else {
			if (yych == 'n') goto yy617;
			goto yy56;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy616;
	if (yych != 'n') goto yy56;
yy616:
	YYDEBUG(616, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'U') goto yy523;
			if (yych == 'u') goto yy523;
			goto yy440;
		}
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'E') goto yy504;
			if (yych == 'e') goto yy504;
			goto yy440;
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy496;
			goto yy440;
		} else {
			if (yych <= ' ') goto yy496;
			if (yych <= ',') goto yy440;
			if (yych <= '-') goto yy593;
			goto yy496;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy440;
			if (yych <= '9') goto yy498;
			goto yy440;
		} else {
			if (yych <= 'Y') goto yy504;
			if (yych == 'y') goto yy504;
			goto yy440;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy620;
	if (yych <= '3') goto yy622;
	if (yych <= '9') goto yy623;
	goto yy56;
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy629;
		if (yych >= 'n') goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
		}
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy621;
			goto yy629;
		} else {
			if (yych <= '9') goto yy568;
			if (yych <= 'm') goto yy621;
			goto yy625;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy568;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy628;
	goto yy56;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy628;
	goto yy56;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy628;
	goto yy56;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy56;
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy621;
yy629:
	YYDEBUG(629, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy569;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy687;
		} else {
			if (yych <= '9') goto yy633;
			if (yych >= 'n') goto yy684;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy685;
		} else {
			if (yych <= 's') goto yy683;
			if (yych <= 't') goto yy686;
		}
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy632:
	YYDEBUG(632, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy631;
			goto yy687;
		} else {
			if (yych <= '1') goto yy633;
			if (yych <= 'm') goto yy631;
			goto yy684;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy685;
		} else {
			if (yych <= 's') goto yy683;
			if (yych <= 't') goto yy686;
			goto yy631;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy687;
		if (yych <= 'm') goto yy631;
		goto yy684;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy631;
			goto yy685;
		} else {
			if (yych <= 's') goto yy683;
			if (yych <= 't') goto yy686;
			goto yy631;
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy682;
		if (yych <= 'T') goto yy56;
		goto yy681;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy682;
		} else {
			if (yych == 'u') goto yy681;
			goto yy56;
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy680;
	if (yych == 'e') goto yy680;
	goto yy56;
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy679;
	if (yych == 'a') goto yy679;
	goto yy56;
yy637:
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy678;
		if (yych <= 'T') goto yy56;
		goto yy677;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy678;
		} else {
			if (yych == 'u') goto yy677;
			goto yy56;
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy675;
	if (yych == 'e') goto yy675;
	goto yy56;
yy639:
	YYDEBUG(639, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy674;
	if (yych == 'c') goto yy674;
	goto yy56;
yy640:
	YYDEBUG(640, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy673;
	if (yych == 'o') goto yy673;
	goto yy56;
yy641:
	YYDEBUG(641, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy642;
	if (yych != 'e') goto yy56;
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy643;
	if (yych != 'c') goto yy56;
yy643:
	YYDEBUG(643, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy644:
	YYDEBUG(644, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy650;
	if (yych <= '2') goto yy651;
	goto yy56;
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy652;
	goto yy56;
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy657;
	if (yych <= '6') goto yy658;
	goto yy56;
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy659;
	goto yy56;
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy659:
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy660;
	if (yych != ' ') goto yy56;
yy660:
	YYDEBUG(660, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(661, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy660;
		} else {
			if (yych == ' ') goto yy660;
			goto yy56;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy56;
			goto yy663;
		} else {
			if (yych != 'G') goto yy56;
		}
	}
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy671;
	goto yy56;
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy664;
	if (yych <= '2') goto yy666;
	if (yych <= '9') goto yy667;
	goto yy56;
yy664:
	YYDEBUG(664, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy665;
	if (yych <= '9') goto yy667;
	if (yych <= ':') goto yy668;
yy665:
	YYDEBUG(665, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy665;
		if (yych >= '5') goto yy669;
	} else {
		if (yych <= '9') goto yy670;
		if (yych <= ':') goto yy668;
		goto yy665;
	}
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy665;
	if (yych <= '5') goto yy669;
	if (yych <= '9') goto yy670;
	if (yych >= ';') goto yy665;
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy665;
	if (yych <= '5') goto yy669;
	if (yych <= '9') goto yy670;
	goto yy665;
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy665;
	if (yych >= ':') goto yy665;
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy665;
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy663;
	if (yych == '-') goto yy663;
	goto yy56;
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy643;
	if (yych == 'v') goto yy643;
	goto yy56;
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy643;
	if (yych == 't') goto yy643;
	goto yy56;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy676;
	if (yych != 'p') goto yy56;
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy644;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy643;
		if (yych == 't') goto yy643;
		goto yy56;
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy643;
	if (yych == 'g') goto yy643;
	goto yy56;
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy643;
	if (yych == 'r') goto yy643;
	goto yy56;
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy643;
		if (yych <= 'X') goto yy56;
		goto yy643;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy643;
		} else {
			if (yych == 'y') goto yy643;
			goto yy56;
		}
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy643;
	if (yych == 'b') goto yy643;
	goto yy56;
yy681:
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy643;
		if (yych <= 'M') goto yy56;
		goto yy643;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy643;
		} else {
			if (yych == 'n') goto yy643;
			goto yy56;
		}
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy643;
	if (yych == 'n') goto yy643;
	goto yy56;
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy692;
	goto yy56;
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy692;
	goto yy56;
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy692;
	goto yy56;
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy692;
	goto yy56;
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy631;
	if (yych >= ':') goto yy631;
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy631;
	if (yych >= ':') goto yy631;
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy631;
	if (yych >= ':') goto yy631;
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy631;
yy692:
	YYDEBUG(692, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy687;
	goto yy631;
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy695;
		goto yy542;
	} else {
		if (yych <= '-') goto yy696;
		if (yych <= '.') goto yy695;
		if (yych >= '0') goto yy542;
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy637;
	case 'D':
	case 'd':	goto yy641;
	case 'F':
	case 'f':	goto yy635;
	case 'J':
	case 'j':	goto yy634;
	case 'M':
	case 'm':	goto yy636;
	case 'N':
	case 'n':	goto yy640;
	case 'O':
	case 'o':	goto yy639;
	case 'S':
	case 's':	goto yy638;
	default:	goto yy56;
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy542;
	if (yych <= '0') goto yy700;
	if (yych <= '1') goto yy701;
	if (yych <= '9') goto yy702;
	goto yy542;
yy696:
	YYDEBUG(696, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy542;
	if (yych <= '0') goto yy697;
	if (yych <= '1') goto yy698;
	if (yych <= '9') goto yy699;
	goto yy542;
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy566;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy699;
	goto yy56;
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy566;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy566;
	goto yy56;
yy700:
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy566;
		goto yy703;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy702;
		goto yy56;
	}
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy566;
		goto yy703;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy566;
	if (yych >= '/') goto yy56;
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy575;
	goto yy56;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy749;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy747;
	goto yy60;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy715;
	case '1':	goto yy716;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy717;
	case 'A':
	case 'a':	goto yy710;
	case 'D':
	case 'd':	goto yy714;
	case 'F':
	case 'f':	goto yy708;
	case 'J':
	case 'j':	goto yy707;
	case 'M':
	case 'm':	goto yy709;
	case 'N':
	case 'n':	goto yy713;
	case 'O':
	case 'o':	goto yy712;
	case 'S':
	case 's':	goto yy711;
	default:	goto yy56;
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy746;
		if (yych <= 'T') goto yy56;
		goto yy745;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy746;
		} else {
			if (yych == 'u') goto yy745;
			goto yy56;
		}
	}
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy744;
	if (yych == 'e') goto yy744;
	goto yy56;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy743;
	if (yych == 'a') goto yy743;
	goto yy56;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy742;
		if (yych <= 'T') goto yy56;
		goto yy741;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy742;
		} else {
			if (yych == 'u') goto yy741;
			goto yy56;
		}
	}
yy711:
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy739;
	if (yych == 'e') goto yy739;
	goto yy56;
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy738;
	if (yych == 'c') goto yy738;
	goto yy56;
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy737;
	if (yych == 'o') goto yy737;
	goto yy56;
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy729;
	if (yych == 'e') goto yy729;
	goto yy56;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy718;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy722;
	goto yy56;
yy716:
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy718;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy722;
	goto yy56;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy719;
	if (yych <= '3') goto yy720;
	if (yych <= '9') goto yy721;
	goto yy56;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy721;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy720:
	YYDEBUG(720, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '1') goto yy721;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy625;
		goto yy621;
	} else {
		if (yych <= 'r') goto yy626;
		if (yych <= 's') goto yy624;
		if (yych <= 't') goto yy627;
		goto yy621;
	}
yy722:
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy725;
	} else {
		if (yych <= '3') goto yy726;
		if (yych <= '9') goto yy721;
		goto yy56;
	}
	YYDEBUG(724, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy727;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy725:
	YYDEBUG(725, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy727;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy726:
	YYDEBUG(726, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '1') goto yy727;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy727:
	YYDEBUG(727, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy625;
	} else {
		if (yych <= 'r') goto yy626;
		if (yych <= 's') goto yy624;
		if (yych <= 't') goto yy627;
	}
yy728:
	YYDEBUG(728, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy729:
	YYDEBUG(729, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy730;
	if (yych != 'c') goto yy56;
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy732;
	if (yych <= '2') goto yy733;
	if (yych <= '3') goto yy734;
	goto yy56;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy735;
	goto yy56;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy735;
	goto yy56;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy735:
	YYDEBUG(735, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(736, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy730;
	if (yych == 'v') goto yy730;
	goto yy56;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy730;
	if (yych == 't') goto yy730;
	goto yy56;
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy740;
	if (yych != 'p') goto yy56;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy731;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy730;
		if (yych == 't') goto yy730;
		goto yy56;
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy730;
	if (yych == 'g') goto yy730;
	goto yy56;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy730;
	if (yych == 'r') goto yy730;
	goto yy56;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy730;
		if (yych <= 'X') goto yy56;
		goto yy730;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy730;
		} else {
			if (yych == 'y') goto yy730;
			goto yy56;
		}
	}
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy730;
	if (yych == 'b') goto yy730;
	goto yy56;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy730;
		if (yych <= 'M') goto yy56;
		goto yy730;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy730;
		} else {
			if (yych == 'n') goto yy730;
			goto yy56;
		}
	}
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy730;
	if (yych == 'n') goto yy730;
	goto yy56;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy755;
				} else {
					if (yych <= ' ') goto yy755;
					if (yych >= '-') goto yy752;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy756;
					if (yych <= '/') goto yy753;
					goto yy769;
				} else {
					if (yych <= '1') goto yy770;
					if (yych <= '2') goto yy772;
					goto yy773;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy54;
					if (yych <= ':') goto yy771;
				} else {
					if (yych <= 'A') goto yy755;
					if (yych >= 'D') goto yy755;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy755;
				} else {
					if (yych <= 'J') goto yy755;
					if (yych >= 'M') goto yy755;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy748;
					if (yych <= 'V') goto yy755;
					goto yy774;
				} else {
					if (yych <= 'Y') goto yy755;
					if (yych >= 'a') goto yy755;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy755;
				} else {
					if (yych != 'g') goto yy755;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy755;
				} else {
					if (yych <= 'o') goto yy755;
					if (yych >= 's') goto yy755;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy755;
				} else {
					if (yych <= 'y') goto yy755;
					if (yych == 0xC2) goto yy755;
				}
			}
		}
	}
yy748:
	YYDEBUG(748, *YYCURSOR);
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy750;
	case '1':	goto yy751;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy717;
	case 'A':
	case 'a':	goto yy710;
	case 'D':
	case 'd':	goto yy714;
	case 'F':
	case 'f':	goto yy708;
	case 'J':
	case 'j':	goto yy707;
	case 'M':
	case 'm':	goto yy709;
	case 'N':
	case 'n':	goto yy713;
	case 'O':
	case 'o':	goto yy712;
	case 'S':
	case 's':	goto yy711;
	default:	goto yy56;
	}
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy718;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy717;
	goto yy56;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy718;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy717;
	goto yy56;
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy937;
	case '1':	goto yy939;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy940;
	case 'A':
	case 'a':	goto yy931;
	case 'D':
	case 'd':	goto yy935;
	case 'F':
	case 'f':	goto yy929;
	case 'J':
	case 'j':	goto yy928;
	case 'M':
	case 'm':	goto yy930;
	case 'N':
	case 'n':	goto yy934;
	case 'O':
	case 'o':	goto yy933;
	case 'S':
	case 's':	goto yy932;
	case 'W':	goto yy936;
	default:	goto yy903;
	}
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy911;
	if (yych <= '1') goto yy912;
	if (yych <= '9') goto yy913;
	goto yy56;
yy754:
	YYDEBUG(754, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy755:
	YYDEBUG(755, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy754;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy754;
					if (yych <= ',') goto yy56;
					goto yy902;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy764;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy768;
					if (yych == 'F') goto yy762;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy65;
					if (yych <= 'I') goto yy757;
					goto yy761;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy763;
					goto yy767;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy766;
					if (yych <= 'R') goto yy56;
					goto yy765;
				} else {
					if (yych <= 'T') goto yy70;
					if (yych <= 'U') goto yy63;
					if (yych <= 'V') goto yy759;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy760;
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy764;
					if (yych <= 'c') goto yy56;
					goto yy768;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy762;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy65;
					if (yych == 'j') goto yy761;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy763;
					if (yych <= 'n') goto yy767;
					goto yy766;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy765;
					if (yych <= 't') goto yy70;
					goto yy63;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy69;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy68;
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy903;
	if (yych <= '0') goto yy895;
	if (yych <= '2') goto yy896;
	if (yych <= '3') goto yy897;
	goto yy903;
yy757:
	YYDEBUG(757, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy894;
	} else {
		if (yych == 'W') goto yy758;
		if (yych <= 'X') goto yy848;
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy892;
	goto yy758;
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy891;
	goto yy758;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy884;
		if (yych <= 'T') goto yy56;
		goto yy883;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy884;
		} else {
			if (yych == 'u') goto yy883;
			goto yy56;
		}
	}
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy877;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy100;
			if (yych <= 'Q') goto yy56;
			goto yy99;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy877;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy100;
			if (yych == 'r') goto yy99;
			goto yy56;
		}
	}
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy874;
			if (yych <= 'H') goto yy56;
			goto yy138;
		} else {
			if (yych == 'O') goto yy137;
			if (yych <= 'R') goto yy56;
			goto yy139;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy874;
			if (yych <= 'h') goto yy56;
			goto yy138;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy137;
			} else {
				if (yych == 's') goto yy139;
				goto yy56;
			}
		}
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy868;
		if (yych <= 'T') goto yy56;
		goto yy867;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy868;
		} else {
			if (yych == 'u') goto yy867;
			goto yy56;
		}
	}
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy860;
			if (yych <= 'T') goto yy56;
			goto yy118;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy119;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy860;
			if (yych == 'u') goto yy118;
			goto yy56;
		}
	}
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy855;
	if (yych == 'c') goto yy855;
	goto yy56;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy849;
	if (yych == 'o') goto yy849;
	goto yy56;
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy115;
		if (yych <= 'D') goto yy56;
		goto yy842;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy115;
		} else {
			if (yych == 'e') goto yy842;
			goto yy56;
		}
	}
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy839;
	if (yych <= '9') goto yy840;
	goto yy60;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy808;
	if (yych <= '9') goto yy787;
	goto yy60;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy788;
	if (yych <= '1') goto yy789;
	goto yy56;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy787;
	goto yy60;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy783;
	if (yych <= '6') goto yy784;
	if (yych <= '9') goto yy54;
	goto yy60;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '0') goto yy775;
		if (yych <= '4') goto yy776;
		goto yy777;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy56;
			goto yy84;
		} else {
			if (yych == 'e') goto yy84;
			goto yy56;
		}
	}
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy778;
	goto yy56;
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy778;
	goto yy56;
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '4') goto yy56;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy780;
	if (yych <= '/') goto yy779;
	if (yych <= '7') goto yy781;
yy779:
	YYDEBUG(779, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '8') goto yy56;
yy781:
	YYDEBUG(781, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(782, *YYCURSOR);
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy785;
	goto yy60;
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '6') goto yy785;
	if (yych <= '9') goto yy54;
	goto yy60;
yy785:
	YYDEBUG(785, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'U') {
					if (yych >= 'S') goto yy60;
				} else {
					if (yych == 'W') goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy60;
				if (yych == 'd') goto yy60;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy60;
				} else {
					if (yych <= 'h') goto yy60;
					if (yych >= 'm') goto yy60;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy786;
				if (yych != 'v') goto yy60;
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
				}
			}
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy785;
	goto yy60;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy790;
	goto yy56;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy792;
	if (yych <= '2') goto yy793;
	if (yych <= '3') goto yy794;
	goto yy56;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy795;
	goto yy56;
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy795;
	goto yy56;
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy797;
	if (yych <= '2') goto yy798;
	goto yy56;
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy799;
	goto yy56;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy804;
	if (yych <= '6') goto yy805;
	goto yy56;
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy806;
	goto yy56;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy806:
	YYDEBUG(806, *YYCURSOR);
	++YYCURSOR;
yy807:
	YYDEBUG(807, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->us = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych >= '1') goto yy810;
	} else {
		if (yych <= '3') goto yy811;
		if (yych <= '9') goto yy785;
		goto yy60;
	}
yy809:
	YYDEBUG(809, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy786;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy786;
					goto yy812;
				} else {
					if (yych == 'D') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy786;
				if (yych <= 'H') goto yy60;
				goto yy786;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy786;
				} else {
					if (yych == 'V') goto yy786;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy786;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy786;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy786;
				} else {
					if (yych == 'v') goto yy786;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy786;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy786;
				}
			}
		}
	}
yy810:
	YYDEBUG(810, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy786;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy786;
					goto yy812;
				} else {
					if (yych == 'D') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy786;
				if (yych <= 'H') goto yy60;
				goto yy786;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy786;
				} else {
					if (yych == 'V') goto yy786;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy786;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy786;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy786;
				} else {
					if (yych == 'v') goto yy786;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy786;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy786;
				}
			}
		}
	}
yy811:
	YYDEBUG(811, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy786;
				goto yy60;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy786;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy786;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy786;
					goto yy60;
				} else {
					if (yych == 'H') goto yy60;
					goto yy786;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy786;
				} else {
					if (yych == 'V') goto yy786;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy786;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy786;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy786;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy786;
				} else {
					if (yych == 'v') goto yy786;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy786;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy786;
				}
			}
		}
	}
yy812:
	YYDEBUG(812, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= 'D') {
					if (yych >= 'D') goto yy66;
				} else {
					if (yych == 'F') goto yy67;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy65;
				} else {
					if (yych <= 'M') goto yy61;
					if (yych >= 'S') goto yy64;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy814;
					goto yy63;
				} else {
					if (yych == 'W') goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy68;
				} else {
					if (yych <= 'd') goto yy66;
					if (yych >= 'f') goto yy67;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy65;
				} else {
					if (yych == 'm') goto yy61;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy64;
					goto yy815;
				} else {
					if (yych <= 'u') goto yy63;
					if (yych >= 'w') goto yy69;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy68;
				} else {
					if (yych == 0xC2) goto yy62;
				}
			}
		}
	}
yy813:
	YYDEBUG(813, *YYCURSOR);
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy829;
			goto yy830;
		} else {
			if (yych <= '9') goto yy831;
			if (yych <= 'G') goto yy56;
			goto yy71;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy72;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy71;
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych >= '2') goto yy817;
		} else {
			if (yych <= '9') goto yy818;
			if (yych <= 'G') goto yy56;
			goto yy71;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy72;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy71;
			if (yych == 'u') goto yy72;
			goto yy56;
		}
	}
	YYDEBUG(816, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy823;
	if (yych <= '9') goto yy818;
	goto yy56;
yy817:
	YYDEBUG(817, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy823;
	if (yych <= '5') goto yy819;
	goto yy56;
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy821;
	if (yych <= '6') goto yy822;
	goto yy56;
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy806;
	goto yy56;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy806;
	goto yy56;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy824;
	if (yych <= '9') goto yy820;
	goto yy56;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy825;
	if (yych <= '6') goto yy826;
	if (yych <= '9') goto yy820;
	goto yy56;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy827;
	if (yych <= '6') goto yy828;
	if (yych <= '9') goto yy806;
	goto yy56;
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy827;
	if (yych <= '5') goto yy821;
	if (yych <= '6') goto yy822;
	goto yy56;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy806;
	goto yy807;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy806;
	goto yy807;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy838;
	if (yych <= '9') goto yy831;
	if (yych <= ':') goto yy832;
	goto yy56;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '4') goto yy838;
		goto yy819;
	} else {
		if (yych == ':') goto yy832;
		goto yy56;
	}
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy819;
	if (yych != ':') goto yy56;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy836;
	if (yych <= '6') goto yy837;
	goto yy56;
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy806;
	goto yy56;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy806;
	goto yy56;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy824;
	if (yych <= '9') goto yy820;
	if (yych <= ':') goto yy832;
	goto yy56;
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy841;
		goto yy810;
	} else {
		if (yych <= '3') goto yy811;
		if (yych <= '9') goto yy785;
		goto yy60;
	}
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy809;
		goto yy810;
	} else {
		if (yych <= '3') goto yy811;
		if (yych <= '9') goto yy785;
		goto yy60;
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy812;
	goto yy60;
yy842:
	YYDEBUG(842, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy843;
	if (yych != 'c') goto yy56;
yy843:
	YYDEBUG(843, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy844;
	if (yych != 'e') goto yy758;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy845;
	if (yych != 'm') goto yy56;
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy846;
	if (yych != 'b') goto yy56;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy847;
	if (yych != 'e') goto yy56;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy848;
	if (yych != 'r') goto yy56;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy758;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy850;
	if (yych != 'v') goto yy56;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy851;
	if (yych != 'e') goto yy758;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy852;
	if (yych != 'm') goto yy56;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy853;
	if (yych != 'b') goto yy56;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy854;
	if (yych != 'e') goto yy56;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy848;
	if (yych == 'r') goto yy848;
	goto yy56;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy856;
	if (yych != 't') goto yy56;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy857;
	if (yych != 'o') goto yy758;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy858;
	if (yych != 'b') goto yy56;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy859;
	if (yych != 'e') goto yy56;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy848;
	if (yych == 'r') goto yy848;
	goto yy56;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy121;
		if (yych <= 'O') goto yy56;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy121;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy862;
	if (yych != 't') goto yy758;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy863;
	if (yych != 'e') goto yy758;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy864;
	if (yych != 'm') goto yy56;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy865;
	if (yych != 'b') goto yy56;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy866;
	if (yych != 'e') goto yy56;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy848;
	if (yych == 'r') goto yy848;
	goto yy56;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy871;
	if (yych == 'g') goto yy871;
	goto yy56;
yy868:
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy869;
	if (yych != 'r') goto yy56;
yy869:
	YYDEBUG(869, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy870;
	if (yych != 'i') goto yy758;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy848;
	if (yych == 'l') goto yy848;
	goto yy56;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy872;
	if (yych != 'u') goto yy758;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy873;
	if (yych != 's') goto yy56;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy848;
	if (yych == 't') goto yy848;
	goto yy56;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy875;
		if (yych <= 'X') goto yy56;
		goto yy848;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy848;
			goto yy56;
		}
	}
yy875:
	YYDEBUG(875, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy876;
	if (yych != 'c') goto yy758;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy848;
	if (yych == 'h') goto yy848;
	goto yy56;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy878;
	if (yych != 'b') goto yy56;
yy878:
	YYDEBUG(878, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy879;
	if (yych != 'r') goto yy758;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy880;
	if (yych != 'u') goto yy56;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy881;
	if (yych != 'a') goto yy56;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy882;
	if (yych != 'r') goto yy56;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy848;
	if (yych == 'y') goto yy848;
	goto yy56;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy890;
		if (yych <= 'M') goto yy56;
		goto yy889;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy890;
		} else {
			if (yych == 'n') goto yy889;
			goto yy56;
		}
	}
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy885;
	if (yych != 'n') goto yy56;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy886;
	if (yych != 'u') goto yy758;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy887;
	if (yych != 'a') goto yy56;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy888;
	if (yych != 'r') goto yy56;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy848;
	if (yych == 'y') goto yy848;
	goto yy56;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy848;
	if (yych == 'e') goto yy848;
	goto yy758;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy848;
	if (yych == 'y') goto yy848;
	goto yy758;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy848;
	goto yy758;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy758;
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy848;
	goto yy758;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy848;
	goto yy758;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy910;
	if (yych <= '9') goto yy909;
	goto yy56;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy908;
	goto yy56;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy906;
	if (yych <= '6') goto yy905;
	goto yy56;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy877;
	if (yych == 'e') goto yy877;
	goto yy56;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy874;
	if (yych == 'a') goto yy874;
	goto yy56;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy904;
	if (yych == 'e') goto yy904;
	goto yy56;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy842;
	if (yych == 'e') goto yy842;
	goto yy56;
yy902:
	YYDEBUG(902, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy903:
	YYDEBUG(903, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy902;
	case 'A':
	case 'a':	goto yy764;
	case 'D':
	case 'd':	goto yy901;
	case 'F':
	case 'f':	goto yy898;
	case 'I':	goto yy757;
	case 'J':
	case 'j':	goto yy761;
	case 'M':
	case 'm':	goto yy899;
	case 'N':
	case 'n':	goto yy767;
	case 'O':
	case 'o':	goto yy766;
	case 'S':
	case 's':	goto yy900;
	case 'V':	goto yy759;
	case 'X':	goto yy760;
	default:	goto yy56;
	}
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy861;
	if (yych == 'p') goto yy861;
	goto yy56;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '6') goto yy907;
	goto yy56;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy786;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy907;
	goto yy56;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy907;
	goto yy56;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy907;
	goto yy56;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy914;
	if (yych <= '9') goto yy922;
	goto yy56;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy914;
	if (yych <= '2') goto yy922;
	goto yy56;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy915;
	if (yych <= '3') goto yy916;
	if (yych <= '9') goto yy917;
	goto yy56;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '9') goto yy917;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy916:
	YYDEBUG(916, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '1') goto yy917;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy917:
	YYDEBUG(917, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy919;
		goto yy419;
	} else {
		if (yych <= 'r') goto yy920;
		if (yych <= 's') goto yy918;
		if (yych <= 't') goto yy921;
		goto yy419;
	}
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy418;
	goto yy56;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy418;
	goto yy56;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy418;
	goto yy56;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy418;
	goto yy56;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy925;
	} else {
		if (yych <= '3') goto yy926;
		if (yych <= '9') goto yy917;
		goto yy56;
	}
	YYDEBUG(924, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '9') goto yy927;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy925:
	YYDEBUG(925, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '9') goto yy927;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy926:
	YYDEBUG(926, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy419;
		if (yych <= '1') goto yy927;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy927:
	YYDEBUG(927, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy418;
		if (yych <= 'm') goto yy419;
		goto yy919;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy920;
		} else {
			if (yych <= 's') goto yy918;
			if (yych <= 't') goto yy921;
			goto yy419;
		}
	}
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1008;
		if (yych <= 'T') goto yy56;
		goto yy1007;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy1008;
		} else {
			if (yych == 'u') goto yy1007;
			goto yy56;
		}
	}
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1005;
	if (yych == 'e') goto yy1005;
	goto yy56;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1002;
	if (yych == 'a') goto yy1002;
	goto yy56;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy999;
		if (yych <= 'T') goto yy56;
		goto yy998;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy999;
		} else {
			if (yych == 'u') goto yy998;
			goto yy56;
		}
	}
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy995;
	if (yych == 'e') goto yy995;
	goto yy56;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy993;
	if (yych == 'c') goto yy993;
	goto yy56;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy991;
	if (yych == 'o') goto yy991;
	goto yy56;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy989;
	if (yych == 'e') goto yy989;
	goto yy56;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy775;
	if (yych <= '4') goto yy776;
	if (yych <= '5') goto yy777;
	goto yy56;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy941;
	if (yych <= '/') goto yy938;
	if (yych <= '9') goto yy960;
yy938:
	YYDEBUG(938, *YYCURSOR);
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy939:
	YYDEBUG(939, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy941;
	if (yych <= '/') goto yy938;
	if (yych <= '2') goto yy960;
	goto yy938;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy938;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy942;
	if (yych <= '3') goto yy943;
	if (yych <= '9') goto yy944;
	goto yy56;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy621;
			goto yy944;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy943:
	YYDEBUG(943, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy621;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy944:
	YYDEBUG(944, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy949;
		if (yych <= 'm') goto yy621;
		goto yy946;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy959;
	goto yy56;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy959;
	goto yy56;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy959;
	goto yy56;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy959;
	goto yy56;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy950;
	if (yych <= '2') goto yy951;
	if (yych <= '9') goto yy952;
	goto yy56;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy952;
	if (yych <= ':') goto yy953;
	goto yy56;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy952;
	if (yych == ':') goto yy953;
	goto yy56;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy954;
	if (yych <= '9') goto yy955;
	goto yy56;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy955;
	if (yych <= ':') goto yy956;
	goto yy56;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy957;
	if (yych <= '6') goto yy958;
	if (yych <= '9') goto yy806;
	goto yy56;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy806;
	goto yy807;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy806;
	goto yy807;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy949;
	goto yy621;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy938;
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy963;
	} else {
		if (yych <= '3') goto yy964;
		if (yych <= '9') goto yy944;
		goto yy56;
	}
	YYDEBUG(962, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy621;
			goto yy965;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy963:
	YYDEBUG(963, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy621;
			goto yy965;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy964:
	YYDEBUG(964, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy621;
		} else {
			if (yych == 'T') goto yy949;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy946;
			if (yych <= 'q') goto yy621;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy621;
		}
	}
yy965:
	YYDEBUG(965, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy966;
		if (yych <= 'm') goto yy419;
		goto yy946;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy419;
			goto yy947;
		} else {
			if (yych <= 's') goto yy945;
			if (yych <= 't') goto yy948;
			goto yy419;
		}
	}
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy967;
	if (yych <= '2') goto yy968;
	if (yych <= '9') goto yy952;
	goto yy56;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy969;
	if (yych <= ':') goto yy953;
	goto yy56;
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy969;
	if (yych == ':') goto yy953;
	goto yy56;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy971;
	if (yych <= '9') goto yy955;
	goto yy56;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy972;
	if (yych <= ':') goto yy956;
	goto yy56;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy974;
	if (yych <= '6') goto yy975;
	if (yych <= '9') goto yy806;
	goto yy56;
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy976;
	goto yy807;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy807;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy807;
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yyaccept = 22;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(979, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy981;
		if (yych <= ',') goto yy807;
		goto yy981;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy807;
			goto yy978;
		} else {
			if (yych != 'G') goto yy807;
		}
	}
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy987;
	goto yy56;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy982;
	if (yych <= '2') goto yy983;
	if (yych <= '9') goto yy984;
	goto yy56;
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy984;
	if (yych <= ':') goto yy985;
	goto yy807;
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy807;
		if (yych >= '5') goto yy986;
	} else {
		if (yych <= '9') goto yy806;
		if (yych <= ':') goto yy985;
		goto yy807;
	}
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '5') goto yy986;
	if (yych <= '9') goto yy806;
	if (yych >= ';') goto yy807;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '5') goto yy986;
	if (yych <= '9') goto yy806;
	goto yy807;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy807;
	if (yych <= '9') goto yy806;
	goto yy807;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy981;
	if (yych == '-') goto yy981;
	goto yy56;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy990;
	if (yych != 'c') goto yy56;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'E') goto yy844;
		if (yych == 'e') goto yy844;
		goto yy758;
	}
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy992;
	if (yych != 'v') goto yy56;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'E') goto yy851;
		if (yych == 'e') goto yy851;
		goto yy758;
	}
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy994;
	if (yych != 't') goto yy56;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'O') goto yy857;
		if (yych == 'o') goto yy857;
		goto yy758;
	}
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy996;
	if (yych != 'p') goto yy56;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'T') goto yy997;
		if (yych != 't') goto yy758;
	}
yy997:
	YYDEBUG(997, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'E') goto yy863;
		if (yych == 'e') goto yy863;
		goto yy758;
	}
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1001;
	if (yych == 'g') goto yy1001;
	goto yy56;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1000;
	if (yych != 'r') goto yy56;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'I') goto yy870;
		if (yych == 'i') goto yy870;
		goto yy758;
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'U') goto yy872;
		if (yych == 'u') goto yy872;
		goto yy758;
	}
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1003;
		if (yych <= 'X') goto yy56;
		goto yy1004;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy1004;
			goto yy56;
		}
	}
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'C') goto yy876;
		if (yych == 'c') goto yy876;
		goto yy758;
	}
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy731;
	goto yy758;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1006;
	if (yych != 'b') goto yy56;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'R') goto yy879;
		if (yych == 'r') goto yy879;
		goto yy758;
	}
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1011;
		if (yych <= 'M') goto yy56;
		goto yy1010;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy1011;
		} else {
			if (yych == 'n') goto yy1010;
			goto yy56;
		}
	}
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1009;
	if (yych != 'n') goto yy56;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'U') goto yy886;
		if (yych == 'u') goto yy886;
		goto yy758;
	}
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'E') goto yy848;
		if (yych == 'e') goto yy848;
		goto yy758;
	}
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy731;
		goto yy758;
	} else {
		if (yych <= 'Y') goto yy848;
		if (yych == 'y') goto yy848;
		goto yy758;
	}
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy542;
			goto yy695;
		} else {
			if (yych <= ',') goto yy542;
			if (yych <= '-') goto yy696;
			goto yy695;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy694;
			if (yych <= 'T') goto yy542;
			goto yy79;
		} else {
			if (yych == 'u') goto yy79;
			goto yy542;
		}
	}
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy121;
		if (yych <= 'O') goto yy56;
		goto yy550;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy121;
		} else {
			if (yych == 'p') goto yy550;
			goto yy56;
		}
	}
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1016;
			goto yy1018;
		} else {
			if (yych <= '-') goto yy1015;
			if (yych <= '.') goto yy695;
			if (yych <= '/') goto yy694;
			goto yy705;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy434;
			goto yy1018;
		} else {
			if (yych <= 'r') goto yy435;
			if (yych <= 's') goto yy429;
			if (yych <= 't') goto yy432;
			goto yy1018;
		}
	}
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1019;
	case '1':	goto yy1020;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy582;
	case 'A':
	case 'a':	goto yy586;
	case 'D':
	case 'd':	goto yy590;
	case 'F':
	case 'f':	goto yy584;
	case 'J':
	case 'j':	goto yy583;
	case 'M':
	case 'm':	goto yy585;
	case 'N':
	case 'n':	goto yy589;
	case 'O':
	case 'o':	goto yy588;
	case 'S':
	case 's':	goto yy587;
	default:	goto yy542;
	}
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1018;
	if (yych <= '0') goto yy700;
	if (yych <= '1') goto yy701;
	if (yych <= '9') goto yy702;
	goto yy1018;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1017;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy1017;
					if (yych <= ',') goto yy56;
					goto yy541;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy538;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy430;
					if (yych == 'F') goto yy431;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy65;
					if (yych <= 'I') goto yy439;
					goto yy443;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy427;
					goto yy446;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy445;
					if (yych <= 'R') goto yy56;
					goto yy428;
				} else {
					if (yych <= 'T') goto yy70;
					if (yych <= 'U') goto yy63;
					if (yych <= 'V') goto yy441;
					goto yy69;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy442;
					if (yych <= 'Y') goto yy68;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy538;
					if (yych <= 'c') goto yy56;
					goto yy430;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy431;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy65;
					if (yych == 'j') goto yy443;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy427;
					if (yych <= 'n') goto yy446;
					goto yy445;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy428;
					if (yych <= 't') goto yy70;
					goto yy63;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy69;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy68;
					if (yych == 0xC2) goto yy62;
					goto yy56;
				}
			}
		}
	}
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy619;
		goto yy566;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy1021;
		goto yy56;
	}
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy619;
		goto yy566;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy1022;
	if (yych <= '.') goto yy566;
	goto yy56;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy1024;
	} else {
		if (yych <= '3') goto yy1025;
		if (yych <= '9') goto yy623;
		goto yy56;
	}
	YYDEBUG(1023, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy1026;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy621;
		if (yych <= '9') goto yy1026;
		if (yych <= 'm') goto yy621;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy621;
		} else {
			if (yych <= '9') goto yy568;
			if (yych <= 'm') goto yy621;
			goto yy625;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy621;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy621;
		}
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy728;
		if (yych <= '9') goto yy569;
		if (yych <= 'm') goto yy728;
		goto yy625;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy728;
			goto yy626;
		} else {
			if (yych <= 's') goto yy624;
			if (yych <= 't') goto yy627;
			goto yy728;
		}
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1016;
			if (yych <= ',') goto yy1018;
			goto yy1015;
		} else {
			if (yych <= '.') goto yy1028;
			if (yych <= '/') goto yy694;
			if (yych <= '5') goto yy1030;
			goto yy705;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1029;
			if (yych == 'n') goto yy434;
			goto yy1018;
		} else {
			if (yych <= 'r') goto yy435;
			if (yych <= 's') goto yy429;
			if (yych <= 't') goto yy432;
			goto yy1018;
		}
	}
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy542;
		if (yych <= '0') goto yy1052;
		goto yy1053;
	} else {
		if (yych <= '5') goto yy1054;
		if (yych <= '9') goto yy1055;
		goto yy542;
	}
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1047;
	if (yych <= '9') goto yy1048;
	goto yy56;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy749;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
	YYDEBUG(1031, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy755;
				} else {
					if (yych <= ' ') goto yy755;
					if (yych >= '-') goto yy752;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy756;
					if (yych <= '/') goto yy753;
					goto yy1033;
				} else {
					if (yych <= '1') goto yy1034;
					if (yych <= '2') goto yy1035;
					goto yy1036;
				}
			}
		} else {
			if (yych <= 'A') {
				if (yych <= '9') {
					if (yych <= '5') goto yy1037;
					if (yych <= '6') goto yy1038;
					goto yy54;
				} else {
					if (yych <= ':') goto yy771;
					if (yych >= 'A') goto yy755;
				}
			} else {
				if (yych <= 'E') {
					if (yych == 'D') goto yy755;
				} else {
					if (yych == 'G') goto yy1032;
					if (yych <= 'J') goto yy755;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'O') goto yy755;
					if (yych >= 'S') goto yy755;
				} else {
					if (yych <= 'W') goto yy774;
					if (yych <= 'Y') goto yy755;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy755;
					if (yych >= 'd') goto yy755;
				} else {
					if (yych == 'f') goto yy755;
					if (yych >= 'h') goto yy755;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy755;
				} else {
					if (yych <= 'o') goto yy755;
					if (yych >= 's') goto yy755;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy755;
				} else {
					if (yych <= 'y') goto yy755;
					if (yych == 0xC2) goto yy755;
				}
			}
		}
	}
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1045;
	if (yych <= '9') goto yy1046;
	goto yy60;
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy1044;
	if (yych <= '9') goto yy1043;
	goto yy60;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1043;
	goto yy60;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy1041;
	if (yych <= '6') goto yy1042;
	if (yych <= '9') goto yy1039;
	goto yy60;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1039;
	goto yy60;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1039;
	if (yych <= '9') goto yy54;
	goto yy60;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'U') {
					if (yych >= 'S') goto yy60;
				} else {
					if (yych == 'W') goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy60;
				if (yych == 'd') goto yy60;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy60;
				} else {
					if (yych <= 'h') goto yy60;
					if (yych >= 'm') goto yy60;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy1040;
				if (yych != 'v') goto yy60;
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
				}
			}
		}
	}
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1040;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1040;
					goto yy785;
				} else {
					if (yych == 'D') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1040;
				if (yych <= 'H') goto yy60;
				goto yy1040;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'V') goto yy1040;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy1040;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1040;
				goto yy60;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1040;
					goto yy785;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy1040;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'H') goto yy60;
					goto yy1040;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'V') goto yy1040;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy1040;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1040;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1040;
					goto yy785;
				} else {
					if (yych == 'D') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1040;
				if (yych <= 'H') goto yy60;
				goto yy1040;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'V') goto yy1040;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych <= 'c') goto yy1040;
				goto yy60;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1040;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy1040;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy809;
					goto yy810;
				} else {
					if (yych <= '3') goto yy811;
					if (yych <= '9') goto yy785;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'G') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1040;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1040;
					if (yych <= 'U') goto yy60;
					goto yy1040;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy1040;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1040;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy1040;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy841;
					goto yy810;
				} else {
					if (yych <= '3') goto yy811;
					if (yych <= '9') goto yy785;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'G') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1040;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1040;
					if (yych <= 'U') goto yy60;
					goto yy1040;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy1040;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1040;
					goto yy60;
				} else {
					if (yych == ' ') goto yy60;
					goto yy1040;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy809;
					goto yy810;
				} else {
					if (yych <= '3') goto yy811;
					if (yych <= '9') goto yy785;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'G') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1040;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1040;
					if (yych <= 'U') goto yy60;
					goto yy1040;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy60;
					goto yy1040;
				} else {
					if (yych <= 'Y') goto yy60;
					if (yych <= 'c') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1040;
					goto yy60;
				} else {
					if (yych == 'h') goto yy60;
					goto yy1040;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy60;
					goto yy1040;
				} else {
					if (yych == 'v') goto yy1040;
					goto yy60;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1040;
					goto yy60;
				} else {
					if (yych == 0xC2) goto yy60;
					goto yy1040;
				}
			}
		}
	}
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1049;
		goto yy455;
	} else {
		if (yych <= '9') goto yy1048;
		if (yych <= ':') goto yy1049;
		goto yy455;
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1049;
	if (yych != ':') goto yy455;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1050;
	if (yych <= '6') goto yy1051;
	if (yych <= '9') goto yy460;
	goto yy56;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy460;
	goto yy455;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych == '0') goto yy460;
	goto yy455;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy1056;
	} else {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy1055;
		if (yych <= ':') goto yy1049;
		goto yy455;
	}
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		if (yych <= '.') goto yy1056;
		goto yy455;
	} else {
		if (yych <= '2') goto yy1055;
		if (yych <= '9') goto yy1048;
		if (yych <= ':') goto yy1049;
		goto yy455;
	}
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
		goto yy1056;
	} else {
		if (yych <= '/') goto yy455;
		if (yych <= '9') goto yy1048;
		if (yych <= ':') goto yy1049;
		goto yy455;
	}
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy455;
		if (yych <= '-') goto yy566;
	} else {
		if (yych == ':') goto yy1049;
		goto yy455;
	}
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1057;
	if (yych <= '6') goto yy1058;
	if (yych <= '9') goto yy574;
	goto yy56;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy1059;
	goto yy455;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy461;
		goto yy455;
	} else {
		if (yych <= '0') goto yy1059;
		if (yych <= '9') goto yy575;
		goto yy455;
	}
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy461;
	if (yych <= '/') goto yy455;
	if (yych <= '9') goto yy569;
	goto yy455;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy424;
			if (yych <= ',') goto yy426;
			goto yy1015;
		} else {
			if (yych <= '.') goto yy438;
			if (yych <= '/') goto yy436;
			if (yych <= '5') goto yy1030;
			goto yy705;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy447;
			if (yych == 'n') goto yy434;
			goto yy426;
		} else {
			if (yych <= 'r') goto yy435;
			if (yych <= 's') goto yy429;
			if (yych <= 't') goto yy432;
			goto yy426;
		}
	}
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1016;
			if (yych <= ',') goto yy1018;
			goto yy1015;
		} else {
			if (yych <= '.') goto yy1028;
			if (yych <= '/') goto yy436;
			if (yych <= '5') goto yy1030;
			goto yy705;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1029;
			if (yych == 'n') goto yy434;
			goto yy1018;
		} else {
			if (yych <= 'r') goto yy435;
			if (yych <= 's') goto yy429;
			if (yych <= 't') goto yy432;
			goto yy1018;
		}
	}
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1063;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy167;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'v') goto yy1064;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy168;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'i') goto yy1065;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy169;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'o') goto yy1066;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy1067;
		if (yych != 'u') goto yy3;
	}
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1068;
	if (yych != 's') goto yy56;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1069;
	if (yych != ' ') goto yy56;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1069;
				if (yych <= 0x1F) goto yy56;
				goto yy1069;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy1076;
				} else {
					if (yych == 'F') goto yy1077;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1075;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy1071;
					if (yych <= 'R') goto yy56;
					goto yy1074;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1080;
					goto yy1073;
				} else {
					if (yych == 'W') goto yy1079;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1078;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy1076;
					if (yych <= 'e') goto yy56;
					goto yy1077;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy1075;
				} else {
					if (yych != 'm') goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1074;
					goto yy1080;
				} else {
					if (yych <= 'u') goto yy1073;
					if (yych <= 'v') goto yy56;
					goto yy1079;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy1078;
				} else {
					if (yych == 0xC2) goto yy1072;
					goto yy56;
				}
			}
		}
	}
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy1155;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy1154;
			if (yych <= 'R') goto yy56;
			goto yy1156;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy1155;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy1154;
			if (yych == 's') goto yy1156;
			goto yy56;
		}
	}
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy1151;
	goto yy56;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1149;
	if (yych == 's') goto yy1149;
	goto yy56;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1136;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1137;
			if (yych <= 'T') goto yy56;
			goto yy1135;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1136;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1137;
			if (yych == 'u') goto yy1135;
			goto yy56;
		}
	}
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1133;
	if (yych == 'o') goto yy1133;
	goto yy56;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1132;
	if (yych == 'a') goto yy1132;
	goto yy56;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1117;
		if (yych <= 'Q') goto yy56;
		goto yy1116;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy1117;
		} else {
			if (yych == 'r') goto yy1116;
			goto yy56;
		}
	}
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1113;
	if (yych == 'e') goto yy1113;
	goto yy56;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1099;
	if (yych == 'e') goto yy1099;
	goto yy56;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1081;
		if (yych <= 'T') goto yy56;
		goto yy1082;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy1082;
			goto yy56;
		}
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1094;
	if (yych == 'u') goto yy1094;
	goto yy56;
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1083;
	if (yych != 'e') goto yy56;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych >= ' ') goto yy1085;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1087;
		} else {
			if (yych == 's') goto yy1087;
		}
	}
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(1086, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy56;
		goto yy1085;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy56;
			goto yy1091;
		} else {
			if (yych == 'o') goto yy1091;
			goto yy56;
		}
	}
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1088;
	if (yych != 'd') goto yy56;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1089;
	if (yych != 'a') goto yy56;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych != 'y') goto yy56;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1085;
	if (yych == ' ') goto yy1085;
	goto yy1084;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1092;
	if (yych != 'f') goto yy56;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1093, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1084;
		} else {
			if (yych != 'r') goto yy1084;
		}
	}
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1096;
	if (yych != 's') goto yy56;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1097;
	if (yych != 'd') goto yy56;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1098;
	if (yych != 'a') goto yy56;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1101;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1101;
		if (yych >= 'f') goto yy56;
	}
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1107;
	if (yych == 'k') goto yy1107;
	goto yy56;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1084;
		} else {
			if (yych != 'n') goto yy1084;
		}
	}
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1103;
	if (yych != 'e') goto yy56;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1104;
	if (yych != 's') goto yy56;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1105;
	if (yych != 'd') goto yy56;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1106;
	if (yych != 'a') goto yy56;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1110;
		if (yych >= 'S') goto yy1109;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1110;
		} else {
			if (yych == 's') goto yy1109;
		}
	}
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1084;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1111;
	if (yych != 'a') goto yy56;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1112;
	if (yych != 'y') goto yy56;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1109;
	if (yych == 's') goto yy1109;
	goto yy1084;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1114;
	if (yych != 'a') goto yy56;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1115;
	if (yych != 'r') goto yy56;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1109;
	if (yych == 's') goto yy1109;
	goto yy1084;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1129;
	if (yych == 'i') goto yy1129;
	goto yy56;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1118;
	if (yych != 'r') goto yy56;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1119;
	if (yych != 't') goto yy56;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1121;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1121;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1126;
	if (yych == 'i') goto yy1126;
	goto yy56;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1122;
	if (yych != 'n') goto yy56;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1123;
	if (yych != 'i') goto yy56;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1124;
	if (yych != 'g') goto yy56;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1125;
	if (yych != 'h') goto yy56;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1115;
	if (yych == 't') goto yy1115;
	goto yy56;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1127;
	if (yych != 'g') goto yy56;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1128;
	if (yych != 'h') goto yy56;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1115;
	if (yych == 't') goto yy1115;
	goto yy56;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1084;
		} else {
			if (yych != 'd') goto yy1084;
		}
	}
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1131;
	if (yych != 'a') goto yy56;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1115;
	if (yych == 'y') goto yy1115;
	goto yy56;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1134;
	if (yych != 'u') goto yy56;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1115;
	if (yych == 'r') goto yy1115;
	goto yy56;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1146;
	if (yych == 'n') goto yy1146;
	goto yy56;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1141;
	if (yych == 't') goto yy1141;
	goto yy56;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1138;
	if (yych != 'c') goto yy56;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1139;
		if (yych <= 'R') goto yy1084;
		goto yy1109;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1084;
		} else {
			if (yych == 's') goto yy1109;
			goto yy1084;
		}
	}
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1140;
	if (yych != 'n') goto yy56;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1115;
	if (yych == 'd') goto yy1115;
	goto yy56;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1084;
		} else {
			if (yych != 'u') goto yy1084;
		}
	}
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1143;
	if (yych != 'r') goto yy56;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1144;
	if (yych != 'd') goto yy56;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1145;
	if (yych != 'a') goto yy56;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1085;
		if (yych <= 0x1F) goto yy1084;
		goto yy1085;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1084;
		} else {
			if (yych != 'd') goto yy1084;
		}
	}
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1148;
	if (yych != 'a') goto yy56;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1150;
	if (yych != 'e') goto yy56;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1115;
	if (yych == 'c') goto yy1115;
	goto yy56;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1152;
	if (yych != 's') goto yy56;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1153;
	if (yych != 'e') goto yy1084;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1115;
	if (yych == 'c') goto yy1115;
	goto yy56;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1177;
	if (yych == 'n') goto yy1177;
	goto yy56;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1159;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy1158;
			if (yych <= 'M') goto yy56;
			goto yy1160;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1159;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy1158;
			if (yych == 'n') goto yy1160;
			goto yy56;
		}
	}
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1157;
	if (yych != 'e') goto yy1084;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1115;
	if (yych == 'c') goto yy1115;
	goto yy56;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1170;
	if (yych == 'l') goto yy1170;
	goto yy56;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1163;
	if (yych == 'r') goto yy1163;
	goto yy56;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1109;
		if (yych <= 'T') goto yy1084;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1084;
			goto yy1109;
		} else {
			if (yych != 'u') goto yy1084;
		}
	}
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1162;
	if (yych != 't') goto yy56;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1115;
	if (yych == 'e') goto yy1115;
	goto yy56;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1164;
	if (yych != 'o') goto yy56;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1165;
	if (yych != 's') goto yy56;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1166;
	if (yych != 'e') goto yy56;
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1167;
	if (yych != 'c') goto yy56;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1168;
	if (yych != 'o') goto yy56;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1169;
	if (yych != 'n') goto yy56;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1115;
	if (yych == 'd') goto yy1115;
	goto yy56;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1171;
	if (yych != 'i') goto yy56;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1172;
	if (yych != 's') goto yy56;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1173;
	if (yych != 'e') goto yy56;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1174;
	if (yych != 'c') goto yy56;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1175;
	if (yych != 'o') goto yy56;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1176;
	if (yych != 'n') goto yy56;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1115;
	if (yych == 'd') goto yy1115;
	goto yy56;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1085;
			goto yy1084;
		} else {
			if (yych <= ' ') goto yy1085;
			if (yych <= 'C') goto yy1084;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1179;
			goto yy1084;
		} else {
			if (yych <= 'd') goto yy1178;
			if (yych == 't') goto yy1179;
			goto yy1084;
		}
	}
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1180;
	if (yych == 'a') goto yy1180;
	goto yy56;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1115;
	if (yych == 'h') goto yy1115;
	goto yy56;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1090;
	if (yych == 'y') goto yy1090;
	goto yy56;
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1063;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1182;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1064;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'v') goto yy1183;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1065;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'i') goto yy1184;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1066;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'o') goto yy1185;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1067;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'u') goto yy1186;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1068;
	if (yych != 's') goto yy179;
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1069;
		} else {
			if (yych == ' ') goto yy1069;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy56;
		}
	}
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy166;
			goto yy1202;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'g') goto yy1202;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1190;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy167;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'v') goto yy1191;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'e') goto yy1192;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy169;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'n') goto yy1193;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy1194;
		if (yych != 't') goto yy3;
	}
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1195;
	if (yych != 'h') goto yy56;
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1196;
	if (yych != ' ') goto yy56;
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1196;
				if (yych <= 0x1F) goto yy56;
				goto yy1196;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy1076;
				} else {
					if (yych == 'F') goto yy1077;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1075;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy1071;
					if (yych <= 'R') goto yy56;
					goto yy1074;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1080;
					goto yy1073;
				} else {
					if (yych != 'W') goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1078;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy1076;
					if (yych <= 'e') goto yy56;
					goto yy1077;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy1075;
				} else {
					if (yych == 'm') goto yy1071;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1074;
					goto yy1080;
				} else {
					if (yych <= 'u') goto yy1073;
					if (yych <= 'v') goto yy56;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy1078;
				} else {
					if (yych == 0xC2) goto yy1072;
					goto yy56;
				}
			}
		}
	}
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1199;
	if (yych != 'e') goto yy56;
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1101;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1101;
		if (yych >= 'f') goto yy56;
	}
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1201;
	if (yych != 'k') goto yy56;
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1110;
		if (yych <= 'R') goto yy56;
		goto yy1109;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy56;
			goto yy1110;
		} else {
			if (yych == 's') goto yy1109;
			goto yy56;
		}
	}
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy167;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'h') goto yy1203;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1204;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1196;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1196;
			if (yych == ')') goto yy164;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1205;
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1205;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1196;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy1196;
		if (yych == ')') goto yy164;
		goto yy3;
	}
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1202;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'g') goto yy1214;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1190;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1208;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1191;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'v') goto yy1209;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1192;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy1210;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1193;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'n') goto yy1211;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1194;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 't') goto yy1212;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1195;
	if (yych != 'h') goto yy179;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1196;
		} else {
			if (yych == ' ') goto yy1196;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy56;
		}
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1203;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'h') goto yy1215;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1204;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1216;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy1196;
			} else {
				if (yych == ' ') goto yy1196;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy172;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy169;
			} else {
				if (yych <= 'H') goto yy1205;
				if (yych <= 'Z') goto yy169;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'h') goto yy1217;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1196;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1196;
			if (yych <= '(') goto yy3;
			goto yy164;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy172;
			goto yy3;
		} else {
			if (yych <= '/') goto yy172;
			if (yych == '_') goto yy172;
			goto yy3;
		}
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1234;
				goto yy166;
			} else {
				if (yych <= 'P') goto yy1236;
				if (yych <= 'U') goto yy166;
				goto yy1235;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy166;
				goto yy3;
			} else {
				if (yych == 'c') goto yy1234;
				goto yy166;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1236;
				goto yy166;
			} else {
				if (yych <= 'v') goto yy1235;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy166;
			goto yy1229;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 't') goto yy1229;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy166;
			goto yy1226;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'x') goto yy1226;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1222;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'C') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'd') goto yy1223;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1224;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy169;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'y') goto yy1225;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy164;
	goto yy191;
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1227;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1196;
		} else {
			if (yych == ' ') goto yy1196;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'T') goto yy167;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'u') goto yy1230;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy168;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'r') goto yy1231;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy169;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'd') goto yy1232;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1233;
		if (yych != 'a') goto yy3;
	}
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy197;
	goto yy56;
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy167;
			goto yy1245;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'o') goto yy1245;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy167;
			goto yy1242;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'e') goto yy1242;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'T') goto yy167;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 't') goto yy1237;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'E') goto yy168;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy218;
				goto yy168;
			} else {
				if (yych <= 'e') goto yy1238;
				if (yych <= 'z') goto yy168;
				goto yy218;
			}
		}
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy169;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'm') goto yy1239;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy1240;
		if (yych != 'b') goto yy3;
	}
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1241;
	if (yych != 'e') goto yy56;
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych == 'r') goto yy229;
	goto yy56;
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy168;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'n') goto yy1243;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy169;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 't') goto yy1244;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1195;
		if (yych == 'h') goto yy1195;
		goto yy3;
	}
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy168;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'n') goto yy1246;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy169;
			goto yy1205;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'd') goto yy1205;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy164;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy172;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy166;
				goto yy1234;
			} else {
				if (yych == 'P') goto yy1236;
				goto yy166;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1235;
				if (yych <= 'Z') goto yy166;
				goto yy3;
			} else {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy3;
				goto yy171;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1263;
				if (yych <= 'o') goto yy171;
				goto yy1265;
			} else {
				if (yych == 'v') goto yy1264;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1229;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 't') goto yy1258;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1226;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'x') goto yy1255;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1222;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1251;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1223;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'd') goto yy1252;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1224;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1253;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1225;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy1254;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy164;
		if (yych <= ',') goto yy191;
		goto yy172;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy191;
			goto yy172;
		} else {
			if (yych == '_') goto yy172;
			goto yy191;
		}
	}
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1227;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1256;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1196;
			if (yych <= 0x1F) goto yy3;
			goto yy1196;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1230;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'u') goto yy1259;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1231;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'r') goto yy1260;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1232;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'd') goto yy1261;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1233;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1262;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy210;
	goto yy179;
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1245;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy1274;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1242;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy1271;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'T') goto yy1237;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1266;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy168;
			} else {
				if (yych <= 'E') goto yy1238;
				if (yych <= 'Z') goto yy168;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy1267;
				if (yych <= 'z') goto yy176;
				goto yy218;
			}
		}
	}
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1239;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'm') goto yy1268;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1240;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1269;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1241;
	if (yych != 'e') goto yy179;
	YYDEBUG(1270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych == 'r') goto yy341;
	goto yy179;
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1243;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'n') goto yy1272;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1244;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 't') goto yy1273;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1195;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1213;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1246;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'n') goto yy1275;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1205;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'd') goto yy1217;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy166;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'c') goto yy1277;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy167;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'k') goto yy1278;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1279;
		if (yych <= '(') goto yy3;
		goto yy164;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1280;
	if (yych != 'o') goto yy56;
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1281;
	if (yych != 'f') goto yy56;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	YYDEBUG(1282, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1283;
	if (yych <= '2') goto yy1285;
	if (yych <= '9') goto yy1286;
	goto yy56;
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1287;
		} else {
			if (yych <= ' ') goto yy1287;
			if (yych <= '/') goto yy1284;
			if (yych <= '9') goto yy1286;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1289;
			if (yych == 'P') goto yy1289;
		} else {
			if (yych <= 'a') goto yy1289;
			if (yych == 'p') goto yy1289;
		}
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1287;
			goto yy1284;
		} else {
			if (yych <= ' ') goto yy1287;
			if (yych <= '/') goto yy1284;
			if (yych >= '5') goto yy1284;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1289;
			if (yych == 'P') goto yy1289;
			goto yy1284;
		} else {
			if (yych <= 'a') goto yy1289;
			if (yych == 'p') goto yy1289;
			goto yy1284;
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy1284;
		} else {
			if (yych <= ' ') goto yy1287;
			if (yych <= '@') goto yy1284;
			goto yy1289;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1289;
			goto yy1284;
		} else {
			if (yych <= 'a') goto yy1289;
			if (yych == 'p') goto yy1289;
			goto yy1284;
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1288, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1287;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy1287;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy1289;
			if (yych != 'p') goto yy56;
		}
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1291;
		if (yych == 'm') goto yy1291;
		goto yy56;
	}
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1291;
	if (yych != 'm') goto yy56;
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1293;
		if (yych == '\t') goto yy1293;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1293;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1293;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1284;
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1277;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'c') goto yy1295;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1278;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'k') goto yy1296;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1279;
			goto yy3;
		} else {
			if (yych <= ')') goto yy164;
			if (yych == '-') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy172;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy166;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 's') goto yy1298;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1299;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1069;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1301;
	if (yych != 'd') goto yy1070;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1302;
	if (yych != 'a') goto yy56;
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1303;
	if (yych != 'y') goto yy56;
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1084;
	} else {
		if (yych <= 'S') goto yy1109;
		if (yych == 's') goto yy1109;
		goto yy1084;
	}
	YYDEBUG(1304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1305;
	if (yych != 'o') goto yy56;
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1306;
	if (yych != 'f') goto yy56;
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1307, *YYCURSOR);
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1298;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 's') goto yy1309;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1299;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1310;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1069;
			if (yych <= 0x1F) goto yy3;
			goto yy1300;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy166;
			goto yy1348;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'b') goto yy1348;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'F') goto yy1338;
			if (yych <= 'Q') goto yy166;
			goto yy1337;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy166;
			goto yy1338;
		} else {
			if (yych == 'r') goto yy1337;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy166;
			goto yy1334;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'u') goto yy1334;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1316;
			if (yych <= 'N') goto yy166;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy166;
			goto yy1316;
		} else {
			if (yych == 'o') goto yy1315;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy167;
			goto yy1319;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'n') goto yy1319;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'C') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'd') goto yy1317;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1318;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy169;
			goto yy1225;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'y') goto yy1225;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1320;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1321;
		if (yych <= '(') goto yy3;
		goto yy164;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1322;
	if (yych != 'o') goto yy56;
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1323;
	if (yych != 'f') goto yy56;
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1325;
	if (yych <= '2') goto yy1326;
	if (yych <= '9') goto yy1327;
	goto yy56;
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1328;
			goto yy1284;
		} else {
			if (yych <= ' ') goto yy1328;
			if (yych <= '/') goto yy1284;
			if (yych <= '9') goto yy1327;
			goto yy1284;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1330;
			if (yych == 'P') goto yy1330;
			goto yy1284;
		} else {
			if (yych <= 'a') goto yy1330;
			if (yych == 'p') goto yy1330;
			goto yy1284;
		}
	}
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1328;
			goto yy1284;
		} else {
			if (yych <= ' ') goto yy1328;
			if (yych <= '/') goto yy1284;
			if (yych >= '5') goto yy1284;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1330;
			if (yych == 'P') goto yy1330;
			goto yy1284;
		} else {
			if (yych <= 'a') goto yy1330;
			if (yych == 'p') goto yy1330;
			goto yy1284;
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy1284;
		} else {
			if (yych <= ' ') goto yy1328;
			if (yych <= '@') goto yy1284;
			goto yy1330;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1330;
			goto yy1284;
		} else {
			if (yych <= 'a') goto yy1330;
			if (yych == 'p') goto yy1330;
			goto yy1284;
		}
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1329, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1328;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy1328;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy1330;
			if (yych != 'p') goto yy56;
		}
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1332;
		if (yych == 'm') goto yy1332;
		goto yy56;
	}
	YYDEBUG(1331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1332;
	if (yych != 'm') goto yy56;
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1293;
		if (yych == '\t') goto yy1293;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1293;
		if (yych != '.') goto yy56;
	}
	YYDEBUG(1333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1293;
		if (yych <= 0x08) goto yy56;
		goto yy1293;
	} else {
		if (yych == ' ') goto yy1293;
		goto yy56;
	}
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy167;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'r') goto yy1335;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1336;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy169;
			goto yy1205;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'h') goto yy1205;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy167;
			goto yy1340;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 's') goto yy1340;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1339;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy1228;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy168;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 't') goto yy1341;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1341:
	YYDEBUG(1341, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1196;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1343;
	if (yych != 'd') goto yy1197;
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1344;
	if (yych != 'a') goto yy56;
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1345;
	if (yych != 'y') goto yy56;
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1084;
	} else {
		if (yych <= 'S') goto yy1109;
		if (yych == 's') goto yy1109;
		goto yy1084;
	}
	YYDEBUG(1346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1347;
	if (yych != 'o') goto yy56;
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1306;
	if (yych == 'f') goto yy1306;
	goto yy56;
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'R') goto yy167;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'r') goto yy1349;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy168;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'u') goto yy1350;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1350:
	YYDEBUG(1350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1351;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy1352;
		if (yych != 'r') goto yy3;
	}
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy229;
	if (yych == 'y') goto yy229;
	goto yy56;
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1348;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'b') goto yy1371;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'F') goto yy1338;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1337;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1367;
				goto yy171;
			} else {
				if (yych <= 'r') goto yy1366;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1334;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'u') goto yy1363;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1316;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1315;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1358;
				goto yy171;
			} else {
				if (yych <= 'o') goto yy1357;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1319;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy1361;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1317;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'd') goto yy1359;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1318;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1360;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1225;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy1254;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1320;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1362;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1321;
			goto yy3;
		} else {
			if (yych <= ')') goto yy164;
			if (yych == '-') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy172;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1335;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1364;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1336;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1365;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1205;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'h') goto yy1217;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1366:
	YYDEBUG(1366, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1340;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 's') goto yy1369;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1339;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1368;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1341;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 't') goto yy1370;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1196;
			if (yych <= 0x1F) goto yy3;
			goto yy1342;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'R') goto yy1349;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1372;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1350;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'u') goto yy1373;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1351;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1374;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1374:
	YYDEBUG(1374, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1352;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1375;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy229;
	if (yych == 'y') goto yy341;
	goto yy179;
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	YYDEBUG(1378, *YYCURSOR);
	if (yych == '.') goto yy1380;
	if (yych <= '/') goto yy1379;
	if (yych <= '9') goto yy1377;
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(1381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(1382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(1383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(1384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(1385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(1386, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1387, *YYCURSOR);
	{
		timelib_ull i, us;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		us = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->relative.us = us;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1388:
	YYDEBUG(1388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
			goto yy1429;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1429;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1421;
			if (yych <= 'T') goto yy166;
			goto yy1422;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy166;
			goto yy1421;
		} else {
			if (yych == 'u') goto yy1422;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1390:
	YYDEBUG(1390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1410;
			if (yych <= 'L') goto yy166;
			goto yy1411;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy166;
			goto yy1410;
		} else {
			if (yych == 'm') goto yy1411;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1391:
	YYDEBUG(1391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
			goto yy1406;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1406;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1392:
	YYDEBUG(1392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy166;
			goto yy1402;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'e') goto yy1402;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1393:
	YYDEBUG(1393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1029;
		goto yy56;
	} else {
		if (yych <= '9') goto yy1396;
		if (yych <= ':') goto yy1029;
		goto yy56;
	}
yy1394:
	YYDEBUG(1394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1029;
		goto yy56;
	} else {
		if (yych <= '4') goto yy1396;
		if (yych == ':') goto yy1029;
		goto yy56;
	}
yy1395:
	YYDEBUG(1395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1029;
	if (yych == ':') goto yy1029;
	goto yy56;
yy1396:
	YYDEBUG(1396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1029;
		goto yy56;
	} else {
		if (yych <= '5') goto yy1397;
		if (yych == ':') goto yy1029;
		goto yy56;
	}
yy1397:
	YYDEBUG(1397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	YYDEBUG(1398, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1032;
	if (yych <= '5') goto yy1399;
	if (yych <= '6') goto yy1400;
	goto yy1032;
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1401;
	goto yy56;
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1040;
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy167;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'l') goto yy1403;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy168;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'f') goto yy1404;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy169;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 't') goto yy1405;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1195;
		if (yych == 'h') goto yy1195;
		goto yy3;
	}
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'R') goto yy167;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 's') goto yy1407;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1407:
	YYDEBUG(1407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy168;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'd') goto yy1408;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1408:
	YYDEBUG(1408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy169;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1409;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1409:
	YYDEBUG(1409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy197;
		if (yych == 'y') goto yy197;
		goto yy3;
	}
yy1410:
	YYDEBUG(1410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
		goto yy1418;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy167;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1418;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1411:
	YYDEBUG(1411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy167;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'o') goto yy1412;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1412:
	YYDEBUG(1412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy168;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'r') goto yy1413;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1413:
	YYDEBUG(1413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy169;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'r') goto yy1414;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1414:
	YYDEBUG(1414, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1415;
		if (yych != 'o') goto yy3;
	}
yy1415:
	YYDEBUG(1415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1416;
	if (yych != 'w') goto yy56;
yy1416:
	YYDEBUG(1416, *YYCURSOR);
	++YYCURSOR;
yy1417:
	YYDEBUG(1417, *YYCURSOR);
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1418:
	YYDEBUG(1418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy168;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'y') goto yy1419;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1419:
	YYDEBUG(1419, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy169;
		if (yych <= '`') goto yy1420;
		if (yych <= 'z') goto yy169;
	}
yy1420:
	YYDEBUG(1420, *YYCURSOR);
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1421:
	YYDEBUG(1421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy167;
			if (yych <= 'R') goto yy1427;
			goto yy1428;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'r') goto yy1427;
			if (yych <= 's') goto yy1428;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1422:
	YYDEBUG(1422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'Q') goto yy167;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'r') goto yy1423;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1423:
	YYDEBUG(1423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy168;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 's') goto yy1424;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1424:
	YYDEBUG(1424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy169;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'd') goto yy1425;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1425:
	YYDEBUG(1425, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1426;
		if (yych != 'a') goto yy3;
	}
yy1426:
	YYDEBUG(1426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy197;
	goto yy56;
yy1427:
	YYDEBUG(1427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy168;
			goto yy1228;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'd') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1428:
	YYDEBUG(1428, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1069;
		} else {
			if (yych == ' ') goto yy1069;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1429:
	YYDEBUG(1429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1430;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1430:
	YYDEBUG(1430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy1228;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1431:
	YYDEBUG(1431, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1429;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1461;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1432:
	YYDEBUG(1432, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1421;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1422;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1453;
				goto yy171;
			} else {
				if (yych <= 'u') goto yy1454;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1433:
	YYDEBUG(1433, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1410;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1411;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1444;
				goto yy171;
			} else {
				if (yych <= 'm') goto yy1445;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1434:
	YYDEBUG(1434, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1406;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1440;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1435:
	YYDEBUG(1435, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1402;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'e') goto yy1436;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1436:
	YYDEBUG(1436, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1403;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'l') goto yy1437;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1437:
	YYDEBUG(1437, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1404;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'f') goto yy1438;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1438:
	YYDEBUG(1438, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1405;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 't') goto yy1439;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1439:
	YYDEBUG(1439, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1195;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1213;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1440:
	YYDEBUG(1440, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1407;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 's') goto yy1441;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1441:
	YYDEBUG(1441, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1408;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'd') goto yy1442;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1442:
	YYDEBUG(1442, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1409;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1443;
			if (yych <= 'z') goto yy177;
			goto yy3;
		}
	}
yy1443:
	YYDEBUG(1443, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy197;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'y') goto yy210;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1444:
	YYDEBUG(1444, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1418;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1451;
			if (yych <= 'z') goto yy175;
			goto yy3;
		}
	}
yy1445:
	YYDEBUG(1445, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1412;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'o') goto yy1446;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1446:
	YYDEBUG(1446, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1413;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'r') goto yy1447;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1447:
	YYDEBUG(1447, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1414;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy1448;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1448:
	YYDEBUG(1448, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1415;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1449;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1449:
	YYDEBUG(1449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1416;
	if (yych != 'w') goto yy179;
	YYDEBUG(1450, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy1417;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy1417;
	}
yy1451:
	YYDEBUG(1451, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1419;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'y') goto yy1452;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1452:
	YYDEBUG(1452, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy1420;
		} else {
			if (yych == '.') goto yy1420;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1420;
			if (yych <= 'Z') goto yy169;
			goto yy1420;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy1420;
			if (yych <= 'z') goto yy177;
			goto yy1420;
		}
	}
yy1453:
	YYDEBUG(1453, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy172;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy167;
				goto yy1427;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1428;
				goto yy167;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy175;
				goto yy1459;
			} else {
				if (yych <= 's') goto yy1460;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1454:
	YYDEBUG(1454, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1423;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'r') goto yy1455;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1455:
	YYDEBUG(1455, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1424;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 's') goto yy1456;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1456:
	YYDEBUG(1456, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1425;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'd') goto yy1457;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1457:
	YYDEBUG(1457, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1426;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1458;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1458:
	YYDEBUG(1458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy197;
	if (yych == 'y') goto yy210;
	goto yy179;
yy1459:
	YYDEBUG(1459, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'd') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1460:
	YYDEBUG(1460, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1069;
			if (yych <= 0x1F) goto yy3;
			goto yy1069;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy172;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1461:
	YYDEBUG(1461, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1430;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1462;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1462:
	YYDEBUG(1462, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1463:
	YYDEBUG(1463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1475;
			if (yych <= 'X') goto yy166;
			goto yy1476;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy166;
			goto yy1475;
		} else {
			if (yych == 'y') goto yy1476;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1464:
	YYDEBUG(1464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy166;
			goto yy1469;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'd') goto yy1469;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1465:
	YYDEBUG(1465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1466;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1466:
	YYDEBUG(1466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy191;
			goto yy164;
		} else {
			if (yych <= '@') goto yy191;
			if (yych <= 'C') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy191;
			goto yy167;
		} else {
			if (yych <= 'd') goto yy1467;
			if (yych <= 'z') goto yy167;
			goto yy191;
		}
	}
yy1467:
	YYDEBUG(1467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy164;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy168;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1468;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1468:
	YYDEBUG(1468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy169;
			goto yy1225;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'y') goto yy1225;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1469:
	YYDEBUG(1469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy167;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'n') goto yy1470;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1470:
	YYDEBUG(1470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy168;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'i') goto yy1471;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1471:
	YYDEBUG(1471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy169;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'g') goto yy1472;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1472:
	YYDEBUG(1472, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1473;
		if (yych != 'h') goto yy3;
	}
yy1473:
	YYDEBUG(1473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1474;
	if (yych != 't') goto yy56;
yy1474:
	YYDEBUG(1474, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1420;
yy1475:
	YYDEBUG(1475, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych == 'C') goto yy1477;
				goto yy167;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'c') goto yy1477;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1476:
	YYDEBUG(1476, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy218;
			goto yy221;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy218;
			if (yych <= '9') goto yy220;
			goto yy218;
		} else {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy218;
			if (yych <= 'z') goto yy167;
			goto yy218;
		}
	}
yy1477:
	YYDEBUG(1477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy360;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy360;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1478:
	YYDEBUG(1478, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy172;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1475;
				goto yy166;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1476;
				goto yy166;
			} else {
				if (yych == '_') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1490;
				goto yy171;
			} else {
				if (yych <= 'y') goto yy1491;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1479:
	YYDEBUG(1479, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1469;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'd') goto yy1484;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1480:
	YYDEBUG(1480, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1466;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1481;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1481:
	YYDEBUG(1481, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy191;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy191;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1467;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy191;
			goto yy172;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy191;
				goto yy175;
			} else {
				if (yych <= 'd') goto yy1482;
				if (yych <= 'z') goto yy175;
				goto yy191;
			}
		}
	}
yy1482:
	YYDEBUG(1482, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1468;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1483;
			if (yych <= 'z') goto yy176;
			goto yy3;
		}
	}
yy1483:
	YYDEBUG(1483, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1225;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'y') goto yy1254;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1484:
	YYDEBUG(1484, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1470;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy1485;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1485:
	YYDEBUG(1485, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1471;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'i') goto yy1486;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1486:
	YYDEBUG(1486, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1472;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'g') goto yy1487;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1487:
	YYDEBUG(1487, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1473;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1488;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1488:
	YYDEBUG(1488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1474;
	if (yych != 't') goto yy179;
	YYDEBUG(1489, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy1420;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy1420;
	}
yy1490:
	YYDEBUG(1490, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'C') goto yy1477;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'c') goto yy1492;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1491:
	YYDEBUG(1491, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy220;
			if (yych <= 0x1F) goto yy218;
			goto yy220;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy218;
				goto yy164;
			} else {
				if (yych <= ',') goto yy218;
				if (yych <= '-') goto yy336;
				goto yy220;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy172;
			if (yych <= '9') goto yy220;
			if (yych <= '@') goto yy218;
			goto yy167;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy218;
				goto yy172;
			} else {
				if (yych <= '`') goto yy218;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1492:
	YYDEBUG(1492, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy360;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy371;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1493:
	YYDEBUG(1493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy164;
			if (yych <= '@') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'O') goto yy1501;
			if (yych <= 'U') goto yy166;
			if (yych <= 'V') goto yy1502;
			goto yy1499;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy166;
			goto yy1501;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy166;
				goto yy1502;
			} else {
				if (yych <= 'w') goto yy1499;
				if (yych <= 'z') goto yy166;
				goto yy3;
			}
		}
	}
yy1494:
	YYDEBUG(1494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy166;
			goto yy1498;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'x') goto yy1498;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1495:
	YYDEBUG(1495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy166;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 'n') goto yy1496;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1496:
	YYDEBUG(1496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1497;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1497:
	YYDEBUG(1497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy168;
			goto yy1228;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'h') goto yy1228;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1498:
	YYDEBUG(1498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
			goto yy1428;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1428;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1499:
	YYDEBUG(1499, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy167;
		if (yych <= '`') goto yy1500;
		if (yych <= 'z') goto yy167;
	}
yy1500:
	YYDEBUG(1500, *YYCURSOR);
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1501:
	YYDEBUG(1501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy167;
			goto yy1507;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 'n') goto yy1507;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1502:
	YYDEBUG(1502, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy164;
				goto yy218;
			} else {
				if (yych <= '-') goto yy221;
				if (yych <= '.') goto yy220;
				goto yy218;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy220;
				goto yy218;
			} else {
				if (yych != 'E') goto yy167;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'e') goto yy1503;
				if (yych <= 'z') goto yy167;
				goto yy218;
			}
		}
	}
yy1503:
	YYDEBUG(1503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy168;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'm') goto yy1504;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1504:
	YYDEBUG(1504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy169;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'b') goto yy1505;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1505:
	YYDEBUG(1505, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1506;
		if (yych != 'e') goto yy3;
	}
yy1506:
	YYDEBUG(1506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych == 'r') goto yy229;
	goto yy56;
yy1507:
	YYDEBUG(1507, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy164;
	} else {
		if (yych <= 'Z') goto yy168;
		if (yych <= '`') goto yy1508;
		if (yych <= 'z') goto yy168;
	}
yy1508:
	YYDEBUG(1508, *YYCURSOR);
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1509:
	YYDEBUG(1509, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy164;
			} else {
				if (yych == '-') goto yy172;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy172;
				if (yych <= '@') goto yy3;
				goto yy166;
			} else {
				if (yych <= 'O') goto yy1501;
				if (yych <= 'U') goto yy166;
				goto yy1502;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1499;
				if (yych <= 'Z') goto yy166;
				goto yy3;
			} else {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy3;
				goto yy171;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1516;
				if (yych <= 'u') goto yy171;
				goto yy1517;
			} else {
				if (yych <= 'w') goto yy1515;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1510:
	YYDEBUG(1510, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1498;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'x') goto yy1514;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1511:
	YYDEBUG(1511, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1496;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 'n') goto yy1512;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1512:
	YYDEBUG(1512, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1497;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1513;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1513:
	YYDEBUG(1513, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1228;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'h') goto yy1257;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1514:
	YYDEBUG(1514, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1428;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1460;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1515:
	YYDEBUG(1515, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy1500;
		} else {
			if (yych == '.') goto yy1500;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1500;
			if (yych <= 'Z') goto yy167;
			goto yy1500;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy1500;
			if (yych <= 'z') goto yy175;
			goto yy1500;
		}
	}
yy1516:
	YYDEBUG(1516, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1507;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 'n') goto yy1522;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1517:
	YYDEBUG(1517, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy218;
				goto yy220;
			} else {
				if (yych == ' ') goto yy220;
				goto yy218;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy164;
				if (yych <= ',') goto yy218;
				goto yy336;
			} else {
				if (yych == '/') goto yy172;
				goto yy220;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy218;
				goto yy167;
			} else {
				if (yych <= 'E') goto yy1503;
				if (yych <= 'Z') goto yy167;
				goto yy218;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy172;
				if (yych <= '`') goto yy218;
				goto yy175;
			} else {
				if (yych <= 'e') goto yy1518;
				if (yych <= 'z') goto yy175;
				goto yy218;
			}
		}
	}
yy1518:
	YYDEBUG(1518, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1504;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'm') goto yy1519;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1519:
	YYDEBUG(1519, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1505;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'b') goto yy1520;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1520:
	YYDEBUG(1520, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1506;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1521;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1521:
	YYDEBUG(1521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy229;
	if (yych == 'r') goto yy341;
	goto yy179;
yy1522:
	YYDEBUG(1522, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy1508;
		} else {
			if (yych == '.') goto yy1508;
			goto yy172;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1508;
			if (yych <= 'Z') goto yy168;
			goto yy1508;
		} else {
			if (yych <= '_') goto yy172;
			if (yych <= '`') goto yy1508;
			if (yych <= 'z') goto yy176;
			goto yy1508;
		}
	}
yy1523:
	YYDEBUG(1523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy166;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy166;
			if (yych <= '`') goto yy3;
			goto yy166;
		} else {
			if (yych <= 's') goto yy1524;
			if (yych <= 'z') goto yy166;
			goto yy3;
		}
	}
yy1524:
	YYDEBUG(1524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy167;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy167;
			if (yych <= '`') goto yy3;
			goto yy167;
		} else {
			if (yych <= 't') goto yy1525;
			if (yych <= 'z') goto yy167;
			goto yy3;
		}
	}
yy1525:
	YYDEBUG(1525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy168;
			if (yych <= '`') goto yy3;
			goto yy168;
		} else {
			if (yych <= 'e') goto yy1526;
			if (yych <= 'z') goto yy168;
			goto yy3;
		}
	}
yy1526:
	YYDEBUG(1526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy164;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy169;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy169;
			if (yych <= '`') goto yy3;
			goto yy169;
		} else {
			if (yych <= 'r') goto yy1527;
			if (yych <= 'z') goto yy169;
			goto yy3;
		}
	}
yy1527:
	YYDEBUG(1527, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy164;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1528;
		if (yych != 'd') goto yy3;
	}
yy1528:
	YYDEBUG(1528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1529;
	if (yych != 'a') goto yy56;
yy1529:
	YYDEBUG(1529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1530;
	if (yych != 'y') goto yy56;
yy1530:
	YYDEBUG(1530, *YYCURSOR);
	++YYCURSOR;
yy1531:
	YYDEBUG(1531, *YYCURSOR);
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1532:
	YYDEBUG(1532, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy166;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1524;
			if (yych <= 'Z') goto yy166;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy171;
			} else {
				if (yych <= 's') goto yy1533;
				if (yych <= 'z') goto yy171;
				goto yy3;
			}
		}
	}
yy1533:
	YYDEBUG(1533, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy167;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1525;
			if (yych <= 'Z') goto yy167;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy175;
			} else {
				if (yych <= 't') goto yy1534;
				if (yych <= 'z') goto yy175;
				goto yy3;
			}
		}
	}
yy1534:
	YYDEBUG(1534, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy168;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1526;
			if (yych <= 'Z') goto yy168;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy176;
			} else {
				if (yych <= 'e') goto yy1535;
				if (yych <= 'z') goto yy176;
				goto yy3;
			}
		}
	}
yy1535:
	YYDEBUG(1535, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy164;
			if (yych <= ',') goto yy3;
			goto yy172;
		} else {
			if (yych == '/') goto yy172;
			if (yych <= '@') goto yy3;
			goto yy169;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1527;
			if (yych <= 'Z') goto yy169;
			if (yych <= '^') goto yy3;
			goto yy172;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy177;
			} else {
				if (yych <= 'r') goto yy1536;
				if (yych <= 'z') goto yy177;
				goto yy3;
			}
		}
	}
yy1536:
	YYDEBUG(1536, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy164;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy172;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1528;
			if (yych == '_') goto yy172;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1537;
			if (yych <= 'z') goto yy178;
			goto yy3;
		}
	}
yy1537:
	YYDEBUG(1537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1529;
	if (yych != 'a') goto yy179;
	YYDEBUG(1538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1530;
	if (yych != 'y') goto yy179;
	YYDEBUG(1539, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy178;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy172;
		goto yy1531;
	} else {
		if (yych <= '/') goto yy172;
		if (yych == '_') goto yy172;
		goto yy1531;
	}
}

}

#define YYMAXFILL 33

timelib_time* timelib_strtotime(char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, TIMELIB_ERR_EMPTY_STRING, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->us = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->us = 0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->us == TIMELIB_UNSET ) time->us = 0;
}

timelib_time *timelib_parse_from_format(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;
	int allow_extra = 0;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'D': /* three letter day */
			case 'l': /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_DAY, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case 'd': /* two digit day, with leading zero */
			case 'j': /* two digit day, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_DAY, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_DAY_OF_YEAR, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case 'm': /* two digit month, with leading zero */
			case 'n': /* two digit month, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MONTH, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': /* three letter month */
			case 'F': /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_MONTH, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_YEAR, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case 'Y': /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': /* two digit hour, with leading zero */
			case 'h': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, TIMELIB_ERR_HOUR_LARGER_THAN_12, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': /* two digit hour, with leading zero */
			case 'H': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': /* am/pm/a.m./p.m. */
			case 'A': /* AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_MERIDIAN, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MINUTE, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case 's': /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_SECOND, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case 'u': /* up to six digit microsecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_SIX_DIGIT_MICROSECOND, "A six digit microsecond could not be found", string, begin);
					} else {
						s->time->us = (f * pow(10, 6 - (ptr - tptr)));
					}
				}
				break;
			case ' ': /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				break;

			case 'e': /* timezone */
			case 'P': /* timezone */
			case 'T': /* timezone */
			case 'O': /* timezone */
				{
					int tz_not_found;
					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': /* separation symbol */
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-' || *ptr == '(' || *ptr == ')') {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
			case '(':
			case ')':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case '|': /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case '?': /* random char */
				++ptr;
				break;

			case '\\': /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, TIMELIB_ERR_EXPECTED_ESCAPE_CHAR, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_ESCAPED_CHAR, "The escaped character could not be found", string, begin);
				}
				break;

			case '*': /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case '+': /* allow extra chars in the format */
				allow_extra = 1;
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_WRONG_FORMAT_SEP, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, TIMELIB_WARN_TRAILING_DATA, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, TIMELIB_ERR_TRAILING_DATA, "Trailing data", string, ptr);
		}
	}
	/* ignore trailing +'s */
	while (*fptr == '+') {
		fptr++;
	}
	if (*fptr) {
		/* Trailing | and ! specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (*fptr++) {
				case '!': /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case '|': /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;

				default:
					add_pbf_error(s, TIMELIB_ERR_DATA_MISSING, "Data missing", string, ptr);
					done = 1;
			}
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->us = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->us == TIMELIB_UNSET) parsed->us = 0;
	} else {
		if (parsed->us == TIMELIB_UNSET) parsed->us = now->us != TIMELIB_UNSET ? now->us : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
