#!/usr/bin/perl
#
# Script to print the key, the reference type, and the first part of the
#  title of ALL references in n BiBTeX database matching a given search
#  string.
#
#
#  This script is part of the XBibFile software package.
#  Writer:  Ross Maloney
#  Date:    August 2000
#

$count = 0;
while ( <> ) {
    chomp;
    if ( /@/ )  {
      $type = 'x';
      $ptr_flag = 0;
      $note_flag = 0;
      if ( /\@ARTICLE/ ) {  $type = 'A' } ;
      if ( /\@BOOK/ ) {  $type = 'B' } ;
      if ( /\@INCOLLECTION/ ) {  $type = 'C' } ;
      if ( /\@INPROCEEDINGS/ ) {  $type = 'P' } ;
      if ( /\@PHDTHESIS/ ) {  $type = 'T' } ;
      @reftype = split(/{/, $_);
      $reftype[1] =~ s/,//;
    }
    elsif ( /^ +title = \{/ ) {
      @fields = split(/{/, $_);
      $fields[1] =~ s/},//;
    }
    elsif ( /^ +annote = \{/ )  {
      $note_flag = 1;
    }
    if ( $note_flag )  {
	if ( /poem/i ) {            # check for test string being present
	    if ( $ptr_flag == 0 )  {
               $count++ ;
               printf "\n%s  %s", $type, $reftype[1];
               printf "\t%s", substr($fields[1], 0, 50) ;
               $ptr_flag = 1;
	   }
            printf "\n*  %s", $_;
        }
    } 
}
print "\nnumber of references = $count\n" ;
