/* searchpath.c 2.9.0 92/07/06 - wrapper around library thingie
 *  - Damian Cugley <pdc@oxford.prg> Thu 15 Feb 1990
 */

#include <sys/param.h>		/* for MAXPATHLEN */
#include "xstdio.h"		/* <stdio.h> plus prototypes */
#include "searchpath.h"
#include "stdc.h"

#ifndef MAXPATHLEN
#  define MAXPATHLEN 1024
#endif

void NONRETURNING exit ARGS((int));

int
main (ac, av)
     int	ac;
     char     **av;
{
  char scratch[MAXPATHLEN];

  if (ac < 3)
    {
      fprintf(stderr, "%s: Not enough arguments\n\
Usage: %s FILENAME PATH [ SUFFIX ]\n",
	      av[0], av[0]);
      if (ac == 2)
	puts(av[1]);		/* The best we can do */
      exit(2);
    }

  if (!findfile(scratch, av[1], av[2], (ac > 3 ? av[3] : (char *)NULL)))
    {
      if (ac > 3)
	fprintf(stderr, "%s: Couldn't find \"%s\" or \"%s%s\" in path\n\
\t\"%s\"\n",
		av[0], av[1], av[1], av[3], av[2]);
      else
	fprintf(stderr, "%s: Couldn't find \"%s\" in path\n\
\t\"%s\"\n",
		av[0], av[1], av[2]);
      puts(av[1]);
      exit(1);
    }

  puts(scratch);
  return(0);
}
