// -*- c++ -*-
// $Id: TeXpk.h,v 1.2 2000/12/13 00:12:27 yotam Exp $
// TeX's PK file class
#ifndef _tExpk
#define _tExpk

#include <iostream>
#include <string>
#include "baseint.h"
// #include "Rect.h"

class Rect;

class TeXpk 
{
 public:
   enum verbose 
   {
      errors    =   0x1, 
      warnings  =   0x2,
      fclopen   =   0x4, // file open or close
      memory    =   0x8, // allocation and free
      preamble  =  0x10,
      firstChar =  0x20,
      allChars  =  0x40,
      loadStat  =  0x80,
      all       =  0xff
   };

   enum Direction {Left, Right, Up, Down, NDir};  

   // constructors / destructors
   TeXpk();
   TeXpk(const char *fn, 
         US32 verbFlags = 0, 
         std::ostream& verboseStream = std::cerr);
   TeXpk(const TeXpk &);

   virtual ~TeXpk();

   TeXpk&  operator=(const TeXpk &);

   // open also closes if necessary
   void open(const char* fn, 
             US32 verbFlags = 0, std::ostream& verboseStream = std::cerr);

   int active() const;

   ////////////////////////////
   // data retrieval members //

   // From preamble
   US8                id() const;          // id=89 is currently supported
   const std::string& comment() const; 
   US32               designSize() const;  // in  (1/2^20)pt
   US32               checkSum() const;    // Should match with TFM file
   US32               hppp() const;
   US32               vppp() const;
    
   US16               nChars() const; // But only upto 256 supported.
   bool               hasChar(US8 c) const; 

   // Character queries. If !hasChar then following return value is undefined.
   US32               tfmWidth(US8 c) const;
   Int32              dx(US8 c) const; // horizontal escapement
   Int32              dy(US8 c) const; // vertical escapement
    
   US32               bitmapWidth(US8 c) const;
   US32               bitmapHeight(US8 c) const;
    
   Int32              hoff(US8 c) const;
   Int32              voff(US8 c) const;
    
   US32               nRects(US8 c) const;
   void               rect(Rect& rect, US8 c, US32 rectInd) const;
    
   US8                charFirst() const;
   US8                charLast()  const;
   US32               maxOffset(Direction di) const; // max reference of bit map

 private:
   class _TeXpkImplement *_impl;
}; // TeXpk

      
#endif /* _tExpk */
