# Gotham Beamer Theme

<!-- Logo -->
<p align="center">
   <a href="https://gitlab.com/RomainNOEL/beamertheme-gotham">
      <img src="support/gotham-logo.png" width="100" alt="Gotham logo">
   </a>
</p>

<!-- BADGES -->
<p align="center">
   <a href="https://ctan.org/pkg/gotham"><img src="https%3A%2F%2Fctan.org%2Fjson%2F2.0%2Fpkg%2Fgotham&query=%24.version.number&logo=latex&label=CTAN"/></a>
   <a href="https://gitlab.com/RomainNOEL/beamertheme-gotham/-/release/"><img src="https://img.shields.io/badge/Latest_Release-%{latest_tag}-blue"/></a>
   <a href="https://gitlab.com/RomainNOEL/beamertheme-gotham/-/pipelines?page=1&scope=all&ref=main"><img src="https://gitlab.com/RomainNOEL/beamertheme-gotham/badges/main/pipeline.svg"/></a>
   <a href="https://gitlab.com/RomainNOEL/beamertheme-gotham/-/blob/main/LICENSE.txt"><img src="https://img.shields.io/badge/License-LPPL_1.3c--Clause-blue.svg"/></a>
   <a href="https://gitlab.com/RomainNOEL/beamertheme-gotham/-/artifacts/"><img src="https://img.shields.io/badge/Documentation-PDF_online-green"/></a>
   <a href="https://gitlab.com/RomainNOEL/beamertheme-gotham/-/blob/main/Authors.md"><img src="https://www.repostatus.org/badges/latest/active.svg"/></a>
</p>


## What is Gotham ?
This `Gotham` package is a modern, minimal-ish, versatile and extendable theme for your `Beamer` presentations using `LaTeX(3)`.


## Table of Contents
[[_TOC_]]


## Why this package ?
ONCE UPON THE TIME, I was adapting `Metropolis` Beamer theme to get my institutional templates.
Indeed, `Metropolis` Beamer theme is a great work that is very convenient and well appreciated by many. 

BUT, `Metropolis` seems not maintained anymore and is not flexible enough.
Moreover, `Metropolis` (or its successor initiative Moloch) and Beamer in some extends are not very flexible. 
For example, it requires cumbersome modifications to apply a different background for your section frames.

SO, `Gotham` tries to bring that kind of flexibility and `LaTeX3` implementation on top of the good-looking `Metropolis` theme.


## See it in action
Here are some screenshot of what you can obtain:

<img src="support/gotham-example169transp-1.png" width="700">

<img src="support/gotham-example43dark-1.png" width="700">

An `pdf` example/demo result is available [here](https://gitlab.com/RomainNOEL/beamertheme-gotham/-/artifacts/), and the `tex` source file to build it is available [here](/examples/section-Gotham.tex).

The following code shows a **minimal example** of a Beamer presentation using Gotham.
```latex
\documentclass{beamer}
\usetheme{gotham}
\title{A minimal example}
\date{\today}
\author{Romain NOEL}
\institute{Centre for Modern Beamer Themes}
\begin{document}
  \maketitle
  \section{First Section}
  \begin{frame}{First Frame}
    Hello, world!
  \end{frame}
\end{document}
```
is yielding the following:

<img src="support/gotham-exampleSimple-1.png" width="700">


## Some of the features included
- `l3build` a build system for LaTeX that unpack the sources, build the documentation and examples, run unit tests, check tags, prepare for CTAN publishing, etc...
- `expl3`
- dark, light and transparent theme
- can adapt to 16:9 and 4:3 screen format
- progress bar
- **can mix** themes


## Documentation
The complete `pdf` documentation can be found through an [artefact](https://gitlab.com/RomainNOEL/beamertheme-gotham/-/artifacts/).


## How to install ?
Several possibilities are available and tested: 
- download the `.sty` released zip files,
- build from sources using `l3build`,
- download or update from [CTAN](https://ctan.org/pkg/beamertheme-gotham),
- fork a example from [Overleaf](https://overleaf.com) .

### Download from release
The zip file containing the `.sty` files is downloadable through our latest [release link](https://gitlab.com/RomainNOEL/beamertheme-gotham/-/releases/)

### Build from sources
You can also install the theme from sources, in which case you need a working LaTeX installation with `l3build` installed. 
Then just follow these steps:
```bash
git clone https://gitlab.com/RomainNOEL/beamertheme-gotham.git
cd beamertheme-gotham
l3build install
```

Additionally you can use the other `l3build` target:
- `l3build unpack` builds the theme style files.
- `l3build doc` builds this documentation manual and the examples.
- `l3build check` builds the theme and manual.
- `l3build install` installs the theme into your local texmf folder.
- STOP unless you want remove it.
- `l3build uninstall` removes the theme from your local texmf folder.
- `l3build clean` removes the files generated by `l3build`.

### Download from CTAN
The CTAN repository is available through the Gotham [package](https://ctan.org/pkg/beamertheme-gotham), so you can install it using your favorite LaTeX package manager. For example, with `tlmgr`:
```bash
tlmgr install beamertheme-gotham
```

### Fork from Overleaf example
If you want to play with it before installing, you can fork this [Overleaf project](https://overleaf.com) and have fun.


## License
The LaTeX Project Public License [(LPPL)](/LICENSE.txt)


## Project status
The status of the project is "maintained".
However, if you have a bit of free time and good will to help the maintenance, it will be very appreciated and welcomed.