// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
// $Header: hp33440.h,v 1.8 91/02/22 15:58:41 hmgr Exp $

// LaserJetII series device-specific definitions.
// The LaserJetII Reference Manual should be consulted for more
// information on the various constants.
//
// by Parag Patel


// LaserJetII
//
class HP33440 : public HP2686
{
protected:
    HP33440(int maxf, int maxc, int maxpg, int maxld, int res,
		    int ho, int vo, int fhmn, int fhmx, int fvmn, int fvmx,
		    int fwd, int fhg, char *deffp) :
	HP2686(maxf, maxc, maxpg, maxld, res, ho, vo,
	    fhmn, fhmx, fvmn, fvmx, fwd, fhg, deffp) { }
public:
    HP33440();
};


// LaserJetIID - does double-sided but is otherwise identical to the II
//
class HP33447 : public HP33440
{
protected:
    HP33447(int maxf, int maxc, int maxpg, int maxld, int res,
		    int ho, int vo, int fhmn, int fhmx, int fvmn,
		    int fvmx, int fwd, int fhg, char *deffp);
public:
    HP33447();
    ~HP33447();
    void newpage(boolean odd, boolean first);
};
