/* Copyright (c) 1991 by Parag Patel.  All Rights Reserved. */
static char rcsid[] = "$Header: ljdump.c,v 1.8 91/02/22 15:59:49 hmgr Exp $";

/*
   NOT written by me. The real author refuses to stick his name in
   here, but he can't stop me from adding this note!  -- Parag

   BTW - This is C code - NOT C++!
 */

#include <stdio.h>
#include <ctype.h>

#define SAME(a,b) (strcmp(a,b)==0)
#define SEQ(s,c,x) (x[strlen(x)-1]==c && strncmp(s,x,strlen(s))==0)

int
getnum(cp)
char *cp;
{
    cp = &cp[strlen(cp)] - 2;
    while (isdigit(*cp))
	cp--;
    return atoi(cp + 1);
}

void
dump_data(nbytes)
int nbytes;
{
    int max = 32;
    int ch;

    printf("\t");
    while (nbytes-- > 0)
    {
	ch = getchar();
	if (max > 0)
	    printf("%.2X", ch);

	if (max-- == 0)
	    printf("->");
    }
    putchar('\n');
}

void
do_esc(seq)
char *seq;
{
    typedef char byte;
    typedef unsigned char ubyte;
    typedef short word;
    typedef unsigned short uword;
    struct
    {
	uword size;
	byte dummy0;
	byte is_eightbit;
	word dummy1;
	uword baseline;
	uword cell_width;
	uword cell_height;
	byte is_landscape;
	byte is_proportional;
	uword symbol_set;
	uword pitch;
	uword height;
	word dummy2;
	byte dummy3;
	byte is_italic;
	byte stroke_weight;
	ubyte typeface;
    } fontdesc;
    struct
    {
	word dummy0;
	word dummy1;
	byte is_landscape;
	byte dymmy2;
	word left_offset;
	word top_offset;
	uword width;
	uword height;
	word deltax;
    } chardesc;

    printf("^[%s", seq);
    if (SEQ(")s", 'W', seq))
    {
	fread(&fontdesc, sizeof fontdesc, 1, stdin);
	printf("\n\t");
	if (fontdesc.is_proportional)
	    printf("proportional ");
	else
	    printf("fixed ");
	if (fontdesc.is_landscape)
	    printf("landscape ");
	else
	    printf("portrait ");
	if (fontdesc.is_italic)
	    printf("italic ");
	printf("%d-bit chars, symbol set: %d%c\n",
		fontdesc.is_eightbit + 7,
		fontdesc.symbol_set >> 5,
		(fontdesc.symbol_set & 0x1F) + 64);
	printf("\tbaseline: %d dots\n", fontdesc.baseline);
	printf("\tcell height: %d dots  width: %d dots\n",
		fontdesc.cell_height, fontdesc.cell_width);
	printf("\tpitch: %.1f dots\n", fontdesc.pitch / 4.0);
	printf("\theight: %.1f dots\n", fontdesc.height / 4.0);
	printf("\tstroke weight: %d, typeface: %d\n",
		fontdesc.stroke_weight, fontdesc.typeface);
    }
    else if (SEQ("(s", 'W', seq))
    {
	fread(&chardesc, sizeof chardesc, 1, stdin);
	if (chardesc.is_landscape)
	    printf("\n\tlandscape");
	printf("\n\ttop offset: %d dots, left offset: %d dots\n",
		chardesc.top_offset, chardesc.left_offset);
	printf("\theight: %d dots, width: %d dots\n",
		chardesc.height, chardesc.width);
	printf("\tdelta X: %.1f dots\n", chardesc.deltax / 4.0);
	dump_data(getnum(seq) - sizeof chardesc);
    }
    else if (SEQ("*b", 'W', seq))
    {
	dump_data(getnum(seq));
    }
    else if (SEQ("*c", 'E', seq) && isprint(getnum(seq)))
	printf(" ('%c')\n", getnum(seq));
    else
	putchar('\n');
}

main()
{
    int ch;
    char *cp;
    char seq[100];

    while ((ch = getchar()) != EOF)
    {
	switch (ch)
	{
	case '\033':
	    for (cp = seq; !isupper((ch = getchar())); *cp++ = ch)
		;
	    *cp++ = ch;
	    *cp = '\0';
	    do_esc(seq);
	    break;
	default:
	    printf("'%c' (%d) (0x%X) (0%o)\n", ch, ch, ch, ch);
	    break;
	}
    }

    exit(0);
}
