# specPS.tcl -- PostScript stuff for TkDVI (`Mickey Mouse' edition)
# Copyright  2001 Anselm Lingnau <anselm@strathspey.org>
# See file COPYING for conditions on use and distribution.
# $Id: specPS.tcl,v 1.2 2001/08/08 11:32:30 anselm Exp $

namespace eval tkdvi::browser::special {}

proc ::tkdvi::browser::special::ps {name key x y cookie s} {
    if {[regexp {([-\d.]+) ([\d.]+) scale} $s -> xscale yscale]} {
	puts stderr "ps: scale: x by $xscale, y by $yscale"
    } elseif {[regexp {([-\d.]+) neg rotate} $s -> rotate]} {
	puts stderr "ps: rotate by $rotate degrees"
    } elseif {[string equal $s "ps: currentpoint grestore moveto"]} {
	puts stderr "ps: undo rotation"
    } elseif {[string first "div scale neg exch neg exch translate" $s] >= 0} {
	puts stderr "ps: undo translation"
    } else {
	puts stderr "ps: $name $key $x $y $cookie $s"
    }
}

proc ::tkdvi::browser::special::PSfile {name key x y cookie s} {
    puts stderr "PSfile: $name $key $x $y $cookie $s"
    if {![regexp \
	  {PSfile="(.*?)" llx=(\d+) lly=(\d+) urx=(\d+) ury=(\d+) rwi=(\d+) }\
	    $s -> file llx lly urx ury rwi]} {
	return
    }
    puts stderr "PSfile: ==> file=$file ($llx,$lly,$urx,$ury) $rwi"
    set pWidth [expr {round($rwi/$tkdvi::browser::Configure($name-shrink))}]
    puts stderr "PSfile:     pixel width = $pWidth"
}

package provide tkdvi::browser::special::ps 1.0
