/*
 * dviInt.h --
 *
 *      This header file describes the internal interfaces of the
 *      Tk DVI package.
 *
 * Copyright  1999 Anselm Lingnau <lingnau@tm.informatik.uni-frankfurt.de>
 * See file COPYING for conditions on use and distribution.
 *
 * $Id: dviInt.h,v 1.3 2001/08/02 08:28:17 anselm Exp $
 */

#ifndef DVIINT_H
#define DVIINT_H

#if HAVE_ATTRIBUTE == 0
#define __attribute__(a)
#endif

#define VAR_UNUSED __attribute__((unused))

#include "dvi.h"

#define STR_EQ(a, b) (strcmp((a), (b)) == 0)
#define STR_EQ_N(a, b, n) (strncmp((a), (b), (n)) == 0)

#ifndef HAVE_STRNCASECMP
int strncasecmp _ANSI_ARGS_((CONST char *s1, CONST char *s2, size_t n));
int strcasecmp _ANSI_ARGS_((CONST char *s1, CONST char *s2));
#endif

/* was:
   #define BIT64 1
   #if BIT64 */
#if SIZEOF_LONG == 8
#define ABS(x) abs(x)
#else
#define ABS(x) labs(x)
#endif

EXTERN U8 DviGetU8 _ANSI_ARGS_((U8 *p));
EXTERN U16 DviGetU16 _ANSI_ARGS_((U8 *p));
EXTERN U32 DviGetU24 _ANSI_ARGS_((U8 *p));
EXTERN U32 DviGetU32 _ANSI_ARGS_((U8 *p));

EXTERN S8 DviGetS8 _ANSI_ARGS_((U8 *p));
EXTERN S16 DviGetS16 _ANSI_ARGS_((U8 *p));
EXTERN S32 DviGetS24 _ANSI_ARGS_((U8 *p));
EXTERN S32 DviGetS32 _ANSI_ARGS_((U8 *p));

EXTERN char * DviSaveStr _ANSI_ARGS_((const char *string));
EXTERN char * DviSaveStrN _ANSI_ARGS_((const char *string,
				       const size_t length));

#define DVI_NO_MEMORY "not enough memory"

#endif /* DVIINT_H */
