/*
 *	This file contains function protocol specifications for routines
 *	in 'graph.c'.
 */

#define Clip_Line_M(a,b,c,d,e,f) \
    Clip_Line ((long *) (a), \
               (long *) (b), \
               (long) (c), \
               (long) (d), \
               (long) (e), \
               (long) (f))
extern int Clip_Line();

#define Clip_Arc_M(a,b,c,d,e,f,g,h,i,j,k) \
    Clip_Arc ((long) (a), \
              (long) (b), \
              (unsigned long) (c), \
              (long) (d), \
              (long) (e), \
              (long) (f), \
              (long) (g), \
              (long) (h), \
              (long) (i), \
              (long *) (j), \
              (long *) (k))
extern unsigned int Clip_Arc();

#define Clip_Polygon_M(a,b,c,d,e,f,g,h,i) \
    Clip_Polygon ((unsigned int) (a), \
                  (long *) (b), \
                  (long *) (c), \
                  (long) (d), \
                  (long) (e), \
                  (long) (f), \
                  (long) (g), \
                  (long *) (h), \
                  (long *) (i))
extern unsigned int Clip_Polygon();

#define Clip_Rule_M(a,b,c,d,e,f) \
    Clip_Rule ((long *) (a), \
               (unsigned long *) (b), \
               (long *) (c), \
               (long *) (d), \
               (long *) (e), \
               (long *) (f))
extern int Clip_Rule();

#define Segment_Line_M(a,b,c,d,e,f,g,h,i) \
    Segment_Line ((long) (a), \
                  (long) (b), \
                  (long) (c), \
                  (long) (d), \
                  (unsigned int) (e), \
                  (unsigned long *) (f), \
                  (unsigned long) (g), \
                  (unsigned long) (h), \
                  (int (*)()) (i))
extern unsigned long Segment_Line();

#define Build_Line_M(a,b,c,d,e,f,g) \
    Build_Line ((long) (a), \
                (long) (b), \
                (long) (c), \
                (long) (d), \
                (unsigned long) (e), \
                (unsigned long) (f), \
                (int (*)()) (g))

#define Segment_Arc_M(a,b,c,d,e,f,g,h,i,j) \
    Segment_Arc ((long) (a), \
                 (long) (b), \
                 (unsigned long) (c), \
                 (long) (d), \
                 (long) (e), \
                 (unsigned int) (f), \
                 (unsigned long *) (g), \
                 (unsigned long) (h), \
                 (unsigned long) (i), \
                 (int (*)()) (j))
extern unsigned long Segment_Arc();

#define Build_Arc_M(a,b,c,d,e,f,g,h) \
    Build_Arc ((long) (a), \
               (long) (b), \
               (unsigned long) (c), \
               (long) (d), \
               (long) (e), \
               (unsigned long) (f), \
               (unsigned long) (g), \
               (int (*)()) (h))

#define Flatten_Arc_M(a,b,c,d,e,f,g,h) \
    Flatten_Arc ((long) (a), \
                 (long) (b), \
                 (unsigned long) (c), \
                 (long) (d), \
                 (long) (e), \
                 (unsigned long) (f), \
                 (unsigned long) (g), \
                 (int (*)()) (h))

#define Compute_Arc_XY_M(a,b,c,d,e,f) \
    Compute_Arc_XY ((long) (a), \
                    (long) (b), \
                    (unsigned long) (c), \
                    (long) (d), \
                    (long *) (e), \
                    (long *) (f))

#define Compute_Arc_Length_M(a,b) \
    Compute_Arc_Length ((unsigned long) (a), \
                        (long) (b))
extern unsigned long Compute_Arc_Length();

#define Compute_Angle_M(a,b) \
    Compute_Angle ((unsigned long) (a), \
                   (unsigned long) (b))
extern unsigned long Compute_Angle();
