/******************************************************************************
                                pammap.h
*******************************************************************************

  Interface header file for hash table and lookup table pam functions
  in libpnm.

******************************************************************************/

#ifndef PAMMAP_H
#define PAMMAP_H
#include "colorname.h"
#include "pam.h"

struct tupleint {
    /* An ordered pair of a tuple value and an integer, such as you 
       would find in a tuple table or tuple hash.

       Note that this is a variable length structure.
    */
    int value;
    sample tuple[1];  
        /* This is actually a variable size array -- its size is the 
           depth of the tuple in question.  Some compilers do not let us
           declare a variable length array.
        */
};
typedef struct tupleint ** tupletable;

struct tupleint_list_item {
    struct tupleint_list_item * next;
    struct tupleint tupleint;
};
typedef struct tupleint_list_item * tupleint_list;

typedef tupleint_list * tuplehash;

NETPBMDLL unsigned int
pnm_hashtuple(struct pam * const pamP, tuple const tuple);

NETPBMDLL void
pnm_addtotuplehash(struct pam *   const pamP,
                   tuplehash      const tuplehash, 
                   tuple          const tuple,
                   int            const value,
                   int *          const fitsP);

NETPBMDLL void
pnm_lookuptuple(struct pam * const pamP, const tuplehash tuplehash, 
                const tuple searchval, 
                int * const foundP, int * const retvalP);

NETPBMDLL tupletable
pnm_alloctupletable(const struct pam * const pamP, unsigned int const size);

NETPBMDLL void
pnm_freetupletable(struct pam * const pamP, tupletable const tupletable);

NETPBMDLL tuplehash
pnm_createtuplehash(void);

NETPBMDLL void
pnm_destroytuplehash(tuplehash const tuplehash);

NETPBMDLL tupletable
pnm_computetuplefreqtable(struct pam *   const pamP,
                          tuple **       const tupleArray,
                          unsigned int   const maxsize,
                          unsigned int * const sizeP);

NETPBMDLL tuplehash
pnm_computetuplefreqhash(struct pam *   const pamP,
                         tuple **       const tupleArray,
                         unsigned int   const maxsize,
                         unsigned int * const sizeP);

NETPBMDLL tuplehash
pnm_computetupletablehash(struct pam * const pamP, 
                          tupletable   const tupletable,
                          unsigned int const tupletableSize);

NETPBMDLL tupletable
pnm_tuplehashtotable(const struct pam * const pamP,
                     tuplehash          const tuplehash,
                     unsigned int       const maxsize);

NETPBMDLL char*
pam_colorname(struct pam *         const pamP, 
              tuple                const color, 
              enum colornameFormat const format);

#endif


