/* dvi.h							-*- C++ -*-
   Time-stamp: "97/01/17 22:28:47 mik"

   Copyright (C) 1991, 92, 93, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.
   
   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef _dvi_h
#define _dvi_h

#include <sys/stat.h>

#if defined _AFXDLLx
#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions
#endif

#if defined (_WIN32)
#if defined (DVI_DLL)
#if defined (IN_DVI_DLL)
#define _DVI_1 __declspec (dllexport)
#else /* ! IN_DVI_DLL */
#define _DVI_1 __declspec (dllimport)
#endif /* ! IN_DVI_DLL */
#endif /* DVI_DLL */
#define _DVI_2
#endif /*  _WIN32 */

#if ! defined (_DVI_1)
#define _DVI_1
#endif

#if ! defined (_DVI_2)
#define _DVI_2
#endif

typedef long dvi_integer;
typedef double dvi_real;
typedef dvi_integer dvi_pixel;
enum dvi_bool { dvi_false = 0, dvi_true = -1 };

typedef struct

{
  const void *bitmap;
  dvi_integer code;
  dvi_pixel x;
  dvi_pixel y;
  dvi_pixel width;
  dvi_pixel height;
} dvi_item;

typedef struct

{
  const void *bitmap;
  dvi_pixel x;
  dvi_pixel y;
  dvi_pixel width;
  dvi_pixel height;
} dvi_bitmap;

#ifdef _AFXDLLx
class _DVI_1 dvi_page : public CObject
#else
class _DVI_1 dvi_page
#endif

{
public:
  inline dvi_integer size () const;
  inline const dvi_item &operator [] (dvi_integer) const;
  inline dvi_bool done () const;
  inline void boundingbox (dvi_pixel &, dvi_pixel &,
			   dvi_pixel &, dvi_pixel &) const;
  inline const dvi_bitmap & getbitmap (dvi_integer) const;
  inline dvi_integer numofbitmaps () const;

private:
  friend class dvi;
  dvi_page ();
  ~dvi_page ();
  dvi_page (dvi_integer,
	    dvi_integer = 0,
	    dvi_integer = 0,
	    dvi_integer = 0,
	    dvi_integer = 0,
	    dvi_integer = 0,
	    dvi_integer = 0,
	    dvi_integer = 0,
	    dvi_integer = 0,
	    dvi_integer = 0,
	    dvi_integer = 0);
  enum dvi_bool additem (const dvi_item &);
  inline dvi_integer fileoffset () const;
  dvi_integer location;		// location within DVI file
  dvi_integer count_reg[10];	// page number
  dvi_item *items;
  dvi_integer nitems;
  dvi_integer curitem;
  void makebitmaps (size_t);
  void destroybitmaps ();
  dvi_pixel x1, y1, x2, y2;	// bounding box
  dvi_bitmap *bitmaps;
  dvi_integer nbitmaps;
  dvi_integer curbitmap;
  void preparebitmaps ();
};

inline dvi_integer
dvi_page::fileoffset () const

{
  return (location);
}

#ifdef _AFXDLLx
class _DVI_1 dvi : public CObject
#else
class _DVI_1 dvi
#endif

{
public:

  static dvi *create (const char *, const char *, int,
		      const char * = 0, int = 0, size_t = 2);
  static void destroy (dvi *);

  dvi (const char *, const char *, int, const char * = 0, int = 0,
       size_t = 2);
  ~dvi ();
  inline dvi_pixel maxpageheight () const;
  inline dvi_pixel maxpagewidth () const;
  const dvi_page &operator[] (dvi_integer);
  inline dvi_integer pagecount () const;
  inline enum dvi_bool ok () const;
  void switchcontext (int);
  void newmode (const char *, unsigned, const char * = 0, unsigned = 0);

private:

  friend class _context;
  class _context *contab;
  int curcontext;
  int contabsize;

  size_t bytesperrword;

  int resolution;		// resolution in dots per inch
  dvi_real conv;		// converts Dvi units to pixels
  const char *mode;		// mode name
  
  dvi_page **pages;
  dvi_integer curpageidx;
  class _pkfont **fonts;
  dvi_integer totalfonts;
  dvi_integer curfontidx;
  
  class _pkfont *curfont;	// current font object
  const class _pkchar *curchar; // current char object
  
  dvi_integer maxhpixel;
  dvi_integer maxvpixel;
  
  class _ifwrdstream *dvistream;
  const char *dvifilename;
  dvi_integer numerator, denominator; // stated conversion ratio
  dvi_integer mag;		// magnification factor times 1000
  dvi_integer totalpages;	// number of pages
  dvi_integer maxv;		// the value of abs(v) should probably not exceed this
  dvi_integer maxh;		// the value of abs(h) should probably not exceed this

  dvi_integer h, v, w, x, y, z, hh, vv; // current state values
  friend class _dvistatestack;
  class _dvistatestack *states;
  dvi_bool isok;
  enum dvierror {fatalerror, fileerror, dviformaterror};
  void bad (dvierror);

  dvi_integer firstparam (int);
  dvi_pixel pixelround (dvi_integer) const;
  dvi_bool installfont (dvi_integer);
  dvi_bool dopage ();		// build the item list of the current page
  dvi_bool specialcases (int opcode, dvi_integer);
  dvi_integer rulepixels (dvi_integer x) const;
  dvi_page *emptypage;
  struct _stat dvistreamstat;
  void freecontents ();
  enum dvi_bool scan ();
};

inline dvi_pixel
dvi::maxpageheight () const

{
  dvi_pixel h = pixelround (maxv);
  return (h > maxvpixel ? h : maxvpixel);
}

inline dvi_pixel
dvi::maxpagewidth () const

{
  dvi_pixel w = pixelround (maxh);
  return (w > maxhpixel ? w : maxhpixel);
}

inline dvi_integer
dvi::pagecount () const

{
  return (totalpages);
}

inline const dvi_item &
dvi_page::operator[] (dvi_integer idx) const

{
  return (items[idx]);
}

inline enum dvi_bool
dvi::ok () const

{
  return (isok);
}

inline enum dvi_bool
dvi_page::done () const

{
  return (curitem > 0 ? dvi_true : dvi_false);
}

inline dvi_integer
dvi_page::size () const

{
  return (curitem);
}

inline void
dvi_page::boundingbox (dvi_pixel &x,
		  dvi_pixel &y,
		  dvi_pixel &width,
		  dvi_pixel &height) const

{
  x = x1;
  y = y1;
  width = x2 - x1 + 1;
  height = y2 - y1 + 1;
}

inline const dvi_bitmap &
dvi_page::getbitmap (dvi_integer idx) const

{
  return (bitmaps[idx]);
}

inline dvi_integer
dvi_page::numofbitmaps () const

{
  return (curbitmap);
}

#ifndef IN_DVI_DLL
#undef _DVI_1
#undef _DVI_2
#endif

#endif /* _dvi_h */
