@ echo off
REM You will need to edit this for paths and names
set SP_CHARSET_FIXED=1
set SP_ENCODING=ISO-8859-1
set gdir=C:\Home\Gellmu\gellmu
set GELLMU_AdminUrl=http://www.dev.null.org/~webmaster/
set GELLMU_CommentUrl=mailto:webadmin@mail.dev.null.org
set GELLMU_MadeUrl=mailto:user@mail.dev.null.org
set emacs_dir=C:\Local\emacs-20.5
set htcat="C:\Local\sp1_3_4\pubtext\HTML401\catalog"
set dosfind="C:\WINDOWS\COMMAND\find.exe"
REM emacs, latex, nsgmls, and perl should already be in com's path
REM  But if not, place pathnames for them here
REM  For example: set emacs_exe="%emacs_dir%\bin\emacs.exe"
set emacs_exe=emacs.exe
set latex=latex
set nsgmls=nsgmls
set perl=perl
REM
REM Edits below here should be relatively rare
REM
set EMACSLOADPATH=%emacs_dir%\site-lisp;%emacs_dir%\lisp;%emacs_dir%\leim
set EMACSDATA=%emacs_dir%\etc
set EMACSPATH=%emacs_dir%\bin
set EMACSLOCKDIR=%emacs_dir%\lock
set TERM=CMD
set HOME_SAVE=%HOME%
set HOME_EXISTS=yes
set HOME_DEFAULT=C:\HOME\
set HOME=
if "%HOME%" == "%HOME_SAVE%" set HOME_EXISTS=no
if "%HOME_EXISTS%" == "yes" set HOME=%HOME_SAVE%
if "%HOME_EXISTS%" == "no" set HOME=%HOME_DEFAULT%
set xgdir=%gdir%\xml
REM Under Windows emacs seems to need a name for the "-l" argument
REM   that is not the name of something else in the current dir
set elispsrc=%gdir%\gellmu.el
set elisplib=%gdir%\wgellmu.elc
set catalog=%gdir%\catalog
set xcatalog=%xgdir%\catalog
set perllib=%gdir%\perllib
set sgmlspl=%perllib%\sgmlspl.pl
set xmlgart=%gdir%\xmlgart.pl
set htmlgart=%gdir%\htmlgart.pl
set ltxgart=%gdir%\ltxgart.pl
set gname=%1
if "%gname%" == "" goto usage
set trapname=%3
if not "%trapname%" == "" goto usage
set fncall=%2
if not "%fncall%" == "" goto skip
set fncall=gellmu-trans
goto fnready
:skip
"%dosfind%" "(defun %fncall%" "%elispsrc%" > "%gname%.zzz"
if not errorlevel 1 goto fnready
set fncall="gellmu-%2"
:fnready
del "%gname%.zzz"
REM In DOS it's too hard to bother finding the stem name if %1
REM   already has the suffix;  emacs will yell.
if not exist "%gname%.glm" goto bail
echo Calling the syntactic translator.
"%emacs_exe%" -batch -l "%elisplib%" -f "%fncall%" "%gname%.glm"
if errorlevel 1 goto exit
if not exist "%gname%.sgml" goto sgbail
echo Parsing the SGML output of the syntactic translator.
"%nsgmls%" -l -oempty -m %catalog% "%gname%.sgml" > "%gname%.psg"
if errorlevel 1 goto exit
echo Converting the SGML version to the XML version.
"%perl%" < "%gname%.psg" -I%perllib% %sgmlspl% %xmlgart% > "%gname%.xml"
if not exist "%gname%.xml" goto xmlbail
echo Parsing the XML version.
"%nsgmls%" -l -oempty  -wxml -c %xcatalog% %gname%.xml > "%gname%.pxg"
if errorlevel 1 goto exit
echo Translating from parsed XML to HTML.
"%perl%" < "%gname%.pxg" -I%perllib% %sgmlspl% %htmlgart% > "%gname%.html"
if not exist "%gname%.html" goto htmlbail
echo Validating the HTML.
"%nsgmls%" -s -m %htcat% "%gname%.html"
echo Translating from parsed XML to LaTeX.
"%perl%" < "%gname%.pxg" -I%perllib% %sgmlspl% %ltxgart% > "%gname%.ltx"
if errorlevel 1 goto exit
if not exist "%gname%.ltx" goto ltxbail
echo Calling LaTeX.
"%latex%" "%gname%.ltx"
if errorlevel 1 goto exit
if not exist "%gname%.dvi" goto ltxdvi
if not exist "%gname%.log" goto ltxlog
"%dosfind%" "Rerun to get" "%gname%.log"
if errorlevel 1 goto exit
"%latex%" "%gname%.ltx"
if errorlevel 1 goto exit
"%dosfind%" "Rerun to get" "%gname%.log"
if errorlevel 1 goto exit
"%latex%" "%gname%.ltx"
if errorlevel 1 goto exit
"%dosfind%" "Rerun to get" "%gname%.log"
if errorlevel 1 goto exit
"%latex%" "%gname%.ltx"

goto exit

:usage
echo Usage: wsmkg  name (suffix .glm IMPLIED) [function-call]
goto exit

:bail
echo wsmkg: -- "%gname%.glm" -- GELLMU file not found
goto exit

:sgbail
echo wsmkg: -- "%gname%.sgml" -- No SGML file.  Did emacs fail?
goto exit

:xmlbail
echo wsmkg: -- "%gname%.xml" -- No XML file.  Did sgmlspl/xmlgart fail?
goto exit

:htmlbail
echo wsmkg: -- "%gname%.html" -- No HTML file.  Did sgmlspl/htmlgart fail?
goto exit

:ltxbail
echo wsmkg: -- "%gname%.ltx" -- No LaTeX file.  Did sgmlspl/ltxgart fail?
goto exit

:ltxlog
echo wsmkg: -- "%gname%.log" -- No log file.  Did latex fail?
goto exit

:ltxdvi
echo wsmkg: -- "%gname%.dvi" -- No DVI file.  Did latex fail?
goto exit

:exit
