/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

#ifndef SEARCH_H
#define SEARCH_H

#define ZAHLSTRING_LEN 100

#define SEARCH_HAUPTTITEL "REFERENCES VERSION 4.1 * SEARCH FUNCTIONS"


#define WARNUNG00 "ERROR: Empty search command."

#define WARNUNG01 "ERROR: Each '&'-period should contain two items separated\
 by the '='-sign. A field-label is expected as the first, and one or more\
 strings seperated by a '|' (logical OR) as the second."

#define WARNUNG02 "ERROR: The '=' sign must be preceded by a field label:\
 KEYW (keywords) or AUTH (authors of an article) INAU (institutional\
 author) or EDIT (editors of a book)\
 or EDTN (edition number of a book)\
 or VOLJ (volume number of a journal/periodical)\
 or INED (institutional editor)\
 or TITA (title of an article) or TITB (title of a book) or DTYP (document\
 type: j1 - article in a journal with personal authors,\
 j2 - article in journal with institutional/no author,\
 b1 - book, b2: chapter in a book,\
 b3 - book with institutional/no editor,\
 m1 - miscellanea,\
 m2 - miscellanea with institutional/no editor,\
 or YEAR\
 (year of publication) or STAT (status field) or\
 PUBL (publisher of a book) or\
 HOWP (howpublished)\
 or IDNR (identification numbers)\
 or PLAC (place of publication) or JRNL (name of journal,\
 using four-letter-code)."

#define WARNUNG02A "ERROR: One of the YEAR-criteria seperated by '|' is\
 too long."



#define WARNUNG02B "ERROR: One of the YEAR-criteria cannot be converted into a\
 number."

#define WARNUNG02C "ERROR: One of the YEAR-criteria in the form '1991-1992'\
 cannot be processed: the first item cannot be converted into a number."

#define WARNUNG02D "ERROR: One of the YEAR-criteria in the form '1991-1992'\
 cannot be processed: the second item cannot be converted into a number."


#define WARNUNG02E "ERROR: One of the YEAR-criteria in the form '1993-1992'\
 cannot be processed: the first number should be smaller than the second."

#define WARNUNG02F "ERROR: DTYP (document type) criteria may only be j1, j2,\
 b1, b2, b3, m1 or m2."

#define WARNUNG03 "ERROR: An empty list of criteria (following '=') cannot be\
 processed."

#define WARNUNG04 "ERROR: The list of SEARCH criteria contains an empty item"


int search_main(char * out_bbt_file);
int search_last_bbt(char * out_bbt_file);


#endif

