## -*-Tcl-*-
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "notes.tcl"
 #                                    created: 18/9/97 {4:33:31 pm} 
 #                                last update: 31/1/1999 {2:34:07 pm} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Copyright (c) 1997-1998  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

alpha::extension notes 0.1 {
    alpha::package require newDocument
    menu::insert File items end newNote
    package::addPrefsDialog notes
    set {newDocTypes(New Note)} notes::new
    hook::register startupHook notes::open
    hook::register deactivateHook notes::deactivate
}

if {![file exists [file join ${PREFS} Notes]]} { 
    file mkdir [file join ${PREFS} Notes] 
}

newPref flag alwaysOpenNotes 1 notes
newPref flag alwaysIconifyNotes 1 notes
newPref flag autoSaveNotes 1 notes

proc file::newNote {} {
    beep
}
proc notes::deactivate {name} {
    global notesmodeVars PREFS
    set a [win::Current]
    if {$notesmodeVars(alwaysIconifyNotes) \
      && [string match [file join ${PREFS} Notes *] $name]} {
	icon -c
    }
}

proc notes::open {} {
    global PREFS notesmodeVars
    foreach f [glob -nocomplain [file join ${PREFS} Notes *]] {
	if {$notesmodeVars(alwaysOpenNotes)} {
	    edit -c -m -w $f
	    if {$notesmodeVars(alwaysIconifyNotes)} {
		icon -c
	    }
	}
    }
}

