## -*-Tcl-*-
 # ###################################################################
 #  Alpha - new Tcl folder configuration
 # 
 #  FILE: "coreFixes.tcl"
 #                                    created: 31/7/97 {2:09:16 am} 
 #                                last update: 1999-09-05T15:09:25Z 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Reorganisation carried out by Vince Darley with much help from Tom 
 # Fetherston, Johan Linde and suggestions from the Alpha-D mailing list.  
 # Alpha is shareware; please register with the author using the register 
 # button in the about box.
 #  
 # This file contains Tcl procs which wrap around or replace
 # core (hard-coded) Alpha procs to fix some bugs they may have.
 # Sadly most core Alpha bugs can't be fixed in this way.
 # 
 # Ultimately, one hopes, these bugs will be fixed and these procs
 # can be removed...
 # ###################################################################
 ##

#  Buggy procs  #

# so any selections present are maintained
rename centerRedraw __centerRedraw
;proc centerRedraw {args} {
    lappend selectionEndPoints [getPos] [selEnd]
    uplevel __centerRedraw $args
    eval select $selectionEndPoints 
}

# so any selections present are maintained
rename insertToTop __insertToTop
;proc insertToTop {args} {
    lappend selectionEndPoints [getPos] [selEnd]
    uplevel __insertToTop $args
    eval select $selectionEndPoints 
}

# not really a 'fix', but it's much more efficient in many places if
# you can set the mode of a window in advance  ---- else you switch
# modes twice on opening the window!  This version of 'new' has a new
# flag '-m' which lets you set the mode.  It also returns the name
# of the window which was really opened.  Any additional flags received
# by this proc are assumed to be arguments to be passed to 'setWinInfo',
# except without the leading '-'.  So, for instance you can do:
#     new -n "blah" -tabsize 4 -shell 1
# Also args '-text' to set the text, or a useful new flag '-info'
# which takes the text as the next arg, and automatically sets the
# window to a read-only shell window, and scrolls to the top after
# inserting the given text.  Useful for all those 'info' windows Alpha
# uses!
rename new __new
;proc new {args} {
    set i 0
    set where {}
    while {[set arg [lindex $args $i]] != ""} {
	incr i
	switch -- $arg {
	    "-n" { 
		set name [lindex $args $i]
		incr i
	    }
	    "-g" { 
		eval lappend where "-g" [lrange $args $i [incr i 3]]
		incr i
	    }
	    "-m" { 
		set mode [lindex $args $i]
		set mi $i
		incr i
	    }
	    default {
		set other($arg) [lindex $args $i]
		incr i
	    }
	}
    }
    if {![info exists name]} {
	set name "Untitled"
    }
    if {[info tclversion] < 8.0} {
	# Alpha can't cope with colons in names
	regsub -all : $name . name
    }
    set newname $name
    
    if {[lsearch -exact [winNames -f] $name] != -1} {
	set i 2
	while {[lsearch -exact [winNames -f] "$name <$i>"] != -1} {
	    incr i
	}
	append name " <${i}>"
    }
    if {![info exists mode]} {
	set mode [file::whichModeForWin $newname]
    }
    if {[info exists mode]} {
	global win::Modes
	set win::Modes($name) $mode
    }
    
    # In this section, we want to see if we need to temporally shadow out
    # the global tabSize value with another value so as to avoid having to
    # monkey with the winInfo array after the creation of the window
    global tabSize ${mode}modeVars global::_oldTabSize
    if {[info exists other(-tabsize)]} {
	set global::_oldTabSize $tabSize 
	set tabSize $other(-tabsize) 
	unset other(-tabsize)
    } elseif {[info exists ${mode}modeVars(tabSize)]} {
	# The mode that the new window will open up in
	# has its own value tabSize
	set  global::_oldTabSize $tabSize 
	set tabSize [set ${mode}modeVars(tabSize)]
    }

    global alpha::platform
    if {${alpha::platform} != "alpha"} {
	eval __new -n [list $name] $where
    } else {
	eval __new -n [list $newname] $where
    }
    if {![info exists mode]} { 
	set name [win::Current]
    }
    if {[info exists other(-info)]} {
	setWinInfo -w $name shell 1
	insertText $other(-info)
	setWinInfo -w $name read-only 1
	goto [minPos]
	unset other(-info)
    }
    # We must do shell first, then text, then dirty and then others
    # in any order.  Else we'd get errors like can't make window read-only
    # when dirty if they were in the wrong order...
    if {[info exists other(-shell)]} {
	setWinInfo -w $name shell $other(-shell)
	unset other(-shell)
    }
    if {[info exists other(-text)]} {
	insertText $other(-text)
	unset other(-text)
    }
    if {[info exists other(-dirty)]} {
	setWinInfo -w $name dirty $other(-dirty)
	unset other(-dirty)
    }
    if {[info exists other]} {
	foreach a [array names other] {
	    setWinInfo -w $name [string range $a 1 end] $other($a)
	}
    }
    return $name 
}

# Not really a fix, but adds features much needed by glob, which otherwise
# force one to write nasty code.  This may eventually end up in the core 
# of Tcl (if I or someone else gets around to implementing it in C).

## 
 # ------------------------------------------------------------------
 # 
 # "glob" --
 # 
 # Backwards compatible extensions to the 'glob' command to address
 # some current issues:
 # 
 # 'file join' is incompatible with backslash-quoted directory paths,
 # so it is very difficult to deal with paths containing
 # glob-sensitive characters in a cross-platform way.  E.g. the user
 # selects a directory in a directory-chooser, and I wish to find (i)
 # all html files in that directory; (ii) all html files in any
 # sub-directory of that directory; (iii) all subdirectories of that
 # directory which contain the word 'hello'.  With the new glob, this
 # can be achieved in a simple, cross-platform way as follows:
 # 
 # (i) 
 # 
 # set dir [tk_chooseDirectory]
 # set html_files [glob -dir $dir *.html]
 # 
 # (ii)
 # 
 # set dir [tk_chooseDirectory]
 # set sub_dir_html_files [glob -join -dir $dir * *.html]
 # 
 # (iii)
 # 
 # set dir [tk_chooseDirectory]
 # set sub_dirs [glob -t d -dir $dir *hello*]
 # 
 # These will work even if '$dir' contains []{}*+\?  characters,
 # which would be difficult to achieve using the old glob, without
 # explicit backslash quoting of 'dir', and without explicit use of
 # the current platform's directory separator (':' on MacOS,
 # backslash or forward slash on other platforms).  Using this
 # version of glob has allowed me to simplify otherwise messy code,
 # and remove bugs caused by user-selected paths containing bad
 # characters.
 # 
 # Syntax:
 #   
 #   glob ?switches? name ?name ...?
 #   
 # Switches:
 # 
 #   -nocomplain:   if no files are found, return an empty string, rather
 #                  than signal an error.
 #     
 #   -join:         the remaining 'name' arguments are treated as 
 #                  a path specification to be handled with 'file
 #                  join'.
 #                  
 #   -dir <pat>:    search for patterns starting in this directory
 #                  
 #   -path <path>:  search for patterns starting with this path
 #                  prefix (i.e. a directory and a file prefix).
 #   
 #   -types <list of types>: only list files/directories of one of
 #                  the types listed.  Currently only type 'd' is
 #                  supported, which lists only directories (hence
 #                  avoiding the need to specify a platform specific
 #                  separator char), but in the future, more types
 #                  (possibly platform specific) will be supported:
 #                  e.g. on MacOS types such as 'TEXT', 'APPL' will be
 #                  supported.  Unrecognised types are ignored by glob.
 #   
 #   --             signals the end of switches, even if the next 
 #                  argument starts with a '-'.
 # 
 # Each name argument is handled separately, unless '-join' is
 # present.  Note the the '-dir' and '-path' flags are mutually
 # exclusive.
 # 
 # The Tcl version below should work with Tcl8.0 or newer.  It
 # requires a helper procedure 'getOpts' which follows.  Obviously if
 # it meets with general approval it should be re-implemented in C.
 # 
 # --Version--Author------------------Changes-----------------------
 #    1.0     vince@biosgroup.com original
 # -----------------------------------------------------------------
 ##
if {[info tclversion] >= 8.0} {
    # We may have patched the core with new glob functionality
    if {[catch {glob -nocomplain -dir a *}] || ($tcl_platform(platform) == "macintosh" && [info tclversion] < 8.3)} {
	# we've copied this here from stringsLists.tcl to avoid some
	# bad auto-loading problems if there are early startup errors.
	;proc getOpts {{take_value ""} {set "set"}} {
	    upvar args a
	    upvar opts o
	    while {[string match \-* [set arg [lindex $a 0]]]} {
		set a [lreplace $a 0 0]
		if {$arg == "--"} {
		    return
		} else {
		    if {[set idx [lsearch -regexp $take_value \
		      "^-?[string range $arg 1 end]( .*)?$"]] == -1} {
			set o($arg) 1
		    } else {
			if {[llength [set the_arg \
			  [lindex $take_value $idx]]] == 1} {
			    $set o($arg) [lindex $a 0]
			    set a [lreplace $a 0 0]
			} else {
			    set numargs [expr {[lindex $the_arg 1] -1}]
			    $set o($arg) [lrange $a 0 $numargs]
			    set a [lreplace $a 0 $numargs]
			}
		    }
		}
	    }
	}
	rename glob __glob
	;proc glob {args} {
	    getOpts {-t -types -type -dir -path}
	    # place platform specific file separator in variable 'separator's
	    regexp {Z(.)Z} [file join Z Z] "" separator
	    if {[info exists opts(-join)]} {
		unset opts(-join)
		set args [list [eval file join $args]]
	    }
	    set add ""
	    foreach t {type types} {
		if {[info exists opts(-$t)]} {
		    eval lappend opts(-t) $opts(-$t)
		    unset opts(-$t)
		}
	    }
	    if {[info exists opts(-t)]} {
		if {[set item [lsearch -exact $opts(-t) "d"]] != -1} {
		    set opts(-t) [lreplace $opts(-t) $item $item]
		    set add $separator
		}
	    }
	    if {[set nocomplain [info exists opts(-nocomplain)]]} {
		unset opts(-nocomplain)
	    }
	    if {[info exists opts(-path)]} {
		if {[info exists opts(-dir)]} {
		    if {$nocomplain} {
			return ""
		    } else {
			error "Can't use option '-dir' with '-path'"
		    }
		}
		regsub -all {[][*?\{\}\\]} $opts(-path) {\\&} prefix
		unset opts(-path)
	    } elseif {[info exists opts(-dir)]} {
		regsub -all {[][*?\{\}\\]} $opts(-dir) {\\&} prefix
		append prefix ${separator}
		unset opts(-dir)
	    } else {
		set prefix ""
	    }
	    set res {}
	    foreach arg $args {
		eval lappend res [__glob -nocomplain -- \
		  "${prefix}${arg}${add}"]
	    }
	    if {[info exists opts(-t)]} {
		# we ignore arguments to -t which haven't yet been handled,
		# since they are assumed to be platform specific
		unset opts(-t)
	    }
	    if {[set llen [llength [array names opts]]]} {
		set ok "-nocomplain, -join, -dir <dir>,\
		  -path <path>, -types <list of types>"
		if {$llen > 1} {
		    error "bad switches \"[array names opts]\":\
		      must be $ok or --"
		} else {
		    error "bad switch \"[array names opts]\":\
		      must be $ok or --"
		}
	    } elseif {[llength $res]} {
		return $res
	    } elseif {$nocomplain} {
		return ""
	    } else {
		switch -- [llength $args] {
		    0 {
			error "wrong # args: should be \"glob ?switches?\
			  name ?name ...?\""
		    }
		    1 {
			error "no files matched glob pattern \"$args\""
		    }
		    default {
			error "no files matched glob patterns \"$args\""
		    }
		}
	    }
	}
    }

} else {
    # we've copied this here from stringsLists.tcl to avoid some
    # bad auto-loading problems if there are early startup errors.
    ;proc getOpts {{take_value ""} {set "set"}} {
	upvar args a
	upvar opts o
	while {[string match \-* [set arg [lindex $a 0]]]} {
	    set a [lreplace $a 0 0]
	    if {$arg == "--"} {
		return
	    } else {
		if {[set idx [lsearch -regexp $take_value \
		  "^-?[string range $arg 1 end]( .*)?$"]] == -1} {
		    set o($arg) 1
		} else {
		    if {[llength [set the_arg \
		      [lindex $take_value $idx]]] == 1} {
			$set o($arg) [lindex $a 0]
			set a [lreplace $a 0 0]
		    } else {
			set numargs [expr {[lindex $the_arg 1] -1}]
			$set o($arg) [lrange $a 0 $numargs]
			set a [lreplace $a 0 $numargs]
		    }
		}
	    }
	}
    }
    rename glob __glob
    ;proc glob {args} {
	getOpts {-t -types -type -dir -path}
	# place platform specific file separator in variable 'separator's
	regexp {Z(.)Z} [file join Z Z] "" separator
	if {[info exists opts(-join)]} {
	    unset opts(-join)
	    set args [list [eval file join $args]]
	}
	set add ""
	foreach t {type types} {
	    if {[info exists opts(-$t)]} {
		eval lappend opts(-t) $opts(-$t)
		unset opts(-$t)
	    }
	}
	if {[info exists opts(-t)]} {
	    if {[set item [lsearch -exact $opts(-t) "d"]] != -1} {
		set opts(-t) [lreplace $opts(-t) $item $item]
		set add $separator
	    }
	}
	if {[set nocomplain [info exists opts(-nocomplain)]]} {
	    unset opts(-nocomplain)
	}
	if {[info exists opts(-path)]} {
	    if {[info exists opts(-dir)]} {
		if {$nocomplain} {
		    return ""
		} else {
		    error "Can't use option '-dir' with '-path'"
		}
	    }
	    regsub -all {[][*?\{\}\\]} $opts(-path) {\\&} prefix
	    unset opts(-path)
	} elseif {[info exists opts(-dir)]} {
	    regsub -all {[][*?\{\}\\]} $opts(-dir) {\\&} prefix
	    append prefix ${separator}
	    unset opts(-dir)
	} else {
	    set prefix ""
	}
	set glob_args [list -nocomplain]
	if {[info exists opts(-t)]} {
	    foreach pair $opts(-t) {
		set type [lindex $pair 0]
		if {$type != "" && $type != "*"} {
		    if {[string length $type] == 4} {
			lappend glob_args -t $type
		    } else {
			lappend old_t $pair
			continue
		    }
		}
		if {[llength $pair] > 1} {
		    # it's a MacOS 'type crea' pair
		    set crea [lindex $pair 1]
		    if {$crea != "" && $crea != "*"} {
			if {[string length $crea] == 4} {
			    lappend glob_args -c $crea
			} else {
			    lappend old_t $pair
			    continue
			}
		    }
		} 
	    }
	    unset opts(-t)
	    if {[info exists old_t]} {
		set opts(-t) $old_t
	    }
	}
	set res {}
	foreach arg $args {
	    eval lappend res [eval __glob $glob_args -- \
	      [list "${prefix}${arg}${add}"]]
	}
	if {[info exists opts(-t)]} {
	    # we ignore arguments to -t which haven't yet been handled,
	    # since they are assumed to be platform specific
	    unset opts(-t)
	}
	if {[set llen [llength [array names opts]]]} {
	    set ok "-nocomplain, -join, -dir <dir>,\
	      -path <path>, -types <list of types>"
	    if {$llen > 1} {
		error "bad switches \"[array names opts]\":\
		  must be $ok or --"
	    } else {
		error "bad switch \"[array names opts]\":\
		  must be $ok or --"
	    }
	} elseif {[llength $res]} {
	    return $res
	} elseif {$nocomplain} {
	    return ""
	} else {
	    switch -- [llength $args] {
		0 {
		    error "wrong # args: should be \"glob ?switches?\
		      name ?name ...?\""
		}
		1 {
		    error "no files matched glob pattern \"$args\""
		}
		default {
		    error "no files matched glob patterns \"$args\""
		}
	    }
	}
    }
}

# If the position to blink is offscreen, show a message with context
rename blink __blink
;proc blink {pos} {
    __blink $pos
    getWinInfo w
    if {[info exists w(currline)]} {
	set topl $w(currline)
	set endl [expr {$topl + $w(linesdisp)}]
	scan [posToRowCol $pos] "%d %d" row col
	if {$row < $topl || $row >= $endl} {
	    message "Matching '[getText [lineStart $pos] [pos::math $pos + 1]]'"
	}
    }
}

# keep window vertical position the same
rename revert __revert
;proc revert {args} {
    getWinInfo w
    set topl $w(currline)
    uplevel __revert $args
    revertHook [win::Current]
    display [rowColToPos $topl 0]
}

rename save __save
;proc save {{name ""}} {
    global win::Modified win::Active
    if {$name == ""} {
	set name [lindex $win::Active 0]
    }
    set origName $name
    if {![file exists $name] && \
      !([regsub { <[0-9]+>$} $name {} name] && [file exists $name])} {
	if {[info exists win::Modified($origName)]} {
	    if {![dialog::yesno "The file appears to have been moved\
	      since it was last opened or saved.  Are you sure you\
	      want to save it?"]} {
		error "Save aborted by user, since file appears to\
		  have been moved."
	    }
	}
	# It's a new window which has never been saved
	set isNew 1
    } else {
	getFileInfo $name info
	if {[set win::Modified($origName)] < $info(modified)} {
	    # File has changed on disk
	    if {![dialog::yesno "This file has changed on disk.  Are you\
	      sure you want to save it?"]} {
		error "Save aborted by user, since newer file existed."
	    }
	}
    }
    uplevel 1 [list __save $origName]
    # New windows don't get savePostHook called until Alpha 8, so
    # we have to do it manually 
    if {[info exists isNew] && ([info tclversion] < 8.0)} {
	# The user may have cancelled the save
	set name [win::Current]
	if {[file exists $name] || \
	  ([regsub { <[0-9]+>$} $name {} name] && [file exists $name])} {
	    savePostHook [win::Current]
	}
    }
}


rename print __print
;proc print {args} {
    # make sure we've got our procs loaded, else Alpha can't print
    catch {printLeftHeader}
    catch {printRightHeader}
    if {[llength $args]} {
	if {[catch __print [lindex $args 0]]} {
	    file::openQuietly [lindex $args 0]
	    uplevel __print
	} 
    } else {
	uplevel __print
    }
}

#  Procs fixed in Alpha 8  #

if {[info tclversion] >= 8.0} {
    # We just have this proc to help people who haven't updated their code
    # to use Tcl 8's native routines.  It will vanish eventually.
    ;proc mkdir {dir} {
	file mkdir $dir
    }
    return
}

rename saveAs __saveAs
;proc saveAs {args} {
    uplevel __saveAs $args
    savePostHook [win::Current]
}

# old version is a bit picky
if {![string length [info commands __cd]]} {
    rename cd __cd
}
;proc cd args {
    if {$args == ".."} { set args "::" }
    if {$args == "."} { set args ":" }
    if {[llength $args]} {
	set path [string trim [eval list $args] "		\{\}"]
	if {![regexp {:$} $path]} { append path ":" }
	if {![file isdir $path] && [file isdir [pwd]$path]} {
	    set path ":$path"
	}
	__cd $path
    } else {
	global HOME
	__cd $HOME
    }
}

# fix for Alpha trapping command clicks on lines which contain ':'
# unnecessarily.
rename icURL __icURL
;proc icURL {args} {
    if {[catch {eval __icURL $args}]} {
	set mods [getModifiers]
	# Alpha highlights the wrong piece of text, so find mouse pos
	# and generate a new piece position
	if {![catch {mousePos} pos]} {
	    goto [eval rowColToPos $pos]
	}
	cmdDoubleClick -1 -1 \
	  [expr {$mods & 34}] [expr {$mods & 72}] [expr {$mods & 144}]
    }
}
# bring to front does nothing if already foremost 
# (the original calls activateHook, changeMode....)
rename bringToFront __bringToFront
;proc bringToFront {name} {
    global win::Current
    if {[file tail $name] != [file tail ${win::Current}]} { 
	__bringToFront $name 
    }
}

# if you select a directory from inside it, it has a ':', if you select
# from outside, it doesn't have a colon.  There is another problem, which
# is that Alpha won't let you select a volume, only a folder within a 
# volume, but I haven't fixed that here.
rename get_directory __get_directory
;proc get_directory {args} {
    set dir [eval __get_directory $args]
    regsub {:$} $dir {} dir
    return $dir
}


# Setting fonts and tabs doesn't need to dirty the window
rename setFontsTabs __setFontsTabs
;proc setFontsTabs {args} {
    set d [winDirty]
    uplevel __setFontsTabs $args
    if {!$d && [winDirty]} {
	setWinInfo dirty 0
    }
}

# Fixes two bugs: the message in the status window was incorrect (shows
# the search, not replace string.  Also a replace string of nothing was
# rejected.
rename enterReplaceString ""
;proc enterReplaceString {} {
    set t [getSelect]
    replaceString $t
    message "Entered replace '$t'"
}

