#include <sys/emx.h>
#include <errno.h>
#include <sys/doscalls.h>
#include <sys/ioctl.h>

WRITEFUNC _console_write = 0;

int __write (int handle, const void *buf, size_t nbyte)
{
    int count, ret_bytes, dos_bytes;

    if (_files[handle] & F_DEV) {   /* DEV_CON (also DEV_CLK, DEV_NUL) */
	if (_console_write)
	    return _console_write (handle, buf, nbyte);
	else {
	    errno = EINVAL;
	    return -1;
	}
    }
    if (!nbyte)
	return dos_write (handle, buf, 0);

    /* dos/windows can't write more than 64K */
    count = nbyte;
    while (count > 0) {
	dos_bytes = (count <= 0xFFF0) ? count : 0xFFF0;
	ret_bytes = dos_write (handle, buf, dos_bytes);
	count -= ret_bytes;
	if (ret_bytes < dos_bytes)
	    break;
	buf += ret_bytes;
    }
    return (nbyte - count);
}
