/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.datatool.DataBase;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntry;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntryRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolRows;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.latex3.SequenceCommand;
import com.dickimawbooks.texparserlib.latex.latex3.TokenListCommand;
import java.io.IOException;

public class DTLdisplayDbRow
extends ControlSequence {
    protected DataToolSty sty;

    public DTLdisplayDbRow(DataToolSty dataToolSty) {
        this("__datatool_display_db_row:Nn", dataToolSty);
    }

    public DTLdisplayDbRow(String string, DataToolSty dataToolSty) {
        super(string);
        this.sty = dataToolSty;
    }

    @Override
    public Object clone() {
        return new DTLdisplayDbRow(this.getName(), this.sty);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        TokenListCommand tokenListCommand = laTeXParserListener.popTokenListCommand(teXParser, teXObjectList);
        int n = TeXParserUtils.popInt(teXParser, teXObjectList);
        String string = teXParser.expandToString(laTeXParserListener.getControlSequence("dtldbname"), teXObjectList);
        DataBase dataBase = this.sty.getDataBase(string);
        DataToolRows dataToolRows = dataBase.getData();
        DataToolEntryRow dataToolEntryRow = dataToolRows.getRow(n);
        int n2 = dataBase.getColumnCount();
        NumericRegister numericRegister = teXParser.getSettings().getNumericRegister("dtlrownum");
        if (dataToolEntryRow == null) {
            laTeXParserListener.getTeXApp().warning(teXParser, laTeXParserListener.getTeXApp().getMessage("ERROR_ROW_NOT_FOUND", n));
        } else {
            numericRegister.advance(teXParser, UserNumber.ONE);
            if (numericRegister.number(teXParser) > 1) {
                tokenListCommand.appendValue(laTeXParserListener.getControlSequence("dtldisplaycr"), teXParser, teXObjectList);
                tokenListCommand.appendValue(laTeXParserListener.getControlSequence("dtldisplaystartrow"), teXParser, teXObjectList);
            }
            teXParser.getSettings().localSetRegister("l__datatool_col_idx_int", UserNumber.ZERO);
            NumericRegister numericRegister2 = teXParser.getSettings().getNumericRegister("l__datatool_col_idx_int");
            SequenceCommand sequenceCommand = laTeXParserListener.getSequenceCommand("l__datatool_column_indexes_seq", teXObjectList);
            for (int i = 0; i < sequenceCommand.size(); ++i) {
                int n3 = TeXParserUtils.toInt(sequenceCommand.get(i), teXParser, teXObjectList);
                if (i > 0) {
                    tokenListCommand.append(laTeXParserListener.getTab());
                }
                numericRegister2.advance(teXParser, UserNumber.ONE);
                DataToolEntry dataToolEntry = dataToolEntryRow.getEntry(n3);
                tokenListCommand.append((TeXObject)dataToolEntry.getContents().clone());
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

