

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{cs-techrep}[2024/09/16 Technical Reports in Computer Science and Software Engineering v0.4]

\newcounter{cstechrep@subfigtracker}
\newcounter{cstechrep@subcaptiontracker}
\newcounter{cstechrep@pbalancetracker}
\newcounter{cstechrep@flushendtracker}


\DeclareOption{subfig}{
  \setcounter{cstechrep@subfigtracker}{1}
  \typeout{cs-techrep class: subfig option is set (use subfloat command).}
}
\DeclareOption{subcaption}{
  \setcounter{cstechrep@subcaptiontracker}{1}
  \typeout{cs-techrep class: subcaption option is set (use subfigure command).}
}

\DeclareOption{onecolumn}{\OptionNotUsed} % IEEE option onecolumn will be ignored

\DeclareOption{pbalance}{
  \setcounter{cstechrep@pbalancetracker}{1}
  \typeout{cs-techrep class: pbalance option is set.}
}
\DeclareOption{flushend}{
  \setcounter{cstechrep@flushendtracker}{1}
  \typeout{cs-techrep class: flushend option is set.}
}

\DeclareOption*{%
  \PassOptionsToClass{\CurrentOption}{IEEEtran}% recommended IEEE options: conference,a4paper
}

\ProcessOptions\relax

\LoadClass{IEEEtran}



\makeatletter
\newcommand*\DefcstechrepVar[1]{\@namedef{cstechrep#1}##1{\global\@namedef{cstechrep#1}{##1}}}
\makeatother

\DefcstechrepVar{AuthorListTex}
\DefcstechrepVar{AuthorListBib} % Use *and* as author separator!
\DefcstechrepVar{TitleTex}
\DefcstechrepVar{TitleBib}
\DefcstechrepVar{Department}  % e.g., Department of Electrical Engineering, Media and Computer Science
\DefcstechrepVar{Institution} % e.g., Ostbayerische Technische Hochschule Amberg-Weiden
\DefcstechrepVar{Address}     % e.g., Amberg, Germany
\DefcstechrepVar{Type}      % e.g., Technical Report
\DefcstechrepVar{Year}        % e.g., 2023
\DefcstechrepVar{Title}
\DefcstechrepVar{Month}       % e.g., 6 (for June)
\DefcstechrepVar{Number}      % e.g., CL-2023-42
\DefcstechrepVar{Lang}        % e.g., english = en-US (or: ngerman = DE)

\RequirePackage{upquote}

\RequirePackage[ngerman,main=english]{babel}
\addto\extrasenglish{\languageshorthands{ngerman}\useshorthands{"}}

\RequirePackage{lmodern} % CM variant with scalable font (to prevent "pdfTeX error (font expansion): auto expansion is only possible with scalable")
\RequirePackage{times} % Times New Roman, because IEEE is based on Times (and not CM/lmodern), however, package times is not a scalable font, thus, lmodern is required additionally and must be loaded before times

\RequirePackage[hyphens]{url}


\makeatletter
\g@addto@macro{\UrlBreaks}{\UrlOrds}
\makeatother


\RequirePackage[zerostyle=b,scaled=.75]{newtxtt}

\RequirePackage[utf8]{inputenc}

\RequirePackage[T1]{fontenc}

\RequirePackage[
  babel=true, % Enable language-specific kerning. Take language-settings from the languge of the current document (see Section 6 of microtype.pdf)
  expansion=alltext,
  protrusion=alltext-nott, % Ensure that at listings, there is no change at the margin of the listing
  nopatch=eqnum, % fix unable to apply patch eqnum
  final % Always enable microtype, even if in draft mode. This helps finding bad boxes quickly.
        % In the standard configuration, this template is always in the final mode, so this option only makes a difference if "pros" use the draft mode
]{microtype}

\DisableLigatures{encoding = T1, family = tt* }


\RequirePackage{graphicx}

\RequirePackage{ccicons}

\RequirePackage{diagbox}

\RequirePackage[cmyk, table]{xcolor}

\RequirePackage[nolist,smaller]{acronym}

\RequirePackage{listings}

\definecolor{eclipseStrings}{RGB}{42,0.0,255}
\definecolor{eclipseKeywords}{RGB}{127,0,85}
\colorlet{numb}{magenta!60!black}


\lstdefinelanguage{json}{
    basicstyle=\normalfont\ttfamily,
    commentstyle=\color{eclipseStrings}, % style of comment
    stringstyle=\color{eclipseKeywords}, % style of strings
    numbers=left,
    numberstyle=\scriptsize,
    stepnumber=1,
    numbersep=8pt,
    showstringspaces=false,
    breaklines=true,
    frame=lines,
    % backgroundcolor=\color{gray}, %only if you like
    string=[s]{"}{"},
    comment=[l]{:\ "},
    morecomment=[l]{:"},
    literate=
        *{0}{{{\color{numb}0}}}{1}
         {1}{{{\color{numb}1}}}{1}
         {2}{{{\color{numb}2}}}{1}
         {3}{{{\color{numb}3}}}{1}
         {4}{{{\color{numb}4}}}{1}
         {5}{{{\color{numb}5}}}{1}
         {6}{{{\color{numb}6}}}{1}
         {7}{{{\color{numb}7}}}{1}
         {8}{{{\color{numb}8}}}{1}
         {9}{{{\color{numb}9}}}{1}
}

\lstset{
  % everything between (* *) is a latex command
  escapeinside={(*}{*)},
  %
  language=json,
  %
  showstringspaces=false,
  %
  extendedchars=true,
  %
  basicstyle=\footnotesize\ttfamily,
  %
  commentstyle=\slshape,
  %
  % default: \rmfamily
  stringstyle=\ttfamily,
  %
  breaklines=true,
  %
  breakatwhitespace=true,
  %
  % alternative: fixed
  columns=flexible,
  %
  numbers=left,
  %
  numberstyle=\tiny,
  %
  basewidth=.5em,
  %
  xleftmargin=.5cm,
  %
  % aboveskip=0mm,
  %
  % belowskip=0mm,
  %
  captionpos=b
}

\lstset{literate=
  {á}{{\'a}}1 {é}{{\'e}}1 {í}{{\'i}}1 {ó}{{\'o}}1 {ú}{{\'u}}1
  {Á}{{\'A}}1 {É}{{\'E}}1 {Í}{{\'I}}1 {Ó}{{\'O}}1 {Ú}{{\'U}}1
  {à}{{\`a}}1 {è}{{\`e}}1 {ì}{{\`i}}1 {ò}{{\`o}}1 {ù}{{\`u}}1
  {À}{{\`A}}1 {È}{{\'E}}1 {Ì}{{\`I}}1 {Ò}{{\`O}}1 {Ù}{{\`U}}1
  {ä}{ä}1 {ë}{{\"e}}1 {ï}{{\"i}}1 {ö}{ö}1 {ü}{{\"u}}1
  {Ä}{ä}1 {Ë}{{\"E}}1 {Ï}{{\"I}}1 {Ö}{ö}1 {Ü}{{\"U}}1
  {â}{{\^a}}1 {ê}{{\^e}}1 {î}{{\^i}}1 {ô}{{\^o}}1 {û}{{\^u}}1
  {Â}{{\^A}}1 {Ê}{{\^E}}1 {Î}{{\^I}}1 {Ô}{{\^O}}1 {Û}{{\^U}}1
  {Ã}{{\~A}}1 {ã}{{\~a}}1 {Õ}{{\~O}}1 {õ}{{\~o}}1
  {œ}{{\oe}}1 {Œ}{{\OE}}1 {æ}{{\ae}}1 {Æ}{{\AE}}1 {ß}{{\ss}}1
  {ű}{{\H{u}}}1 {Ű}{{\H{U}}}1 {ő}{{\H{o}}}1 {Ő}{{\H{O}}}1
  {ç}{{\c c}}1 {Ç}{{\c C}}1 {ø}{{\o}}1 {å}{{\r a}}1 {Å}{{\r A}}1
}

\RequirePackage{booktabs}

\RequirePackage[alwaysadjust]{paralist}


\RequirePackage[
    defernumbers=true,  % required due to self-cite
    %style=ieee,        % english only
    sorting=none,       % nty, nyt, nyvt, anyt, anyvt, ynt, ydnt, none, debug
    sortcites=false,
    citestyle=numeric-comp,
    bibstyle=numeric,
    backend=biber,
    bibencoding=utf8,   % = auto, utf8, ascii
    hyperref=true,      % activate hyperref support
    backref=false,      % activate backrefs
    isbn=true,
    url=true,
    doi=true,
    urldate=terse,      % = iso, year, short, long, terse
    maxnames=5,         % max number of names in text ??
    minnames=1,         % min number of names in text ??
    maxbibnames=99,     % max number of names in bibliography
    minbibnames=1,      % number of names in bibliography (bevor et al)
    maxcitenames=99,    % max number of names in text ??
    mincitenames=1,     % max number of names in text ??
    giveninits=false,   % abbreviate first names
    uniquename=init,    % otherwise option conflict with firstinits=true
    autolang=other
]{biblatex}

\makeatletter
\let\blx@rerun@biber\relax
\makeatother

\addbibresource{selfref.bib} % selfref.bib needs to be generated, containing a bibentry with key selfref
\DeclareBibliographyCategory{selfref}
\addtocategory{selfref}{selfref}

\renewcommand{\bibfont}{\normalfont\small}

\RequirePackage{etoolbox}
\makeatletter
\patchcmd{\NAT@test}{\else \NAT@nm}{\else \NAT@hyper@{\NAT@nm}}{}{}
\makeatother

\makeatletter
\DeclareCiteCommand{\citemonth}
  {\usebibmacro{prenote}}
  {%
    \let\oldabx@bibmonth\abx@bibmonth%
    %\let\abx@bibmonth\blx@imc@biblstring\typeout{CHG: abx@bibmonth \meaning\abx@bibmonth}% false: not abbreviated; but nowork
    \setkeys{blx@opt@pre}{dateabbrev=false}% nowork
    \mkbibmonth{\thefield{month}}%
    \let\abx@bibmonth\oldabx@bibmonth% restore
  }
  {\multicitedelim}
  {\usebibmacro{postnote}}
\makeatother

\RequirePackage{pdfcomment}

\newcommand{\commentontext}[2]{\colorbox{yellow!60}{#1}\pdfcomment[color={0.234 0.867 0.211},hoffset=-6pt,voffset=10pt,opacity=0.5]{#2}}
\newcommand{\commentatside}[1]{\pdfcomment[color={0.045 0.278 0.643},icon=Note]{#1}}

\newcommand{\todo}[1]{\commentatside{#1}}

\newcommand{\TODO}[1]{\commentatside{#1}}

\RequirePackage{stfloats}
\fnbelowfloat

\RequirePackage[group-minimum-digits=4,per-mode=fraction]{siunitx}
\addto\extrasgerman{\sisetup{locale = DE}}

\RequirePackage{hyperref}

\hypersetup{
  hidelinks,
  colorlinks=true,
  allcolors=black,
  pdfstartview=Fit,
  breaklinks=true
}

\RequirePackage[all]{hypcap}

\RequirePackage{orcidlink}

\RequirePackage[autostyle=true]{csquotes}

\defineshorthand{"`}{\openautoquote}
\defineshorthand{"'}{\closeautoquote}

\usepackage{amsmath,amssymb,amsfonts}

\RequirePackage[capitalise,nameinlink,noabbrev]{cleveref}

\crefname{listing}{Listing}{Listings}
\Crefname{listing}{Listing}{Listings}
\crefname{lstlisting}{Listing}{Listings}
\Crefname{lstlisting}{Listing}{Listings}

\RequirePackage{lipsum}

\RequirePackage{tcolorbox}
\tcbuselibrary{listings}

\DeclareFontFamily{U}{MnSymbolC}{}
\DeclareSymbolFont{MnSyC}{U}{MnSymbolC}{m}{n}
\DeclareFontShape{U}{MnSymbolC}{m}{n}{
  <-6>    MnSymbolC5
  <6-7>   MnSymbolC6
  <7-8>   MnSymbolC7
  <8-9>   MnSymbolC8
  <9-10>  MnSymbolC9
  <10-12> MnSymbolC10
  <12->   MnSymbolC12%
}{}
\DeclareMathSymbol{\powerset}{\mathord}{MnSyC}{180}

\RequirePackage{xspace}
\newcommand{\eg}{e.\,g.,\ }
\newcommand{\ie}{i.\,e.,\ }

\makeatletter
\newcommand{\hydash}{\penalty\@M-\hskip\z@skip}
\makeatother


\input glyphtounicode
\pdfgentounicode=1

\RequirePackage{lscape}
\RequirePackage{pdflscape}
\RequirePackage{afterpage}

\RequirePackage[hyperxmp=false,lang=English]{doclicense}

\makeatletter
\def\ps@IEEEtitlepagestyle{
  \def\@oddfoot{\mycopyrightnotice}
  \def\@evenfoot{}
}
\def\mycopyrightnotice{
  {\footnotesize
    \begin{minipage}{0.8\textwidth}
  \centering
    % Creative Commons / Open Access:
    %\href{https://creativecommons.org/licenses/by/4.0/}{\ccby{} This work is %licensed under a Creative Commons Attribution 4.0 International (CC BY 4.0) %License.}
    % License based on doclicense package:
    \href{\doclicenseURL}{\doclicenseIcon{} This work is licensed under a \doclicenseLongNameRef{} (\doclicenseNameRef{}) license.}
    % Citation advice:
    \\Please cite as: \fullcite{selfref}.
  \end{minipage}
  }
}
\makeatother

\makeatletter
\def\filecontentsForceExpansion#1#2#3{
  \global\let\ltxspecials\dospecials
  \gdef\dospecials{\ltxspecials
    \catcode`#1=0
    \catcode`#2=1
    \catcode`#3=2
    \global\let\dospecials\ltxspecials
  }
}
\makeatother

\title{\cstechrepTitleTex}

\author{
\IEEEauthorblockN{\cstechrepAuthorListTex}
\IEEEauthorblockA{%
\cstechrepDepartment\\
\cstechrepInstitution\\
\cstechrepAddress
}}

\IEEEspecialpapernotice{\cstechrepType: \cstechrepNumber, \citemonth{selfref} \cstechrepYear}

\ifnum\value{cstechrep@subfigtracker}=1
  \typeout{cs-techrep class: load subfig package (use subfloat command).}
  \RequirePackage[caption=false,font=footnotesize]{subfig}
\fi
\ifnum\value{cstechrep@subcaptiontracker}=1
  \typeout{cs-techrep class: load subcaption package (use subfigure command).}
  \RequirePackage{subcaption}
  \captionsetup[subfigure]{labelformat=parens,font=footnotesize}
\fi

\ifnum\value{cstechrep@pbalancetracker}=1
  \typeout{cs-techrep class: load pbalance package.}
  \RequirePackage{pbalance}
\fi
\ifnum\value{cstechrep@flushendtracker}=1
  \typeout{cs-techrep class: load flushend package.}
  \RequirePackage{flushend}
\fi


\RequirePackage[shortcuts]{extdash} % Use \-/ for a breakable dash that does not prevent the remainer of the word to be hyphenated

\endinput
%%
%% End of file `cs-techrep.cls'.
