function change(factor)
{
	if (match($0, "R [0-9\.\-]+")==0){
		printf("%s (%d) : Pattern matching Error in %s.\n",FILENAME,NR,$1) > "CON"
		exit(1)
	}
	orgpatn = substr($0,RSTART, RLENGTH)
	newpatn = sprintf("R %f", substr(orgpatn,3)*factor)
	if (sub(orgpatn,newpatn)==0){
		printf("%s (%d%) : Replacing Error in GLUE.\n",FILENAME,NR) > "CON"
		exit(1)
	}
	return newpatn
}
function changeglue(factor)
{
	if (match($0, "R [0-9\.\-]+ R [0-9\.\-]+ R [0-9\.\-]+")==0){
		printf("%s (%d) : Pattern matching Error in GLUE.\n",FILENAME,NR) > "CON"
	}
	orgpatn = substr($0,RSTART, RLENGTH)
	base = str5 * factor
	plus = str7 * factor
	minus = str9 * factor
	newpatn = sprintf("R %f R %f R %f",base,plus,minus)
	if (sub(orgpatn,newpatn)==0){
		printf("%s (%d) : Replacing Error in GLUE.\n",FILENAME,NR) > "CON"
		exit(1)
	}
	return newpatn
}
function changekern(factor)
{
	if (match($0, "R [0-9\.\-]+")==0){
		printf("%s (%d) : Pattern matching Error in KRN.\n",FILENAME,NR) > "CON"
		exit(1)
	}
	orgpatn = substr($0,RSTART, RLENGTH)
	newpatn = sprintf("R %f", substr(orgpatn,3)*factor)
	if (sub(orgpatn,newpatn)==0){
		printf("%s (%d) : Replacing Error in GLUE.\n",FILENAME, NR) > "CON"
		exit(1)
	}
	return newpatn
}
BEGIN{
#	printf("%d %s %s %s\n", argc, argv[0], argv[1], argv[2])
#	if (argc < 3) exit
#	pitch_shrink = (argv[1]=="H" || argv[1]=="h")
#	level = argv[2]
	f_name = FILENAME
	tatekumi = 0
	pitch_shrink = level < 0
	if (level < 0) level = -level
	if (level>4 || level <1){
		printf("Level must be 1 - 4 \n")
		exit
	}
	level = 1 - (level / 10)
}
END{
	printf ("%s has been converted. (%s %d%) \n",FILENAME,
			 (pitch_shrink)?"chou-tai":"hei-tai",int((1-level)*10+0.5)*10) > "CON"
}
{
	str3=$3-0
	str5=$5-0
	str7=$7-0
	str9=$9-0
}
/DIRECTION /{
	if (match($0,"TATE")){
		printf("Tate-kumi dirction is detected. \n")>"CON"
		tatekumi = 1
		pitch_shrink=!pitch_shrink
	}
}
/QUAD /{
	if (!pitch_shrink)change(level)
}
/CHARWD /{
	if (!pitch_shrink)change(level)
}
/GLUE /{
	if (!pitch_shrink) changeglue(level)
}
/KRN /{
	if (!pitch_shrink) changekern(level)
}
/CHARHT /{
	if (pitch_shrink) change(level)
}
/CHARDP /{
	if (pitch_shrink) change(level)
}
{
	print
}
